/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.util.PathString;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.HashCodes;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    @NotNull
    private final ResourceResolver myResourceResolver;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Configuration myConfiguration;

    public GutterIconRenderer(@NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet, @NotNull VirtualFile file, @NotNull Configuration configuration) {
        this.myResourceResolver = resourceResolver;
        this.myFacet = facet;
        this.myFile = file;
        this.myConfiguration = configuration;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = GutterIconCache.getInstance().getIcon(this.myFile, (RenderResources)this.myResourceResolver, this.myFacet);
        return icon2 == null ? EmptyIcon.ICON_0 : icon2;
    }

    @NotNull
    public AnAction getClickAction() {
        return new GutterIconClickAction(this.myFile, this.myResourceResolver, this.myFacet, this.myConfiguration);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myFacet.equals((Object)that.myFacet)) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myFacet.hashCode(), (int)this.myFile.hashCode());
    }

    @NotNull
    private static PathString getResourcesRoot(@NotNull IAndroidTarget target) {
        String targetResources = target.getPath(11);
        if (SdkUtils.endsWithIgnoreCase((String)targetResources, (String)".jar")) {
            return new PathString("jar", targetResources + "!/");
        }
        return new PathString("file", targetResources).getParentOrRoot();
    }

    @VisibleForTesting
    public static interface NavigationTargetProvider {
        @Nullable
        public VirtualFile getNavigationTarget();
    }

    private static class GutterIconClickAction
    extends AnAction
    implements NavigationTargetProvider {
        private static final int PREVIEW_MAX_WIDTH = JBUI.scale((int)128);
        private static final int PREVIEW_MAX_HEIGHT = JBUI.scale((int)128);
        private static final String PREVIEW_TEXT = "Click Image to Open Resource";
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ResourceResolver myResourceResolver;
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final Configuration myConfiguration;
        @Nullable
        private VirtualFile myNavigationTarget;
        private boolean myNavigationTargetComputed;

        private GutterIconClickAction(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet, @NotNull Configuration configuration) {
            this.myFile = file;
            this.myResourceResolver = resourceResolver;
            this.myFacet = facet;
            this.myConfiguration = configuration;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Project project;
            Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
            if (editor2 != null && (project = editor2.getProject()) != null) {
                VirtualFile navigationTarget = this.getNavigationTarget();
                Runnable onClick = navigationTarget == null ? null : () -> GutterIconClickAction.openImageResourceTab(project, navigationTarget);
                JBPopup preview = this.createPreview(onClick);
                if (preview != null) {
                    preview.show(new RelativePoint((MouseEvent)event.getInputEvent()));
                } else if (navigationTarget != null) {
                    GutterIconClickAction.openImageResourceTab(project, navigationTarget);
                }
            }
        }

        @Nullable
        private JBPopup createPreview(final @Nullable Runnable onClick) {
            Icon icon2 = GutterIconFactory.createIcon(this.myFile, (RenderResources)this.myResourceResolver, PREVIEW_MAX_WIDTH, PREVIEW_MAX_HEIGHT, this.myFacet);
            if (icon2 == null) {
                return null;
            }
            final JBLabel label = new JBLabel(icon2);
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)label, null);
            if (onClick != null) {
                builder.setAdText(PREVIEW_TEXT, 0);
            }
            final JBPopup popup2 = builder.createPopup();
            if (onClick != null) {
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        onClick.run();
                        popup2.cancel();
                        label.removeMouseListener((MouseListener)this);
                    }
                });
            }
            return popup2;
        }

        private static void openImageResourceTab(@NotNull Project project, @NotNull VirtualFile navigationTarget) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, navigationTarget, -1);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
        }

        @Override
        @VisibleForTesting
        @Nullable
        public VirtualFile getNavigationTarget() {
            if (!this.myNavigationTargetComputed) {
                IAndroidTarget target = this.myConfiguration.getTarget();
                if (target instanceof CompatibilityRenderTarget) {
                    PathString renderResourcesRoot = GutterIconRenderer.getResourcesRoot(target);
                    PathString path = FileExtensions.toPathString(this.myFile);
                    if (path.startsWith(renderResourcesRoot)) {
                        PathString resourcesRoot;
                        VirtualFile file;
                        IAndroidTarget projectTarget = ConfigurationManager.getOrCreateInstance(this.myFacet).getProjectTarget();
                        if (projectTarget != null && (file = FileExtensions.toVirtualFile(path = (resourcesRoot = GutterIconRenderer.getResourcesRoot(projectTarget)).resolve(renderResourcesRoot.relativize(path)))) != null && file.exists()) {
                            this.myNavigationTarget = file;
                        }
                    } else {
                        this.myNavigationTarget = this.myFile;
                    }
                }
                this.myNavigationTargetComputed = true;
            }
            return this.myNavigationTarget;
        }
    }
}

