/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.ReplaceTagFix;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AlarmFactory;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlLinkManager {
    private static final String URL_EDIT_CLASSPATH = "action:classpath";
    private static final String URL_BUILD = "action:build";
    private static final String URL_SYNC = "action:sync";
    private static final String URL_SHOW_XML = "action:showXml";
    private static final String URL_ACTION_IGNORE_FRAGMENTS = "action:ignoreFragment";
    private static final String URL_RUNNABLE = "runnable:";
    private static final String URL_COMMAND = "command:";
    private static final String URL_REPLACE_TAGS = "replaceTags:";
    private static final String URL_SHOW_TAG = "showTag:";
    private static final String URL_OPEN = "open:";
    private static final String URL_CREATE_CLASS = "createClass:";
    private static final String URL_OPEN_CLASS = "openClass:";
    private static final String URL_ASSIGN_FRAGMENT_URL = "assignFragmentUrl:";
    private static final String URL_ASSIGN_LAYOUT_URL = "assignLayoutUrl:";
    private static final String URL_EDIT_ATTRIBUTE = "editAttribute:";
    private static final String URL_REPLACE_ATTRIBUTE_VALUE = "replaceAttributeValue:";
    private static final String URL_DISABLE_SANDBOX = "disableSandbox:";
    private static final String URL_REFRESH_RENDER = "refreshRender";
    private static final String URL_ADD_DEPENDENCY = "addDependency:";
    private static final String URL_CLEAR_CACHE_AND_NOTIFY = "clearCacheAndNotify";
    private SparseArray<Runnable> myLinkRunnables;
    private SparseArray<WriteCommandAction> myLinkCommands;
    private int myNextLinkId = 0;
    private static final NotificationGroup NOTIFICATIONS_GROUP = new NotificationGroup("Render error panel notifications", NotificationDisplayType.BALLOON, false);

    public static void showNotification(@NotNull String content) {
        Notification notification = NOTIFICATIONS_GROUP.createNotification(content, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
        AlarmFactory.getInstance().create().addRequest(() -> ((Notification)notification).expire(), TimeUnit.SECONDS.toMillis(2L));
    }

    public void handleUrl(@NotNull String url, @Nullable Module module, @Nullable PsiFile file, @Nullable DataContext dataContext, @Nullable RenderResult result2, @Nullable EditorDesignSurface surface) {
        if (url.startsWith("http:") || url.startsWith("https:")) {
            BrowserLauncher.getInstance().browse(url, null, module == null ? null : module.getProject());
        } else if (url.startsWith("file:")) {
            assert (module != null);
            HtmlLinkManager.handleFileUrl(url, module);
        } else if (url.startsWith(URL_REPLACE_TAGS)) {
            assert (module != null);
            assert (file != null);
            HtmlLinkManager.handleReplaceTagsUrl(url, module, file);
        } else if (url.equals(URL_BUILD)) {
            assert (dataContext != null);
            assert (module != null);
            HtmlLinkManager.handleBuildProjectUrl(url, module.getProject());
        } else if (url.equals(URL_SYNC)) {
            assert (dataContext != null);
            assert (module != null);
            HtmlLinkManager.handleSyncProjectUrl(url, module.getProject());
        } else if (url.equals(URL_EDIT_CLASSPATH)) {
            assert (module != null);
            HtmlLinkManager.handleEditClassPathUrl(url, module);
        } else if (url.startsWith(URL_CREATE_CLASS)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleNewClassUrl(url, module);
        } else if (url.startsWith(URL_OPEN)) {
            assert (module != null);
            HtmlLinkManager.handleOpenStackUrl(url, module);
        } else if (url.startsWith(URL_OPEN_CLASS)) {
            assert (module != null);
            HtmlLinkManager.handleOpenClassUrl(url, module);
        } else if (url.equals(URL_SHOW_XML)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleShowXmlUrl(url, module, file);
        } else if (url.startsWith(URL_SHOW_TAG)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleShowTagUrl(url, module, file);
        } else if (url.startsWith(URL_ASSIGN_FRAGMENT_URL)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleAssignFragmentUrl(url, module, file);
        } else if (url.startsWith(URL_ASSIGN_LAYOUT_URL)) {
            assert (module != null && file != null);
            HtmlLinkManager.handleAssignLayoutUrl(url, module, file);
        } else if (url.equals(URL_ACTION_IGNORE_FRAGMENTS)) {
            assert (result2 != null);
            HtmlLinkManager.handleIgnoreFragments(url, surface);
        } else if (url.startsWith(URL_EDIT_ATTRIBUTE)) {
            assert (result2 != null);
            if (module != null && file != null) {
                HtmlLinkManager.handleEditAttribute(url, module, file);
            }
        } else if (url.startsWith(URL_REPLACE_ATTRIBUTE_VALUE)) {
            assert (result2 != null);
            if (module != null && file != null) {
                HtmlLinkManager.handleReplaceAttributeValue(url, module, file);
            }
        } else if (url.startsWith(URL_DISABLE_SANDBOX)) {
            assert (module != null);
            HtmlLinkManager.handleDisableSandboxUrl(module, surface);
        } else if (url.startsWith(URL_RUNNABLE)) {
            Runnable linkRunnable = this.getLinkRunnable(url);
            if (linkRunnable != null) {
                linkRunnable.run();
            }
        } else if (url.startsWith(URL_ADD_DEPENDENCY) && module != null) {
            assert (module.getModuleFile() != null);
            HtmlLinkManager.handleAddDependency(url, module);
            ProjectSystemUtil.getSyncManager(module.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
        } else if (url.startsWith(URL_COMMAND)) {
            WriteCommandAction command = this.getLinkCommand(url);
            if (command != null) {
                command.execute();
            }
        } else if (url.startsWith(URL_REFRESH_RENDER)) {
            HtmlLinkManager.handleRefreshRenderUrl(surface);
        } else if (url.startsWith(URL_CLEAR_CACHE_AND_NOTIFY)) {
            HtmlLinkManager.handleRefreshRenderUrl(surface);
            HtmlLinkManager.showNotification("Cache cleared");
        } else assert (false) : "Unexpected URL: " + url;
    }

    @Nullable
    public static String createFilePositionUrl(@NotNull File file, int line, int column) {
        try {
            String fileUrl = SdkUtils.fileToUrlString((File)file);
            if (line != -1) {
                if (column > 0) {
                    return fileUrl + ':' + line + ':' + column;
                }
                return fileUrl + ':' + line;
            }
            return fileUrl;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(HtmlLinkManager.class).error((Throwable)e);
            return null;
        }
    }

    private static void handleFileUrl(@NotNull String url, @NotNull Module module) {
        Project project = module.getProject();
        try {
            int line = -1;
            int column = 0;
            Pattern pattern = Pattern.compile(".*:(\\d+)(:(\\d+))");
            Matcher matcher = pattern.matcher(url);
            if (matcher.matches()) {
                line = Integer.parseInt(matcher.group(1));
                column = Integer.parseInt(matcher.group(3));
                url = url.substring(0, matcher.start(1) - 1);
            } else {
                matcher = Pattern.compile(".*:(\\d+)").matcher(url);
                if (matcher.matches()) {
                    line = Integer.parseInt(matcher.group(1));
                    url = url.substring(0, matcher.start(1) - 1);
                }
            }
            File ioFile = SdkUtils.urlToFile((String)url);
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file != null) {
                HtmlLinkManager.openEditor(project, file, line, column);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String createCommandLink(@NotNull WriteCommandAction command) {
        String url = URL_COMMAND + this.myNextLinkId;
        if (this.myLinkCommands == null) {
            this.myLinkCommands = new SparseArray(5);
        }
        this.myLinkCommands.put(this.myNextLinkId, (Object)command);
        ++this.myNextLinkId;
        return url;
    }

    @Nullable
    private WriteCommandAction getLinkCommand(String url) {
        if (this.myLinkCommands != null && url.startsWith(URL_COMMAND)) {
            String idString = url.substring(URL_COMMAND.length());
            int id = Integer.decode(idString);
            return (WriteCommandAction)this.myLinkCommands.get(id);
        }
        return null;
    }

    public String createRunnableLink(@NotNull Runnable runnable) {
        String url = URL_RUNNABLE + this.myNextLinkId;
        if (this.myLinkRunnables == null) {
            this.myLinkRunnables = new SparseArray(5);
        }
        this.myLinkRunnables.put(this.myNextLinkId, (Object)runnable);
        ++this.myNextLinkId;
        return url;
    }

    @Nullable
    private Runnable getLinkRunnable(String url) {
        if (this.myLinkRunnables != null && url.startsWith(URL_RUNNABLE)) {
            String idString = url.substring(URL_RUNNABLE.length());
            int id = Integer.decode(idString);
            return (Runnable)this.myLinkRunnables.get(id);
        }
        return null;
    }

    public String createReplaceTagsUrl(String from, String to) {
        return URL_REPLACE_TAGS + from + '/' + to;
    }

    private static void handleReplaceTagsUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file) {
        assert (url.startsWith(URL_REPLACE_TAGS)) : url;
        int start = URL_REPLACE_TAGS.length();
        int delimiterPos = url.indexOf(47, start);
        if (delimiterPos != -1) {
            String wrongTag = url.substring(start, delimiterPos);
            String rightTag = url.substring(delimiterPos + 1);
            ReplaceTagFix fix = new ReplaceTagFix(module.getProject(), (XmlFile)file, wrongTag, rightTag);
            fix.execute();
        }
    }

    public String createBuildProjectUrl() {
        return URL_BUILD;
    }

    private static void handleBuildProjectUrl(@NotNull String url, @NotNull Project project) {
        assert (url.equals(URL_BUILD)) : url;
        ProjectSystemUtil.getProjectSystem(project).buildProject();
    }

    public String createSyncProjectUrl() {
        return URL_SYNC;
    }

    private static void handleSyncProjectUrl(@NotNull String url, @NotNull Project project) {
        assert (url.equals(URL_SYNC)) : url;
        ProjectSystemSyncManager.SyncReason reason = project.isInitialized() ? ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED : ProjectSystemSyncManager.SyncReason.PROJECT_LOADED;
        ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(reason, true);
    }

    public String createEditClassPathUrl() {
        return URL_EDIT_CLASSPATH;
    }

    private static void handleEditClassPathUrl(@NotNull String url, @NotNull Module module) {
        assert (url.equals(URL_EDIT_CLASSPATH)) : url;
        ProjectSettingsService.getInstance((Project)module.getProject()).openModuleSettings(module);
    }

    public String createOpenClassUrl(@NotNull String className) {
        return URL_OPEN_CLASS + className;
    }

    private static void handleOpenClassUrl(@NotNull String url, @NotNull Module module) {
        PsiFile containingFile;
        assert (url.startsWith(URL_OPEN_CLASS)) : url;
        String className = url.substring(URL_OPEN_CLASS.length());
        Project project = module.getProject();
        PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (clz != null && (containingFile = clz.getContainingFile()) != null) {
            HtmlLinkManager.openEditor(project, containingFile, clz.getTextOffset());
        }
    }

    private static void handleShowXmlUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file) {
        assert (url.equals(URL_SHOW_XML)) : url;
        HtmlLinkManager.openEditor(module.getProject(), file, 0, -1);
    }

    public String createShowTagUrl(String tag) {
        return URL_SHOW_TAG + tag;
    }

    private static void handleShowTagUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file) {
        assert (url.startsWith(URL_SHOW_TAG)) : url;
        String tagName = url.substring(URL_SHOW_TAG.length());
        XmlTag first = (XmlTag)ApplicationManager.getApplication().runReadAction(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!tagName.equals(tag.getName())) continue;
                return tag;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first);
        } else {
            HtmlLinkManager.openEditor(module.getProject(), file, 0, -1);
        }
    }

    public String createNewClassUrl(String className) {
        return URL_CREATE_CLASS + className;
    }

    private static void handleNewClassUrl(@NotNull String url, @NotNull Module module) {
        PsiFile file;
        PsiClass newClass;
        PsiDirectory targetDirectory;
        String packageName;
        String className;
        assert (url.startsWith(URL_CREATE_CLASS)) : url;
        String s = url.substring(URL_CREATE_CLASS.length());
        final Project project = module.getProject();
        String title = "Create Custom View";
        int index = s.lastIndexOf(46);
        if (index == -1) {
            className = s;
            packageName = MergedManifestManager.getSnapshot(module).getPackage();
            if (packageName == null) {
                return;
            }
        } else {
            packageName = s.substring(0, index);
            className = s.substring(index + 1);
        }
        CreateClassDialog dialog2 = new CreateClassDialog(project, title, className, packageName, (ClassKind)CreateClassKind.CLASS, true, module){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog2.show();
        if (dialog2.getExitCode() == 0 && (targetDirectory = dialog2.getTargetDirectory()) != null && (newClass = (PsiClass)new WriteCommandAction<PsiClass>(project, "Create Class", new PsiFile[0]){

            protected void run(@NotNull Result<PsiClass> result2) throws Throwable {
                PsiClass targetClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
                PsiManager manager = PsiManager.getInstance((Project)project);
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
                PsiElementFactory factory = facade.getElementFactory();
                PsiJavaCodeReferenceElement superclassReference = factory.createReferenceElementByFQClassName("android.view.View", targetClass.getResolveScope());
                PsiReferenceList extendsList = targetClass.getExtendsList();
                if (extendsList != null) {
                    extendsList.add((PsiElement)superclassReference);
                }
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                PsiJavaFile javaFile = (PsiJavaFile)targetClass.getContainingFile();
                PsiImportList importList = javaFile.getImportList();
                if (importList != null) {
                    PsiClass attributeSetClass;
                    PsiClass contextClass = JavaPsiFacade.getInstance((Project)project).findClass("android.content.Context", scope);
                    if (contextClass != null) {
                        importList.add((PsiElement)factory.createImportStatement(contextClass));
                    }
                    if ((attributeSetClass = JavaPsiFacade.getInstance((Project)project).findClass("android.util.AttributeSet", scope)) != null) {
                        importList.add((PsiElement)factory.createImportStatement(attributeSetClass));
                    }
                }
                PsiMethod constructor1arg = factory.createMethodFromText("public " + className + "(Context context) {\n  this(context, null);\n}\n", (PsiElement)targetClass);
                targetClass.add((PsiElement)constructor1arg);
                PsiMethod constructor2args = factory.createMethodFromText("public " + className + "(Context context, AttributeSet attrs) {\n  this(context, attrs, 0);\n}\n", (PsiElement)targetClass);
                targetClass.add((PsiElement)constructor2args);
                PsiMethod constructor3args = factory.createMethodFromText("public " + className + "(Context context, AttributeSet attrs, int defStyle) {\n  super(context, attrs, defStyle);\n}\n", (PsiElement)targetClass);
                targetClass.add((PsiElement)constructor3args);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                PsiFile containingFile = targetClass.getContainingFile();
                if (containingFile != null) {
                    codeStyleManager.reformat((PsiElement)javaFile);
                }
                result2.setResult((Object)targetClass);
            }
        }.execute().getResultObject()) != null && (file = newClass.getContainingFile()) != null) {
            HtmlLinkManager.openEditor(project, file, newClass.getTextOffset());
        }
    }

    public String createOpenStackUrl(@NotNull String className, @NotNull String methodName, @NotNull String fileName, int lineNumber) {
        return URL_OPEN + className + '#' + methodName + ';' + fileName + ':' + lineNumber;
    }

    private static void handleOpenStackUrl(@NotNull String url, @NotNull Module module) {
        Project project;
        PsiClass clz;
        int line;
        String fileName;
        String className;
        assert (url.startsWith(URL_OPEN)) : url;
        int start = URL_OPEN.length();
        int semi = url.indexOf(59, start);
        if (semi != -1) {
            className = url.substring(start, semi);
            int colon = url.indexOf(58, semi + 1);
            if (colon != -1) {
                fileName = url.substring(semi + 1, colon);
                line = Integer.decode(url.substring(colon + 1));
            } else {
                fileName = url.substring(semi + 1);
                line = -1;
            }
        } else {
            className = url.substring(start);
            fileName = null;
            line = -1;
        }
        String method = null;
        int hash2 = className.indexOf(35);
        if (hash2 != -1) {
            method = className.substring(hash2 + 1);
            className = className.substring(0, hash2);
        }
        if ((clz = JavaPsiFacade.getInstance((Project)(project = module.getProject())).findClass(className, GlobalSearchScope.allScope((Project)project))) != null) {
            String name;
            VirtualFile virtualFile;
            PsiFile containingFile = clz.getContainingFile();
            if (fileName != null && containingFile != null && line != -1 && (virtualFile = containingFile.getVirtualFile()) != null && fileName.equals(name = virtualFile.getName())) {
                HtmlLinkManager.openEditor(project, containingFile, line - 1, -1);
                return;
            }
            if (method != null) {
                PsiMethod[] methodsByName;
                for (PsiMethod psiMethod : methodsByName = clz.findMethodsByName(method, true)) {
                    VirtualFile virtualFile2;
                    PsiFile psiFile = psiMethod.getContainingFile();
                    if (psiFile == null || (virtualFile2 = psiFile.getVirtualFile()) == null) continue;
                    OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, virtualFile2, psiMethod.getTextOffset());
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
                    return;
                }
            }
            if (fileName != null) {
                PsiFile[] files2 = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                for (PsiMethod psiMethod : files2) {
                    if (HtmlLinkManager.openEditor(project, (PsiFile)psiMethod, line != -1 ? line - 1 : -1, -1)) break;
                }
            }
        }
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile, int line, int column) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            return HtmlLinkManager.openEditor(project, file, line, column);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file, int line, int column) {
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file, line, column);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        if (manager.openTextEditor(descriptor2, true) != null) {
            return true;
        }
        return !manager.openEditor(descriptor2, true).isEmpty();
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile, int offset) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            return HtmlLinkManager.openEditor(project, file, offset);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file, offset);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true).isEmpty();
    }

    public String createAssignFragmentUrl(@Nullable String id) {
        return URL_ASSIGN_FRAGMENT_URL + (id != null ? id : "");
    }

    @NotNull
    private static String getFragmentClass(@NotNull Module module, @NotNull String fqcn) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            String jvmClassName;
            Project project = module.getProject();
            JavaPsiFacade finder = JavaPsiFacade.getInstance((Project)project);
            PsiClass psiClass = finder.findClass(fqcn, module.getModuleScope());
            if (psiClass == null) {
                psiClass = finder.findClass(fqcn, GlobalSearchScope.allScope((Project)project));
            }
            if (psiClass != null && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)psiClass)) != null) {
                return jvmClassName.replace('/', '.');
            }
            return fqcn;
        });
    }

    private static void handleAssignFragmentUrl(@NotNull String url, @NotNull Module module, final @NotNull PsiFile file) {
        assert (url.startsWith(URL_ASSIGN_FRAGMENT_URL)) : url;
        Predicate<PsiClass> psiFilter = ChooseClassDialog.getUserDefinedPublicAndUnrestrictedFilter();
        String className = ChooseClassDialog.openDialog(module, "Fragments", null, psiFilter, "android.app.Fragment", SdkConstants.CLASS_V4_FRAGMENT.oldName(), SdkConstants.CLASS_V4_FRAGMENT.newName());
        if (className == null) {
            return;
        }
        final String fragmentClass = HtmlLinkManager.getFragmentClass(module, className);
        int start = URL_ASSIGN_FRAGMENT_URL.length();
        final String id = start == url.length() ? null : Lint.stripIdPrefix((String)url.substring(start));
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(module.getProject(), "Assign Fragment", new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result2) throws Throwable {
                Collection tags2 = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
                for (XmlTag tag : tags2) {
                    String tagId;
                    if (!tag.getName().equals("fragment") || id != null && ((tagId = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")) == null || !tagId.endsWith(id) || !id.equals(Lint.stripIdPrefix((String)tagId))) || tag.getAttribute("name", "http://schemas.android.com/apk/res/android") != null || tag.getAttribute("class") != null) continue;
                    tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                    return;
                }
                if (id == null) {
                    for (XmlTag tag : tags2) {
                        if (!tag.getName().equals("fragment")) continue;
                        tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                        break;
                    }
                }
            }
        };
        action2.execute();
    }

    public String createPickLayoutUrl(@NotNull String activityName) {
        return URL_ASSIGN_LAYOUT_URL + activityName;
    }

    public String createAssignLayoutUrl(@NotNull String activityName, @NotNull String layout2) {
        return URL_ASSIGN_LAYOUT_URL + activityName + ':' + layout2;
    }

    private static void handleAssignLayoutUrl(@NotNull String url, @NotNull Module module, @NotNull PsiFile file) {
        assert (url.startsWith(URL_ASSIGN_LAYOUT_URL)) : url;
        int start = URL_ASSIGN_LAYOUT_URL.length();
        int layoutStart = url.indexOf(58, start + 1);
        Project project = module.getProject();
        XmlFile xmlFile = (XmlFile)file;
        if (layoutStart == -1) {
            String activityName = url.substring(start);
            HtmlLinkManager.pickLayout(module, xmlFile, activityName);
        } else {
            String activityName = url.substring(start, layoutStart);
            String layoutName = url.substring(layoutStart + 1);
            String layout2 = "@layout/" + layoutName;
            HtmlLinkManager.assignLayout(project, xmlFile, activityName, layout2);
        }
    }

    private static void pickLayout(@NotNull Module module, @NotNull XmlFile file, @NotNull String activityName) {
        String layout2;
        ChooseResourceDialog dialog2 = ChooseResourceDialog.builder().setModule(module).setTypes(EnumSet.of(ResourceType.LAYOUT)).setFile(file).setHideLeftSideActions().build();
        if (dialog2.showAndGet() && !(layout2 = dialog2.getResourceName()).equals("@layout/" + file.getName())) {
            HtmlLinkManager.assignLayout(module.getProject(), file, activityName, layout2);
        }
    }

    private static void assignLayout(@NotNull Project project, final @NotNull XmlFile file, final @NotNull String activityName, final @NotNull String layout2) {
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(project, "Assign Preview Layout", new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result2) throws Throwable {
                AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
                Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
                for (XmlTag tag : xmlTags) {
                    if (!tag.getName().equals("fragment")) continue;
                    String name = tag.getAttributeValue("class");
                    if (name == null || name.isEmpty()) {
                        name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                    }
                    if (!activityName.equals(name)) continue;
                    tag.setAttribute("layout", "http://schemas.android.com/tools", layout2);
                }
            }
        };
        action2.execute();
    }

    public String createIgnoreFragmentsUrl() {
        return URL_ACTION_IGNORE_FRAGMENTS;
    }

    private static void handleIgnoreFragments(@NotNull String url, @Nullable EditorDesignSurface surface) {
        assert (url.equals(URL_ACTION_IGNORE_FRAGMENTS));
        RenderLogger.ignoreFragments();
        HtmlLinkManager.requestRender(surface);
    }

    public String createEditAttributeUrl(String attribute, String value2) {
        return URL_EDIT_ATTRIBUTE + attribute + '/' + value2;
    }

    private static void handleEditAttribute(@NotNull String url, @NotNull Module module, @NotNull PsiFile file) {
        assert (url.startsWith(URL_EDIT_ATTRIBUTE));
        int attributeStart = URL_EDIT_ATTRIBUTE.length();
        int valueStart = url.indexOf(47);
        String attributeName = url.substring(attributeStart, valueStart);
        String value2 = url.substring(valueStart + 1);
        XmlAttribute first = (XmlAttribute)ApplicationManager.getApplication().runReadAction(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlAttribute.class);
            for (XmlAttribute attribute : attributes) {
                if (!attributeName.equals(attribute.getLocalName()) || !value2.equals(attribute.getValue())) continue;
                return attribute;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first.getValueElement());
        } else {
            HtmlLinkManager.openEditor(module.getProject(), file, 0, -1);
        }
    }

    public String createReplaceAttributeValueUrl(String attribute, String oldValue, String newValue) {
        return URL_REPLACE_ATTRIBUTE_VALUE + attribute + '/' + oldValue + '/' + newValue;
    }

    private static void handleReplaceAttributeValue(@NotNull String url, @NotNull Module module, final @NotNull PsiFile file) {
        assert (url.startsWith(URL_REPLACE_ATTRIBUTE_VALUE));
        int attributeStart = URL_REPLACE_ATTRIBUTE_VALUE.length();
        int valueStart = url.indexOf(47);
        int newValueStart = url.indexOf(47, valueStart + 1);
        final String attributeName = url.substring(attributeStart, valueStart);
        final String oldValue = url.substring(valueStart + 1, newValueStart);
        final String newValue = url.substring(newValueStart + 1);
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(module.getProject(), "Set Attribute Value", new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result2) throws Throwable {
                Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlAttribute.class);
                int oldValueLen = oldValue.length();
                for (XmlAttribute attribute : attributes) {
                    String attributeValue;
                    if (!attributeName.equals(attribute.getLocalName()) || (attributeValue = attribute.getValue()) == null) continue;
                    if (oldValue.equals(attributeValue)) {
                        attribute.setValue(newValue);
                        continue;
                    }
                    int index = attributeValue.indexOf(oldValue);
                    if (index == -1 || index != 0 && attributeValue.charAt(index - 1) != '|' || index + oldValueLen != attributeValue.length() && attributeValue.charAt(index + oldValueLen) != '|') continue;
                    attributeValue = attributeValue.substring(0, index) + newValue + attributeValue.substring(index + oldValueLen);
                    attribute.setValue(attributeValue);
                }
            }
        };
        action2.execute();
    }

    public String createDisableSandboxUrl() {
        return URL_DISABLE_SANDBOX;
    }

    private static void handleDisableSandboxUrl(@NotNull Module module, @Nullable EditorDesignSurface surface) {
        RenderSecurityManager.sEnabled = false;
        HtmlLinkManager.requestRender(surface);
        Messages.showInfoMessage((Project)module.getProject(), (String)"The custom view rendering sandbox was disabled for this session.\n\nYou can turn it off permanently by adding\nandroid.render.sandbox=false\nto {install}/bin/idea.properties.", (String)"Disabled Rendering Sandbox");
    }

    public String createRefreshRenderUrl() {
        return URL_REFRESH_RENDER;
    }

    public String createClearCacheUrl() {
        return URL_CLEAR_CACHE_AND_NOTIFY;
    }

    private static void handleRefreshRenderUrl(@Nullable EditorDesignSurface surface) {
        if (surface != null) {
            RefreshRenderAction.clearCache(surface.getConfiguration());
        }
    }

    private static void requestRender(@Nullable EditorDesignSurface surface) {
        if (surface != null) {
            surface.forceUserRequestedRefresh();
        }
    }

    public String createAddDependencyUrl(GoogleMavenArtifactId artifactId) {
        return URL_ADD_DEPENDENCY + (Object)((Object)artifactId);
    }

    @VisibleForTesting
    static void handleAddDependency(@NotNull String url, @NotNull Module module) {
        assert (url.startsWith(URL_ADD_DEPENDENCY)) : url;
        String coordinateStr = url.substring(URL_ADD_DEPENDENCY.length());
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateStr + ":+"));
        if (coordinate == null) {
            Logger.getInstance(HtmlLinkManager.class).warn("Invalid coordinate " + coordinateStr);
            return;
        }
        if (DependencyManagementUtil.addDependencies(module, Collections.singletonList(coordinate), false, false).isEmpty()) {
            return;
        }
        Logger.getInstance(HtmlLinkManager.class).warn("Could not add dependency " + coordinate);
    }
}

