/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.lint.UpgradeConstraintLayoutFix;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderLogger
extends LayoutLog
implements IRenderLogger {
    public static final String TAG_MISSING_DIMENSION = "missing.dimension";
    public static final String TAG_MISSING_FRAGMENT = "missing.fragment";
    public static final String TAG_STILL_BUILDING = "project.building";
    static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.RenderLogger");
    private static final boolean LOG_ALL = Boolean.getBoolean("adt.renderLog") || ApplicationManager.getApplication().isUnitTestMode();
    private static Set<String> ourIgnoredFidelityWarnings;
    private static boolean ourIgnoreAllFidelityWarnings;
    private static boolean ourIgnoreFragments;
    private final Module myModule;
    private final String myName;
    private Set<String> myFidelityWarningStrings;
    private boolean myHaveExceptions;
    private Multiset<String> myTags;
    @GuardedBy(value="myMessages")
    private final List<RenderProblem> myMessages = new ArrayList<RenderProblem>();
    private List<RenderProblem> myFidelityWarnings;
    private Set<String> myMissingClasses;
    private Map<String, Throwable> myBrokenClasses;
    private Map<String, Throwable> myClassesWithIncorrectFormat;
    private String myResourceClass;
    private boolean myMissingResourceClass;
    private boolean myHasLoadedClasses;
    private HtmlLinkManager myLinkManager;
    private boolean myMissingSize;
    private List<String> myMissingFragments;
    private Object myCredential;

    public RenderLogger(@Nullable String name, @Nullable Module module, @Nullable Object credential) {
        this.myName = name;
        this.myModule = module;
        this.myCredential = credential;
    }

    public RenderLogger(@Nullable String name, @Nullable Module module) {
        this(name, module, null);
    }

    @VisibleForTesting
    static void resetFidelityErrorsFilters() {
        ourIgnoreAllFidelityWarnings = false;
        if (ourIgnoredFidelityWarnings != null) {
            ourIgnoredFidelityWarnings.clear();
        }
    }

    public static void ignoreFidelityWarning(@NotNull Object clientData) {
        if (ourIgnoredFidelityWarnings == null) {
            ourIgnoredFidelityWarnings = new com.intellij.util.containers.HashSet();
        }
        ourIgnoredFidelityWarnings.add((String)clientData);
    }

    public static void ignoreAllFidelityWarnings() {
        ourIgnoreAllFidelityWarnings = true;
    }

    public static void ignoreFragments() {
        ourIgnoreFragments = true;
    }

    @NotNull
    private static String describe(@Nullable String message2, @Nullable Throwable throwable) {
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            return throwable != null && throwable.getMessage() != null ? throwable.getMessage() : "";
        }
        return message2;
    }

    static boolean isIssue164378(@Nullable Throwable throwable) {
        StackTraceElement[] stackTrace;
        return throwable instanceof NoSuchFieldError && (stackTrace = throwable.getStackTrace()).length >= 1 && stackTrace[0].getClassName().startsWith("android.support");
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    public Project getProject() {
        if (this.myModule != null) {
            return this.myModule.getProject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageToIdeaLog(@NotNull String message2, @Nullable Throwable t) {
        String logMessage;
        if (t == null) {
            logMessage = message2;
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            writer.println(t.getMessage());
            t.printStackTrace(writer);
            logMessage = message2 + "\n" + stringWriter.toString();
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            LOG.debug(logMessage);
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private void logMessageToIdeaLog(@NotNull String message2) {
        this.logMessageToIdeaLog(message2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(@NotNull RenderProblem message2) {
        List<RenderProblem> list = this.myMessages;
        synchronized (list) {
            this.myMessages.add(message2);
        }
        this.logMessageToIdeaLog(XmlUtils.fromXmlAttributeValue((String)message2.getHtml()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RenderProblem> getMessages() {
        ImmutableList copy;
        List<RenderProblem> list = this.myMessages;
        synchronized (list) {
            copy = ImmutableList.copyOf(this.myMessages);
        }
        return copy;
    }

    public boolean hasProblems() {
        return this.hasErrors() || this.myFidelityWarnings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        boolean hasMessage;
        List<RenderProblem> list = this.myMessages;
        synchronized (list) {
            hasMessage = !this.myMessages.isEmpty();
        }
        return this.myHaveExceptions || hasMessage || this.myClassesWithIncorrectFormat != null || this.myBrokenClasses != null || this.myMissingClasses != null || this.myMissingSize || this.myMissingFragments != null;
    }

    @NotNull
    public List<RenderProblem> getFidelityWarnings() {
        return this.myFidelityWarnings != null ? this.myFidelityWarnings : Collections.emptyList();
    }

    public void error(@Nullable String tag, @Nullable String message2, @Nullable Object viewCookie, @Nullable Object data) {
        AndroidFacet facet;
        String description = RenderLogger.describe(message2, null);
        if (tag == null && message2 != null && (message2.startsWith("Failed to find style ") || message2.startsWith("Unable to resolve parent style name: "))) {
            tag = "resources.resolve.theme";
        }
        this.addTag(tag);
        if ("resources.resolve.theme".equals(tag) && this.myModule != null && BuildSettings.getInstance(this.myModule.getProject()).getBuildMode() == BuildMode.SOURCE_GEN && (facet = AndroidFacet.getInstance(this.myModule)) != null && facet.requiresAndroidModel()) {
            description = "Still building project; theme resources from libraries may be missing. Layout should refresh when the build is complete.\n\n" + description;
            tag = TAG_STILL_BUILDING;
            this.addTag(tag);
        }
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, description).tag(tag));
    }

    public void error(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        String description = RenderLogger.describe(message2, throwable);
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (RenderLogger.isIssue164378(throwable)) {
                return;
            }
            if ("Unable to find the layout for Action Bar.".equals(description)) {
                description = description + "\nConsider updating to a more recent version of appcompat, or switch the rendering library in the IDE down to API 21";
            }
            if (description.isEmpty()) {
                description = "Exception raised during rendering";
            } else if (description.equals(throwable.getLocalizedMessage()) || description.equals(throwable.getMessage())) {
                description = "Exception raised during rendering: " + description;
            } else {
                if (message2 != null && message2.equals("onMeasure error") && throwable.toString().startsWith("java.lang.NoSuchMethodError: android.support.constraint.solver.widgets.Guideline.setRelative")) {
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    String issue2 = "214853";
                    problem.tag(issue2);
                    problem.throwable(throwable);
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    builder.add("You appear to be using constraint layout version alpha3 or earlier; you must use version alpha4 or later with this version of the layout editor (because the API for guidelines changed incompatibly as of alpha4.)");
                    builder.add(" (");
                    builder.addLink("Update Library", this.getLinkManager().createRunnableLink(() -> UpgradeConstraintLayoutFix.apply(this.myModule)));
                    builder.add(", ");
                    ShowExceptionFix detailsFix = new ShowExceptionFix(this.getProject(), throwable);
                    builder.addLink("Show Exception", this.getLinkManager().createRunnableLink(detailsFix));
                    builder.add(")");
                    this.addMessage(problem);
                    return;
                }
                if (message2 != null && message2.startsWith("Failed to configure parser for ") && message2.endsWith(".png")) {
                    StackTraceElement[] frames;
                    for (StackTraceElement frame : frames = throwable.getStackTrace()) {
                        if (frame.getMethodName().equals("createFromXml") && frame.getClassName().equals("android.content.res.ColorStateList")) {
                            String basePath;
                            String path = message2.substring("Failed to configure parser for ".length());
                            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                            problem.tag("bitmapAsColor");
                            HtmlBuilder builder = problem.getHtmlBuilder();
                            builder.add("Resource error: Attempted to load a bitmap as a color state list.").newline();
                            builder.add("Verify that your style/theme attributes are correct, and make sure layouts are using the right attributes.");
                            builder.newline().newline();
                            path = FileUtil.toSystemIndependentName((String)path);
                            String string = basePath = this.getProject() != null && this.getProject().getBasePath() != null ? FileUtil.toSystemIndependentName((String)this.getProject().getBasePath()) : null;
                            if (basePath != null && path.startsWith(basePath)) {
                                path = path.substring(basePath.length());
                                path = StringUtil.trimStart((String)path, (String)File.separator);
                            }
                            path = FileUtil.toSystemDependentName((String)path);
                            builder.add("The relevant image is ").add(path);
                            HashSet widgets = Sets.newHashSet();
                            for (StackTraceElement f : frames) {
                                String className;
                                if (!f.getMethodName().equals("<init>") || !(className = f.getClassName()).startsWith("android.widget.")) continue;
                                widgets.add(className.substring(className.lastIndexOf(46) + 1));
                            }
                            if (!widgets.isEmpty()) {
                                ArrayList sorted = Lists.newArrayList((Iterable)widgets);
                                Collections.sort(sorted);
                                builder.newline().newline().add("Widgets possibly involved: ").add(Joiner.on((String)", ").join((Iterable)sorted));
                            }
                            this.addMessage(problem);
                            return;
                        }
                        if (!frame.getClassName().startsWith("com.android.tools.")) {
                            continue;
                        }
                        break;
                    }
                } else if (message2 != null && message2.startsWith("Failed to parse file ") && throwable instanceof XmlPullParserException) {
                    int end;
                    int index;
                    XmlPullParserException e = (XmlPullParserException)throwable;
                    String msg = e.getMessage();
                    if (msg.startsWith("Binary XML file ") && (index = msg.indexOf(58)) != -1 && index < msg.length() - 1) {
                        msg = msg.substring(index + 1).trim();
                    }
                    int lineNumber = e.getLineNumber();
                    int column = e.getColumnNumber();
                    String reader = " in java.io.InputStreamReader@";
                    int index2 = msg.indexOf(reader);
                    if (index2 != -1 && (end = msg.indexOf(41, index2 + 1)) != -1) {
                        msg = msg.substring(0, index2) + msg.substring(end);
                    }
                    String path = message2.substring("Failed to parse file ".length());
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    problem.tag("xmlParse");
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    if (lineNumber != -1) {
                        builder.add("Line ").add(Integer.toString(lineNumber)).add(": ");
                    }
                    builder.add(msg);
                    if (lineNumber != -1) {
                        builder.add(" (");
                        File file = new File(path);
                        String url = HtmlLinkManager.createFilePositionUrl(file, lineNumber, column);
                        if (url != null) {
                            builder.addLink("Show", url);
                            builder.add(")");
                        }
                    }
                    this.addMessage(problem);
                    return;
                }
            }
            this.myHaveExceptions = true;
        }
        this.addTag(tag);
        if (this.getProject() == null) {
            this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, description).tag(tag).throwable(throwable));
        } else {
            this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, description, this.getProject(), this.getLinkManager(), throwable).tag(tag));
        }
    }

    public void warning(@Nullable String tag, @NotNull String message2, @Nullable Object viewCookie, @Nullable Object data) {
        String description = RenderLogger.describe(message2, null);
        if ("info".equals(tag)) {
            Logger.getInstance(this.getClass()).info(description);
            return;
        }
        if ("resources.format".equals(tag)) {
            Pattern pattern;
            Matcher matcher;
            if (description.equals("You must supply a layout_width attribute.") || description.equals("You must supply a layout_height attribute.")) {
                this.myMissingSize = true;
                this.addTag(TAG_MISSING_DIMENSION);
                return;
            }
            if (description.endsWith(" is not a valid value") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid value")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value2 = matcher.group(1);
                problem.setClientData(new String[]{attribute, value2});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value2);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                this.addMessage(problem);
                return;
            }
            if (description.endsWith(" is not a valid format.") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid format.")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value3 = matcher.group(1);
                problem.setClientData(new String[]{attribute, value3});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value3);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                problem.setClientData(url);
                this.addMessage(problem);
                return;
            }
        } else if (TAG_MISSING_FRAGMENT.equals(tag)) {
            if (!ourIgnoreFragments) {
                if (this.myMissingFragments == null) {
                    this.myMissingFragments = Lists.newArrayList();
                }
                String name = data instanceof String ? (String)data : null;
                this.myMissingFragments.add(name);
            }
            return;
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.WARNING, description).tag(tag));
    }

    public void fidelityWarning(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        if (ourIgnoreAllFidelityWarnings || ourIgnoredFidelityWarnings != null && ourIgnoredFidelityWarnings.contains(message2)) {
            return;
        }
        String description = RenderLogger.describe(message2, throwable);
        if (this.myFidelityWarningStrings != null && this.myFidelityWarningStrings.contains(description)) {
            return;
        }
        if (throwable != null) {
            this.myHaveExceptions = true;
        }
        RenderProblem error = RenderProblem.createDeferred(HighlightSeverity.ERROR, tag, description, throwable);
        error.setClientData(description);
        if (this.myFidelityWarnings == null) {
            this.myFidelityWarnings = new ArrayList<RenderProblem>();
            this.myFidelityWarningStrings = Sets.newHashSet();
        }
        this.myFidelityWarnings.add(error);
        assert (this.myFidelityWarningStrings != null);
        this.myFidelityWarningStrings.add(description);
        this.addTag(tag);
    }

    private void addTag(@Nullable String tag) {
        if (tag == null) {
            return;
        }
        if (this.myTags == null) {
            this.myTags = HashMultiset.create();
        }
        this.myTags.add((Object)tag);
    }

    public boolean seenTagPrefix(@NotNull String prefix) {
        if (this.myTags == null) {
            return false;
        }
        return this.myTags.stream().anyMatch(s -> s.startsWith(prefix));
    }

    @Override
    @NotNull
    public HtmlLinkManager getLinkManager() {
        if (this.myLinkManager == null) {
            this.myLinkManager = new HtmlLinkManager();
        }
        return this.myLinkManager;
    }

    @Override
    public void setHasLoadedClasses() {
        this.myHasLoadedClasses = true;
    }

    public boolean isMissingSize() {
        return this.myMissingSize;
    }

    public boolean hasLoadedClasses() {
        return this.myHasLoadedClasses;
    }

    public boolean isMissingResourceClass() {
        return this.myMissingResourceClass;
    }

    @Override
    public void setMissingResourceClass() {
        this.myMissingResourceClass = true;
    }

    @Nullable
    public String getResourceClass() {
        return this.myResourceClass;
    }

    @Override
    public void setResourceClass(@NotNull String resourceClass) {
        this.myResourceClass = resourceClass;
    }

    @NotNull
    public Map<String, Throwable> getClassesWithIncorrectFormat() {
        return this.myClassesWithIncorrectFormat != null ? this.myClassesWithIncorrectFormat : Collections.emptyMap();
    }

    @NotNull
    public Map<String, Throwable> getBrokenClasses() {
        return this.myBrokenClasses != null ? this.myBrokenClasses : Collections.emptyMap();
    }

    @NotNull
    public Set<String> getMissingClasses() {
        return this.myMissingClasses != null ? this.myMissingClasses : Collections.emptySet();
    }

    @Override
    public void addMissingClass(@NotNull String className) {
        if (!className.equals("fragment")) {
            if (this.myMissingClasses == null) {
                this.myMissingClasses = new TreeSet<String>();
            }
            this.myMissingClasses.add(className);
            this.logMessageToIdeaLog("Class not found " + className);
        }
    }

    @Override
    public void addIncorrectFormatClass(@NotNull String className, @NotNull Throwable exception) {
        if (this.myClassesWithIncorrectFormat == null) {
            this.myClassesWithIncorrectFormat = new HashMap<String, Throwable>();
        }
        this.myClassesWithIncorrectFormat.put(className, exception);
        this.logMessageToIdeaLog("Class with incorrect format " + className, exception);
    }

    @Override
    public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        if (this.myBrokenClasses == null) {
            this.myBrokenClasses = new HashMap<String, Throwable>();
        }
        this.myBrokenClasses.put(className, exception);
        this.logMessageToIdeaLog("Broken class " + className, exception);
    }

    @Nullable
    public List<String> getMissingFragments() {
        return this.myMissingFragments;
    }
}

