/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final ImmutableList<ViewInfo> myRootViews;
    @NotNull
    private final ImmutableList<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, Map<ResourceReference, ResourceValue>> myDefaultProperties;
    @NotNull
    private final Map<Object, String> myDefaultStyles;
    @NotNull
    private final Module myModule;
    private boolean isDisposed;

    protected RenderResult(@NotNull PsiFile file, @NotNull Module module, @NotNull RenderLogger logger, @Nullable RenderTask renderTask, @NotNull Result renderResult, @NotNull ImmutableList<ViewInfo> rootViews, @NotNull ImmutableList<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, Map<ResourceReference, ResourceValue>> defaultProperties, @NotNull Map<Object, String> defaultStyles) {
        this.myRenderTask = renderTask;
        this.myModule = module;
        this.myFile = file;
        this.myLogger = logger;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
        this.myDefaultStyles = defaultStyles;
    }

    public void dispose() {
        this.isDisposed = true;
        this.myImage.dispose();
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger, @NotNull ImagePool.Image image) {
        List rootViews = session.getRootViews();
        List systemRootViews = session.getSystemRootViews();
        Map defaultProperties = session.getDefaultNamespacedProperties();
        Map defaultStyles = session.getDefaultStyles();
        return new RenderResult(file, renderTask.getContext().getModule(), logger, renderTask, session.getResult(), (ImmutableList<ViewInfo>)(rootViews != null ? ImmutableList.copyOf((Collection)rootViews) : ImmutableList.of()), (ImmutableList<ViewInfo>)(systemRootViews != null ? ImmutableList.copyOf((Collection)systemRootViews) : ImmutableList.of()), image, (Map<Object, Map<ResourceReference, ResourceValue>>)(defaultProperties != null ? ImmutableMap.copyOf((Map)defaultProperties) : ImmutableMap.of()), (Map<Object, String>)(defaultStyles != null ? ImmutableMap.copyOf((Map)defaultStyles) : ImmutableMap.of()));
    }

    @NotNull
    public static RenderResult createSessionInitializationError(@NotNull RenderTask renderTask, @NotNull PsiFile file, @NotNull RenderLogger logger, @Nullable Throwable throwable) {
        Module module = logger.getModule();
        assert (module != null);
        return new RenderResult(file, module, logger, renderTask, Result.Status.ERROR_UNKNOWN.createResult("Failed to initialize session", throwable), (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map<Object, Map<ResourceReference, ResourceValue>>)ImmutableMap.of(), (Map<Object, String>)ImmutableMap.of());
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        return new RenderResult(file, module, new RenderLogger(null, module), null, Result.Status.ERROR_UNKNOWN.createResult(""), (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map<Object, Map<ResourceReference, ResourceValue>>)ImmutableMap.of(), (Map<Object, String>)ImmutableMap.of());
    }

    @NotNull
    public Result getRenderResult() {
        return this.myRenderResult;
    }

    @NotNull
    public RenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        return !this.isDisposed ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
    }

    public boolean hasImage() {
        return !this.isDisposed && this.myImage != ImagePool.NULL_POOLED_IMAGE;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public ImmutableList<ViewInfo> getRootViews() {
        return this.myRootViews;
    }

    @NotNull
    public ImmutableList<ViewInfo> getSystemRootViews() {
        return this.mySystemRootViews;
    }

    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        return this.myDefaultProperties;
    }

    @NotNull
    public Map<Object, String> getDefaultStyles() {
        return this.myDefaultStyles;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("renderResult", (Object)this.myRenderResult).add("psiFile", (Object)this.myFile).add("rootViews", this.myRootViews).add("systemViews", this.mySystemRootViews).toString();
    }
}

