/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolFactory;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderService
implements Disposable {
    private static final long DEFAULT_RENDER_THREAD_TIMEOUT_MS;
    @VisibleForTesting
    public static long ourRenderThreadTimeoutMs;
    private static final AtomicReference<Thread> ourRenderingThread;
    private static ExecutorService ourRenderingExecutor;
    private static final AtomicInteger ourTimeoutExceptionCounter;
    private static final Key<RenderService> KEY;
    private static boolean isFirstCall;
    private final Project myProject;
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    private final Object myCredential = new Object();
    private final ImagePool myImagePool = ImagePoolFactory.createImagePool();
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;

    private static void innerInitializeRenderExecutor() {
        ourRenderingExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread renderingThread = new Thread(null, r, "Layoutlib Render Thread");
            renderingThread.setDaemon(true);
            ourRenderingThread.set(renderingThread);
            return renderingThread;
        });
    }

    public static void initializeRenderExecutor() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        RenderService.innerInitializeRenderExecutor();
    }

    private static void shutdownRenderExecutor() {
        ourRenderingExecutor.shutdownNow();
        Thread currentThread = ourRenderingThread.getAndSet(null);
        if (currentThread != null) {
            currentThread.interrupt();
        }
    }

    public static void shutdownRenderExecutor(long timeoutSeconds) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (timeoutSeconds > 0L) {
            try {
                ourRenderingExecutor.awaitTermination(timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                Logger.getInstance(RenderService.class).warn("The RenderExecutor does not shutdown after " + timeoutSeconds + " seconds");
            }
        }
        RenderService.shutdownRenderExecutor();
    }

    @NotNull
    public static RenderService getInstance(@NotNull Project project) {
        RenderService renderService = (RenderService)project.getUserData(KEY);
        if (renderService == null) {
            renderService = new RenderService(project);
            project.putUserData(KEY, (Object)renderService);
        }
        return renderService;
    }

    public static void setForTesting(@NotNull Project project, @Nullable RenderService renderService) {
        project.putUserData(KEY, (Object)renderService);
    }

    @VisibleForTesting
    protected RenderService(@NotNull Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module, @Nullable IAndroidTarget target) {
        if (module == null || target == null) {
            return null;
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            }
            catch (RenderingException | IOException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean supportsCapability(@NotNull Module module, @NotNull IAndroidTarget target, int capability) {
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                LayoutLibrary library = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
                if (library != null) {
                    return library.supports(capability);
                }
            }
            catch (RenderingException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean canRender(@Nullable PsiFile file) {
        return file != null && LayoutPullParsers.isSupported(file);
    }

    @NotNull
    public RenderLogger createLogger(@NotNull AndroidFacet facet) {
        Module module = facet.getModule();
        return new RenderLogger(module.getName(), module, this.myCredential);
    }

    @NotNull
    public RenderTaskBuilder taskBuilder(@NotNull AndroidFacet facet, @NotNull Configuration configuration) {
        return new RenderTaskBuilder(this, facet, configuration, this.myImagePool, this.myCredential);
    }

    public void dispose() {
        this.myProject.putUserData(KEY, null);
        this.myImagePool.dispose();
    }

    @Nullable
    public AndroidPlatform getPlatform(@NotNull AndroidFacet facet) {
        return AndroidPlatform.getInstance(facet.getModule());
    }

    @Nullable
    private static AndroidPlatform getPlatform(@NotNull AndroidFacet facet, @Nullable RenderLogger logger) {
        Module module = facet.getModule();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null && logger != null) {
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                RenderProblem.Html message2 = RenderProblem.create(HighlightSeverity.ERROR);
                logger.addMessage(message2);
                message2.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger.getLinkManager().createRunnableLink(() -> {
                    Project project = module.getProject();
                    ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                    if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() && service instanceof AndroidProjectSettingsService) {
                        ((AndroidProjectSettingsService)service).openSdkSettings();
                        return;
                    }
                    AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                }));
            } else {
                String message3 = AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName());
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message3));
            }
        }
        return platform;
    }

    public static void runRenderAction(@NotNull Runnable runnable) throws Exception {
        RenderService.runRenderAction(Executors.callable(runnable));
    }

    public static <T> T runRenderAction(@NotNull Callable<T> callable) throws Exception {
        try {
            if (ourTimeoutExceptionCounter.get() > 3) {
                ourRenderingExecutor.submit(() -> ourTimeoutExceptionCounter.set(0)).get(50L, TimeUnit.MILLISECONDS);
            }
            long timeout = ourRenderThreadTimeoutMs;
            if (isFirstCall) {
                isFirstCall = false;
                timeout *= 2L;
            }
            T result2 = ourRenderingExecutor.submit(callable).get(timeout, TimeUnit.MILLISECONDS);
            ourTimeoutExceptionCounter.set(0);
            return result2;
        }
        catch (TimeoutException e) {
            ourTimeoutExceptionCounter.incrementAndGet();
            Thread renderingThread = ourRenderingThread.get();
            TimeoutException timeoutException = new TimeoutException("Preview timed out while rendering the layout.\nThis typically happens when there is an infinite loop or unbounded recursion in one of the custom views.");
            if (renderingThread != null) {
                timeoutException.setStackTrace(renderingThread.getStackTrace());
            }
            throw timeoutException;
        }
    }

    @NotNull
    public static <T> CompletableFuture<T> runAsyncRenderAction(@NotNull Supplier<T> callable) {
        return CompletableFuture.supplyAsync(callable, ourRenderingExecutor);
    }

    public static void runAsyncRenderAction(@NotNull Runnable runnable) {
        ourRenderingExecutor.submit(runnable);
    }

    @NotNull
    public static ViewInfo getSafeBounds(@NotNull ViewInfo view) {
        int left2 = Math.abs(view.getLeft());
        int right2 = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom2 = Math.abs(view.getBottom());
        if (left2 < 0x2000000 && right2 < 0x2000000 && top < 0x2000000 && bottom2 < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static XmlTag getXmlTag(@NotNull ViewInfo view) {
        Object cookie = view.getCookie();
        if (cookie != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof XmlTag) {
                return (XmlTag)cookie;
            }
        }
        return null;
    }

    @NotNull
    public ImagePool getSharedImagePool() {
        return this.myImagePool;
    }

    static {
        ourRenderThreadTimeoutMs = DEFAULT_RENDER_THREAD_TIMEOUT_MS = Long.getLong("layoutlib.thread.timeout", TimeUnit.SECONDS.toMillis(ApplicationManager.getApplication().isUnitTestMode() ? 60L : 6L)).longValue();
        ourRenderingThread = new AtomicReference();
        ourTimeoutExceptionCounter = new AtomicInteger(0);
        KEY = Key.create((String)RenderService.class.getName());
        isFirstCall = true;
        RenderService.innerInitializeRenderExecutor();
        ShutDownTracker.getInstance().registerShutdownTask(RenderService::shutdownRenderExecutor);
    }

    public static class RenderTaskBuilder {
        private final RenderService myService;
        private final AndroidFacet myFacet;
        private final Configuration myConfiguration;
        private final Object myCredential;
        @NotNull
        private ImagePool myImagePool;
        @Nullable
        private PsiFile myPsiFile;
        @Nullable
        private RenderLogger myLogger;
        @Nullable
        private ILayoutPullParserFactory myParserFactory;
        private boolean isSecurityManagerEnabled = true;
        private float myDownscaleFactor = 1.0f;
        private boolean showDecorations = true;
        private int myMaxRenderWidth = -1;
        private int myMaxRenderHeight = -1;
        private boolean isShadowEnabled = (Boolean)StudioFlags.NELE_ENABLE_SHADOW.get();
        private boolean useHighQualityShadows = (Boolean)StudioFlags.NELE_RENDER_HIGH_QUALITY_SHADOW.get();

        private RenderTaskBuilder(@NotNull RenderService service, @NotNull AndroidFacet facet, @NotNull Configuration configuration, @NotNull ImagePool defaultImagePool, @NotNull Object credential) {
            this.myService = service;
            this.myFacet = facet;
            this.myConfiguration = configuration;
            this.myImagePool = defaultImagePool;
            this.myCredential = credential;
        }

        @NotNull
        public RenderTaskBuilder withPsiFile(@NotNull PsiFile psiFile) {
            this.myPsiFile = psiFile;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withLogger(@NotNull RenderLogger logger) {
            this.myLogger = logger;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withParserFactory(@NotNull ILayoutPullParserFactory parserFactory) {
            this.myParserFactory = parserFactory;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableImagePool() {
            this.myImagePool = ImagePoolFactory.getNonPooledPool();
            return this;
        }

        @NotNull
        public RenderTaskBuilder withDownscaleFactor(float downscaleFactor) {
            this.myDownscaleFactor = downscaleFactor;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
            this.myMaxRenderWidth = maxRenderWidth;
            this.myMaxRenderHeight = maxRenderHeight;
            return this;
        }

        @VisibleForTesting
        @NotNull
        public RenderTaskBuilder disableSecurityManager() {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("This method can only be called in unit test mode");
            }
            this.isSecurityManagerEnabled = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableDecorations() {
            this.showDecorations = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableShadow() {
            this.isShadowEnabled = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableHighQualityShadow() {
            this.useHighQualityShadows = false;
            return this;
        }

        @NotNull
        public CompletableFuture<RenderTask> build() {
            if (this.myLogger == null) {
                this.withLogger(this.myService.createLogger(this.myFacet));
            }
            return CompletableFuture.supplyAsync(() -> {
                LayoutLibrary layoutLib;
                AndroidPlatform platform = RenderService.getPlatform(this.myFacet, this.myLogger);
                if (platform == null) {
                    return null;
                }
                IAndroidTarget target = this.myConfiguration.getTarget();
                if (target == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
                    return null;
                }
                Module module = this.myFacet.getModule();
                try {
                    layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(module.getProject());
                    if (layoutLib == null) {
                        String message2 = AndroidBundle.message("android.layout.preview.cannot.load.library.error", new Object[0]);
                        this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2));
                        return null;
                    }
                }
                catch (UnsupportedJavaRuntimeException e) {
                    RenderProblem.Html javaVersionProblem = RenderProblem.create(HighlightSeverity.ERROR);
                    javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", RenderService.JDK_INSTALL_URL);
                    this.myLogger.addMessage(javaVersionProblem);
                    return null;
                }
                catch (RenderingException e) {
                    String message3 = e.getPresentableMessage();
                    message3 = message3 != null ? message3 : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message3, module.getProject(), this.myLogger.getLinkManager(), e));
                    return null;
                }
                catch (IOException e) {
                    String message4 = e.getMessage();
                    this.myLogger.error(null, "I/O error: " + (message4 != null ? ": " + message4 : ""), e, null, null);
                    return null;
                }
                if (this.myPsiFile != null && "PreferenceScreen".equals(AndroidPsiUtils.getRootTagName(this.myPsiFile)) && !layoutLib.supports(14)) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "This version of the rendering library does not support rendering Preferences. Update it using the SDK Manager"));
                    return null;
                }
                Device device = this.myConfiguration.getDevice();
                if (device == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
                    return null;
                }
                try {
                    RenderTask task = new RenderTask(this.myFacet, this.myService, this.myConfiguration, this.myLogger, layoutLib, device, this.myCredential, (CrashReporter)StudioCrashReporter.getInstance(), this.myImagePool, this.myParserFactory, this.isSecurityManagerEnabled, this.myDownscaleFactor);
                    if (this.myPsiFile instanceof XmlFile) {
                        task.setXmlFile((XmlFile)this.myPsiFile);
                    }
                    task.setDecorations(this.showDecorations).setHighQualityShadows(this.useHighQualityShadows).setShadowEnabled(this.isShadowEnabled);
                    if (this.myMaxRenderWidth != -1 && this.myMaxRenderHeight != -1) {
                        task.setMaxRenderSize(this.myMaxRenderWidth, this.myMaxRenderHeight);
                    }
                    return task;
                }
                catch (IncorrectOperationException | AssertionError | IllegalStateException e) {
                    if (!module.isDisposed()) {
                        throw e;
                    }
                    return null;
                }
            }, AppExecutorUtil.getAppExecutorService());
        }

        @Nullable
        public RenderTask buildSynchronously() {
            return (RenderTask)Futures.getUnchecked(this.build());
        }
    }
}

