/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.CachingImageFactory;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTaskContext;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutFilePullParser;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderTask {
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private static final IImageFactory SIMPLE_IMAGE_FACTORY = new IImageFactory(){

        @NotNull
        public BufferedImage getImage(int width, int height) {
            BufferedImage image = new BufferedImage(width, height, 2);
            image.setAccelerationPriority(1.0f);
            return image;
        }
    };
    private static final float MIN_DOWNSCALING_FACTOR = 0.7f;
    private static final int DOWNSCALED_IMAGE_MAX_BYTES = 2500000;
    private static final ExecutorService ourDisposeService = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            return new Thread(runnable, "RenderTask dispose thread");
        }
    });
    @NotNull
    private final ImagePool myImagePool;
    @NotNull
    private final RenderTaskContext myContext;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    private final float myDefaultQuality;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode = SessionParams.RenderingMode.NORMAL;
    @Nullable
    private Integer myOverrideBgColor;
    private boolean myShowDecorations = true;
    private boolean myShadowEnabled = true;
    private boolean myHighQualityShadow = true;
    private AssetRepositoryImpl myAssetRepository;
    private long myTimeout;
    @NotNull
    private final Locale myLocale;
    @NotNull
    private final Object myCredential;
    private boolean myProvideCookiesForIncludedViews = false;
    @Nullable
    private RenderSession myRenderSession;
    @NotNull
    private IImageFactory myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
    @Nullable
    private IImageFactory myImageFactoryDelegate;
    private final boolean isSecurityManagerEnabled;
    @NotNull
    private CrashReporter myCrashReporter;
    private final List<CompletableFuture<?>> myRunningFutures = new LinkedList();
    @NotNull
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    @Nullable
    private XmlFile myXmlFile;

    RenderTask(@NotNull AndroidFacet facet, @NotNull RenderService renderService, @NotNull Configuration configuration, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Device device, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory, boolean isSecurityManagerEnabled, float quality) {
        this.isSecurityManagerEnabled = isSecurityManagerEnabled;
        if (!isSecurityManagerEnabled) {
            LOG.debug("Security manager was disabled");
        }
        this.myLogger = logger;
        this.myCredential = credential;
        this.myCrashReporter = crashReporter;
        this.myImagePool = imagePool;
        this.myAssetRepository = new AssetRepositoryImpl(facet);
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        ScreenOrientation orientation = configuration.getFullConfig().getScreenOrientationQualifier() != null ? configuration.getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet);
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        Module module = facet.getModule();
        this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, appResources, module, facet, this.myLogger, this.myCredential, actionBarHandler, parserFactory);
        if (ResourceIdManager.get(module).finalIdsUsed()) {
            this.myLayoutlibCallback.loadAndParseRClass();
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        this.myLocale = configuration.getLocale();
        this.myContext = new RenderTaskContext(module.getProject(), module, configuration, moduleInfo, renderService.getPlatform(facet));
        this.myDefaultQuality = quality;
        this.restoreDefaultQuality();
    }

    public void setQuality(float quality) {
        if (quality >= 1.0f) {
            this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
            return;
        }
        float actualSamplingFactor = 0.7f + Math.max(Math.min(quality, 1.0f), 0.0f) * 0.3f;
        long maxSize = (long)(2500000.0f * actualSamplingFactor);
        this.myCachingImageFactory = new CachingImageFactory((width, height) -> {
            int downscaleWidth = width;
            int downscaleHeight = height;
            int size = width * height;
            if ((long)size > maxSize) {
                double scale = (double)maxSize / (double)size;
                downscaleWidth = (int)((double)downscaleWidth * scale);
                downscaleHeight = (int)((double)downscaleHeight * scale);
            }
            return SIMPLE_IMAGE_FACTORY.getImage(downscaleWidth, downscaleHeight);
        });
    }

    public void restoreDefaultQuality() {
        this.setQuality(this.myDefaultQuality);
    }

    public void setXmlFile(@NotNull XmlFile file) {
        this.myXmlFile = file;
        ReadAction.run(() -> this.getContext().setFolderType(ResourceHelper.getFolderType((PsiFile)file)));
    }

    @Nullable
    public XmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @NotNull
    public IRenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        return this.myHardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public Future<?> dispose() {
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        return ourDisposeService.submit(() -> {
            try {
                CompletableFuture[] currentRunningFutures;
                List<CompletableFuture<?>> list = this.myRunningFutures;
                synchronized (list) {
                    currentRunningFutures = this.myRunningFutures.toArray(new CompletableFuture[0]);
                    this.myRunningFutures.clear();
                }
                CompletableFuture.allOf(currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
            if (this.myRenderSession != null) {
                try {
                    RenderService.runAsyncRenderAction(() -> ((RenderSession)this.myRenderSession).dispose());
                    this.myRenderSession = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.myImageFactoryDelegate = null;
            this.myAssetRepository = null;
            return null;
        });
    }

    @NotNull
    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderTask setOverrideBgColor(@Nullable Integer overrideBgColor) {
        this.myOverrideBgColor = overrideBgColor;
        return this;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    public RenderTask setShadowEnabled(boolean shadowEnabled) {
        this.myShadowEnabled = shadowEnabled;
        return this;
    }

    public RenderTask setHighQualityShadows(boolean highQualityShadows) {
        this.myHighQualityShadow = highQualityShadows;
        return this;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory) {
        RenderSecurityManager securityManager;
        RenderTaskContext context;
        IAndroidTarget target;
        ILayoutPullParser includingParser;
        XmlFile psiFile = this.getXmlFile();
        if (psiFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        if (this.isDisposed.get()) {
            return null;
        }
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)this.getContext().getConfiguration().getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutPsiPullParser) {
            boolean useSrcCompat = DependencyManagementUtil.dependsOn(this.getContext().getModule(), GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(this.getContext().getModule(), GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
            ((LayoutPsiPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources((Map<String, TagSnapshot>)((LayoutPsiPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser((RenderResources)resolver, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = (context = this.getContext()).getConfiguration().getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        Module module = context.getModule();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger, simulatedPlatform);
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)AndroidPsiUtils.getRootTagName((PsiFile)psiFile));
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ENABLE_SHADOW, (Object)this.myShadowEnabled);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_HIGH_QUALITY_SHADOW, (Object)this.myHighQualityShadow);
        params.setExtendedViewInfoMode(true);
        MergedManifestSnapshot manifestInfo = MergedManifestManager.getSnapshot(module);
        Configuration configuration = context.getConfiguration();
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Device device = configuration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                ResourceValue resource;
                ResourceValue appLabel = manifestInfo.getApplicationLabel();
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = configuration.getActivity();
                if (activity != null) {
                    params.setActivityName(activity);
                    ActivityAttributesSnapshot attributes = manifestInfo.getActivityAttributes(activity);
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            appLabel = attributes.getLabel();
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
                if ((resource = params.getResources().resolveResValue(appLabel)) != null) {
                    params.setAppLabel(resource.getValue());
                }
            }
            catch (Exception appLabel) {
                // empty catch block
            }
        }
        if (this.myOverrideBgColor != null) {
            params.setOverrideBgColor(this.myOverrideBgColor.intValue());
        } else if (this.requiresTransparency()) {
            params.setOverrideBgColor(0);
        }
        params.setImageFactory(factory);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        this.myLayoutlibCallback.setLogger(this.myLogger);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? RenderSecurityManagerFactory.create(module, this.getContext().getPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session = this.myLayoutLib.createSession(params);
            if (session.getResult().isSuccess()) {
                long now = System.nanoTime();
                session.setSystemBootTimeNanos(now);
                session.setSystemTimeNanos(now);
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            RenderResult result2 = RenderResult.create(this, session, (PsiFile)psiFile, this.myLogger, this.myImagePool.copyOf(session.getImage()));
            this.myRenderSession = session;
            this.addDiagnostics(result2.getRenderResult());
            RenderResult renderResult = result2;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t) {
                this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
                throw t;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(RenderResources resolver, ILayoutPullParser modelParser) {
        XmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (this.myIncludedWithin == null) {
            String layout2 = IncludeReference.getIncludingLayout(xmlFile);
            Module module = this.getContext().getModule();
            this.myIncludedWithin = layout2 != null ? IncludeReference.get(module, xmlFile, resolver) : IncludeReference.NONE;
        }
        ILayoutPullParser topParser = null;
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Comparing.equal((Object)this.myIncludedWithin.getToFile(), (Object)xmlFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            String queryLayoutName = ResourceHelper.getResourceName((PsiFile)xmlFile);
            this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.getContext().getProject(), layoutVirtualFile);
            if (psiFile instanceof XmlFile) {
                LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                parser.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                topParser = parser;
            } else {
                topParser = LayoutFilePullParser.create(new PathString(this.myIncludedWithin.getFromPath()), ResourceNamespace.TODO());
                if (topParser == null) {
                    this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), null, null, null);
                }
            }
        }
        return topParser;
    }

    private static <T> CompletableFuture<T> immediateFailedFuture(Throwable exception) {
        CompletableFuture future2 = new CompletableFuture();
        future2.completeExceptionally(exception);
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Supplier<V> callable) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        List<CompletableFuture<?>> list = this.myRunningFutures;
        synchronized (list) {
            CompletableFuture newFuture = RenderService.runAsyncRenderAction(callable);
            this.myRunningFutures.add(newFuture);
            newFuture.whenCompleteAsync((result2, ex) -> {
                List<CompletableFuture<?>> list = this.myRunningFutures;
                synchronized (list) {
                    this.myRunningFutures.remove(newFuture);
                }
            });
            return newFuture;
        }
    }

    @NotNull
    public CompletableFuture<RenderResult> inflate() {
        XmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile"));
        }
        if (xmlFile.getProject().isDisposed()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return this.runAsyncRenderAction(() -> this.createRenderSession((width, height) -> {
                if (this.myImageFactoryDelegate != null) {
                    return this.myImageFactoryDelegate.getImage(width, height);
                }
                return new BufferedImage(width, height, 2);
            }));
        }
        catch (Exception e) {
            String message2 = e.getMessage();
            if (message2 == null) {
                message2 = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            return CompletableFuture.completedFuture(RenderResult.createSessionInitializationError(this, (PsiFile)xmlFile, this.myLogger, e));
        }
    }

    @NotNull
    public CompletableFuture<RenderResult> layout() {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        assert (this.getXmlFile() != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            XmlFile psiFile = this.getXmlFile();
            return this.runAsyncRenderAction(() -> this.lambda$layout$6(renderSession, (PsiFile)psiFile));
        }
        catch (Exception exception) {
            return CompletableFuture.completedFuture(null);
        }
    }

    private void reportException(@NotNull Throwable e) {
        this.myCrashReporter.submit((CrashReport)new StudioExceptionReport.Builder().setThrowable(e, false).build());
    }

    @NotNull
    private CompletableFuture<RenderResult> renderInner() {
        XmlFile psiFile = this.getXmlFile();
        assert (psiFile != null);
        CompletionStage<Object> inflateCompletableResult = this.myRenderSession == null ? this.inflate().whenComplete((renderResult, exception) -> {
            Result result2;
            Result result3 = result2 = renderResult != null ? renderResult.getRenderResult() : null;
            if (result2 == null || !result2.isSuccess()) {
                Throwable e;
                Throwable throwable = e = result2 != null ? result2.getException() : exception;
                if (e != null) {
                    this.reportException(e);
                }
                if (result2 != null) {
                    this.myLogger.error(null, result2.getErrorMessage(), e, null, null);
                }
            }
        }) : CompletableFuture.completedFuture(null);
        return inflateCompletableResult.thenCompose(arg_0 -> this.lambda$renderInner$9((PsiFile)psiFile, arg_0));
    }

    @NotNull
    CompletableFuture<RenderResult> render(@NotNull IImageFactory factory) {
        this.myImageFactoryDelegate = factory;
        return this.renderInner();
    }

    @NotNull
    public CompletableFuture<RenderResult> render() {
        return this.render(this.myCachingImageFactory);
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result2) {
        ILayoutPullParser layoutEmbeddedParser;
        if (!this.myLogger.hasProblems() && !result2.isSuccess()) {
            if (result2.getException() != null || result2.getErrorMessage() != null) {
                this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
            } else if (result2.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result2.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull ResourceValue drawableResourceValue) {
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderTaskContext context = this.getContext();
        Module module = this.getContext().getModule();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)context.getConfiguration().getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        return this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params)).thenCompose(result2 -> {
            Throwable exception;
            if (result2 != null && result2.isSuccess()) {
                Object data = result2.getData();
                if (!(data instanceof BufferedImage)) {
                    data = null;
                }
                return CompletableFuture.completedFuture((BufferedImage)data);
            }
            Throwable throwable = exception = result2 == null ? new RuntimeException("Rendering failed - null result") : result2.getException();
            if (exception == null) {
                String message2 = result2.getErrorMessage();
                exception = new RuntimeException(message2 == null ? "Rendering failed" : "Rendering failed - " + message2);
            }
            this.reportException(exception);
            return RenderTask.immediateFailedFuture(exception);
        });
    }

    @NotNull
    public List<BufferedImage> renderDrawableAllStates(@Nullable ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            return Collections.emptyList();
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderTaskContext context = this.getContext();
        Module module = context.getModule();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)context.getConfiguration().getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        boolean supportsMultipleStates = this.myLayoutLib.supports(15);
        if (supportsMultipleStates) {
            params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES, (Object)Boolean.TRUE);
        }
        try {
            Result result2 = RenderService.runRenderAction(() -> this.myLayoutLib.renderDrawable(params));
            if (result2 != null && result2.isSuccess()) {
                Object data = result2.getData();
                if (supportsMultipleStates && data instanceof List) {
                    return (List)data;
                }
                if (!supportsMultipleStates && data instanceof BufferedImage) {
                    return Collections.singletonList((BufferedImage)data);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        return this.myLayoutLib;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        return this.myLayoutlibCallback;
    }

    public boolean supportsCapability(int capability) {
        return this.myLayoutLib.supports(capability);
    }

    private boolean isNonRectangular() {
        ResourceFolderType folderType = this.getContext().getFolderType();
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    private boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    @NotNull
    public CompletableFuture<Map<XmlTag, ViewInfo>> measureChildren(@NotNull XmlTag parent, @Nullable AttributeFilter filter2) {
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter2, parent, this.myLogger);
        HashMap map2 = new HashMap();
        return RenderService.runAsyncRenderAction(() -> this.measure(modelParser)).thenComposeAsync(session -> {
            if (session != null) {
                try {
                    Result result2 = session.getResult();
                    if (result2 != null && result2.isSuccess()) {
                        assert (session.getRootViews().size() == 1);
                        ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                        List children = root.getChildren();
                        for (ViewInfo info : children) {
                            XmlTag tag = RenderService.getXmlTag(info);
                            if (tag == null) continue;
                            map2.put(tag, info);
                        }
                    }
                    CompletableFuture<Map> completableFuture = CompletableFuture.completedFuture(map2);
                    return completableFuture;
                }
                finally {
                    RenderService.runAsyncRenderAction(() -> ((RenderSession)session).dispose());
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        });
    }

    @Nullable
    public ViewInfo measureChild(@NotNull XmlTag tag, @Nullable AttributeFilter filter2) {
        Map map2;
        XmlTag parent = tag.getParentTag();
        if (parent != null && (map2 = (Map)Futures.getUnchecked(this.measureChildren(parent, filter2))) != null) {
            for (Map.Entry entry : map2.entrySet()) {
                if (entry.getKey() != tag) continue;
                return (ViewInfo)entry.getValue();
            }
        }
        return null;
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        RenderTaskContext context = this.getContext();
        ResourceResolver resolver = context.getConfiguration().getResourceResolver();
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.getContext().getModule();
        SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        MergedManifestSnapshot manifestInfo = MergedManifestManager.getSnapshot(module);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            return this.myLayoutLib.createSession(params);
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
            throw t;
        }
    }

    @VisibleForTesting
    void setCrashReporter(@NotNull CrashReporter crashReporter) {
        this.myCrashReporter = crashReporter;
    }

    @NotNull
    public RenderTaskContext getContext() {
        return this.myContext;
    }

    private /* synthetic */ CompletionStage lambda$renderInner$9(PsiFile psiFile, RenderResult ignored) {
        try {
            return this.runAsyncRenderAction(() -> {
                this.myRenderSession.render();
                RenderResult result2 = RenderResult.create(this, this.myRenderSession, psiFile, this.myLogger, this.myImagePool.copyOf(this.myRenderSession.getImage()));
                Result renderResult = result2.getRenderResult();
                if (renderResult.getException() != null) {
                    this.reportException(renderResult.getException());
                    this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
                }
                return result2;
            });
        }
        catch (Exception e) {
            this.reportException(e);
            String message2 = e.getMessage();
            if (message2 == null) {
                message2 = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            return CompletableFuture.completedFuture(RenderResult.createSessionInitializationError(this, psiFile, this.myLogger, e));
        }
    }

    private /* synthetic */ RenderResult lambda$layout$6(RenderSession renderSession, PsiFile psiFile) {
        this.myRenderSession.measure();
        return RenderResult.create(this, renderSession, psiFile, this.myLogger, ImagePool.NULL_POOLED_IMAGE);
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull XmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

