/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.imagepool;

import com.android.tools.idea.rendering.imagepool.ImagePool;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonPooledImage
implements ImagePool.Image {
    private BufferedImage myImage;

    private NonPooledImage(@NotNull BufferedImage image) {
        this.myImage = image;
    }

    @Override
    public int getWidth() {
        assert (this.myImage != null) : "Image already disposed";
        return this.myImage.getWidth();
    }

    @Override
    public int getHeight() {
        assert (this.myImage != null) : "Image already disposed";
        return this.myImage.getHeight();
    }

    @Override
    public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        assert (this.myImage != null) : "Image already disposed";
        g.drawImage(this.myImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    @Override
    public void paint(Consumer<Graphics2D> command) {
        assert (this.myImage != null) : "Image already disposed";
        command.accept(this.myImage.createGraphics());
    }

    @Override
    @Nullable
    public BufferedImage getCopy(@Nullable GraphicsConfiguration gc, int x, int y, int w, int h) {
        assert (this.myImage != null) : "Image already disposed";
        if (x == 0 && y == 0 && w == this.getWidth() && h == this.getHeight()) {
            return NonPooledImage.copy(this.myImage);
        }
        return NonPooledImage.copy(this.myImage.getSubimage(x, y, w, h));
    }

    @Override
    public void dispose() {
        this.myImage = null;
    }

    @NotNull
    private static BufferedImage copy(@NotNull BufferedImage originalImage) {
        WritableRaster raster = originalImage.copyData(originalImage.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(originalImage.getColorModel(), raster, originalImage.isAlphaPremultiplied(), null);
    }

    @NotNull
    public static NonPooledImage create(int w, int h, int type) {
        return new NonPooledImage(new BufferedImage(w, h, type));
    }

    @NotNull
    static NonPooledImage copyOf(@NotNull BufferedImage image) {
        return new NonPooledImage(NonPooledImage.copy(image));
    }
}

