/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityRenderTarget
implements IAndroidTarget {
    private final int myApiLevel;
    private final IAndroidTarget myDelegate;
    private final AndroidVersion myVersion;
    private final IAndroidTarget myRealTarget;
    private final String myHashString;

    public CompatibilityRenderTarget(@NotNull IAndroidTarget delegate, int apiLevel, @Nullable IAndroidTarget realTarget) {
        this.myDelegate = delegate;
        this.myApiLevel = apiLevel;
        this.myRealTarget = realTarget;
        this.myVersion = realTarget != null ? realTarget.getVersion() : new AndroidVersion(apiLevel, null);
        this.myHashString = "compat-" + AndroidTargetHash.getPlatformHashString((AndroidVersion)this.myVersion);
    }

    public static IAndroidTarget copyWithNewDelegate(@NotNull CompatibilityRenderTarget original, @NotNull IAndroidTarget newDelegate) {
        return new CompatibilityRenderTarget(newDelegate, original.myApiLevel, original.myRealTarget);
    }

    @NotNull
    public IAndroidTarget getRenderTarget() {
        return this.myDelegate;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        return this.myRealTarget;
    }

    public String getDescription() {
        return this.myDelegate.getDescription();
    }

    @NotNull
    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    public String getVersionName() {
        return SdkVersionInfo.getAndroidName((int)this.myApiLevel);
    }

    public String hashString() {
        return this.myHashString;
    }

    public int compareTo(@NotNull IAndroidTarget other) {
        int delta = this.myApiLevel - other.getVersion().getApiLevel();
        if (delta != 0) {
            return delta;
        }
        return this.myDelegate.compareTo((Object)other);
    }

    public int getRevision() {
        return 1;
    }

    @NotNull
    public String getPath(int pathId) {
        return this.myDelegate.getPath(pathId);
    }

    @NotNull
    public File getFile(int pathId) {
        return this.myDelegate.getFile(pathId);
    }

    @NotNull
    public String getLocation() {
        return this.myDelegate.getLocation();
    }

    public String getVendor() {
        return this.myDelegate.getVendor();
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public String getFullName() {
        return this.myDelegate.getFullName();
    }

    public String getClasspathName() {
        return this.myDelegate.getClasspathName();
    }

    public String getShortClasspathName() {
        return this.myDelegate.getShortClasspathName();
    }

    public boolean isPlatform() {
        return this.myDelegate.isPlatform();
    }

    public IAndroidTarget getParent() {
        return this.myDelegate.getParent();
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.myDelegate.getBuildToolInfo();
    }

    @NotNull
    public List<String> getBootClasspath() {
        return this.myDelegate.getBootClasspath();
    }

    public boolean hasRenderingLibrary() {
        return this.myDelegate.hasRenderingLibrary();
    }

    @NotNull
    public File[] getSkins() {
        return this.myDelegate.getSkins();
    }

    @Nullable
    public File getDefaultSkin() {
        return this.myDelegate.getDefaultSkin();
    }

    @NotNull
    public List<OptionalLibrary> getOptionalLibraries() {
        return this.myDelegate.getOptionalLibraries();
    }

    @NotNull
    public List<OptionalLibrary> getAdditionalLibraries() {
        return this.myDelegate.getAdditionalLibraries();
    }

    public String[] getPlatformLibraries() {
        return this.myDelegate.getPlatformLibraries();
    }

    public String getProperty(String name) {
        return this.myDelegate.getProperty(name);
    }

    public Map<String, String> getProperties() {
        return this.myDelegate.getProperties();
    }

    public boolean canRunOn(IAndroidTarget target) {
        return this.myDelegate.canRunOn(target);
    }
}

