/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.parsers.DomPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

class MenuLayoutParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";

    private MenuLayoutParserFactory() {
    }

    @NotNull
    public static ILayoutPullParser create(@NotNull PsiFile psiFile, @NotNull LayoutlibCallbackImpl layoutlibCallback) {
        ResourceRepositoryManager repositoryManager;
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true);
        if (frameLayoutDocument == null) {
            return LayoutPullParsers.createEmptyParser();
        }
        ActionBarHandler actionBarHandler = layoutlibCallback.getActionBarHandler();
        if (actionBarHandler != null && (repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)psiFile)) != null) {
            ResourceReference menuResource = new ResourceReference(repositoryManager.getNamespace(), ResourceType.MENU, ResourceHelper.getResourceName(psiFile));
            actionBarHandler.setMenuIds(Collections.singletonList(menuResource));
        }
        return DomPullParser.createFromDocument(frameLayoutDocument, Collections.emptyMap());
    }

    @NotNull
    public static ILayoutPullParser createInNavigationView(@NotNull PsiFile file) {
        String xml = "<android.support.design.widget.NavigationView xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:layout_width=\"wrap_content\"\n    android:layout_height=\"match_parent\"\n    app:menu=\"@menu/" + ResourceHelper.getResourceName(file) + "\" />\n";
        Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
        return document == null ? LayoutPullParsers.createEmptyParser() : DomPullParser.createFromDocument(document);
    }
}

