/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.rendering.webp.ConvertToWebpAction;
import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.android.tools.idea.rendering.webp.WebpConvertedFile;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpPreviewDialog
extends DialogWrapper
implements ChangeListener,
KeyListener {
    private final ConvertToWebpAction.WebpConversionTask myTask;
    private final Project myProject;
    private final WebpConversionSettings mySettings;
    private JBLabel myPngSizeLabel;
    private JSlider myQualitySlider;
    private JBLabel myQualityText;
    private JPanel myPanel;
    private JBLabel myFileIndexLabel;
    private JComponent myPreviewImage;
    private JBLabel myWebpSizeLabel;
    private JBLabel myQualityLabel;
    private JBLabel myPngLabel;
    private BufferedImage myPngImage;
    private BufferedImage myWebpImage;
    private BufferedImage myDeltaImage;
    private int myPngBytes;
    private int myWebpBytes;
    private boolean myAllowLossless;
    private List<WebpConvertedFile> myFiles;
    private int myFileIndex;
    private PrevAction myPrevAction;
    private NextAction myNextAction;
    private MergingUpdateQueue myRenderingQueue;
    private AcceptAllAction myAcceptAll;

    WebpPreviewDialog(@NotNull ConvertToWebpAction.WebpConversionTask task, @NotNull Project project, @NotNull WebpConversionSettings settings, @NotNull List<WebpConvertedFile> files2) {
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Preview and Adjust Converted Images");
        this.myTask = task;
        this.myProject = project;
        this.mySettings = settings;
        this.myFiles = files2;
        this.myQualitySlider.setValue(settings.quality);
        this.myQualitySlider.addChangeListener(this);
        this.myAllowLossless = settings.allowLossless;
        this.init();
        this.myRenderingQueue = new MergingUpdateQueue(WebpPreviewDialog.class.getSimpleName(), 50, true, null, this.getDisposable(), null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myRenderingQueue.setRestartTimerOnAdd(true);
        this.addKeyListener(this);
        this.myPanel.addKeyListener(this);
        this.myPreviewImage.setFocusable(true);
        this.myPreviewImage.requestFocus();
        this.selectImage(0);
    }

    private void selectImage(int index) {
        this.myFileIndex = index;
        this.myPngImage = null;
        this.myPngBytes = 0;
        this.myWebpImage = null;
        this.myWebpBytes = 0;
        this.myDeltaImage = null;
        this.myPrevAction.setEnabled(this.myFileIndex > 0);
        boolean isLast = this.myFileIndex == this.myFiles.size() - 1;
        this.myNextAction.setEnabled(!isLast);
        this.myAcceptAll.putValue("Name", isLast ? "Finish" : "Accept All");
        this.myPanel.repaint();
        this.requestUpdatePreview();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)1200, (int)600));
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myPreviewImage = new JComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D graphics = (Graphics2D)g.create();
                try {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    int third = width / 3;
                    graphics.setColor((Color)JBColor.WHITE);
                    graphics.fillRect(0, 0, width, height);
                    if (WebpPreviewDialog.this.myPngImage == null) {
                        Icon icon2 = AllIcons.Process.Big.Step_8;
                        icon2.paintIcon(this, g, width / 2 - icon2.getIconWidth() / 2, height / 2 - icon2.getIconHeight() / 2);
                        return;
                    }
                    int imageWidth = WebpPreviewDialog.this.myPngImage.getWidth();
                    int imageHeight = WebpPreviewDialog.this.myPngImage.getHeight();
                    if (imageWidth < third && imageHeight < height) {
                        int centerX = (third - imageWidth) / 2;
                        int centerY = (height - imageHeight) / 2;
                        graphics.drawImage(WebpPreviewDialog.this.myPngImage, null, centerX, centerY);
                        if (WebpPreviewDialog.this.myDeltaImage != null) {
                            graphics.drawImage(WebpPreviewDialog.this.myDeltaImage, null, third + centerX, centerY);
                        }
                        if (WebpPreviewDialog.this.myWebpImage != null) {
                            graphics.drawImage(WebpPreviewDialog.this.myWebpImage, null, 2 * third + centerX, centerY);
                        }
                    } else {
                        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        double scale = Math.min((double)height / (double)imageHeight, (double)third / (double)imageWidth);
                        int dx = (int)((double)third - (double)imageWidth * scale) / 2;
                        int dy = (int)((double)height - (double)imageHeight * scale) / 2;
                        graphics.drawImage(WebpPreviewDialog.this.myPngImage, dx, dy, (int)((double)imageWidth * scale), (int)((double)imageHeight * scale), null);
                        if (WebpPreviewDialog.this.myDeltaImage != null) {
                            graphics.drawImage(WebpPreviewDialog.this.myDeltaImage, third + dx, dy, (int)((double)imageWidth * scale), (int)((double)imageHeight * scale), null);
                        }
                        if (WebpPreviewDialog.this.myWebpImage != null) {
                            graphics.drawImage(WebpPreviewDialog.this.myWebpImage, 2 * third + dx, dy, (int)((double)imageWidth * scale), (int)((double)imageHeight * scale), null);
                        }
                    }
                    graphics.setColor((Color)JBColor.GRAY);
                    graphics.drawLine(third, 0, third, height);
                    graphics.drawLine(2 * third, 0, 2 * third, height);
                }
                finally {
                    graphics.dispose();
                }
            }
        };
    }

    private void selectPrevious() {
        if (this.myFileIndex > 0) {
            this.selectImage(this.myFileIndex - 1);
        }
    }

    private void selectNext() {
        if (this.myFileIndex < this.myFiles.size() - 1) {
            this.selectImage(this.myFileIndex + 1);
        }
    }

    @NotNull
    protected Action[] createActions() {
        this.myPrevAction = new PrevAction();
        this.myNextAction = new NextAction();
        this.myAcceptAll = new AcceptAllAction();
        this.myPrevAction.setEnabled(false);
        this.myNextAction.setEnabled(this.myFiles.size() > 1);
        if (SystemInfo.isMac) {
            return new Action[]{this.getCancelAction(), this.myPrevAction, this.myNextAction, this.myAcceptAll};
        }
        return new Action[]{this.myPrevAction, this.myNextAction, this.myAcceptAll, this.getCancelAction()};
    }

    private void updatePreview() {
        if (this.myFiles.isEmpty()) {
            return;
        }
        WebpConvertedFile convertedFile = this.myFiles.get(this.myFileIndex);
        if (this.myPngImage == null) {
            try {
                this.myPngImage = convertedFile.getSourceImage();
                this.myPngBytes = (int)convertedFile.sourceFile.getLength();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myPngImage != null) {
            this.mySettings.quality = this.myQualitySlider.getValue();
            this.mySettings.lossless = this.myAllowLossless && this.mySettings.quality == 100;
            convertedFile.convert(this.myPngImage, this.mySettings);
            byte[] bytes = convertedFile.encoded;
            try {
                this.myWebpImage = bytes != null ? ImageIO.read(new ByteArrayInputStream(bytes)) : null;
                int n = this.myWebpBytes = bytes != null ? bytes.length : 0;
                if (this.myWebpImage != null) {
                    int imageWidth = this.myPngImage.getWidth();
                    int imageHeight = this.myPngImage.getHeight();
                    int level = JBColor.WHITE.getRed();
                    boolean light = level >= 128;
                    this.myDeltaImage = new BufferedImage(imageWidth, imageHeight, 2);
                    if (!this.mySettings.lossless) {
                        for (int y = 0; y < imageHeight; ++y) {
                            for (int x = 0; x < imageWidth; ++x) {
                                int webpPixel = this.myWebpImage.getRGB(x, y);
                                int pngPixel = this.myPngImage.getRGB(x, y);
                                int webpBlue = webpPixel & 0xFF;
                                int pngBlue = pngPixel & 0xFF;
                                int blueDelta = Math.abs(webpBlue - pngBlue);
                                int webpGreen = (webpPixel >>>= 8) & 0xFF;
                                int pngGreen = (pngPixel >>>= 8) & 0xFF;
                                int greenDelta = Math.abs(webpGreen - pngGreen);
                                int webpRed = (webpPixel >>>= 8) & 0xFF;
                                int pngRed = (pngPixel >>>= 8) & 0xFF;
                                int redDelta = Math.abs(webpRed - pngRed);
                                int pngAlpha = (pngPixel >>>= 8) & 0xFF;
                                int alpha = pngAlpha << 24;
                                int deltaColor = light ? alpha | level - redDelta << 16 | level - greenDelta << 8 | level - blueDelta : alpha | level + redDelta << 16 | level + greenDelta << 8 | level + blueDelta;
                                this.myDeltaImage.setRGB(x, y, deltaColor);
                            }
                        }
                    }
                } else {
                    this.myDeltaImage = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myPngSizeLabel.setText(ConvertToWebpAction.formatSize(this.myPngBytes));
                int percentage = this.myWebpBytes * 100 / this.myPngBytes;
                this.myWebpSizeLabel.setText(ConvertToWebpAction.formatSize(this.myWebpBytes) + " (" + percentage + "% of original size)");
                VirtualFile file = this.myFiles.get((int)this.myFileIndex).sourceFile;
                String path = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.myProject.getBaseDir());
                this.myFileIndexLabel.setText(path + " (" + (this.myFileIndex + 1) + "/" + this.myFiles.size() + ")");
                this.myQualityLabel.setText(this.mySettings.lossless ? "Lossless" : "Quality (Default 75%)");
                String extension = convertedFile.sourceFile.getExtension();
                extension = extension == null ? "Source" : extension.toUpperCase(Locale.US);
                this.myPngLabel.setText(extension);
                this.repaint();
            });
        }
    }

    private void requestUpdatePreview() {
        this.myRenderingQueue.queue(new Update(WebpPreviewDialog.class.getSimpleName(), 999){

            public void run() {
                if (WebpPreviewDialog.this.myProject.isDisposed()) {
                    return;
                }
                WebpPreviewDialog.this.updatePreview();
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    private void updateQualityText() {
        this.myQualityText.setText(Integer.toString(this.myQualitySlider.getValue()) + "%");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.requestUpdatePreview();
        this.updateQualityText();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 40 || e.getKeyCode() == 39) {
            this.selectNext();
        } else if (e.getKeyCode() == 38 || e.getKeyCode() == 37) {
            this.selectPrevious();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JSlider jSlider;
        JBLabel jBLabel6;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 3, null, null, null));
        JComponent jComponent = this.myPreviewImage;
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(4, 0, 1, 3, 2, 1, 1, 1, null, null, null));
        this.myQualityLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Quality (Default 75%) :");
        jPanel3.add((Component)jBLabel6, "West");
        this.myQualitySlider = jSlider = new JSlider();
        jSlider.setMajorTickSpacing(5);
        jSlider.setPaintTicks(true);
        jPanel3.add((Component)jSlider, "Center");
        this.myQualityText = jBLabel5 = new JBLabel();
        jBLabel5.setText("");
        jPanel3.add((Component)jBLabel5, "East");
        this.myFileIndexLabel = jBLabel4 = new JBLabel();
        jBLabel4.setHorizontalAlignment(0);
        jBLabel4.setText("");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        this.myPngLabel = jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalAlignment(0);
        jBLabel3.setText("PNG");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setHorizontalAlignment(0);
        jBLabel7.setText("WEBP");
        jPanel.add((Component)jBLabel7, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myPngSizeLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 2, 0, 1, 0, null, null, null));
        this.myWebpSizeLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setHorizontalAlignment(0);
        jBLabel8.setText("Difference");
        jPanel.add((Component)jBLabel8, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    protected class AcceptAllAction
    extends DialogWrapper.DialogWrapperAction {
        private AcceptAllAction() {
            super((DialogWrapper)WebpPreviewDialog.this, "Accept All");
        }

        protected void doAction(ActionEvent e) {
            WebpPreviewDialog.this.myTask.encode(WebpPreviewDialog.this.myFiles, true);
            WebpPreviewDialog.this.doOKAction();
        }
    }

    protected class NextAction
    extends DialogWrapper.DialogWrapperAction {
        private NextAction() {
            super((DialogWrapper)WebpPreviewDialog.this, "Next");
        }

        protected void doAction(ActionEvent e) {
            WebpPreviewDialog.this.selectNext();
        }
    }

    protected class PrevAction
    extends DialogWrapper.DialogWrapperAction {
        private PrevAction() {
            super((DialogWrapper)WebpPreviewDialog.this, "Previous");
        }

        protected void doAction(ActionEvent e) {
            WebpPreviewDialog.this.selectPrevious();
        }
    }
}

