/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.projectmodel.ResourceFolder;
import com.android.tools.idea.resources.aar.AarProtoResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.resources.aar.AarSourceResourceRepository;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AarResourceRepositoryCache {
    private final Cache<Path, AarProtoResourceRepository> myProtoRepositories = CacheBuilder.newBuilder().softValues().build();
    private final Cache<ResourceFolder, AarSourceResourceRepository> mySourceRepositories = CacheBuilder.newBuilder().softValues().build();

    public static AarResourceRepositoryCache getInstance() {
        return (AarResourceRepositoryCache)ServiceManager.getService(AarResourceRepositoryCache.class);
    }

    @NotNull
    public AarSourceResourceRepository getSourceRepository(@NotNull ExternalLibrary library) {
        ResourceFolder resFolder = library.getResFolder();
        String libraryName = library.getAddress();
        if (resFolder == null) {
            throw new IllegalArgumentException("No resource for " + libraryName);
        }
        File resourceDirectory = resFolder.getRoot().toFile();
        if (resourceDirectory == null) {
            throw new IllegalArgumentException("Cannot find resource directory " + resFolder.getRoot() + " for " + libraryName);
        }
        return AarResourceRepositoryCache.getRepository(resFolder, libraryName, this.mySourceRepositories, () -> AarSourceResourceRepository.create(resFolder, libraryName));
    }

    @NotNull
    public AarProtoResourceRepository getProtoRepository(@NotNull ExternalLibrary library) {
        PathString resApkPath = library.getResApkFile();
        String libraryName = library.getAddress();
        if (resApkPath == null) {
            throw new IllegalArgumentException("No res.apk for " + libraryName);
        }
        Path resApkFile = resApkPath.toPath();
        if (resApkFile == null) {
            throw new IllegalArgumentException("Cannot find " + resApkPath + " for " + libraryName);
        }
        return AarResourceRepositoryCache.getRepository(resApkFile, libraryName, this.myProtoRepositories, () -> AarProtoResourceRepository.create(resApkFile, libraryName));
    }

    @NotNull
    private static <K, T extends AarResourceRepository> T getRepository(@NotNull K key, @Nullable String libraryName, @NotNull Cache<K, T> cache2, @NotNull Supplier<T> factory) {
        AarResourceRepository aarRepository = (AarResourceRepository)CacheUtils.getAndUnwrap(cache2, key, factory::get);
        if (!Objects.equals(libraryName, aarRepository.getLibraryName())) {
            assert (false) : "Library name mismatch: " + libraryName + " vs " + aarRepository.getLibraryName();
            Logger logger = Logger.getInstance(AarResourceRepositoryCache.class);
            logger.error((Throwable)new Exception("Library name mismatch: " + libraryName + " vs " + aarRepository.getLibraryName()));
        }
        return (T)aarRepository;
    }

    public void removeProtoRepository(@NotNull Path resApkFile) {
        this.myProtoRepositories.invalidate((Object)resApkFile);
    }

    public void removeSourceRepository(@NotNull ResourceFolder resourceFolder) {
        this.mySourceRepositories.invalidate((Object)resourceFolder);
    }

    public void clear() {
        this.myProtoRepositories.invalidateAll();
        this.mySourceRepositories.invalidateAll();
    }

    private AarResourceRepositoryCache() {
    }
}

