/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResourceRepositoryWithLocking
extends AbstractResourceRepository {
    public static final Object ITEM_MAP_LOCK = new Object();

    @NotNull
    protected abstract ResourceTable getFullTable();

    @Nullable
    protected abstract ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace var1, @NotNull ResourceType var2, boolean var3);

    @NotNull
    protected final ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        return this.getMap(namespace, resourceType, true);
    }

    @NotNull
    protected ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        ListMultimap<String, ResourceItem> map2 = this.getMap(namespace, resourceType, false);
        return map2 == null ? ImmutableListMultimap.of() : map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return super.getResources(namespace, resourceType, resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull Predicate<ResourceItem> filter2) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return super.getResources(namespace, resourceType, filter2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ListMultimap<String, ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return super.getResources(namespace, resourceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(@NotNull ResourceVisitor visitor) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry entry : this.getFullTable().rowMap().entrySet()) {
                if (!visitor.shouldVisitNamespace((ResourceNamespace)entry.getKey()) || AbstractResourceRepositoryWithLocking.acceptByResources((Map)((Map)entry.getValue()), (ResourceVisitor)visitor) != ResourceVisitor.VisitResult.ABORT) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return super.hasResources(namespace, resourceType, resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return super.hasResources(namespace, resourceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull ResourceNamespace namespace) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return super.getResourceTypes(namespace);
        }
    }
}

