/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidClassWithOnlyInnerClassesBase
extends AndroidLightClassBase {
    private static final Logger LOG = Logger.getInstance(AndroidClassWithOnlyInnerClassesBase.class);
    @NotNull
    protected final CachedValue<PsiClass[]> myClassCache;
    @NotNull
    protected final String myShortName;
    @NotNull
    protected final PsiJavaFile myFile;

    public AndroidClassWithOnlyInnerClassesBase(@NotNull String shortName, @Nullable String packageName, @NotNull PsiManager psiManager, @NotNull Collection<String> modifiers) {
        super(psiManager, modifiers);
        Project project = this.getProject();
        this.myShortName = shortName;
        this.myClassCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recomputing inner classes of " + ((Object)((Object)this)).getClass());
            }
            PsiClass[] innerClasses = this.doGetInnerClasses();
            return CachedValueProvider.Result.create((Object)innerClasses, (Object[])this.getInnerClassesDependencies());
        });
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        this.myFile = (PsiJavaFile)factory.createFileFromText(shortName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)"// This class is generated on-the-fly by the IDE.");
        if (packageName == null || !PsiNameHelper.getInstance((Project)project).isQualifiedName(packageName)) {
            packageName = "_";
        }
        this.myFile.setPackageName(packageName);
    }

    @NotNull
    protected abstract PsiClass[] doGetInnerClasses();

    @NotNull
    protected abstract Object[] getInnerClassesDependencies();

    @Nullable
    public final PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public final PsiClass[] getInnerClasses() {
        return (PsiClass[])this.myClassCache.getValue();
    }

    @Override
    @Nullable
    public final PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        for (PsiClass aClass : this.getInnerClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    public final String getName() {
        return this.myShortName;
    }

    @Override
    @NotNull
    public final PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public TextRange getTextRange() {
        return TextRange.EMPTY_RANGE;
    }
}

