/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidDependenciesCache;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectRootListener {
    public static void ensureSubscribed(@NotNull Project project) {
        ServiceManager.getService((Project)project, AndroidProjectRootListener.class);
    }

    private AndroidProjectRootListener(final @NotNull Project project) {
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                AndroidProjectRootListener.moduleRootsOrDependenciesChanged(project);
            }
        });
    }

    private static void moduleRootsOrDependenciesChanged(final @NotNull Project project) {
        DumbService.getInstance((Project)project).queueTask(new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (!project.isDisposed()) {
                    indicator.setText("Updating resource repository roots");
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    for (Module module : moduleManager.getModules()) {
                        AndroidProjectRootListener.moduleRootsOrDependenciesChanged(module);
                    }
                }
            }
        });
    }

    private static void moduleRootsOrDependenciesChanged(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            if (facet.requiresAndroidModel() && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
                return;
            }
            AndroidDependenciesCache.getInstance(module).dropCache();
            ResourceFolderManager.getInstance(facet).checkForChanges();
            ResourceRepositoryManager.getInstance(facet).updateRootsAndLibraries();
        }
    }
}

