/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.resources.aar.AarSourceResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AppResourceRepository
extends MultiResourceRepository {
    static final Key<Boolean> TEMPORARY_RESOURCE_CACHE = Key.create((String)"TemporaryResourceCache");
    private final AndroidFacet myFacet;
    private long myIdsModificationCount;
    private ListMultimap<String, ResourceItem> myIds;
    private final Object RESOURCE_MAP_LOCK = new Object();
    @Nullable
    private Collection<VirtualFile> myResourceDirs;

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet, @NotNull Collection<AarResourceRepository> libraryRepositories2) {
        AppResourceRepository repository = new AppResourceRepository(facet, AppResourceRepository.computeLocalRepositories(facet), libraryRepositories2);
        AndroidProjectRootListener.ensureSubscribed(facet.getModule().getProject());
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            if (this.myResourceDirs == null) {
                ImmutableList.Builder result2 = ImmutableList.builder();
                for (LocalResourceRepository resourceRepository : this.getLocalResources()) {
                    result2.addAll(resourceRepository.getResourceDirs());
                }
                this.myResourceDirs = result2.build();
            }
            return this.myResourceDirs;
        }
    }

    private static List<LocalResourceRepository> computeLocalRepositories(@NotNull AndroidFacet facet) {
        return ImmutableList.of((Object)((Object)ResourceRepositoryManager.getProjectResources(facet)), (Object)((Object)SampleDataResourceRepository.getInstance(facet)));
    }

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> localResources, @NotNull Collection<AarResourceRepository> libraryResources) {
        super(facet.getModule().getName() + " with modules and libraries");
        this.myFacet = facet;
        this.setChildren(localResources, libraryResources);
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getAllIds(@NotNull ResourceNamespace namespace) {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            ImmutableList<AarResourceRepository> libraryResources = this.getLibraryResources();
            if (this.myIds == null) {
                int size = 0;
                for (AarResourceRepository library : libraryResources) {
                    Set<String> idsFromRTxt;
                    if (!(library instanceof AarSourceResourceRepository) || (idsFromRTxt = ((AarSourceResourceRepository)library).getIdsFromRTxt()) == null) continue;
                    size += idsFromRTxt.size();
                }
                this.myIds = ArrayListMultimap.create((int)size, (int)1);
            } else {
                this.myIds.clear();
            }
            for (AarResourceRepository library : libraryResources) {
                Set<String> idsFromRTxt;
                if (!(library instanceof AarSourceResourceRepository) || (idsFromRTxt = ((AarSourceResourceRepository)library).getIdsFromRTxt()) == null) continue;
                for (String name : idsFromRTxt) {
                    this.myIds.put((Object)name, (Object)new IdResourceItem(name));
                }
            }
            this.myIds.putAll(super.getResources(namespace, ResourceType.ID));
        }
        return this.myIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ListMultimap<String, ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return type == ResourceType.ID && namespace == ResourceNamespace.RES_AUTO ? this.getAllIds(namespace) : super.getResources(namespace, type);
        }
    }

    void updateRoots(@NotNull Collection<? extends AarResourceRepository> libraryResources) {
        List<LocalResourceRepository> localResources = AppResourceRepository.computeLocalRepositories(this.myFacet);
        this.updateRoots(localResources, libraryResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoots(@NotNull List<? extends LocalResourceRepository> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources) {
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        this.invalidateResourceDirs();
        this.setChildren(localResources, libraryResources);
        ResourceIdManager.get(this.myFacet.getModule()).resetDynamicIds();
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull Collection<AarResourceRepository> libraries) {
        AppResourceRepository repository = new AppResourceRepository(facet, modules, libraries);
        Disposer.register((Disposable)facet, (Disposable)repository);
        return repository;
    }

    private static class IdResourceItem
    implements ResourceItem {
        private final String myName;

        IdResourceItem(@NotNull String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public ResourceType getType() {
            return ResourceType.ID;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            return ResourceNamespace.RES_AUTO;
        }

        @Nullable
        public String getLibraryName() {
            return null;
        }

        @NotNull
        public ResourceReference getReferenceToSelf() {
            return new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, this.myName);
        }

        @NotNull
        public String getKey() {
            return this.myName;
        }

        @Nullable
        public ResourceValue getResourceValue() {
            return null;
        }

        @Nullable
        public PathString getSource() {
            return null;
        }

        public boolean isFileBased() {
            return false;
        }

        @NotNull
        public FolderConfiguration getConfiguration() {
            return FolderConfiguration.createDefault();
        }
    }
}

