/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.level2.Library;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository {
    private static File myFrameworkResDirOrJar;
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(@NotNull String path, int mode) throws IOException {
        assert (this.myFacet != null);
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, Library::getAssetsFolder).map(assetDir -> assetDir.findFileByRelativePath(path)).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file) {
        File fontCachePathFile = DownloadableFontCacheService.getInstance().getFontPath();
        if (fontCachePathFile == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByUrl("file://" + fontCachePathFile.getAbsolutePath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path, int mode) throws IOException {
        String url;
        assert (this.myFacet != null);
        if (path.startsWith("apk:") || path.startsWith("jar:")) {
            return new ByteArrayInputStream(FileResourceReader.readBytes(path));
        }
        if (path.startsWith("file://")) {
            url = path;
        } else {
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            url = "file://" + path;
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return null;
        }
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, Library::getResFolder).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file, (boolean)true)).map(resDir -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (AssetRepositoryImpl.isCachedFontFile(file)) {
                try {
                    return file.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    public boolean isFileResource(@NotNull String path) {
        return ResourceHelper.isFileResource(path);
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet, @NotNull Function<IdeaSourceProvider, Collection<VirtualFile>> sourceMapper, @NotNull Function<Library, String> aarMapper) {
        Stream dirsFromSources = Stream.concat(Stream.of(facet), AndroidUtils.getAllAndroidDependencies(facet.getModule(), true).stream()).flatMap(f -> IdeaSourceProvider.getAllIdeaSourceProviders(f).stream()).distinct().map(sourceMapper).flatMap(Collection::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> dirsFromAars = ResourceRepositoryManager.findAarLibraries(facet).stream().map(aarMapper).map(path -> manager.findFileByUrl("file://" + path)).filter(Objects::nonNull);
        Stream<VirtualFile> frameworkDirs = Stream.of(AssetRepositoryImpl.getSdkResDirOrJar(facet)).filter(Objects::nonNull).map(path -> manager.findFileByUrl("file://" + path)).filter(Objects::nonNull);
        Stream<VirtualFile> sampleDataDirs = Stream.of(ResourceContent.getSampleDataBaseDir(), ResourceContent.getSampleDataUserDir(facet)).filter(Objects::nonNull).map(dir -> manager.findFileByUrl("file://" + dir.getAbsolutePath())).filter(Objects::nonNull);
        return Stream.of(dirsFromSources, dirsFromAars, frameworkDirs, sampleDataDirs).flatMap(stream -> stream);
    }

    @Nullable
    private static File getSdkResDirOrJar(@NotNull AndroidFacet facet) {
        if (myFrameworkResDirOrJar == null) {
            ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(facet);
            IAndroidTarget target = manager.getHighestApiTarget();
            if (target == null) {
                return null;
            }
            CompatibilityRenderTarget compatibilityTarget = StudioEmbeddedRenderTarget.getCompatibilityTarget(target);
            myFrameworkResDirOrJar = compatibilityTarget.getFile(11);
        }
        return myFrameworkResDirOrJar;
    }
}

