/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.DataBindingLayoutInfoFile;
import com.android.tools.idea.res.MergedDataBindingLayoutInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDataBindingLayoutInfo
implements DataBindingLayoutInfo {
    @NotNull
    private final Map<DataBindingResourceType, Map<String, PsiDataBindingResourceItem>> myItems = new EnumMap<DataBindingResourceType, Map<String, PsiDataBindingResourceItem>>(DataBindingResourceType.class);
    private String myClassName;
    private String myNonConfigurationClassName;
    private String myPackageName;
    private final PsiResourceFile myPsiResourceFile;
    private PsiClass myPsiClass;
    private long myLayoutModificationCount;
    private long myBindingModificationCount;
    private boolean myClassNameSpecifiedByUser;
    private final AndroidFacet myFacet;
    @NotNull
    private final String myConfigurationName;
    private MergedDataBindingLayoutInfo myMergedInfo;

    public DefaultDataBindingLayoutInfo(@NotNull AndroidFacet facet, @NotNull PsiResourceFile psiResourceFile, @NotNull String className, @NotNull String packageName, boolean classNameSpecifiedByUser) {
        this.myFacet = facet;
        this.myNonConfigurationClassName = className;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myClassNameSpecifiedByUser = classNameSpecifiedByUser;
        this.myPsiResourceFile = psiResourceFile;
        PsiDirectory parent = this.myPsiResourceFile.getPsiFile().getParent();
        this.myConfigurationName = parent != null ? parent.getName() : "";
    }

    @Override
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    void update(String className, String packageName, boolean classNameSpecifiedByUser, long modificationCount) {
        if (StringUtil.equals((CharSequence)this.myNonConfigurationClassName, (CharSequence)className) && StringUtil.equals((CharSequence)this.myPackageName, (CharSequence)packageName) && classNameSpecifiedByUser == this.myClassNameSpecifiedByUser) {
            return;
        }
        this.myNonConfigurationClassName = className;
        this.myPackageName = packageName;
        this.updateClassName();
        this.myLayoutModificationCount = modificationCount;
    }

    public void replaceItems(@NotNull List<PsiDataBindingResourceItem> newItems, long modificationCount) {
        EnumMap<DataBindingResourceType, Map> itemsByType = new EnumMap<DataBindingResourceType, Map>(DataBindingResourceType.class);
        for (PsiDataBindingResourceItem item : newItems) {
            DataBindingResourceType type = item.getType();
            Map itemsByName = itemsByType.computeIfAbsent(type, t -> new HashMap());
            itemsByName.put(item.getName(), item);
        }
        if (!itemsByType.equals(this.myItems)) {
            this.myItems.clear();
            this.myItems.putAll(itemsByType);
            this.myLayoutModificationCount = modificationCount;
        }
    }

    public void setMergedInfo(MergedDataBindingLayoutInfo mergedInfo) {
        if (this.myMergedInfo == mergedInfo) {
            return;
        }
        ++this.myBindingModificationCount;
        this.myMergedInfo = mergedInfo;
        this.updateClassName();
    }

    private void updateClassName() {
        this.myClassName = this.myMergedInfo != null ? DefaultDataBindingLayoutInfo.calculateConfigurationName(this.myConfigurationName, this.myNonConfigurationClassName) : this.myNonConfigurationClassName;
    }

    private static String calculateConfigurationName(String configurationName, String nonConfigurationClassName) {
        if (StringUtil.isEmpty((String)configurationName)) {
            return nonConfigurationClassName + "Impl";
        }
        if (configurationName.startsWith("layout-")) {
            return nonConfigurationClassName + DataBindingUtil.convertToJavaClassName(configurationName.substring("layout-".length())) + "Impl";
        }
        if (configurationName.startsWith("layout")) {
            return nonConfigurationClassName + "Impl";
        }
        return nonConfigurationClassName + DataBindingUtil.convertToJavaClassName(configurationName) + "Impl";
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public Project getProject() {
        return this.myPsiResourceFile.getPsiFile().getProject();
    }

    @Override
    public String getQualifiedName() {
        return this.myPackageName + "." + this.myClassName;
    }

    String getNonConfigurationClassName() {
        return this.myNonConfigurationClassName;
    }

    String getFileName() {
        return this.myPsiResourceFile.getName();
    }

    @Override
    public PsiElement getNavigationElement() {
        return new DataBindingLayoutInfoFile(this);
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myPsiResourceFile.getPsiFile();
    }

    @Override
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public Map<String, PsiDataBindingResourceItem> getItems(@NotNull DataBindingResourceType type) {
        Map<String, PsiDataBindingResourceItem> itemsByName = this.myItems.get(type);
        return itemsByName == null ? Collections.emptyMap() : itemsByName;
    }

    @Override
    @NotNull
    public List<DataBindingLayoutInfo.ViewWithId> getViewsWithIds() {
        ArrayList<DataBindingLayoutInfo.ViewWithId> result2 = new ArrayList<DataBindingLayoutInfo.ViewWithId>();
        for (ResourceItem item : this.myPsiResourceFile) {
            String name;
            PsiResourceItem psiResourceItem;
            XmlTag tag;
            if (!ResourceType.ID.equals((Object)item.getType()) || !(item instanceof PsiResourceItem) || (tag = (psiResourceItem = (PsiResourceItem)item).getTag()) == null || StringUtil.isEmpty((String)(name = item.getName()))) continue;
            result2.add(new DataBindingLayoutInfo.ViewWithId(DataBindingUtil.convertToJavaFieldName(name.trim()), tag));
        }
        return result2;
    }

    @Override
    @Nullable
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiResourceFile.getPsiFile());
    }

    @Override
    public long getModificationCount() {
        return this.myLayoutModificationCount + this.myBindingModificationCount;
    }

    @Override
    public boolean isMerged() {
        return false;
    }

    @Override
    @Nullable
    public DataBindingLayoutInfo getMergedInfo() {
        return this.myMergedInfo;
    }

    @NotNull
    public String getConfigurationName() {
        return this.myConfigurationName;
    }
}

