/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.projectmodel.DynamicResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.res.DynamicResourceValueItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicResourceValueRepository
extends LocalResourceRepository
implements BuildVariantView.BuildVariantSelectionChangeListener,
SingleNamespaceResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceTable myFullTable = new ResourceTable();
    @NotNull
    private final ResourceNamespace myNamespace;

    private DynamicResourceValueRepository(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace) {
        super("Gradle Dynamic");
        this.myFacet = facet;
        this.myNamespace = namespace;
        assert (facet.requiresAndroidModel());
    }

    private void registerListeners() {
        this.myFacet.getModule().getProject().getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS) {
                this.notifyProjectSynced();
            }
        });
        BuildVariantUpdater.getInstance(this.myFacet.getModule().getProject()).addSelectionChangeListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        Project project = this.myFacet.getModule().getProject();
        if (!project.isDisposed()) {
            BuildVariantUpdater.getInstance(project).removeSelectionChangeListener(this);
        }
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    @NotNull
    public static DynamicResourceValueRepository create(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace) {
        DynamicResourceValueRepository repository = new DynamicResourceValueRepository(facet, namespace);
        try {
            repository.registerListeners();
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)repository);
            throw t;
        }
        return repository;
    }

    @VisibleForTesting
    @NotNull
    public static DynamicResourceValueRepository createForTest(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace, @NotNull Map<String, DynamicResourceValue> values) {
        DynamicResourceValueRepository repository = new DynamicResourceValueRepository(facet, namespace);
        repository.addValues(values);
        Disposer.register((Disposable)facet, (Disposable)repository);
        return repository;
    }

    @Override
    protected ResourceTable getFullTable() {
        if (this.myFullTable.isEmpty()) {
            AndroidModel androidModel = AndroidModel.get(this.myFacet.getModule());
            if (androidModel == null) {
                return this.myFullTable;
            }
            this.addValues(androidModel.getResValues());
        }
        return this.myFullTable;
    }

    private void notifyProjectSynced() {
        this.myFullTable.clear();
        super.invalidateParentCaches();
    }

    private void addValues(Map<String, DynamicResourceValue> resValues) {
        for (Map.Entry<String, DynamicResourceValue> entry : resValues.entrySet()) {
            DynamicResourceValue field2 = entry.getValue();
            String name = entry.getKey();
            ResourceType type = field2.getType();
            ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map2 == null) {
                map2 = ArrayListMultimap.create();
                this.myFullTable.put((Object)this.myNamespace, (Object)type, (Object)map2);
            } else if (map2.containsKey((Object)name)) continue;
            DynamicResourceValueItem item = new DynamicResourceValueItem(this.myNamespace, type, name, field2.getValue());
            map2.put((Object)name, (Object)item);
        }
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        ListMultimap multimap;
        if (!namespace.equals((Object)this.myNamespace)) {
            return create2 ? ArrayListMultimap.create() : null;
        }
        if (this.myFullTable.isEmpty()) {
            this.getFullTable();
        }
        if ((multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type)) == null && create2) {
            multimap = ArrayListMultimap.create();
            this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Override
    public void selectionChanged() {
        this.notifyProjectSynced();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return ImmutableSet.of();
    }
}

