/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.util.PathString;
import com.android.utils.XmlUtils;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileResourceReader {
    @NotNull
    public static byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        String scheme;
        switch (scheme = resourcePath.getFilesystemUri().getScheme()) {
            case "file": {
                return FileResourceReader.readFileBytes(resourcePath.getRawPath());
            }
            case "apk": 
            case "jar": {
                String path = resourcePath.getRawPath();
                int separatorPos = path.indexOf("!/");
                int separatorEnd = separatorPos + "!/".length();
                if (separatorPos <= 0 || separatorEnd == path.length()) {
                    throw new IllegalArgumentException("Invalid path in \"" + resourcePath + "\"");
                }
                return FileResourceReader.readZipEntryBytes(path.substring(0, separatorPos), path.substring(separatorEnd));
            }
        }
        throw new IllegalArgumentException("Unknown schema in \"" + resourcePath + "\"");
    }

    @NotNull
    public static byte[] readBytes(@NotNull String resourcePath) throws IOException {
        if (resourcePath.startsWith("apk:") || resourcePath.startsWith("jar:")) {
            int separatorPos;
            int prefixLength = "apk:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            if ((separatorPos = resourcePath.lastIndexOf("!/")) < prefixLength) {
                throw new IllegalArgumentException("Invalid resource path \"" + resourcePath + "\"");
            }
            return FileResourceReader.readZipEntryBytes(resourcePath.substring(prefixLength, separatorPos), resourcePath.substring(separatorPos + "!/".length()));
        }
        if (resourcePath.startsWith("file:")) {
            int prefixLength = "file:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            resourcePath = resourcePath.substring(prefixLength);
        }
        return FileResourceReader.readFileBytes(resourcePath);
    }

    @NotNull
    private static byte[] readFileBytes(String filePath) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(filePath);){
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)fileStream, (OutputStream)byteOutputStream);
            byte[] byArray = byteOutputStream.toByteArray();
            return byArray;
        }
    }

    @NotNull
    private static byte[] readZipEntryBytes(String zipPath, String zipEntryPath) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipPath);){
            int n;
            ZipEntry entry = zipFile.getEntry(zipEntryPath);
            if (entry == null) {
                throw new FileNotFoundException("Zip entry \"" + zipPath + ':' + zipEntryPath + "\" does not exist");
            }
            long entrySize = entry.getSize();
            if (entrySize > Integer.MAX_VALUE) {
                throw new IOException("Zip entry \"" + zipPath + ':' + zipEntryPath + "\" is too large");
            }
            int size = (int)entrySize;
            byte[] bytes = new byte[size];
            InputStream stream = zipFile.getInputStream(entry);
            int offset = 0;
            while ((n = stream.read(bytes, offset, size)) > 0) {
                offset += n;
                size -= n;
            }
            if (size != 0) {
                throw new IOException("Incomplete read from \"" + zipPath + ':' + zipEntryPath + "\"");
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        try {
            byte[] contents = FileResourceReader.readBytes(resourcePath);
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull VirtualFile resourceFile) throws IOException {
        try {
            byte[] contents = resourceFile.contentsToByteArray();
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static XmlPullParser createXmlPullParser(@NotNull byte[] contents) {
        try {
            ProtoXmlPullParser parser;
            if (XmlUtils.isProtoXml((byte[])contents)) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput((InputStream)new ByteArrayInputStream(contents), null);
            return parser;
        }
        catch (XmlPullParserException e) {
            throw new Error("Internal error", e);
        }
    }

    private FileResourceReader() {
    }
}

