/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalResourceRepository
extends AbstractResourceRepositoryWithLocking
implements Disposable,
ModificationTracker {
    protected static final Logger LOG = Logger.getInstance(LocalResourceRepository.class);
    protected static final AtomicLong ourModificationCounter = new AtomicLong();
    private final String myDisplayName;
    @Nullable
    private List<MultiResourceRepository> myParents;
    private volatile long myGeneration;
    private final Object RESOURCE_DIRS_LOCK = new Object();
    @Nullable
    private Set<VirtualFile> myResourceDirs;

    protected LocalResourceRepository(@NotNull String displayName) {
        this.myDisplayName = displayName;
        this.setModificationCount(ourModificationCounter.incrementAndGet());
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(@NotNull MultiResourceRepository parent) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents == null) {
                this.myParents = new ArrayList<MultiResourceRepository>(2);
            }
            this.myParents.add(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(@NotNull MultiResourceRepository parent) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                this.myParents.remove((Object)parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateParentCaches() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (MultiResourceRepository parent : this.myParents) {
                    parent.invalidateCache(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateParentCaches(@NotNull ResourceNamespace namespace, ResourceType ... types) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (MultiResourceRepository parent : this.myParents) {
                    parent.invalidateCache(this, namespace, types);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    protected void setModificationCount(long count) {
        this.myGeneration = count;
    }

    @Nullable
    public DataBindingLayoutInfo getDataBindingLayoutInfo(String layoutName) {
        return null;
    }

    @Nullable
    public Map<String, DataBindingLayoutInfo> getDataBindingResourceFiles() {
        return null;
    }

    public boolean isScanPending(@NotNull PsiFile psiFile) {
        return false;
    }

    @Nullable
    public static XmlTag getItemTag(@NotNull Project project, @NotNull ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getTag();
        }
        PsiFile psiFile = AndroidResourceUtil.getItemPsiFile(project, item);
        if (psiFile instanceof XmlFile) {
            String resourceName = item.getName();
            XmlFile xmlFile = (XmlFile)psiFile;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null && rootTag.isValid()) {
                XmlTag[] subTags;
                for (XmlTag tag : subTags = rootTag.getSubTags()) {
                    XmlTag[] items2;
                    if (!tag.isValid()) continue;
                    ResourceType resourceType = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                    if (resourceType == item.getType() && resourceName.equals(tag.getAttributeValue("name"))) {
                        return tag;
                    }
                    if (item.getType() != ResourceType.ATTR || resourceType != ResourceType.STYLEABLE) continue;
                    for (XmlTag child : items2 = tag.getSubTags()) {
                        if (!resourceName.equals(child.getAttributeValue("name")) || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        return child;
                    }
                }
            }
            assert (FolderTypeRelationship.getRelatedFolders((ResourceType)item.getType()).contains(ResourceFolderType.VALUES)) : item.getType();
        }
        return null;
    }

    @Nullable
    public String getViewTag(@NotNull ResourceItem item) {
        if (item instanceof PsiResourceItem) {
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiResourceItem psiItem = (PsiResourceItem)item;
            XmlTag tag = psiItem.getTag();
            String id = item.getName();
            if (tag != null && tag.isValid() && id.equals(Lint.stripIdPrefix((String)tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")))) {
                return tag.getName();
            }
            PsiFile file = psiItem.getPsiFile();
            if (file instanceof XmlFile && file.isValid() && (rootTag = (xmlFile = (XmlFile)file).getRootTag()) != null && rootTag.isValid()) {
                return LocalResourceRepository.findViewTag(rootTag, id);
            }
        }
        return null;
    }

    @Nullable
    private static String findViewTag(XmlTag tag, String target) {
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null && id.endsWith(target) && target.equals(Lint.stripIdPrefix((String)id))) {
            return tag.getName();
        }
        for (XmlTag sub : tag.getSubTags()) {
            String found;
            if (!sub.isValid() || (found = LocalResourceRepository.findViewTag(sub, target)) == null) continue;
            return found;
        }
        return null;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<VirtualFile> getResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            if (this.myResourceDirs != null) {
                return this.myResourceDirs;
            }
            this.myResourceDirs = this.computeResourceDirs();
            return this.myResourceDirs;
        }
    }

    @NotNull
    protected abstract Set<VirtualFile> computeResourceDirs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (LocalResourceRepository localResourceRepository : this.myParents) {
                    localResourceRepository.invalidateResourceDirs();
                }
            }
        }
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    ListMultimap<String, ResourceItem> getOrCreateMapPackageAccessible(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        return this.getOrCreateMap(namespace, type);
    }

    ResourceTable getFullTablePackageAccessible() {
        return this.getFullTable();
    }

    public static final class EmptyRepository
    extends LocalResourceRepository
    implements SingleNamespaceResourceRepository {
        @NotNull
        private final ResourceNamespace myNamespace;

        public EmptyRepository(@NotNull ResourceNamespace namespace) {
            super("");
            this.myNamespace = namespace;
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        protected ResourceTable getFullTable() {
            return new ResourceTable();
        }

        @Override
        @Nullable
        protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
            if (create2) {
                throw new UnsupportedOperationException();
            }
            return null;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public String getPackageName() {
            return this.myNamespace.getPackageName();
        }
    }
}

