/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.DefaultDataBindingLayoutInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergedDataBindingLayoutInfo
implements DataBindingLayoutInfo {
    @NotNull
    private final List<DefaultDataBindingLayoutInfo> myInfoList;
    @NotNull
    private final DefaultDataBindingLayoutInfo myBaseInfo;
    private PsiClass myPsiClass;
    @NotNull
    private final CachedValue<List<DataBindingLayoutInfo.ViewWithId>> myViewWithIdsCache;
    @NotNull
    private final CachedValue<Map<DataBindingResourceType, Map<String, PsiDataBindingResourceItem>>> myResourceItemCache;

    public MergedDataBindingLayoutInfo(@NotNull List<DefaultDataBindingLayoutInfo> infoList) {
        this.myInfoList = infoList;
        this.myBaseInfo = this.selectBaseInfo();
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)this.myBaseInfo.getProject());
        this.myViewWithIdsCache = cacheManager.createCachedValue(() -> {
            HashSet used = new HashSet();
            ArrayList result2 = new ArrayList();
            for (DataBindingLayoutInfo dataBindingLayoutInfo : this.myInfoList) {
                dataBindingLayoutInfo.getViewsWithIds().forEach(viewWithId -> {
                    if (used.add(viewWithId.name)) {
                        result2.add(viewWithId);
                    }
                });
            }
            return CachedValueProvider.Result.create(result2, this.myInfoList);
        }, false);
        this.myResourceItemCache = cacheManager.createCachedValue(() -> {
            EnumMap<DataBindingResourceType, Map> result2 = new EnumMap<DataBindingResourceType, Map>(DataBindingResourceType.class);
            for (DataBindingLayoutInfo dataBindingLayoutInfo : this.myInfoList) {
                for (DataBindingResourceType type : DataBindingResourceType.values()) {
                    HashSet used = new HashSet();
                    Map<String, PsiDataBindingResourceItem> itemsByName = dataBindingLayoutInfo.getItems(type);
                    for (Map.Entry<String, PsiDataBindingResourceItem> entry : itemsByName.entrySet()) {
                        Map resultItemsByName = result2.computeIfAbsent(type, t -> new HashMap());
                        String name = entry.getKey();
                        PsiDataBindingResourceItem item = entry.getValue();
                        resultItemsByName.putIfAbsent(name, item);
                    }
                }
            }
            return CachedValueProvider.Result.create(result2, this.myInfoList);
        }, false);
    }

    public DefaultDataBindingLayoutInfo selectBaseInfo() {
        DefaultDataBindingLayoutInfo best = null;
        for (DefaultDataBindingLayoutInfo info : this.myInfoList) {
            if (best != null && best.getConfigurationName().length() <= info.getConfigurationName().length()) continue;
            best = info;
        }
        return best;
    }

    @Override
    public AndroidFacet getFacet() {
        return this.myBaseInfo.getFacet();
    }

    @Override
    public String getClassName() {
        return this.myBaseInfo.getNonConfigurationClassName();
    }

    @Override
    public String getPackageName() {
        return this.myBaseInfo.getPackageName();
    }

    @Override
    public Project getProject() {
        return this.myBaseInfo.getProject();
    }

    @Override
    public String getQualifiedName() {
        return this.myBaseInfo.getPackageName() + "." + this.getClassName();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this.myBaseInfo.getNavigationElement();
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myBaseInfo.getPsiFile();
    }

    @Override
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public Map<String, PsiDataBindingResourceItem> getItems(@NotNull DataBindingResourceType type) {
        Map itemsByName = (Map)((Map)this.myResourceItemCache.getValue()).get(type);
        return itemsByName == null ? Collections.emptyMap() : itemsByName;
    }

    @Override
    @NotNull
    public List<DataBindingLayoutInfo.ViewWithId> getViewsWithIds() {
        return (List)this.myViewWithIdsCache.getValue();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myBaseInfo.getModule();
    }

    @Override
    public long getModificationCount() {
        int total = this.myInfoList.size();
        for (DataBindingLayoutInfo dataBindingLayoutInfo : this.myInfoList) {
            total = (int)((long)total + dataBindingLayoutInfo.getModificationCount());
        }
        return total;
    }

    @Override
    public boolean isMerged() {
        return true;
    }

    @Override
    @Nullable
    public DataBindingLayoutInfo getMergedInfo() {
        return null;
    }
}

