/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.tools.idea.res.DynamicResourceValueRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ModuleResourceRepository
extends MultiResourceRepository
implements SingleNamespaceResourceRepository {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final SourceSet mySourceSet;
    @NotNull
    private final ResourceFolderRegistry myRegistry;

    @NotNull
    static LocalResourceRepository forMainResources(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace) {
        ModuleResourceRepository moduleRepository;
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet.getModule().getProject());
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet);
        if (!facet.requiresAndroidModel()) {
            VirtualFile primaryResourceDir = (VirtualFile)ContainerUtil.getFirstItem(folderManager.getFolders(), null);
            if (primaryResourceDir == null) {
                return new LocalResourceRepository.EmptyRepository(namespace);
            }
            return new ModuleResourceRepository(facet, namespace, Collections.singletonList(resourceFolderRegistry.get(facet, primaryResourceDir)), SourceSet.MAIN);
        }
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet, namespace);
        try {
            ArrayList<LocalResourceRepository> childRepositories = new ArrayList<LocalResourceRepository>(1 + resourceDirectories.size());
            childRepositories.add(dynamicResources);
            ModuleResourceRepository.addRepositoriesInReverseOverlayOrder(resourceDirectories, childRepositories, facet, resourceFolderRegistry);
            moduleRepository = new ModuleResourceRepository(facet, namespace, childRepositories, SourceSet.MAIN);
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)dynamicResources);
            throw t;
        }
        Disposer.register((Disposable)moduleRepository, (Disposable)dynamicResources);
        return moduleRepository;
    }

    @NotNull
    static LocalResourceRepository forTestResources(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace) {
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet.getModule().getProject());
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet);
        if (!facet.requiresAndroidModel()) {
            return new LocalResourceRepository.EmptyRepository(namespace);
        }
        List<VirtualFile> resourceDirectories = folderManager.getTestFolders();
        ArrayList<LocalResourceRepository> childRepositories = new ArrayList<LocalResourceRepository>(resourceDirectories.size());
        ModuleResourceRepository.addRepositoriesInReverseOverlayOrder(resourceDirectories, childRepositories, facet, resourceFolderRegistry);
        return new ModuleResourceRepository(facet, namespace, childRepositories, SourceSet.TEST);
    }

    private static void addRepositoriesInReverseOverlayOrder(@NotNull List<VirtualFile> resourceDirectories, @NotNull List<LocalResourceRepository> childRepositories, @NotNull AndroidFacet facet, @NotNull ResourceFolderRegistry resourceFolderRegistry) {
        int i2 = resourceDirectories.size();
        while (--i2 >= 0) {
            VirtualFile resourceDirectory = resourceDirectories.get(i2);
            ResourceFolderRepository repository = resourceFolderRegistry.get(facet, resourceDirectory);
            childRepositories.add(repository);
        }
    }

    private ModuleResourceRepository(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull SourceSet sourceSet) {
        super(facet.getModule().getName());
        this.myFacet = facet;
        this.myNamespace = namespace;
        this.mySourceSet = sourceSet;
        this.myRegistry = ResourceFolderRegistry.getInstance(facet.getModule().getProject());
        this.setChildren(delegates, (Collection<? extends AarResourceRepository>)ImmutableList.of());
        ResourceFolderManager.ResourceFolderListener resourceFolderListener = new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void mainResourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<? extends VirtualFile> folders, @NotNull Collection<? extends VirtualFile> added, @NotNull Collection<? extends VirtualFile> removed) {
                if (ModuleResourceRepository.this.mySourceSet == SourceSet.MAIN) {
                    ModuleResourceRepository.this.updateRoots(folders);
                }
            }

            @Override
            public void testResourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<? extends VirtualFile> folders, @NotNull Collection<? extends VirtualFile> added, @NotNull Collection<? extends VirtualFile> removed) {
                if (ModuleResourceRepository.this.mySourceSet == SourceSet.TEST) {
                    ModuleResourceRepository.this.updateRoots(folders);
                }
            }
        };
        this.myFacet.getModule().getMessageBus().connect((Disposable)this).subscribe(ResourceFolderManager.TOPIC, (Object)resourceFolderListener);
    }

    @VisibleForTesting
    void updateRoots(List<? extends VirtualFile> resourceDirectories) {
        ArrayList<LocalResourceRepository> other = null;
        HashMap<VirtualFile, ResourceFolderRepository> map2 = new HashMap<VirtualFile, ResourceFolderRepository>();
        ImmutableList<LocalResourceRepository> children = this.getLocalResources();
        for (LocalResourceRepository repository : children) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map2.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = new ArrayList<LocalResourceRepository>();
            }
            other.add(repository);
        }
        HashSet<? extends VirtualFile> newDirs = new HashSet<VirtualFile>(resourceDirectories);
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(newDirs.size() + (other != null ? other.size() : 0));
        if (other != null) {
            resources.addAll(other);
        }
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map2.get(dir));
            if (repository == null) {
                repository = this.myRegistry.get(this.myFacet, dir);
            } else {
                map2.remove(dir);
            }
            resources.add(repository);
        }
        if (resources.equals(children)) {
            assert (map2.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map2.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources, Collections.emptyList());
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)this.mySourceSet).toString();
    }

    @VisibleForTesting
    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories, @NotNull ResourceNamespace namespace, @Nullable DynamicResourceValueRepository dynamicResourceValueRepository) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<DynamicResourceValueRepository> delegates = new ArrayList<DynamicResourceValueRepository>(resourceDirectories.size() + (dynamicResourceValueRepository == null ? 0 : 1));
        if (dynamicResourceValueRepository != null) {
            delegates.add(dynamicResourceValueRepository);
        }
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet.getModule().getProject());
        resourceDirectories.forEach(dir -> delegates.add((DynamicResourceValueRepository)((Object)resourceFolderRegistry.get(facet, (VirtualFile)dir, namespace))));
        ModuleResourceRepository repository = new ModuleResourceRepository(facet, namespace, delegates, SourceSet.MAIN);
        Disposer.register((Disposable)facet, (Disposable)repository);
        return repository;
    }

    private static enum SourceSet {
        MAIN,
        TEST;

    }
}

