/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ImmutableList<LocalResourceRepository> myLocalResources;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ImmutableList<AarResourceRepository> myLibraryResources;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ImmutableList<ResourceRepository> myChildren;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myLeafsByNamespace;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myRepositoriesByNamespace;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long[] myModificationCounts;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ResourceTable myFullTable;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final ResourceTable myCachedMaps = new ResourceTable();
    @GuardedBy(value="ITEM_MAP_LOCK")
    private Map<String, DataBindingLayoutInfo> myDataBindingResourceFiles = new HashMap<String, DataBindingLayoutInfo>();
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;

    MultiResourceRepository(@NotNull String displayName) {
        super(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myLocalResources != null) {
                for (LocalResourceRepository child : this.myLocalResources) {
                    child.removeParent(this);
                }
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myLocalResources = ImmutableList.copyOf(localResources);
            this.myLibraryResources = ImmutableList.copyOf(libraryResources);
            this.myChildren = ImmutableList.builder().addAll(this.myLocalResources).addAll(this.myLibraryResources).build();
            ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeLeafs((ResourceRepository)this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myLeafsByNamespace = mapBuilder.build();
            mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeNamespaceMap((ResourceRepository)this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myRepositoriesByNamespace = mapBuilder.build();
            this.myModificationCounts = new long[localResources.size()];
            if (localResources.size() == 1) {
                LocalResourceRepository child;
                child = localResources.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            int i2 = 0;
            for (LocalResourceRepository child : this.myLocalResources) {
                child.addParent(this);
                this.myModificationCounts[i2++] = child.getModificationCount();
            }
            this.myFullTable = null;
            this.myCachedMaps.clear();
            this.invalidateParentCaches();
        }
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    private static void computeLeafs(@NotNull ResourceRepository repository, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.computeLeafs(child, result2);
            }
        } else {
            for (SingleNamespaceResourceRepository resourceRepository : repository.getLeafResourceRepositories()) {
                result2.put((Object)resourceRepository.getNamespace(), (Object)resourceRepository);
            }
        }
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    private static void computeNamespaceMap(@NotNull ResourceRepository repository, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository instanceof SingleNamespaceResourceRepository) {
            SingleNamespaceResourceRepository singleNamespaceRepository = (SingleNamespaceResourceRepository)repository;
            ResourceNamespace namespace = singleNamespaceRepository.getNamespace();
            result2.put((Object)namespace, (Object)singleNamespaceRepository);
        } else if (repository instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.computeNamespaceMap(child, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<LocalResourceRepository> getLocalResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLocalResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<AarResourceRepository> getLibraryResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLibraryResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ResourceRepository> getRepositoriesForNamespace(@NotNull ResourceNamespace namespace) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return ImmutableList.copyOf((Collection)this.myRepositoriesByNamespace.get((Object)namespace));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myLocalResources.size() == 1) {
                return ((LocalResourceRepository)((Object)this.myLocalResources.get(0))).getModificationCount();
            }
            boolean changed = false;
            for (int i2 = 0; i2 < this.myLocalResources.size(); ++i2) {
                LocalResourceRepository child = (LocalResourceRepository)((Object)this.myLocalResources.get(i2));
                long rev = child.getModificationCount();
                if (rev == this.myModificationCounts[i2]) continue;
                this.myModificationCounts[i2] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DataBindingLayoutInfo getDataBindingLayoutInfo(String layoutName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                DataBindingLayoutInfo info = child.getDataBindingLayoutInfo(layoutName);
                if (info == null) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, DataBindingLayoutInfo> getDataBindingResourceFiles() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            long modificationCount = this.getModificationCount();
            if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
                return this.myDataBindingResourceFiles;
            }
            HashMap<String, DataBindingLayoutInfo> selected = new HashMap<String, DataBindingLayoutInfo>();
            for (LocalResourceRepository child : this.myLocalResources) {
                Map<String, DataBindingLayoutInfo> childFiles = child.getDataBindingResourceFiles();
                if (childFiles == null) continue;
                selected.putAll(childFiles);
            }
            this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
            this.myDataBindingResourceFilesModificationCount = modificationCount;
            return this.myDataBindingResourceFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return ImmutableSet.copyOf((Collection)this.myRepositoriesByNamespace.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected ResourceTable getFullTable() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myFullTable == null) {
                if (this.myLocalResources.size() == 1 && this.myLibraryResources.isEmpty()) {
                    this.myFullTable = ((LocalResourceRepository)((Object)this.myLocalResources.get(0))).getFullTablePackageAccessible();
                } else {
                    this.myFullTable = new ResourceTable();
                    for (ResourceNamespace namespace : this.getNamespaces()) {
                        for (ResourceType type : ResourceType.values()) {
                            ListMultimap<String, ResourceItem> map2 = this.getMap(namespace, type, false);
                            if (map2 == null) continue;
                            this.myFullTable.put((Object)namespace, (Object)type, map2);
                        }
                    }
                }
            }
            return this.myFullTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap map2 = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
            if (map2 != null) {
                return map2;
            }
            if (this.myLocalResources.size() == 1 && this.myLibraryResources.isEmpty()) {
                return ((LocalResourceRepository)((Object)this.myLocalResources.get(0))).getOrCreateMapPackageAccessible(namespace, type);
            }
            ImmutableList repositoriesForNamespace = this.myLeafsByNamespace.get((Object)namespace);
            if (repositoriesForNamespace.size() == 1) {
                return ArrayListMultimap.create((Multimap)((SingleNamespaceResourceRepository)repositoriesForNamespace.get(0)).getResources(namespace, type));
            }
            map2 = ArrayListMultimap.create();
            HashMultimap seenQualifiers = HashMultimap.create();
            for (ResourceRepository child : repositoriesForNamespace) {
                ListMultimap items2 = child.getResources(namespace, type);
                for (ResourceItem item : items2.values()) {
                    String name = item.getName();
                    String qualifiers = item.getConfiguration().getQualifierString();
                    if (type != ResourceType.STYLEABLE && type != ResourceType.ID && map2.containsKey((Object)name) && seenQualifiers.containsEntry((Object)name, (Object)qualifiers)) continue;
                    map2.put((Object)name, (Object)item);
                    seenQualifiers.put((Object)name, (Object)qualifiers);
                }
            }
            this.myCachedMaps.put((Object)namespace, (Object)type, (Object)map2);
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return ((ResourceRepository)this.myChildren.get(0)).hasResources(namespace, type);
            }
            if (this instanceof SingleNamespaceResourceRepository) {
                if (namespace.equals((Object)((SingleNamespaceResourceRepository)this).getNamespace())) {
                    for (ResourceRepository child : this.myChildren) {
                        if (!child.hasResources(namespace, type)) continue;
                        return true;
                    }
                }
                return false;
            }
            ImmutableList repositories = this.myRepositoriesByNamespace.get((Object)namespace);
            for (ResourceRepository repository : repositories) {
                if (!repository.hasResources(namespace, type)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                child.removeParent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            this.myCachedMaps.clear();
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository, @NotNull ResourceNamespace namespace, ResourceType ... types) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            for (ResourceType type : types) {
                this.myCachedMaps.remove((Object)namespace, (Object)type);
            }
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(namespace, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public boolean isScanPending(@NotNull PsiFile psiFile) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            for (LocalResourceRepository child : this.myLocalResources) {
                if (!child.isScanPending(psiFile)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void sync() {
        super.sync();
        for (LocalResourceRepository childRepository : this.getLocalResources()) {
            childRepository.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            for (LocalResourceRepository resourceRepository : this.myLocalResources) {
                result2.addAll(resourceRepository.computeResourceDirs());
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLeafsByNamespace.values();
        }
    }
}

