/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> localResources) {
        super(facet.getModule().getName() + " with modules");
        this.myFacet = facet;
        this.setChildren(localResources, Collections.emptyList());
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        return new ProjectResourceRepository(facet, resources);
    }

    @NotNull
    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        LocalResourceRepository main = ResourceRepositoryManager.getModuleResources(facet);
        List<AndroidFacet> dependencies = AndroidUtils.getAndroidResourceDependencies(facet.getModule());
        if (dependencies.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(dependencies.size() + 1);
        resources.add(main);
        for (AndroidFacet dependency : dependencies) {
            resources.add(ResourceRepositoryManager.getModuleResources(dependency));
        }
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.invalidateResourceDirs();
        this.setChildren(repositories, Collections.emptyList());
    }

    @VisibleForTesting
    @NotNull
    static ProjectResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules) {
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, modules);
        Disposer.register((Disposable)facet, (Disposable)repository);
        return repository;
    }
}

