/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.fileTypes.FontFileType;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.SampleDataListener;
import com.google.common.collect.Iterables;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class PsiProjectListener
implements PsiTreeChangeListener {
    private final ResourceFolderRegistry myRegistry;
    private SampleDataListener mySampleDataListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ResourceNotificationManager myResourceNotificationManager;
    private static final List<FileNameMatcher> RENDERSCRIPT_MATCHERS = Arrays.asList(AndroidRenderscriptFileType.fileNameMatchers());

    @NotNull
    public static PsiProjectListener getInstance(@NotNull Project project) {
        return (PsiProjectListener)project.getComponent(PsiProjectListener.class);
    }

    public PsiProjectListener(@NotNull Project project) {
        this.myProject = project;
        this.myResourceNotificationManager = ResourceNotificationManager.getInstance(project);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this);
        this.myRegistry = ResourceFolderRegistry.getInstance(project);
    }

    void setSampleDataListener(SampleDataListener sampleDataListener) {
        assert (this.mySampleDataListener == null) : "SampleDataListener already set!";
        this.mySampleDataListener = sampleDataListener;
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == StdFileTypes.JAVA || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (fileType == StdFileTypes.XML) {
            return true;
        }
        if (fileType.isBinary()) {
            return fileType == ImageFileTypeManager.getInstance().getImageFileType() || fileType == FontFileType.INSTANCE;
        }
        return false;
    }

    public static boolean isRelevantFile(@NotNull VirtualFile file) {
        String parentName;
        String extension = file.getExtension();
        if (StringUtil.isEmpty((String)extension)) {
            return false;
        }
        if (StdFileTypes.JAVA.getDefaultExtension().equals(extension) || "kt".equals(extension)) {
            return false;
        }
        if (StdFileTypes.XML.getDefaultExtension().equals(extension)) {
            return true;
        }
        String fileName = file.getName();
        if ("aidl".equals(extension) || "AndroidManifest.xml".equals(fileName)) {
            return true;
        }
        if (Iterables.any(RENDERSCRIPT_MATCHERS, matcher -> matcher != null && matcher.accept(fileName))) {
            return true;
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    static boolean isRelevantFile(@NotNull PsiFile file) {
        String parentName;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    private void dispatch(@Nullable VirtualFile file, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        if (file != null) {
            this.dispatchToRegistry(file, invokeCallback);
        }
        this.dispatchToResourceNotificationManager(invokeCallback);
    }

    private void dispatchToRegistry(@NotNull VirtualFile file, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        while (file != null) {
            ResourceFolderRegistry.CachedRepositories cached = this.myRegistry.getCached(file);
            if (cached != null) {
                if (cached.namespaced != null) {
                    invokeCallback.consume((Object)cached.namespaced.getPsiListener());
                }
                if (cached.nonNamespaced != null) {
                    invokeCallback.consume((Object)cached.nonNamespaced.getPsiListener());
                }
                return;
            }
            file = file.getParent();
        }
    }

    private void dispatchToResourceNotificationManager(@NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        PsiTreeChangeListener resourceNotificationPsiListener = this.myResourceNotificationManager.getPsiListener();
        if (resourceNotificationPsiListener != null) {
            invokeCallback.consume((Object)resourceNotificationPsiListener);
        }
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.computeModulesToInvalidateAttributeDefs(file);
                    if (PsiProjectListener.isRelevantFile(file)) {
                        this.dispatchChildAdded(event, file);
                    }
                }
            } else if (child instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)child;
                this.dispatchChildAdded(event, directory.getVirtualFile());
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            this.dispatchChildAdded(event, psiFile.getVirtualFile());
        } else if (this.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
        if (this.mySampleDataListener != null) {
            this.mySampleDataListener.childAdded(event);
        }
    }

    private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childAdded(event)));
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null && psiFile.getVirtualFile() != null) {
            this.computeModulesToInvalidateAttributeDefs(psiFile.getVirtualFile());
        }
        if (psiFile == null) {
            PsiDirectory directory;
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildRemoved(event, file);
                }
            } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                VirtualFile file = directory.getVirtualFile();
                this.dispatchChildRemoved(event, file);
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildRemoved(event, file);
        } else if (this.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
        if (this.mySampleDataListener != null) {
            this.mySampleDataListener.childRemoved(event);
        }
    }

    private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childRemoved(event)));
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null) {
                this.computeModulesToInvalidateAttributeDefs(file);
            }
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildReplaced(event, file);
            } else if (this.isGradleFileEdit(psiFile)) {
                PsiProjectListener.notifyGradleEdit(psiFile);
            }
            if (this.mySampleDataListener != null) {
                this.mySampleDataListener.childReplaced(event);
            }
        } else {
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)parent;
                this.dispatchChildReplaced(event, directory.getVirtualFile());
            }
        }
    }

    private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childReplaced(event)));
    }

    private boolean isGradleFileEdit(@NotNull PsiFile psiFile) {
        return GradleFiles.getInstance(this.myProject).isGradleFile(psiFile);
    }

    private static void notifyGradleEdit(@NotNull PsiFile psiFile) {
        EditorNotifications.getInstance((Project)psiFile.getProject()).updateAllNotifications();
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforeChildrenChange(event, file);
        }
    }

    private void dispatchBeforeChildrenChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforeChildrenChange(event)));
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null) {
                this.computeModulesToInvalidateAttributeDefs(file);
            }
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildrenChanged(event, file);
            }
            if (this.mySampleDataListener != null) {
                this.mySampleDataListener.childrenChanged(event);
            }
        }
    }

    private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childrenChanged(event)));
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        PsiElement child = event.getChild();
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            if (child instanceof PsiFile && PsiProjectListener.isRelevantFile((PsiFile)child)) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.dispatchChildMoved(event, file);
                    return;
                }
                PsiElement oldParent = event.getOldParent();
                if (oldParent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)oldParent;
                    VirtualFile dir = directory.getVirtualFile();
                    this.dispatchChildMoved(event, dir);
                }
            }
        } else {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null) {
                this.computeModulesToInvalidateAttributeDefs(file);
                if (PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildMoved(event, file);
                }
                if (this.mySampleDataListener != null) {
                    this.mySampleDataListener.childMoved(event);
                }
            }
        }
    }

    private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        PsiElement oldParent;
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
        if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory) {
            PsiDirectory sourceDir = (PsiDirectory)oldParent;
            this.dispatch(sourceDir.getVirtualFile(), (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforePropertyChange(event, file);
        }
    }

    private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforePropertyChange(event)));
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchPropertyChanged(event, file);
        }
    }

    private void dispatchPropertyChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.propertyChanged(event)));
    }

    private void computeModulesToInvalidateAttributeDefs(@NotNull VirtualFile file) {
        if (!PsiProjectListener.isRelevantFile(file)) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(file, this.myProject);
        if (facet != null) {
            for (Module module : AndroidUtils.getSetWithBackwardDependencies(facet.getModule())) {
                AndroidFacet moduleFacet = AndroidFacet.getInstance(module);
                if (moduleFacet == null) continue;
                ModuleResourceManagers.getInstance(moduleFacet).getLocalResourceManager().invalidateAttributeDefinitions();
            }
        }
    }
}

