/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.ResourceClassGenerator;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClassRegistry
implements ProjectComponent {
    private final Map<ResourceRepository, ResourceClassGenerator> myGeneratorMap = new HashMap<ResourceRepository, ResourceClassGenerator>();
    private Set<String> myPackages;

    public void addLibrary(@NotNull ResourceRepository repo, @NotNull ResourceIdManager idManager, @Nullable String packageName, @NotNull ResourceNamespace namespace) {
        if (StringUtil.isNotEmpty((String)packageName)) {
            if (this.myPackages == null) {
                this.myPackages = new HashSet<String>();
            }
            this.myPackages.add(packageName);
            if (!this.myGeneratorMap.containsKey(repo)) {
                ResourceClassGenerator generator = ResourceClassGenerator.create(idManager, repo, namespace);
                this.myGeneratorMap.put(repo, generator);
            }
        }
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String className, @NotNull ResourceRepositoryManager repositoryManager) {
        int index = className.lastIndexOf(46);
        if (index > 1 && className.charAt(index + 1) == 'R' && (index == className.length() - 2 || className.charAt(index + 2) == '$')) {
            ResourceNamespace namespace;
            List<ResourceRepository> repositories;
            ResourceClassGenerator generator;
            String pkg = className.substring(0, index);
            if (this.myPackages != null && this.myPackages.contains(pkg) && (generator = this.findClassGenerator(repositories = repositoryManager.getAppResourcesForNamespace(namespace = ResourceNamespace.fromPackageName((String)pkg)), className)) != null) {
                return generator.generate(className);
            }
        }
        return null;
    }

    @Nullable
    private ResourceClassGenerator findClassGenerator(@NotNull List<ResourceRepository> repositories, @NotNull String className) {
        ResourceClassGenerator foundGenerator = null;
        for (int i2 = 0; i2 < repositories.size(); ++i2) {
            ResourceClassGenerator generator = this.myGeneratorMap.get(repositories.get(i2));
            if (generator == null) continue;
            if (foundGenerator == null) {
                foundGenerator = generator;
                continue;
            }
            throw new NoClassDefFoundError(className + " class could not be loaded because of package name collision between libraries");
        }
        return foundGenerator;
    }

    public void clearCache() {
        this.myGeneratorMap.clear();
    }

    @NotNull
    public static ResourceClassRegistry get(@NotNull Project project) {
        return (ResourceClassRegistry)project.getComponent(ResourceClassRegistry.class);
    }

    @NotNull
    public String getComponentName() {
        return ResourceClassRegistry.class.getName();
    }

    @VisibleForTesting
    @NotNull
    Collection<String> getPackages() {
        return this.myPackages == null ? Collections.emptySet() : this.myPackages;
    }

    @VisibleForTesting
    @NotNull
    Map<ResourceRepository, ResourceClassGenerator> getGeneratorMap() {
        return this.myGeneratorMap;
    }
}

