/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.SdkUtils;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.ImmutableList;
import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFolderRegistry
implements Disposable {
    @NotNull
    private Project myProject;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNamespacedCache = ResourceFolderRegistry.buildCache();
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNonNamespacedCache = ResourceFolderRegistry.buildCache();
    @NotNull
    private final ImmutableList<Cache<VirtualFile, ResourceFolderRepository>> myCaches = ImmutableList.of(this.myNamespacedCache, this.myNonNamespacedCache);

    public ResourceFolderRegistry(@NotNull Project project) {
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ResourceFolderRegistry.this.removeStaleEntries();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VfsListener());
    }

    @NotNull
    private static Cache<VirtualFile, ResourceFolderRepository> buildCache() {
        RemovalListener removalListener = notification -> Disposer.dispose((Disposable)((Disposable)notification.getValue()));
        return CacheBuilder.newBuilder().removalListener(removalListener).build();
    }

    @NotNull
    public static ResourceFolderRegistry getInstance(@NotNull Project project) {
        return (ResourceFolderRegistry)ServiceManager.getService((Project)project, ResourceFolderRegistry.class);
    }

    @NotNull
    public ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
        return (ResourceFolderRepository)((Object)ReadAction.compute(() -> this.get(facet, dir, ResourceRepositoryManager.getInstance(facet).getNamespace())));
    }

    @VisibleForTesting
    @NotNull
    ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        Cache<VirtualFile, ResourceFolderRepository> cache2 = namespace == ResourceNamespace.RES_AUTO ? this.myNonNamespacedCache : this.myNamespacedCache;
        ResourceFolderRepository repository = (ResourceFolderRepository)((Object)CacheUtils.getAndUnwrap(cache2, (Object)dir, () -> {
            ResourceFolderRepository newRepository = ResourceFolderRepository.create(facet, dir, namespace);
            Disposer.register((Disposable)this, (Disposable)newRepository);
            return newRepository;
        }));
        assert (repository.getNamespace().equals((Object)namespace));
        assert (!Disposer.isDisposed((Disposable)repository));
        return repository;
    }

    @Nullable
    public CachedRepositories getCached(@NotNull VirtualFile directory) {
        ResourceFolderRepository namespaced = (ResourceFolderRepository)((Object)this.myNamespacedCache.getIfPresent((Object)directory));
        ResourceFolderRepository nonNamespaced = (ResourceFolderRepository)((Object)this.myNonNamespacedCache.getIfPresent((Object)directory));
        return namespaced == null && nonNamespaced == null ? null : new CachedRepositories(namespaced, nonNamespaced);
    }

    public void reset() {
        this.myNamespacedCache.invalidateAll();
        this.myNonNamespacedCache.invalidateAll();
    }

    private void removeStaleEntries() {
        this.myNamespacedCache.asMap().keySet().removeIf(dir -> this.isStale((VirtualFile)dir));
        this.myNonNamespacedCache.asMap().keySet().removeIf(dir -> this.isStale((VirtualFile)dir));
    }

    private boolean isStale(@NotNull VirtualFile dir) {
        AndroidFacet facet = AndroidFacet.getInstance(dir, this.myProject);
        if (facet == null) {
            return true;
        }
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet);
        return !folderManager.getFolders().contains(dir) && !folderManager.getTestFolders().contains(dir);
    }

    public void dispose() {
        this.reset();
    }

    private class VfsListener
    implements BulkFileListener {
        private VfsListener() {
        }

        @UiThread
        public void before(@NotNull List<? extends VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileMoveEvent) {
                    this.onFileOrDirectoryRemoved(((VFileMoveEvent)vFileEvent).getFile());
                    continue;
                }
                if (vFileEvent instanceof VFileDeleteEvent) {
                    this.onFileOrDirectoryRemoved(((VFileDeleteEvent)vFileEvent).getFile());
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) continue;
                this.onFileOrDirectoryRemoved(((VFilePropertyChangeEvent)vFileEvent).getFile());
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(createEvent.getParent(), createEvent.getChildName());
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(copyEvent.getNewParent(), copyEvent.getNewChildName());
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(moveEvent.getNewParent(), moveEvent.getFile().getName());
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                    VFilePropertyChangeEvent renameEvent = (VFilePropertyChangeEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(renameEvent.getFile().getParent(), (String)renameEvent.getNewValue());
                    continue;
                }
                if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                this.onFileContentChanged(((VFileContentChangeEvent)vFileEvent).getFile());
            }
        }

        private void onFileOrDirectoryCreated(@NotNull VirtualFile parent, @NotNull String childName) {
            VirtualFile dir;
            VirtualFile file = null;
            VirtualFile virtualFile = dir = parent.isDirectory() ? parent : parent.getParent();
            while (dir != null) {
                for (Cache cache2 : ResourceFolderRegistry.this.myCaches) {
                    ResourceFolderRepository repository = (ResourceFolderRepository)((Object)cache2.getIfPresent((Object)dir));
                    if (repository == null) continue;
                    if (file == null && (file = parent.findChild(childName)) == null) {
                        return;
                    }
                    if (file.isDirectory()) {
                        for (VirtualFile child : file.getChildren()) {
                            if (child.isDirectory()) continue;
                            repository.onFileCreated(child);
                        }
                        continue;
                    }
                    repository.onFileCreated(file);
                }
                dir = dir.getParent();
            }
        }

        private void onFileOrDirectoryRemoved(@NotNull VirtualFile file) {
            VirtualFile dir;
            VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
            while (dir != null) {
                for (Cache cache2 : ResourceFolderRegistry.this.myCaches) {
                    ResourceFolderRepository repository = (ResourceFolderRepository)((Object)cache2.getIfPresent((Object)dir));
                    if (repository == null) continue;
                    repository.onFileOrDirectoryRemoved(file);
                }
                dir = dir.getParent();
            }
        }

        private void onFileContentChanged(@NotNull VirtualFile file) {
            if (file.isDirectory()) {
                return;
            }
            if (SdkUtils.hasImageExtension((String)file.getName())) {
                VirtualFile dir;
                VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
                while (dir != null) {
                    for (Cache cache2 : ResourceFolderRegistry.this.myCaches) {
                        ResourceFolderRepository repository = (ResourceFolderRepository)((Object)cache2.getIfPresent((Object)dir));
                        if (repository == null) continue;
                        repository.onBitmapFileUpdated(file);
                    }
                    dir = dir.getParent();
                }
            }
        }
    }

    public static class CachedRepositories {
        @Nullable
        public final ResourceFolderRepository namespaced;
        @Nullable
        public final ResourceFolderRepository nonNamespaced;

        public CachedRepositories(@Nullable ResourceFolderRepository namespaced, @Nullable ResourceFolderRepository nonNamespaced) {
            this.namespaced = namespaced;
            this.nonNamespaced = nonNamespaced;
        }
    }

    public static class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project project) {
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (facets.isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = AndroidResourceUtil.getResourceDirectoriesForFacets(facets);
            if (resDirectories.isEmpty()) {
                return;
            }
            Path projectCacheRoot = ResourceFolderRepositoryFileCacheService.get().getProjectDir(this.myProject);
            if (projectCacheRoot == null) {
                return;
            }
            try {
                FileUtil.ensureExists((File)projectCacheRoot.toFile());
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            assert (!application.isWriteAccessAllowed());
            int numDone = 0;
            int maxThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
            ExecutorService parallelExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ResourceFolderRegistry", (int)maxThreads);
            ArrayList<Future<ResourceFolderRepository>> repositoryJobs = new ArrayList<Future<ResourceFolderRepository>>();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                AndroidFacet facet = entry.getValue();
                VirtualFile dir = entry.getKey();
                ResourceFolderRegistry registry = ResourceFolderRegistry.getInstance(this.myProject);
                repositoryJobs.add(parallelExecutor.submit(() -> registry.get(facet, dir)));
            }
            for (Future future2 : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    future2.get();
                }
                catch (ExecutionException facet) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
        }
    }
}

