/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.TextResourceValue;
import com.android.ide.common.resources.DataBindingResourceType;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedResourceWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NoOpResourcePreprocessor;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.DefaultDataBindingLayoutInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MergedDataBindingLayoutInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFileAdapter;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceItemSource;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceFolderRepository
extends LocalResourceRepository
implements SingleNamespaceResourceRepository {
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    private final Module myModule;
    private final AndroidFacet myFacet;
    private final PsiListener myListener;
    private final VirtualFile myResourceDir;
    @NotNull
    private final ResourceNamespace myNamespace;
    @GuardedBy(value="AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK")
    private final ResourceTable myFullTable = new ResourceTable();
    private final Map<VirtualFile, ResourceItemSource<? extends ResourceItem>> sources = new HashMap<VirtualFile, ResourceItemSource<? extends ResourceItem>>();
    private Map<String, DataBindingLayoutInfo> myDataBindingResourceFiles = new HashMap<String, DataBindingLayoutInfo>();
    private long myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
    private final Object SCAN_LOCK = new Object();
    private Set<PsiFile> myPendingScans;
    @VisibleForTesting
    InitialScanState myInitialScanState;
    @VisibleForTesting
    static int ourFullRescans;

    private ResourceFolderRepository(@NotNull AndroidFacet facet, @NotNull VirtualFile resourceDir, @NotNull ResourceNamespace namespace) {
        super(resourceDir.getName());
        this.myFacet = facet;
        this.myModule = facet.getModule();
        this.myListener = new PsiListener();
        this.myResourceDir = resourceDir;
        this.myNamespace = namespace;
        ResourceMerger merger = this.loadPreviousStateIfExists();
        this.myInitialScanState = new InitialScanState(merger, VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir));
        this.scanRemainingFiles();
        Application app = ApplicationManager.getApplication();
        if (!(this.hasFreshFileCache() || this.namespacesUsed() || app.isUnitTestMode())) {
            this.saveStateToFile();
        }
        if (!app.isUnitTestMode()) {
            this.myInitialScanState = null;
        }
    }

    @NotNull
    AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public VirtualFile getResourceDir() {
        return this.myResourceDir;
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return null;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        return new ResourceFolderRepository(facet, dir, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void saveStateToFile() {
        File blobRoot = ResourceFolderRepositoryFileCacheService.get().getResourceDir(this.myModule.getProject(), this.myResourceDir);
        if (blobRoot == null) {
            return;
        }
        try {
            NoOpResourcePreprocessor preprocessor = NoOpResourcePreprocessor.INSTANCE;
            File tempDirectory = FileUtil.createTempDirectory((String)"resource", (String)"tmp", (boolean)false);
            try {
                MergedResourceWriter consumer = MergedResourceWriter.createWriterWithoutPngCruncher((File)blobRoot, null, null, (ResourcePreprocessor)preprocessor, (File)tempDirectory);
                this.myInitialScanState.myResourceMerger.writeBlobToWithTimestamps(blobRoot, (MergeConsumer)consumer);
            }
            finally {
                FileUtil.delete((File)tempDirectory);
            }
        }
        catch (MergingException | IOException e) {
            LOG.error("Failed to saveStateToFile", e);
            FileUtil.delete((File)blobRoot);
        }
    }

    private ResourceMerger loadPreviousStateIfExists() {
        if (this.namespacesUsed()) {
            return this.createFreshResourceMerger();
        }
        File blobRoot = ResourceFolderRepositoryFileCacheService.get().getResourceDir(this.myModule.getProject(), this.myResourceDir);
        if (blobRoot == null || !blobRoot.exists()) {
            return this.createFreshResourceMerger();
        }
        ResourceMerger merger = new ResourceMerger(0);
        try {
            if (!merger.loadFromBlob(blobRoot, false)) {
                LOG.warn("failed to loadPreviousStateIfExists " + blobRoot);
                return this.createFreshResourceMerger();
            }
        }
        catch (MergingException e) {
            LOG.warn("failed to loadPreviousStateIfExists " + blobRoot, (Throwable)e);
            return this.createFreshResourceMerger();
        }
        HashSet<ResourceFile> resourceFiles = new HashSet<ResourceFile>();
        List resourceSets = merger.getDataSets();
        if (resourceSets.size() != 1) {
            LOG.error("Expecting exactly one resource set, but found " + resourceSets.size());
            return this.createFreshResourceMerger();
        }
        ResourceSet dataSet = (ResourceSet)resourceSets.get(0);
        List sourceFiles = dataSet.getSourceFiles();
        if (sourceFiles.size() != 1) {
            LOG.error("Expecting exactly source files (res/ directories), but found " + sourceFiles.size());
            return this.createFreshResourceMerger();
        }
        File myResourceDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        if (!FileUtil.filesEqual((File)((File)sourceFiles.get(0)), (File)myResourceDirFile)) {
            LOG.warn(String.format("source file %1$s, does not match resource dir %2$s", sourceFiles.get(0), myResourceDirFile));
            return this.createFreshResourceMerger();
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        for (ResourceMergerItem item : dataSet.getDataMap().values()) {
            ResourceFile file = (ResourceFile)item.getSourceFile();
            if (file != null) {
                if (!resourceFiles.contains(file)) {
                    VirtualFile vFile = VfsUtil.findFileByIoFile((File)file.getFile(), (boolean)false);
                    if (vFile == null) {
                        item.setIgnoredFromDiskMerge(true);
                        continue;
                    }
                    resourceFiles.add(file);
                    this.sources.put(vFile, new ResourceFileAdapter(file));
                }
                ResourceFolderRepository.addToResult(result2, (ResourceItem)item);
                continue;
            }
            item.setIgnoredFromDiskMerge(true);
        }
        this.commitToRepository(result2);
        return merger;
    }

    private boolean namespacesUsed() {
        return ResourceRepositoryManager.getInstance(this.myFacet).getNamespacing() != AaptOptions.Namespacing.DISABLED;
    }

    private static void addToResult(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, ResourceItem item) {
        result2.computeIfAbsent(item.getType(), t -> LinkedListMultimap.create()).put((Object)item.getName(), (Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToRepository(Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : itemsByType.entrySet()) {
                this.getMap(this.myNamespace, entry.getKey(), true).putAll((Multimap)entry.getValue());
            }
        }
    }

    private ResourceMerger createFreshResourceMerger() {
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet myData = new ResourceSet(this.myResourceDir.getName(), this.myNamespace, null, false);
        File resourceDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        myData.addSource(resourceDir);
        merger.addDataSet(myData);
        return merger;
    }

    @VisibleForTesting
    boolean hasFreshFileCache() {
        return this.myInitialScanState.numXmlReparsed * 4 <= this.myInitialScanState.numXml;
    }

    private void scanRemainingFiles() {
        if (!this.myResourceDir.isValid()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> this.getPsiDirsForListener(this.myResourceDir));
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        this.scanResFolder(result2, this.myResourceDir);
        ApplicationManager.getApplication().runReadAction(() -> this.scanQueuedPsiResources(result2));
        this.commitToRepository(result2);
    }

    private void getPsiDirsForListener(@NotNull VirtualFile resourceDir) {
        PsiManager manager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory resourceDirPsi = manager.findDirectory(resourceDir);
        if (resourceDirPsi != null) {
            resourceDirPsi.getSubdirectories();
        }
    }

    private void scanQueuedPsiResources(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        PsiFile file;
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        for (PsiValueResourceQueueEntry valueResource : this.myInitialScanState.myPsiValueResourceQueue) {
            file = psiManager.findFile(valueResource.file);
            if (file == null) continue;
            this.scanValueFileAsPsi(result2, file, valueResource.folderConfiguration);
        }
        for (PsiFileResourceQueueEntry fileResource : this.myInitialScanState.myPsiFileResourceQueue) {
            if (!fileResource.file.isValid() || (file = psiManager.findFile(fileResource.file)) == null) continue;
            List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)fileResource.folderType);
            assert (resourceTypes.size() >= 1) : fileResource.folderType;
            ResourceType type = (ResourceType)resourceTypes.get(0);
            this.scanFileResourceFileAsPsi(result2, fileResource.folderType, fileResource.folderConfiguration, type, true, file);
        }
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile) {
        Project project;
        if (psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !(project = this.myModule.getProject()).isDisposed()) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    private void scanResFolder(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull VirtualFile resDir) {
        for (VirtualFile subDir : resDir.getChildren()) {
            FolderConfiguration folderConfiguration;
            String name;
            ResourceFolderType folderType;
            if (!subDir.isValid() || !subDir.isDirectory() || (folderType = ResourceFolderType.getFolderType((String)(name = subDir.getName()))) == null || (folderConfiguration = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
            String qualifiers = ResourceFolderRepository.getQualifiers(name);
            if (folderType == ResourceFolderType.VALUES) {
                this.scanValueResFolder(result2, subDir, qualifiers, folderConfiguration);
                continue;
            }
            this.scanFileResourceFolder(result2, subDir, folderType, qualifiers, folderConfiguration);
        }
    }

    @NotNull
    private static String getQualifiers(String dirName) {
        int index = dirName.indexOf(45);
        return index != -1 ? dirName.substring(index + 1) : "";
    }

    private void scanFileResourceFolder(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull VirtualFile directory, @NotNull ResourceFolderType folderType, String qualifiers, @NotNull FolderConfiguration folderConfiguration) {
        List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        assert (resourceTypes.size() >= 1) : folderType;
        ResourceType type = (ResourceType)resourceTypes.get(0);
        boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        for (VirtualFile file : directory.getChildren()) {
            boolean idGeneratingFile;
            if (!file.isValid() || file.isDirectory()) continue;
            FileType fileType = file.getFileType();
            boolean bl = idGeneratingFile = idGeneratingFolder && fileType == StdFileTypes.XML;
            if (!PsiProjectListener.isRelevantFileType(fileType) && folderType != ResourceFolderType.RAW) continue;
            this.scanFileResourceFile(result2, qualifiers, folderType, folderConfiguration, type, idGeneratingFile, file);
        }
    }

    private void scanFileResourceFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull ResourceFolderType folderType, @NotNull FolderConfiguration folderConfiguration, @NotNull ResourceType type, boolean idGenerating, @NotNull PsiFile file) {
        String resourceName = ResourceHelper.getResourceName(file);
        if (FileResourceNameValidator.getErrorTextForNameWithoutExtension((String)resourceName, (ResourceFolderType)folderType) != null) {
            return;
        }
        PsiResourceItem item = PsiResourceItem.forFile(resourceName, type, this.myNamespace, file, false);
        if (idGenerating) {
            ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
            this.addIds(result2, items2, file);
            PsiResourceFile resourceFile = new PsiResourceFile(file, items2, folderType, folderConfiguration);
            this.scanDataBinding(resourceFile, this.getModificationCount());
            this.sources.put(file.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file, Collections.singletonList(item), folderType, folderConfiguration);
            this.sources.put(file.getVirtualFile(), resourceFile);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    private void scanFileResourceFile(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration, ResourceType type, boolean idGenerating, VirtualFile file) {
        ResourceFile resourceFile;
        if (idGenerating) {
            if (this.sources.containsKey(file)) {
                this.myInitialScanState.countCacheHit();
                return;
            }
            try {
                boolean isDensityBasedResource;
                resourceFile = this.myInitialScanState.loadFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                if (resourceFile == null) {
                    this.myInitialScanState.queuePsiFileResourceScan(new PsiFileResourceQueueEntry(file, qualifiers, folderType, folderConfiguration));
                    return;
                }
                boolean bl = isDensityBasedResource = folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
                if (!isDensityBasedResource) {
                    this.myInitialScanState.countCacheMiss();
                }
                for (ResourceMergerItem item : resourceFile.getItems()) {
                    ResourceFolderRepository.addToResult(result2, (ResourceItem)item);
                    if (!isDensityBasedResource) continue;
                    item.setIgnoredFromDiskMerge(true);
                }
            }
            catch (MergingException e) {
                this.myInitialScanState.queuePsiFileResourceScan(new PsiFileResourceQueueEntry(file, qualifiers, folderType, folderConfiguration));
                return;
            }
        } else {
            String name = ResourceHelper.getResourceName(file);
            ResourceMergerItem item = new ResourceMergerItem(name, this.myNamespace, type, null, this.getLibraryName());
            ResourceFolderRepository.addToResult(result2, (ResourceItem)item);
            resourceFile = new ResourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file), item, folderConfiguration);
            item.setIgnoredFromDiskMerge(true);
        }
        this.sources.put(file, new ResourceFileAdapter(resourceFile));
    }

    @Override
    @Nullable
    public DataBindingLayoutInfo getDataBindingLayoutInfo(String layoutName) {
        List<ResourceItem> resourceItems = this.getResources(this.myNamespace, ResourceType.LAYOUT, layoutName);
        for (ResourceItem item : resourceItems) {
            PsiResourceFile source;
            if (!(item instanceof PsiResourceItem) || (source = ((PsiResourceItem)item).getSourceFile()) == null) continue;
            return source.getDataBindingLayoutInfo();
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, DataBindingLayoutInfo> getDataBindingResourceFiles() {
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            return this.myDataBindingResourceFiles;
        }
        this.myDataBindingResourceFilesModificationCount = modificationCount;
        Map<String, List<DefaultDataBindingLayoutInfo>> infoFilesByConfiguration = this.sources.values().stream().map(resourceFile -> resourceFile instanceof PsiResourceFile ? ((PsiResourceFile)resourceFile).getDataBindingLayoutInfo() : null).filter(Objects::nonNull).collect(Collectors.groupingBy(DefaultDataBindingLayoutInfo::getFileName));
        Map<String, DataBindingLayoutInfo> selected = infoFilesByConfiguration.entrySet().stream().flatMap(entry -> {
            if (((List)entry.getValue()).size() == 1) {
                DefaultDataBindingLayoutInfo info2 = (DefaultDataBindingLayoutInfo)((List)entry.getValue()).get(0);
                info2.setMergedInfo(null);
                return ((List)entry.getValue()).stream();
            }
            MergedDataBindingLayoutInfo mergedDataBindingLayoutInfo = new MergedDataBindingLayoutInfo((List)entry.getValue());
            ((List)entry.getValue()).forEach(info -> info.setMergedInfo(mergedDataBindingLayoutInfo));
            ArrayList<MergedDataBindingLayoutInfo> list = new ArrayList<MergedDataBindingLayoutInfo>(1 + ((List)entry.getValue()).size());
            list.add(mergedDataBindingLayoutInfo);
            list.addAll((Collection)entry.getValue());
            return list.stream();
        }).collect(Collectors.toMap(DataBindingLayoutInfo::getQualifiedName, kls -> kls));
        this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
        return this.myDataBindingResourceFiles;
    }

    @Nullable
    private static XmlTag getLayoutTag(PsiElement element) {
        if (!(element instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)element).getRootTag();
        if (rootTag != null && "layout".equals(rootTag.getName())) {
            return rootTag;
        }
        return null;
    }

    @Nullable
    private static XmlTag getDataTag(XmlTag layoutTag) {
        return layoutTag.findFirstSubTag("data");
    }

    private static void scanDataBindingDataTag(PsiResourceFile resourceFile, @Nullable XmlTag dataTag, long modificationCount) {
        DefaultDataBindingLayoutInfo info = resourceFile.getDataBindingLayoutInfo();
        assert (info != null);
        ArrayList<PsiDataBindingResourceItem> items2 = new ArrayList<PsiDataBindingResourceItem>();
        if (dataTag == null) {
            info.replaceItems(items2, modificationCount);
            return;
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (XmlTag tag : dataTag.findSubTags("variable")) {
            String name;
            String nameValue = tag.getAttributeValue("name");
            if (nameValue == null || !StringUtil.isNotEmpty((String)(name = StringUtil.unescapeXmlEntities((String)nameValue))) || !usedNames.add(name)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(name, DataBindingResourceType.VARIABLE, tag, resourceFile);
            items2.add(item);
        }
        HashSet<String> usedAliases = new HashSet<String>();
        for (XmlTag tag : dataTag.findSubTags("import")) {
            int lastIndexOfDot;
            String alias;
            String typeValue = tag.getAttributeValue("type");
            if (typeValue == null) continue;
            String type = StringUtil.unescapeXmlEntities((String)typeValue);
            String aliasValue = tag.getAttributeValue("alias");
            String string = alias = aliasValue == null ? null : StringUtil.unescapeXmlEntities((String)aliasValue);
            if (alias == null && (lastIndexOfDot = type.lastIndexOf(46)) >= 0) {
                alias = type.substring(lastIndexOfDot + 1);
            }
            if (!StringUtil.isNotEmpty((String)alias) || !usedAliases.add(type)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(alias, DataBindingResourceType.IMPORT, tag, resourceFile);
            items2.add(item);
        }
        info.replaceItems(items2, modificationCount);
    }

    private void scanDataBinding(PsiResourceFile resourceFile, long modificationCount) {
        boolean hasClassNameAttr;
        String classPackage;
        String className;
        if (resourceFile.getFolderType() != ResourceFolderType.LAYOUT) {
            resourceFile.setDataBindingLayoutInfo(null);
            return;
        }
        XmlTag layout2 = ResourceFolderRepository.getLayoutTag((PsiElement)resourceFile.getPsiFile());
        if (layout2 == null) {
            resourceFile.setDataBindingLayoutInfo(null);
            return;
        }
        XmlTag dataTag = ResourceFolderRepository.getDataTag(layout2);
        String modulePackage = MergedManifestManager.getSnapshot(this.myFacet).getPackage();
        String classAttrValue = null;
        if (dataTag != null && (classAttrValue = dataTag.getAttributeValue("class")) != null) {
            classAttrValue = StringUtil.unescapeXmlEntities((String)classAttrValue);
        }
        if (StringUtil.isEmpty(classAttrValue)) {
            className = DataBindingUtil.convertToJavaClassName(resourceFile.getName()) + "Binding";
            classPackage = modulePackage + ".databinding";
            hasClassNameAttr = false;
        } else {
            hasClassNameAttr = true;
            int firstDotIndex = classAttrValue.indexOf(46);
            if (firstDotIndex < 0) {
                classPackage = modulePackage + ".databinding";
                className = classAttrValue;
            } else {
                int lastDotIndex = classAttrValue.lastIndexOf(46);
                classPackage = firstDotIndex == 0 ? modulePackage + classAttrValue.substring(0, lastDotIndex) : classAttrValue.substring(0, lastDotIndex);
                className = classAttrValue.substring(lastDotIndex + 1);
            }
        }
        if (resourceFile.getDataBindingLayoutInfo() == null) {
            resourceFile.setDataBindingLayoutInfo(new DefaultDataBindingLayoutInfo(this.myFacet, resourceFile, className, classPackage, hasClassNameAttr));
        } else {
            resourceFile.getDataBindingLayoutInfo().update(className, classPackage, hasClassNameAttr, modificationCount);
        }
        ResourceFolderRepository.scanDataBindingDataTag(resourceFile, dataTag, modificationCount);
    }

    @Override
    @NotNull
    @GuardedBy(value="AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK")
    protected ResourceTable getFullTable() {
        return this.myFullTable;
    }

    @Override
    @Nullable
    @Contract(value="_, _, true -> !null")
    @GuardedBy(value="AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK")
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        ListMultimap multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type);
        if (multimap == null && create2) {
            multimap = LinkedListMultimap.create();
            this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    private void addIds(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, List<PsiResourceItem> items2, PsiFile file) {
        this.addIds(result2, items2, (PsiElement)file, false);
    }

    private void addIds(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, List<PsiResourceItem> items2, PsiElement element, boolean calledFromPsiListener) {
        HashMap<String, XmlTag> pendingResourceIds = new HashMap<String, XmlTag>();
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element, XmlTag.class);
        if (element instanceof XmlTag) {
            this.addId(result2, items2, (XmlTag)element, pendingResourceIds, calledFromPsiListener);
        }
        if (!xmlTags.isEmpty()) {
            for (XmlTag xmlTag : xmlTags) {
                this.addId(result2, items2, xmlTag, pendingResourceIds, calledFromPsiListener);
            }
        }
        if (!pendingResourceIds.isEmpty()) {
            for (Map.Entry entry : pendingResourceIds.entrySet()) {
                String id = (String)entry.getKey();
                PsiResourceItem item = PsiResourceItem.forXmlTag(id, ResourceType.ID, this.myNamespace, (XmlTag)entry.getValue(), calledFromPsiListener);
                items2.add(item);
                ResourceFolderRepository.addToResult(result2, item);
            }
        }
    }

    private void addId(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, List<PsiResourceItem> items2, XmlTag tag, Map<String, XmlTag> pendingResourceIds, boolean calledFromPsiListener) {
        assert (tag.isValid());
        ListMultimap<String, ResourceItem> idMultimap = result2.get(ResourceType.ID);
        for (XmlAttribute attribute : tag.getAttributes()) {
            String id;
            String value2;
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) || (value2 = attribute.getValue()) == null || !value2.startsWith("@+id/") || "id".equals(attribute.getLocalName()) || !ResourceFolderRepository.isValidResourceName(id = value2.substring("@+id/".length())) || idMultimap == null || idMultimap.containsKey((Object)id) || pendingResourceIds.containsKey(id)) continue;
            pendingResourceIds.put(id, tag);
        }
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null) {
            if (id.startsWith("@id/")) {
                if (!pendingResourceIds.containsKey(id = id.substring("@id/".length()))) {
                    return;
                }
            } else if (id.startsWith("@+id/")) {
                id = id.substring("@+id/".length());
            } else {
                return;
            }
            if (ResourceFolderRepository.isValidResourceName(id)) {
                pendingResourceIds.remove(id);
                PsiResourceItem item = PsiResourceItem.forXmlTag(id, ResourceType.ID, this.myNamespace, tag, calledFromPsiListener);
                items2.add(item);
                ResourceFolderRepository.addToResult(result2, item);
            }
        }
    }

    private void scanValueResFolder(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull VirtualFile directory, String qualifiers, FolderConfiguration folderConfiguration) {
        assert (directory.getName().startsWith("values"));
        for (VirtualFile file : directory.getChildren()) {
            if (!file.isValid() || file.isDirectory()) continue;
            this.scanValueFile(result2, qualifiers, file, folderConfiguration);
        }
    }

    private boolean scanValueFileAsPsi(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, PsiFile file, FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            XmlFile xmlFile = (XmlFile)file;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root = document.getRootTag();
                if (root == null) {
                    return false;
                }
                if (!root.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root.getSubTags();
                ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>(subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    String name = tag.getAttributeValue("name");
                    ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                    if (type == null || !ResourceFolderRepository.isValidResourceName(name)) continue;
                    PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, this.myNamespace, tag, false);
                    ResourceFolderRepository.addToResult(result2, item);
                    items2.add(item);
                    added = true;
                    if (type != ResourceType.STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (!ResourceFolderRepository.isValidResourceName(attrName) || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = PsiResourceItem.forXmlTag(attrName, ResourceType.ATTR, this.myNamespace, child, false);
                        items2.add(attrItem);
                        ResourceFolderRepository.addToResult(result2, attrItem);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file, items2, ResourceFolderType.VALUES, folderConfiguration);
                this.sources.put(file.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    @Contract(value="null -> false")
    private static boolean isValidResourceName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && ValueResourceNameValidator.getErrorText((String)name, null) == null;
    }

    private void scanValueFile(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, String qualifiers, VirtualFile virtualFile, FolderConfiguration folderConfiguration) {
        FileType fileType = virtualFile.getFileType();
        if (fileType == StdFileTypes.XML) {
            if (this.sources.containsKey(virtualFile)) {
                this.myInitialScanState.countCacheHit();
                return;
            }
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            try {
                ResourceFile resourceFile = this.myInitialScanState.loadFile(file);
                if (resourceFile == null) {
                    this.myInitialScanState.queuePsiValueResourceScan(new PsiValueResourceQueueEntry(virtualFile, qualifiers, folderConfiguration));
                    return;
                }
                for (ResourceItem item : resourceFile.getItems()) {
                    ResourceFolderRepository.addToResult(result2, item);
                }
                this.myInitialScanState.countCacheMiss();
                this.sources.put(virtualFile, new ResourceFileAdapter(resourceFile));
            }
            catch (MergingException e) {
                this.myInitialScanState.queuePsiValueResourceScan(new PsiValueResourceQueueEntry(virtualFile, qualifiers, folderConfiguration));
            }
        }
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile, ResourceFolderType folderType) {
        ResourceItemSource<? extends ResourceItem> resFile = this.sources.get(psiFile.getVirtualFile());
        if (resFile instanceof PsiResourceFile) {
            return false;
        }
        this.rescan(psiFile, folderType);
        return true;
    }

    private boolean isResourceFolder(@Nullable PsiElement parent) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (parent instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)parent).getParentDirectory()) != null) {
            VirtualFile dir = parentDirectory.getVirtualFile();
            return dir.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFolder(@NotNull VirtualFile virtualFile) {
        VirtualFile parentDirectory;
        if (virtualFile.isDirectory() && (parentDirectory = virtualFile.getParent()) != null) {
            return parentDirectory.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(@NotNull PsiFile psiFile) {
        return this.isResourceFolder((PsiElement)psiFile.getParent());
    }

    private boolean isResourceFile(@NotNull VirtualFile virtualFile) {
        VirtualFile parent = virtualFile.getParent();
        return parent != null && this.isResourceFolder(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(@NotNull PsiFile psiFile) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            return this.myPendingScans != null && this.myPendingScans.contains(psiFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void rescan(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.isScanPending(psiFile)) {
                return;
            }
            if (this.myPendingScans == null) {
                this.myPendingScans = new HashSet<PsiFile>();
            }
            this.myPendingScans.add(psiFile);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!psiFile.isValid()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                boolean rescan;
                Object object = this.SCAN_LOCK;
                synchronized (object) {
                    rescan = this.myPendingScans != null && this.myPendingScans.contains(psiFile);
                }
                if (rescan) {
                    this.rescanImmediately(psiFile, folderType);
                    object = this.SCAN_LOCK;
                    synchronized (object) {
                        this.myPendingScans.remove(psiFile);
                        if (this.myPendingScans.isEmpty()) {
                            this.myPendingScans = null;
                        }
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        ArrayList<PsiFile> files2;
        super.sync();
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.myPendingScans == null || this.myPendingScans.isEmpty()) {
                return;
            }
            files2 = new ArrayList<PsiFile>(this.myPendingScans);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (PsiFile file : files2) {
                ResourceFolderType folderType;
                if (!file.isValid() || (folderType = ResourceHelper.getFolderType(file)) == null) continue;
                this.rescanImmediately(file, folderType);
            }
        });
        object = this.SCAN_LOCK;
        synchronized (object) {
            this.myPendingScans = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescanImmediately(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ApplicationManager.getApplication().runReadAction(() -> this.rescanImmediately(psiFile, folderType));
            return;
        }
        if (psiFile.getProject().isDisposed()) {
            return;
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        PsiFile file = psiFile;
        if (folderType == ResourceFolderType.VALUES) {
            ++ourFullRescans;
            ResourceItemSource<? extends ResourceItem> source = this.sources.get(file.getVirtualFile());
            boolean removed = false;
            if (source != null) {
                for (ResourceItem resourceItem : source) {
                    removed |= !this.removeItems(resourceItem.getType(), resourceItem.getName(), source).isEmpty();
                }
                this.sources.remove(file.getVirtualFile());
            }
            file = this.ensureValid(file);
            boolean added = false;
            if (file != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory psiDirectory = file.getParent();
                assert (psiDirectory != null);
                PsiDirectory fileParent = psiFile.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    added = this.scanValueFileAsPsi(result2, file, folderConfiguration);
                }
            }
            if (added || removed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches();
            }
        } else {
            ResourceItemSource<? extends ResourceItem> source = this.sources.get(file.getVirtualFile());
            if (source instanceof PsiResourceFile) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && file.getFileType() == StdFileTypes.XML) {
                    ++ourFullRescans;
                    HashSet<String> idsBefore = new HashSet<String>();
                    Object object = ITEM_MAP_LOCK;
                    synchronized (object) {
                        ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)ResourceType.ID);
                        if (map2 != null) {
                            ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                            for (PsiResourceItem item : psiResourceFile) {
                                if (item.getType() != ResourceType.ID) continue;
                                idsBefore.add(item.getName());
                                idItems.add(item);
                            }
                            for (String id : idsBefore) {
                                List mapItems = map2.get((Object)id);
                                if (mapItems == null || mapItems.isEmpty()) continue;
                                ArrayList<ResourceItem> toDelete = new ArrayList<ResourceItem>(mapItems.size());
                                for (ResourceItem mapItem : mapItems) {
                                    if (!(mapItem instanceof PsiResourceItem) || ((PsiResourceItem)mapItem).getSourceFile() != psiResourceFile) continue;
                                    toDelete.add(mapItem);
                                }
                                for (ResourceItem delete : toDelete) {
                                    map2.remove((Object)delete.getName(), (Object)delete);
                                }
                            }
                            for (PsiResourceItem item : idItems) {
                                psiResourceFile.removeItem(item);
                            }
                        }
                    }
                    ArrayList<PsiResourceItem> arrayList = new ArrayList<PsiResourceItem>();
                    file = this.ensureValid(file);
                    if (file != null) {
                        this.addIds(result2, arrayList, file);
                    }
                    if (!arrayList.isEmpty()) {
                        for (PsiResourceItem item : arrayList) {
                            psiResourceFile.addItem(item);
                        }
                    }
                    this.rescanJustDataBinding(psiFile);
                    this.invalidateParentCaches(this.myNamespace, ResourceType.ID);
                }
            } else {
                boolean switchingToPsi;
                boolean bl = switchingToPsi = source != null;
                if (switchingToPsi) {
                    this.removeItemsFromSource(source);
                }
                ++ourFullRescans;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                List list = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                assert (list.size() >= 1) : folderType;
                ResourceType type = (ResourceType)list.get(0);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                if ((file = this.ensureValid(file)) != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file.getFileType() == StdFileTypes.XML;
                        this.scanFileResourceFileAsPsi(result2, folderType, folderConfiguration, type, idGeneratingFile, file);
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches();
                }
            }
        }
        this.commitToRepository(result2);
    }

    @NotNull
    private <T extends ResourceItem> List<T> removeItems(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceItemSource<T> source) {
        return this.removeItems(type, name, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T extends ResourceItem> List<T> removeItems(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceItemSource<T> source, @Nullable XmlTag xmlTag) {
        ArrayList<ResourceItem> removed = new ArrayList<ResourceItem>();
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            List mapItems;
            ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map2 != null && (mapItems = map2.get((Object)name)) != null) {
                ListIterator iterator = mapItems.listIterator();
                while (iterator.hasNext()) {
                    ResourceItem item = (ResourceItem)iterator.next();
                    if (!source.isSourceOf(item) || xmlTag != null && item instanceof PsiResourceItem && !((PsiResourceItem)item).wasTag(xmlTag)) continue;
                    iterator.remove();
                    removed.add(item);
                }
            }
        }
        return removed;
    }

    private void bitmapUpdated(@NotNull VirtualFile bitmap) {
        AndroidTargetData targetData;
        IAndroidTarget target;
        Module module = this.myFacet.getModule();
        ConfigurationManager configurationManager = ConfigurationManager.findExistingInstance(module);
        if (configurationManager != null && (target = configurationManager.getConfiguration(bitmap).getTarget()) != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
            targetData.clearLayoutBitmapCache(module);
        }
    }

    private void clearFontCache(VirtualFile virtualFile) {
        AndroidTargetData targetData;
        IAndroidTarget target;
        Module module = this.myFacet.getModule();
        ConfigurationManager configurationManager = ConfigurationManager.findExistingInstance(module);
        if (configurationManager != null && (target = configurationManager.getConfiguration(virtualFile).getTarget()) != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
            targetData.clearFontCache(virtualFile.getPath());
        }
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        return this.myListener;
    }

    void onBitmapFileUpdated(@NotNull VirtualFile file) {
        if (ResourceHelper.getFolderType(file) != null) {
            this.bitmapUpdated(file);
        }
    }

    void onFileCreated(@NotNull VirtualFile file) {
        PsiFile psiFile;
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if (folderType == null) {
            return;
        }
        if (this.isResourceFile(file) && PsiProjectListener.isRelevantFile(file) && (psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(file)) != null) {
            this.rescanImmediately(psiFile, folderType);
        }
    }

    void onFileOrDirectoryRemoved(@NotNull VirtualFile file) {
        if (file.isDirectory()) {
            Iterator<Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>>> iterator = this.sources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>> entry = iterator.next();
                iterator.remove();
                VirtualFile sourceFile = entry.getKey();
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)sourceFile, (boolean)true)) continue;
                this.onSourceRemoved(sourceFile, entry.getValue());
            }
        } else {
            ResourceItemSource<? extends ResourceItem> source = this.sources.remove(file);
            if (source != null) {
                this.onSourceRemoved(file, source);
            }
        }
    }

    private void onSourceRemoved(@NotNull VirtualFile file, @NotNull ResourceItemSource<? extends ResourceItem> source) {
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches();
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if (folderType == ResourceFolderType.VALUES || folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && file.getFileType() == StdFileTypes.XML) {
            this.removeItemsFromSource(source);
        } else if (folderType != null) {
            FileType fileType;
            if (folderType == ResourceFolderType.DRAWABLE && (fileType = file.getFileType()).isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png")) {
                this.bitmapUpdated(file);
            }
            if (folderType == ResourceFolderType.FONT) {
                this.clearFontCache(file);
            }
            List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            for (ResourceType type : resourceTypes) {
                if (type == ResourceType.ID) continue;
                String name = ResourceHelper.getResourceName(file);
                this.removeItems(type, name, source);
            }
        }
    }

    private void rescanJustDataBinding(@NotNull PsiFile psiFile) {
        ResourceItemSource<? extends ResourceItem> resFile = this.sources.get(psiFile.getVirtualFile());
        if (resFile != null) {
            PsiResourceFile resourceFile = (PsiResourceFile)resFile;
            if (!resourceFile.getPsiFile().isValid()) {
                resourceFile.setPsiFile(psiFile, resourceFile.getFolderConfiguration());
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.scanDataBinding(resourceFile, this.getModificationCount());
        }
    }

    @Nullable
    private ResourceItemSource<? extends ResourceItem> findSource(String dirName, String fileName) {
        String folderTypeName;
        String qualifiers;
        int index = dirName.indexOf(45);
        if (index == -1) {
            qualifiers = "";
            folderTypeName = dirName;
        } else {
            qualifiers = dirName.substring(index + 1);
            folderTypeName = dirName.substring(0, index);
        }
        ResourceFolderType folderType = ResourceFolderType.getTypeByName((String)folderTypeName);
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString((String)qualifiers);
        if (folderConfiguration == null) {
            folderConfiguration = new FolderConfiguration();
        }
        for (ResourceItemSource<? extends ResourceItem> source : this.sources.values()) {
            String sourceFilename;
            if (source instanceof ResourceFileAdapter) {
                sourceFilename = ((ResourceFileAdapter)source).getResourceFile().getFile().getName();
            } else {
                VirtualFile virtualFile = source.getVirtualFile();
                String string = sourceFilename = virtualFile == null ? null : virtualFile.getName();
            }
            if (folderType != source.getFolderType() || !fileName.equals(sourceFilename) || !folderConfiguration.equals((Object)source.getFolderConfiguration())) continue;
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemsFromSource(ResourceItemSource<? extends ResourceItem> source) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceItem resourceItem : source) {
                this.removeItems(resourceItem.getType(), resourceItem.getName(), source);
            }
        }
    }

    private static boolean isItemElement(XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.fromXmlTagName((String)tag) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findValueResourceItem(XmlTag tag, @NotNull PsiFile file) {
        if (!tag.isValid()) {
            ResourceItemSource<? extends ResourceItem> resFile = this.sources.get(file.getVirtualFile());
            if (resFile != null) {
                assert (resFile instanceof PsiResourceFile);
                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                for (ResourceItem item : resourceFile) {
                    PsiResourceItem pri = (PsiResourceItem)item;
                    if (!pri.wasTag(tag)) continue;
                    return item;
                }
            }
            return null;
        }
        String name = tag.getAttributeValue("name");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return name != null ? this.findValueResourceItem(tag, file, name) : null;
        }
    }

    @Nullable
    private ResourceItem findValueResourceItem(XmlTag tag, @NotNull PsiFile file, String name) {
        ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
        return this.findResourceItem(type, file, name, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file, @Nullable String name, @Nullable XmlTag tag) {
        if (type == null || name == null) {
            return null;
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file.getVirtualFile());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map2 == null) {
                return null;
            }
            List items2 = map2.get((Object)name);
            assert (items2 != null);
            if (tag != null) {
                for (ResourceItem resourceItem : items2) {
                    PsiResourceItem psiResourceItem;
                    if (!(resourceItem instanceof PsiResourceItem) || !(psiResourceItem = (PsiResourceItem)resourceItem).wasTag(tag)) continue;
                    return resourceItem;
                }
            } else {
                for (ResourceItem item : items2) {
                    if (item instanceof PsiResourceItem) {
                        if (!Objects.equals(((PsiResourceItem)item).getPsiFile(), file)) continue;
                        return item;
                    }
                    ResourceFile resourceFile = (ResourceFile)((ResourceMergerItem)item).getSourceFile();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return Collections.singleton(this.myResourceDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean equalFilesItems(ResourceFolderRepository other) {
        File otherResourceDir;
        File myResourceDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        if (!FileUtil.filesEqual((File)myResourceDirFile, (File)(otherResourceDir = VfsUtilCore.virtualToIoFile((VirtualFile)other.myResourceDir)))) {
            return false;
        }
        if (this.sources.size() != other.sources.size()) {
            return false;
        }
        for (Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>> fileEntry : this.sources.entrySet()) {
            ResourceItemSource<? extends ResourceItem> otherResFile = other.sources.get(fileEntry.getKey());
            if (otherResFile == null) {
                return false;
            }
            if (Objects.equals(fileEntry.getValue().getVirtualFile(), otherResFile.getVirtualFile())) continue;
            return false;
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ResourceTable otherResourceTable = other.getFullTable();
            if (this.myFullTable.size() != otherResourceTable.size()) {
                return false;
            }
            for (Table.Cell cell : this.myFullTable.cellSet()) {
                assert (cell.getColumnKey() != null);
                ListMultimap ownEntries = (ListMultimap)cell.getValue();
                ListMultimap otherEntries = (ListMultimap)otherResourceTable.get(cell.getRowKey(), cell.getColumnKey());
                if (otherEntries == null != (ownEntries == null)) {
                    return false;
                }
                if (ownEntries == null) continue;
                if (otherEntries.size() != ownEntries.size()) {
                    return false;
                }
                for (Map.Entry itemEntry : ownEntries.entries()) {
                    List otherItemsList = otherEntries.get(itemEntry.getKey());
                    if (otherItemsList == null) {
                        return false;
                    }
                    ResourceItem item = (ResourceItem)itemEntry.getValue();
                    if (ContainerUtil.exists((Iterable)otherItemsList, otherItem -> {
                        if (!item.getReferenceToSelf().equals((Object)otherItem.getReferenceToSelf())) {
                            return false;
                        }
                        if (Objects.equals(item.getSource(), otherItem.getSource())) {
                            ResourceValue resourceValue2 = item.getResourceValue();
                            ResourceValue otherResourceValue = otherItem.getResourceValue();
                            switch (item.getType()) {
                                case ID: {
                                    break;
                                }
                                case STRING: {
                                    if (resourceValue2 instanceof TextResourceValue && otherResourceValue instanceof TextResourceValue) {
                                        if (Objects.equals(resourceValue2.getValue(), otherResourceValue.getValue())) break;
                                        return false;
                                    }
                                }
                                default: {
                                    if (Objects.equals(resourceValue2, otherResourceValue)) break;
                                    return false;
                                }
                            }
                        }
                        return true;
                    })) continue;
                    return false;
                }
            }
        }
        return this.myDataBindingResourceFiles.keySet().equals(other.myDataBindingResourceFiles.keySet());
    }

    private final class PsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;

        private PsiListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (folderType == ResourceFolderType.VALUES) {
                        if (child instanceof XmlTag) {
                            XmlTag parentTag;
                            XmlTag tag = (XmlTag)child;
                            if (ResourceFolderRepository.isItemElement(tag)) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                if (source != null) {
                                    assert (source instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                                    String name = tag.getAttributeValue("name");
                                    if (ResourceFolderRepository.isValidResourceName(name)) {
                                        ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                                        if (type == ResourceType.STYLEABLE) {
                                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                                            return;
                                        }
                                        if (type != null) {
                                            PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, ResourceFolderRepository.this.myNamespace, tag, true);
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ResourceFolderRepository.this.getMap(ResourceFolderRepository.this.myNamespace, type, true).put((Object)name, (Object)item);
                                                psiResourceFile.addItem(item);
                                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, type);
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                            if ((parentTag = tag.getParentTag()) != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceItem parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                if (parentItem instanceof PsiResourceItem) {
                                    if (((PsiResourceItem)parentItem).recomputeValue()) {
                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    }
                                    return;
                                }
                            }
                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                        } else {
                            if (parent instanceof XmlText) {
                                XmlText text = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile);
                                return;
                            }
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                            return;
                        }
                        if (parent instanceof XmlElement && child instanceof XmlElement) {
                            if (child instanceof XmlTag) {
                                ResourceItemSource resFile;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                if (this.affectsDataBinding((XmlTag)child)) {
                                    ResourceFolderRepository.this.rescanJustDataBinding(psiFile);
                                }
                                ArrayList ids = new ArrayList();
                                HashMap result2 = new HashMap();
                                ResourceFolderRepository.this.addIds(result2, ids, child, true);
                                ResourceFolderRepository.this.commitToRepository(result2);
                                if (!ids.isEmpty() && (resFile = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile())) != null) {
                                    assert (resFile instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                    for (PsiResourceItem id : ids) {
                                        psiResourceFile.addItem(id);
                                    }
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, ResourceType.ID);
                                }
                                return;
                            }
                            if (child instanceof XmlAttribute || parent instanceof XmlAttribute) {
                                XmlAttribute attribute;
                                XmlAttribute xmlAttribute = attribute = parent instanceof XmlAttribute ? (XmlAttribute)parent : (XmlAttribute)child;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (this.affectsDataBinding(attribute)) {
                                    ResourceFolderRepository.this.rescanJustDataBinding(psiFile);
                                }
                            }
                        }
                    } else if (folderType == ResourceFolderType.FONT) {
                        ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            block26: {
                ResourceFolderType folderType;
                PsiFile psiFile;
                block27: {
                    PsiElement parent;
                    PsiElement child;
                    block28: {
                        XmlTag parentTag;
                        psiFile = event.getFile();
                        if (psiFile == null || !PsiProjectListener.isRelevantFile(psiFile)) break block26;
                        if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                            return;
                        }
                        folderType = ResourceHelper.getFolderType(psiFile);
                        if (folderType == null || !ResourceFolderRepository.this.isResourceFile(psiFile)) break block26;
                        child = event.getChild();
                        parent = event.getParent();
                        if (folderType != ResourceFolderType.VALUES) break block27;
                        if (!(child instanceof XmlTag)) break block28;
                        XmlTag tag = (XmlTag)child;
                        if (parent instanceof XmlTag && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag = (XmlTag)parent) != null) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                return;
                            }
                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                            if (resourceItem instanceof PsiResourceItem) {
                                ResourceItem declareStyleable;
                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                return;
                            }
                        }
                        if (ResourceFolderRepository.isItemElement(tag)) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                return;
                            }
                            ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                            if (source != null) {
                                ResourceType type;
                                String name;
                                PsiResourceFile resourceFile = (PsiResourceFile)source;
                                if (!tag.isValid()) {
                                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile);
                                    if (item == null) {
                                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                                        return;
                                    }
                                    name = item.getName();
                                } else {
                                    name = tag.getAttributeValue("name");
                                }
                                if (name != null && (type = AndroidResourceUtil.getResourceTypeForResourceTag(tag)) != null) {
                                    Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                    synchronized (object) {
                                        ListMultimap map2 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)type);
                                        if (map2 == null) {
                                            return;
                                        }
                                        List removed = ResourceFolderRepository.this.removeItems(type, name, resourceFile, tag);
                                        if (!removed.isEmpty()) {
                                            for (PsiResourceItem item : removed) {
                                                resourceFile.removeItem(item);
                                            }
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                            ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, type);
                                        }
                                    }
                                }
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                        break block26;
                    }
                    if (parent instanceof XmlText) {
                        XmlText text = (XmlText)parent;
                        this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                        break block26;
                    } else if (child instanceof XmlText) {
                        this.handleValueXmlTextEdit(parent, psiFile);
                        break block26;
                    } else {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    }
                    break block26;
                }
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                } else if (folderType == ResourceFolderType.FONT) {
                    ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void removeFile(@Nullable ResourceItemSource<? extends ResourceItem> source) {
            if (source == null) {
                return;
            }
            for (Map.Entry entry : ResourceFolderRepository.this.sources.entrySet()) {
                if (source != entry.getValue()) continue;
                VirtualFile keyFile = (VirtualFile)entry.getKey();
                ResourceFolderRepository.this.sources.remove(keyFile);
                break;
            }
            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
            ResourceFolderRepository.this.invalidateParentCaches();
            ResourceFolderRepository.this.removeItemsFromSource(source);
        }

        private void addFile(PsiFile psiFile) {
            assert (PsiProjectListener.isRelevantFile(psiFile));
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                if (PsiProjectListener.isRelevantFile(psiFile)) {
                    PsiElement parent;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                        PsiElement parent2 = event.getParent();
                        PsiElement child = event.getChild();
                        if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                            if (event.getOldChild() == event.getNewChild()) {
                                ResourceFolderRepository.this.rescan(psiFile, folderType);
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent2 instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                    if (source != null) {
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                            ResourceUrl newResourceUrl;
                                            XmlAttributeValue oldValue = (XmlAttributeValue)oldChild;
                                            XmlAttributeValue newValue = (XmlAttributeValue)newChild;
                                            ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldValue.getValue());
                                            if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newValue.getValue()))) {
                                                return;
                                            }
                                            if (this.handleIdChange(psiFile, source, xmlTag, newResourceUrl, Lint.stripIdPrefix((String)oldValue.getValue()))) {
                                                return;
                                            }
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                }
                            } else if (parent2 instanceof XmlAttributeValue) {
                                PsiElement grandParent = parent2.getParent();
                                if (grandParent instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                assert (grandParent instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)grandParent;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                    if (resFile != null) {
                                        ResourceUrl newResourceUrl;
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldChild.getText());
                                        if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newChild.getText()))) {
                                            return;
                                        }
                                        if (this.handleIdChange(psiFile, resFile, xmlTag, newResourceUrl, Lint.stripIdPrefix((String)oldChild.getText()))) {
                                            return;
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (this.affectsDataBinding(attribute)) {
                                    ResourceFolderRepository.this.rescanJustDataBinding(psiFile);
                                } else if (folderType != ResourceFolderType.VALUES) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                            }
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.VALUES) {
                        PsiElement parent3 = event.getParent();
                        if (parent3 instanceof XmlElement) {
                            if (parent3 instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlTag) {
                                XmlTag parentTag = (XmlTag)parent3;
                                if (AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        return;
                                    }
                                }
                                if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                    return;
                                }
                            }
                            if (parent3 instanceof XmlText) {
                                XmlText text = (XmlText)parent3;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (parent3 instanceof XmlAttributeValue) {
                                PsiElement attribute = parent3.getParent();
                                if (attribute instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                PsiElement tag = attribute.getParent();
                                assert (attribute instanceof XmlAttribute) : attribute;
                                XmlAttribute xmlAttribute = (XmlAttribute)attribute;
                                assert (tag instanceof XmlTag) : tag;
                                XmlTag xmlTag = (XmlTag)tag;
                                String attributeName = xmlAttribute.getName();
                                if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                    ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(xmlTag);
                                    if (type != null) {
                                        String newName2;
                                        String oldName = event.getOldChild().getText();
                                        if (oldName.equals(newName2 = event.getNewChild().getText())) {
                                            return;
                                        }
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile, oldName, xmlTag);
                                        if (item != null) {
                                            ResourceItem style;
                                            XmlTag parentTag;
                                            Object newResourceUrl = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (newResourceUrl) {
                                                ListMultimap map2 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)item.getType());
                                                if (map2 != null) {
                                                    map2.remove((Object)oldName, (Object)item);
                                                    if (ResourceFolderRepository.isValidResourceName(newName2)) {
                                                        PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName2, type, ResourceFolderRepository.this.myNamespace, xmlTag, true);
                                                        map2.put((Object)newName2, (Object)newItem);
                                                        ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                                        if (resFile != null) {
                                                            PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                                            resourceFile.removeItem((PsiResourceItem)item);
                                                            resourceFile.addItem(newItem);
                                                        } else assert (false) : item;
                                                    }
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, type);
                                                }
                                            }
                                            if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                                ((PsiResourceItem)style).recomputeValue();
                                            }
                                            return;
                                        }
                                    } else {
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && AndroidResourceUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.COLOR) {
                        PsiElement parent4 = event.getParent();
                        if (parent4 instanceof XmlElement) {
                            PsiElement attribute;
                            if (parent4 instanceof XmlComment) {
                                return;
                            }
                            if (parent4 instanceof XmlAttributeValue && (attribute = parent4.getParent()) instanceof XmlProcessingInstruction) {
                                return;
                            }
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            return;
                        }
                    } else if (folderType == ResourceFolderType.FONT) {
                        ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                    } else if (folderType != null && (parent = event.getParent()) instanceof XmlElement) {
                        if (parent instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleIdChange(@NotNull PsiFile psiFile, @NotNull ResourceItemSource<? extends ResourceItem> resFile, @NotNull XmlTag xmlTag, @Nullable ResourceUrl newResourceUrl, @NotNull String oldName) {
            if (resFile instanceof PsiResourceFile) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                ResourceItem item = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                synchronized (object) {
                    ListMultimap map2 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)ResourceType.ID);
                    if (map2 != null) {
                        boolean madeChanges = false;
                        if (item != null) {
                            map2.remove((Object)oldName, (Object)item);
                            if (psiResourceFile.isSourceOf(item)) {
                                psiResourceFile.removeItem((PsiResourceItem)item);
                            }
                            madeChanges = true;
                        }
                        if (newResourceUrl != null) {
                            String newName2 = newResourceUrl.name;
                            if (newResourceUrl.urlType == ResourceUrl.UrlType.CREATE && ResourceFolderRepository.isValidResourceName(newName2)) {
                                PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName2, ResourceType.ID, ResourceFolderRepository.this.myNamespace, xmlTag, true);
                                map2.put((Object)newName2, (Object)newItem);
                                psiResourceFile.addItem(newItem);
                                madeChanges = true;
                            }
                        }
                        if (madeChanges) {
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, ResourceType.ID);
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent, @NotNull PsiFile psiFile) {
            XmlTag style;
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.fromXmlTagName((String)style.getName()) != null) {
                boolean cleared;
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile);
                if (item instanceof PsiResourceItem && (cleared = ((PsiResourceItem)item).recomputeValue())) {
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                }
                return;
            }
            while (parentTag != null) {
                if (ResourceFolderRepository.isItemElement(parentTag)) {
                    boolean cleared;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                    if (!(item instanceof PsiResourceItem) || !(cleared = ((PsiResourceItem)item).recomputeValue())) break;
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    break;
                }
                parentTag = parentTag.getParentTag();
            }
        }

        public final void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            PsiElement parent = event.getParent();
            if (this.myIgnoreChildrenChanged ? parent != event.getChild() : event instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event).isGenericChange()) {
                return;
            }
            if (parent != null && parent.getChildren().length == 1 && parent.getChildren()[0] instanceof PsiWhiteSpace) {
                return;
            }
            PsiFile psiFile = event.getFile();
            if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
                ResourceFolderType folderType;
                VirtualFile file = psiFile.getVirtualFile();
                if (file != null && (folderType = ResourceHelper.getFolderType(psiFile)) != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            } else {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
        }

        private boolean affectsDataBinding(@NotNull XmlAttribute attribute) {
            return ArrayUtil.contains((String)attribute.getLocalName(), (String[])SdkConstants.ATTRS_DATA_BINDING) && ArrayUtil.contains((String)attribute.getParent().getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING);
        }

        private boolean affectsDataBinding(@NotNull XmlTag xmlTag) {
            return ArrayUtil.contains((String)xmlTag.getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING);
        }
    }

    private static class PsiValueResourceQueueEntry {
        public final VirtualFile file;
        public final String qualifiers;
        public final FolderConfiguration folderConfiguration;

        PsiValueResourceQueueEntry(VirtualFile file, String qualifiers, FolderConfiguration folderConfiguration) {
            this.file = file;
            this.qualifiers = qualifiers;
            this.folderConfiguration = folderConfiguration;
        }
    }

    private static class PsiFileResourceQueueEntry {
        public final VirtualFile file;
        public final String qualifiers;
        public final ResourceFolderType folderType;
        public final FolderConfiguration folderConfiguration;

        PsiFileResourceQueueEntry(VirtualFile file, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration) {
            this.file = file;
            this.qualifiers = qualifiers;
            this.folderType = folderType;
            this.folderConfiguration = folderConfiguration;
        }
    }

    static class InitialScanState {
        int numXml;
        int numXmlReparsed;
        final ResourceMerger myResourceMerger;
        final ResourceSet myResourceSet;
        final ILogger myILogger;
        final File myResourceDir;
        final Collection<PsiFileResourceQueueEntry> myPsiFileResourceQueue = new ArrayList<PsiFileResourceQueueEntry>();
        final Collection<PsiValueResourceQueueEntry> myPsiValueResourceQueue = new ArrayList<PsiValueResourceQueueEntry>();

        InitialScanState(ResourceMerger merger, File resourceDir) {
            this.myResourceMerger = merger;
            assert (this.myResourceMerger.getDataSets().size() == 1);
            this.myResourceSet = (ResourceSet)this.myResourceMerger.getDataSets().get(0);
            this.myResourceSet.setShouldParseResourceIds(true);
            this.myResourceSet.setDontNormalizeQualifiers(true);
            this.myResourceSet.setTrackSourcePositions(false);
            this.myILogger = new LogWrapper(LOG).alwaysLogAsDebug(true).allowVerbose(false);
            this.myResourceDir = resourceDir;
        }

        public void countCacheHit() {
            ++this.numXml;
        }

        public void countCacheMiss() {
            ++this.numXml;
            ++this.numXmlReparsed;
        }

        @Nullable
        ResourceFile loadFile(File file) throws MergingException {
            return (ResourceFile)this.myResourceSet.loadFile(this.myResourceDir, file, this.myILogger);
        }

        public void queuePsiFileResourceScan(PsiFileResourceQueueEntry data) {
            this.myPsiFileResourceQueue.add(data);
        }

        public void queuePsiValueResourceScan(PsiValueResourceQueueEntry data) {
            this.myPsiValueResourceQueue.add(data);
        }
    }
}

