/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStringUtil;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceHelper$sam$java_util_Comparator$0;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TwoColorsIcon;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u00bc\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a8\u0010\u0019\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u001e\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)\u001a\u001e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b\u001a\u000e\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u000200\u001a\u0016\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001\u001a\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\"\u001a\u00020#2\u0006\u00106\u001a\u00020\u0016H\u0002\u001a\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0002\u001a\u001e\u0010:\u001a\u0002002\f\u0010;\u001a\b\u0012\u0004\u0012\u0002000<2\u0006\u0010/\u001a\u000200H\u0002\u001a\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00010>2\u0006\u0010?\u001a\u00020@\u001a.\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00010<2\u0006\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00140>2\b\b\u0002\u0010E\u001a\u00020\u0016H\u0007\u001a\u0012\u0010F\u001a\u0004\u0018\u00010G2\b\u0010?\u001a\u0004\u0018\u00010H\u001a\u0012\u0010F\u001a\u0004\u0018\u00010G2\b\u0010?\u001a\u0004\u0018\u00010@\u001a\u0010\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010?\u001a\u00020K\u001a\u0012\u0010I\u001a\u0004\u0018\u00010J2\b\u0010?\u001a\u0004\u0018\u00010H\u001a\u0012\u0010I\u001a\u0004\u0018\u00010J2\b\u0010?\u001a\u0004\u0018\u00010@\u001a\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O\u001a\u0010\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010N\u001a\u00020O\u001a\u000e\u0010R\u001a\u00020\u00012\u0006\u0010?\u001a\u00020H\u001a\u000e\u0010R\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@\u001a\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020H0<2\b\u0010?\u001a\u0004\u0018\u00010H2\u0006\u0010T\u001a\u00020\u0016\u001a\u000e\u0010U\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#\u001a\u0010\u0010V\u001a\u00020\u00012\u0006\u0010N\u001a\u00020WH\u0002\u001a(\u0010X\u001a\u00020\u00162\u0006\u0010Y\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020\u00012\u0006\u0010B\u001a\u00020CH\u0002\u001a\u001e\u0010[\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\u00012\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\b\u001a\u0016\u0010`\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\u00012\u0006\u0010a\u001a\u00020\u0001\u001a\u000e\u0010b\u001a\u00020\u00162\u0006\u0010c\u001a\u00020\u0001\u001a\u0016\u0010d\u001a\u00020\u00162\u0006\u0010\\\u001a\u00020\u00012\u0006\u0010_\u001a\u00020\b\u001a\u0012\u0010e\u001a\u0004\u0018\u0001002\b\u0010f\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010g\u001a\u0004\u0018\u00010H2\u0006\u0010B\u001a\u00020C\u001a(\u0010h\u001a\u0004\u0018\u00010\u00012\b\u0010i\u001a\u0004\u0018\u00010j2\b\u0010Z\u001a\u0004\u0018\u00010\u00012\b\u0010k\u001a\u0004\u0018\u00010JH\u0007\u001a\u000e\u0010l\u001a\u00020\u00012\u0006\u0010m\u001a\u00020\u0001\u001a\u0010\u0010n\u001a\u0004\u0018\u00010o2\u0006\u0010p\u001a\u00020\u0001\u001a0\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00010r*\u00020\u00182\u0006\u0010Y\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010s\u001a\u00020\u001d2\u0006\u0010t\u001a\u00020u\u001a\f\u0010v\u001a\u0004\u0018\u00010H*\u00020w\u001a\u0012\u0010x\u001a\u00020\u0016*\u00020y2\u0006\u0010B\u001a\u00020C\u001a\u0012\u0010x\u001a\u00020\u0016*\u00020w2\u0006\u0010B\u001a\u00020C\u001a\u0012\u0010z\u001a\u00020\u0016*\u00020y2\u0006\u0010B\u001a\u00020C\u001a\u0012\u0010z\u001a\u00020\u0016*\u00020w2\u0006\u0010B\u001a\u00020C\u001a\n\u0010{\u001a\u00020\u0016*\u00020\u0014\u001a\n\u0010|\u001a\u00020\u0016*\u00020\u0014\u001a\u001c\u0010}\u001a\u000200*\u00020~2\u0006\u0010/\u001a\u0002002\b\u0010\u007f\u001a\u0004\u0018\u00010\u0001\u001a\u001f\u0010\u0080\u0001\u001a\u0004\u0018\u00010y*\u00020~2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010N\u001a\u00020O\u001a\u0017\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0083\u0001*\u00030\u0082\u00012\u0006\u0010N\u001a\u00020O\u001a.\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001*\u00020~2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010y2\u0007\u0010\u0087\u0001\u001a\u00020\b2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0002\u001a-\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u0085\u0001*\u00020~2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010B\u001a\u00020CH\u0002\u001a+\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u0085\u0001*\u00020~2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010B\u001a\u00020C\u001a\"\u0010\u008c\u0001\u001a\u0004\u0018\u000100*\u00020~2\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001\u001a-\u0010\u008c\u0001\u001a\u0004\u0018\u000100*\u00020~2\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008e\u0001\u001a\u00020\bH\u0002\u001a\"\u0010\u008f\u0001\u001a\u0004\u0018\u00010H*\u00020~2\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001\u001a\u0018\u0010\u0091\u0001\u001a\u0004\u0018\u00010H*\u00020~2\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010y\u001a&\u0010\u0093\u0001\u001a\b\u0012\u0004\u0012\u0002000<*\u00020~2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001\u001a1\u0010\u0093\u0001\u001a\b\u0012\u0004\u0012\u0002000<*\u00020~2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008e\u0001\u001a\u00020\bH\u0002\u001a\u001a\u0010\u0094\u0001\u001a\u0004\u0018\u00010y*\u00020~2\t\u0010\u0095\u0001\u001a\u0004\u0018\u00010yH\u0003\u001a\u0018\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u000b*\u00020O2\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u0001\u001a!\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0099\u0001*\u00020~2\u0007\u0010\u0086\u0001\u001a\u00020y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001\u001a,\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0099\u0001*\u00020~2\u0007\u0010\u009a\u0001\u001a\u00020y2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008e\u0001\u001a\u00020\bH\u0002\u001a\u0014\u0010\u009b\u0001\u001a\u00020\u0001*\u00020~2\u0007\u0010\u0086\u0001\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u009c\u0001"}, d2={"ALPHA_FLOATING_ERROR_FORMAT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NO_PREFIX_PACKAGES", "", "[Ljava/lang/String;", "RESOURCE_ICON_SIZE", "", "RESOURCE_PROTOCOLS", "resourceNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "Lcom/intellij/psi/PsiElement;", "getResourceNamespace", "(Lcom/intellij/psi/PsiElement;)Lcom/android/ide/common/rendering/api/ResourceNamespace;", "addFrameworkItems", "", "destination", "", "type", "Lcom/android/resources/ResourceType;", "includeFileResources", "", "frameworkResources", "Lcom/android/ide/common/resources/ResourceRepository;", "addProjectItems", "repository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "lookup", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "appendText", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "buildResourceId", "packageId", "", "typeId", "entryId", "", "clamp", "i", "min", "max", "colorToString", "color", "Ljava/awt/Color;", "compareResourceReferences", "resource1", "resource2", "createStateListState", "Lcom/android/tools/idea/res/StateListState;", "isFramework", "extend", "", "nibble", "findContrastingOtherColor", "colors", "", "findIdsInFile", "", "file", "Lcom/intellij/psi/PsiFile;", "getCompletionFromTypes", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "completionTypes", "sort", "getFolderConfiguration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFolderType", "Lcom/android/resources/ResourceFolderType;", "Lcom/android/ide/common/resources/ResourceFile;", "getNamespaceResolver", "Lcom/android/ide/common/rendering/api/ResourceNamespace$Resolver;", "element", "Lcom/intellij/psi/xml/XmlElement;", "getNamespacesContext", "Lcom/android/tools/idea/res/ResourceNamespaceContext;", "getResourceName", "getResourceVariations", "includeSelf", "getTextContent", "getXmlTextValue", "Lcom/intellij/psi/xml/XmlText;", "isAccessible", "namespace", "name", "isClassPackageNeeded", "qualifiedName", "baseClass", "Lcom/intellij/psi/PsiClass;", "apiLevel", "isDirectlyInPackage", "packagePrefix", "isFileResource", "candidatePath", "isViewPackageNeeded", "parseColor", "s", "pickAnyLayoutFile", "prependResourcePrefix", "module", "Lcom/intellij/openapi/module/Module;", "folderType", "styleToTheme", "style", "toFileResourcePathString", "Lcom/android/ide/common/util/PathString;", "resourcePath", "getResourceItems", "", "visibilityLookup", "minVisibility", "Lcom/android/resources/ResourceVisibility;", "getSourceAsVirtualFile", "Lcom/android/ide/common/resources/ResourceItem;", "isAccessibleInCode", "Lcom/android/ide/common/rendering/api/ResourceValue;", "isAccessibleInXml", "isFileBased", "isValueBased", "makeColorWithAlpha", "Lcom/android/ide/common/rendering/api/RenderResources;", "alphaValue", "resolve", "resourceUrl", "Lcom/android/resources/ResourceUrl;", "Lcom/android/ide/common/rendering/api/ResourceReference;", "resolveAsColorIcon", "Ljavax/swing/Icon;", "value", "size", "project", "Lcom/intellij/openapi/project/Project;", "resolveAsDrawable", "resolveAsIcon", "resolveColor", "colorValue", "depth", "resolveDrawable", "drawable", "resolveLayout", "layout", "resolveMultipleColors", "resolveNullableResValue", "res", "resolveResourceNamespace", "prefix", "resolveStateList", "Lcom/android/tools/idea/res/StateList;", "resourceValue", "resolveStringValue", "intellij.android.core"})
@JvmName(name="ResourceHelper")
public final class ResourceHelper {
    public static final int RESOURCE_ICON_SIZE = 16;
    @NotNull
    public static final String ALPHA_FLOATING_ERROR_FORMAT = "The alpha attribute in %1$s/%2$s does not resolve to a floating point number";
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.res.ResourceHelper");
    private static final String[] NO_PREFIX_PACKAGES = new String[]{"android.widget.", "android.view.", "android.webkit."};
    private static final String[] RESOURCE_PROTOCOLS = new String[]{"apk", "jar", "file"};

    @NotNull
    public static final String styleToTheme(@NotNull String style) {
        String string;
        if (StringsKt.startsWith$default((String)style, (String)"@style/", (boolean)false, (int)2, null)) {
            String string2 = style;
            int n = "@style/".length();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)style, (String)"@android:style/", (boolean)false, (int)2, null)) {
            String string5 = style;
            int n = "@android:style/".length();
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)style, (String)"@", (boolean)false, (int)2, null)) {
            int index = StringsKt.indexOf$default((CharSequence)style, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string8 = style;
                int n = index + 1;
                String string9 = string8;
                if (string9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.substring(n);
                string = string10;
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = style;
            }
        } else {
            string = style;
        }
        return string;
    }

    public static final boolean isValueBased(@NotNull ResourceType $receiver) {
        return FolderTypeRelationship.getRelatedFolders((ResourceType)$receiver).contains(ResourceFolderType.VALUES);
    }

    public static final boolean isFileBased(@NotNull ResourceType $receiver) {
        Object v0;
        block2: {
            if ($receiver == ResourceType.ID) {
                return false;
            }
            Iterable $receiver$iv = FolderTypeRelationship.getRelatedFolders((ResourceType)$receiver);
            for (Object element$iv : $receiver$iv) {
                ResourceFolderType it = (ResourceFolderType)element$iv;
                boolean bl = false;
                if (!(it != ResourceFolderType.VALUES)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @NotNull
    public static final String getResourceName(@NotNull VirtualFile file) {
        return Lint.getBaseName((String)file.getName());
    }

    @NotNull
    public static final String getResourceName(@NotNull PsiFile file) {
        return Lint.getBaseName((String)file.getName());
    }

    @Nullable
    public static final ResourceFolderType getFolderType(@Nullable PsiFile file) {
        ResourceFolderType resourceFolderType;
        if (file == null) {
            resourceFolderType = null;
        } else if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            boolean $i$f$runReadAction = false;
            resourceFolderType = (ResourceFolderType)ApplicationManager.getApplication().runReadAction(new Computable<T>(file){
                final /* synthetic */ PsiFile $file$inlined;
                {
                    this.$file$inlined = psiFile;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)ResourceHelper.getFolderType(this.$file$inlined);
                }
            });
        } else if (!file.isValid()) {
            resourceFolderType = ResourceHelper.getFolderType(file.getVirtualFile());
        } else {
            PsiDirectory psiDirectory = file.getParent();
            if (psiDirectory != null) {
                PsiDirectory psiDirectory2;
                PsiDirectory it = psiDirectory2 = psiDirectory;
                boolean bl = false;
                resourceFolderType = ResourceFolderType.getFolderType((String)it.getName());
            } else {
                resourceFolderType = null;
            }
        }
        return resourceFolderType;
    }

    @Nullable
    public static final ResourceFolderType getFolderType(@Nullable VirtualFile file) {
        ResourceFolderType resourceFolderType;
        VirtualFile virtualFile = file;
        if (virtualFile != null && (virtualFile = virtualFile.getParent()) != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            resourceFolderType = ResourceFolderType.getFolderType((String)it.getName());
        } else {
            resourceFolderType = null;
        }
        return resourceFolderType;
    }

    @Nullable
    public static final ResourceFolderType getFolderType(@NotNull ResourceFile file) {
        ResourceFolderType resourceFolderType;
        File file2 = file.getFile().getParentFile();
        if (file2 != null) {
            File file3;
            File it = file3 = file2;
            boolean bl = false;
            resourceFolderType = ResourceFolderType.getFolderType((String)it.getName());
        } else {
            resourceFolderType = null;
        }
        return resourceFolderType;
    }

    @Nullable
    public static final FolderConfiguration getFolderConfiguration(@Nullable PsiFile file) {
        FolderConfiguration folderConfiguration;
        if (file == null) {
            folderConfiguration = null;
        } else if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            boolean $i$f$runReadAction = false;
            folderConfiguration = (FolderConfiguration)ApplicationManager.getApplication().runReadAction(new Computable<T>(file){
                final /* synthetic */ PsiFile $file$inlined;
                {
                    this.$file$inlined = psiFile;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)ResourceHelper.getFolderConfiguration(this.$file$inlined);
                }
            });
        } else if (!file.isValid()) {
            folderConfiguration = ResourceHelper.getFolderConfiguration(file.getVirtualFile());
        } else {
            PsiDirectory psiDirectory = file.getParent();
            if (psiDirectory != null) {
                PsiDirectory psiDirectory2;
                PsiDirectory it = psiDirectory2 = psiDirectory;
                boolean bl = false;
                folderConfiguration = FolderConfiguration.getConfigForFolder((String)it.getName());
            } else {
                folderConfiguration = null;
            }
        }
        return folderConfiguration;
    }

    @Nullable
    public static final FolderConfiguration getFolderConfiguration(@Nullable VirtualFile file) {
        FolderConfiguration folderConfiguration;
        VirtualFile virtualFile = file;
        if (virtualFile != null && (virtualFile = virtualFile.getParent()) != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            folderConfiguration = FolderConfiguration.getConfigForFolder((String)it.getName());
        } else {
            folderConfiguration = null;
        }
        return folderConfiguration;
    }

    @NotNull
    public static final List<VirtualFile> getResourceVariations(@Nullable VirtualFile file, boolean includeSelf) {
        String parentName;
        if (file == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<VirtualFile> variations = new ArrayList<VirtualFile>();
        String name = file.getName();
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            return variations;
        }
        VirtualFile resFolder = virtualFile;
        String prefix = parentName = file.getParent().getName();
        int qualifiers = StringsKt.indexOf$default((CharSequence)prefix, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (qualifiers != -1) {
            String string = prefix;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, qualifiers);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            parentName = string3;
            string = prefix;
            n = 0;
            int n2 = qualifiers + 1;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            prefix = string5;
        } else {
            prefix = prefix + '-';
        }
        for (VirtualFile resource : resFolder.getChildren()) {
            VirtualFile variation;
            String n = resource.getName();
            if (!StringsKt.startsWith$default((String)n, (String)prefix, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)n, (Object)parentName) || !resource.isDirectory() || (variation = resource.findChild(name)) == null || !includeSelf && Intrinsics.areEqual((Object)file, (Object)variation)) continue;
            variations.add(variation);
        }
        return variations;
    }

    @Nullable
    public static final VirtualFile getSourceAsVirtualFile(@NotNull ResourceItem $receiver) {
        boolean $i$f$runReadAction = false;
        return (VirtualFile)ApplicationManager.getApplication().runReadAction(new Computable<T>($receiver){
            final /* synthetic */ ResourceItem $this_getSourceAsVirtualFile$inlined;
            {
                this.$this_getSourceAsVirtualFile$inlined = resourceItem;
            }

            public final T compute() {
                Object object;
                boolean bl = false;
                if (this.$this_getSourceAsVirtualFile$inlined instanceof PsiResourceItem) {
                    PsiFile psiFile = ((PsiResourceItem)this.$this_getSourceAsVirtualFile$inlined).getPsiFile();
                    object = psiFile != null ? psiFile.getVirtualFile() : null;
                } else {
                    PathString pathString = this.$this_getSourceAsVirtualFile$inlined.getOriginalSource();
                    object = pathString != null ? FileExtensions.toVirtualFile$default(pathString, false, 1, null) : null;
                }
                return (T)object;
            }
        });
    }

    public static final boolean isViewPackageNeeded(@NotNull String qualifiedName, int apiLevel) {
        for (String noPrefixPackage : NO_PREFIX_PACKAGES) {
            if (!ResourceHelper.isDirectlyInPackage(qualifiedName, noPrefixPackage)) continue;
            return false;
        }
        return apiLevel >= 20 ? !ResourceHelper.isDirectlyInPackage(qualifiedName, "android.app.") : true;
    }

    public static final boolean isClassPackageNeeded(@NotNull String qualifiedName, @NotNull PsiClass baseClass, int apiLevel) {
        return InheritanceUtil.isInheritor((PsiClass)baseClass, (String)"android.view.View") ? ResourceHelper.isViewPackageNeeded(qualifiedName, apiLevel) : (InheritanceUtil.isInheritor((PsiClass)baseClass, (String)"android.preference.Preference") ? !ResourceHelper.isDirectlyInPackage(qualifiedName, "android.preference") : (InheritanceUtil.isInheritor((PsiClass)baseClass, (String)MigrateToAndroidxUtil.getNameInProject(SdkConstants.CLASS_PREFERENCE_ANDROIDX, baseClass.getProject())) ? !ResourceHelper.isDirectlyInPackage(qualifiedName, "androidx.preference") : !StringsKt.startsWith$default((String)qualifiedName, (String)"android.", (boolean)false, (int)2, null)));
    }

    public static final boolean isDirectlyInPackage(@NotNull String qualifiedName, @NotNull String packagePrefix) {
        return StringsKt.startsWith$default((String)qualifiedName, (String)packagePrefix, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)qualifiedName, (char)'.', (int)(packagePrefix.length() + 1), (boolean)false, (int)4, null) == -1;
    }

    @Nullable
    public static final Color resolveColor(@NotNull RenderResources $receiver, @Nullable ResourceValue colorValue, @NotNull Project project) {
        return ResourceHelper.resolveColor($receiver, colorValue, project, 0);
    }

    private static final Color resolveColor(@NotNull RenderResources $receiver, ResourceValue colorValue, Project project, int depth) {
        Color color;
        if (depth >= 50) {
            LOG.warn("too deep " + colorValue);
            return null;
        }
        ResourceValue resourceValue2 = ResourceHelper.resolveNullableResValue($receiver, colorValue);
        if (resourceValue2 == null) {
            return null;
        }
        ResourceValue result2 = resourceValue2;
        StateList stateList = ResourceHelper.resolveStateList($receiver, result2, project);
        if (stateList == null) {
            return ResourceHelper.parseColor(result2.getValue());
        }
        StateList stateList2 = stateList;
        List<StateListState> states = stateList2.getStates();
        if (states.isEmpty()) {
            return null;
        }
        StateListState state = states.get(states.size() - 1);
        Color color2 = ResourceHelper.parseColor(state.getValue());
        if (color2 == null) {
            color2 = ResourceHelper.resolveColor($receiver, $receiver.findResValue(state.getValue(), false), project, depth + 1);
        }
        if (color2 == null) {
            return null;
        }
        Color stateColor = color2;
        try {
            color = ResourceHelper.makeColorWithAlpha($receiver, stateColor, state.getAlpha());
        }
        catch (NumberFormatException e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The alpha attribute in %s/%s does not resolve to a floating point number";
            Object[] objectArray = new Object[]{stateList2.getDirName(), stateList2.getFileName()};
            Logger logger = LOG;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            logger.warn(string3);
            color = stateColor;
        }
        return color;
    }

    @NotNull
    public static final List<Color> resolveMultipleColors(@NotNull RenderResources $receiver, @Nullable ResourceValue value2, @NotNull Project project) {
        return ResourceHelper.resolveMultipleColors($receiver, value2, project, 0);
    }

    @Nullable
    public static final Icon resolveAsIcon(@NotNull RenderResources $receiver, @Nullable ResourceValue value2, @NotNull Project project, @NotNull AndroidFacet facet) {
        Icon icon2 = ResourceHelper.resolveAsColorIcon($receiver, value2, 16, project);
        if (icon2 == null) {
            icon2 = ResourceHelper.resolveAsDrawable($receiver, value2, project, facet);
        }
        return icon2;
    }

    private static final Icon resolveAsColorIcon(@NotNull RenderResources $receiver, ResourceValue value2, int size, Project project) {
        Icon icon2;
        List<Color> colors = ResourceHelper.resolveMultipleColors($receiver, value2, project);
        switch (colors.size()) {
            case 0: {
                icon2 = null;
                break;
            }
            case 1: {
                icon2 = (Icon)JBUI.scale((JBUI.JBIcon)((JBUI.JBIcon)new ColorIcon(size, (Color)CollectionsKt.first(colors), false)));
                break;
            }
            default: {
                icon2 = (Icon)JBUI.scale((JBUI.JBIcon)((JBUI.JBIcon)new TwoColorsIcon(size, (Color)CollectionsKt.last(colors), ResourceHelper.findContrastingOtherColor(colors, (Color)CollectionsKt.last(colors)))));
            }
        }
        return icon2;
    }

    private static final Color findContrastingOtherColor(List<? extends Color> colors, Color color) {
        Color color2;
        Object v0;
        Iterable $receiver$iv = colors;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            Color it = (Color)maxElem$iv;
            boolean bl = false;
            float maxValue$iv = MaterialColorUtils.colorDistance(it, color);
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                Color it2 = (Color)e$iv;
                $i$a$-maxBy-ResourceHelper$findContrastingOtherColor$1 = false;
                float v$iv = MaterialColorUtils.colorDistance(it2, color);
                if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v0 = maxElem$iv;
        }
        if ((color2 = (Color)v0) == null) {
            color2 = (Color)CollectionsKt.first(colors);
        }
        return color2;
    }

    private static final Icon resolveAsDrawable(@NotNull RenderResources $receiver, ResourceValue value2, Project project, AndroidFacet facet) {
        VirtualFile virtualFile = AndroidAnnotatorUtil.pickBestBitmap(ResourceHelper.resolveDrawable($receiver, value2, project));
        if (virtualFile == null) {
            return null;
        }
        VirtualFile bitmap = virtualFile;
        return GutterIconCache.getInstance().getIcon(bitmap, $receiver, facet);
    }

    private static final List<Color> resolveMultipleColors(@NotNull RenderResources $receiver, ResourceValue value2, Project project, int depth) {
        if (depth >= 50) {
            LOG.warn("too deep " + value2);
            return CollectionsKt.emptyList();
        }
        ResourceValue resourceValue2 = ResourceHelper.resolveNullableResValue($receiver, value2);
        if (resourceValue2 == null) {
            return CollectionsKt.emptyList();
        }
        ResourceValue resolvedValue = resourceValue2;
        ArrayList<Color> result2 = new ArrayList<Color>();
        StateList stateList = ResourceHelper.resolveStateList($receiver, resolvedValue, project);
        if (stateList != null) {
            for (StateListState state : stateList.getStates()) {
                List<Color> stateColors = null;
                ResourceValue resolvedStateResource = $receiver.findResValue(state.getValue(), false);
                stateColors = resolvedStateResource != null ? ResourceHelper.resolveMultipleColors($receiver, resolvedStateResource, project, depth + 1) : CollectionsKt.listOfNotNull((Object)ResourceHelper.parseColor(state.getValue()));
                for (Color color : stateColors) {
                    try {
                        result2.add(ResourceHelper.makeColorWithAlpha($receiver, color, state.getAlpha()));
                    }
                    catch (NumberFormatException e) {
                        String string;
                        result2.add(color);
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string2 = ALPHA_FLOATING_ERROR_FORMAT;
                        Object[] objectArray = new Object[]{stateList.getDirName(), stateList.getFileName()};
                        Logger logger = LOG;
                        Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                        logger.warn(string);
                    }
                }
            }
        } else {
            Color color = ResourceHelper.parseColor(resolvedValue.getValue());
            if (color != null) {
                result2.add(color);
            }
        }
        return result2;
    }

    @NotNull
    public static final String resolveStringValue(@NotNull RenderResources $receiver, @NotNull String value2) {
        ResourceValue resourceValue2 = $receiver.findResValue(value2, false);
        if (resourceValue2 == null) {
            return value2;
        }
        ResourceValue resValue = resourceValue2;
        Object object = ResourceHelper.resolveNullableResValue($receiver, resValue);
        if (object == null || (object = object.getValue()) == null) {
            object = value2;
        }
        return object;
    }

    @Nullable
    public static final VirtualFile pickAnyLayoutFile(@NotNull AndroidFacet facet) {
        VirtualFile[] openFiles;
        VirtualFile[] virtualFileArray = openFiles = FileEditorManager.getInstance((Project)facet.getModule().getProject()).getOpenFiles();
        int n = virtualFileArray.length;
        for (int j = 0; j < n; ++j) {
            VirtualFile file = virtualFileArray[j];
            if (!StringsKt.endsWith$default((String)file.getName(), (String)".xml", (boolean)false, (int)2, null) || file.getParent() == null || !StringsKt.startsWith$default((String)file.getParent().getName(), (String)"layout", (boolean)false, (int)2, null)) continue;
            return file;
        }
        for (VirtualFile resourceDir : ResourceFolderManager.Companion.getInstance(facet).getFolders()) {
            for (VirtualFile folder : resourceDir.getChildren()) {
                if (!StringsKt.startsWith$default((String)folder.getName(), (String)"layout", (boolean)false, (int)2, null) || !folder.isDirectory()) continue;
                for (VirtualFile file : folder.getChildren()) {
                    if (!StringsKt.endsWith$default((String)file.getName(), (String)".xml", (boolean)false, (int)2, null) || file.getParent() == null || !StringsKt.startsWith$default((String)file.getParent().getName(), (String)"layout", (boolean)false, (int)2, null)) continue;
                    return file;
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final ResourceNamespace getResourceNamespace(@NotNull PsiElement $receiver) {
        OrderEntry it;
        boolean bl;
        Iterable $receiver$iv;
        List orderEntries;
        ResourceNamespace resourceNamespace;
        block8: {
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)$receiver.getProject());
            VirtualFile vFile = $receiver.getContainingFile().getOriginalFile().getVirtualFile();
            if ($receiver.getUserData(ModuleUtilCore.KEY_MODULE) != null || vFile != null && (projectFileIndex.isInSource(vFile) || projectFileIndex.getModuleForFile(vFile) != null)) {
                AndroidFacet androidFacet;
                AndroidFacet androidFacet2 = AndroidFacet.getInstance($receiver);
                Object object = androidFacet2;
                if (androidFacet2 == null) return null;
                AndroidFacet it2 = androidFacet = object;
                boolean bl2 = false;
                ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(it2);
                object = resourceRepositoryManager;
                if (resourceRepositoryManager == null) return null;
                resourceNamespace = ((ResourceRepositoryManager)object).getNamespace();
                return resourceNamespace;
            }
            VirtualFile virtualFile = vFile;
            if (virtualFile == null) return null;
            orderEntries = projectFileIndex.getOrderEntriesForFile(virtualFile);
            $receiver$iv = orderEntries;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (OrderEntry)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof JdkOrderEntry)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            resourceNamespace = ResourceNamespace.ANDROID;
            return resourceNamespace;
        } else {
            $receiver$iv = orderEntries;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return null;
            }
            Iterator iterator = $receiver$iv.iterator();
            do {
                Object element$iv;
                if (!iterator.hasNext()) return null;
                element$iv = iterator.next();
                it = (OrderEntry)element$iv;
                boolean bl4 = false;
            } while (!(it instanceof LibraryOrderEntry));
            boolean bl5 = true;
            if (!bl5) return null;
            resourceNamespace = ResourceNamespace.RES_AUTO;
        }
        return resourceNamespace;
    }

    @Nullable
    public static final ResourceNamespaceContext getNamespacesContext(@NotNull XmlElement element) {
        ResourceNamespace resourceNamespace = ResourceHelper.getResourceNamespace((PsiElement)element);
        if (resourceNamespace == null) {
            return null;
        }
        return new ResourceNamespaceContext(resourceNamespace, ResourceHelper.getNamespaceResolver(element));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ResourceValue resolve(@NotNull RenderResources $receiver, @NotNull ResourceUrl resourceUrl, @NotNull XmlElement element) {
        void namespace;
        ResourceNamespaceContext resourceNamespaceContext = ResourceHelper.getNamespacesContext(element);
        if (resourceNamespaceContext == null) {
            return null;
        }
        ResourceNamespaceContext resourceNamespaceContext2 = resourceNamespaceContext;
        ResourceNamespace resourceNamespace = resourceNamespaceContext2.component1();
        ResourceNamespace.Resolver namespaceResolver2 = resourceNamespaceContext2.component2();
        ResourceReference resourceReference = resourceUrl.resolve((ResourceNamespace)namespace, namespaceResolver2);
        if (resourceReference == null) {
            return null;
        }
        ResourceReference resourceReference2 = resourceReference;
        return $receiver.getUnresolvedResource(resourceReference2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ResourceNamespace resolveResourceNamespace(@NotNull XmlElement $receiver, @Nullable String prefix) {
        void namespace;
        ResourceNamespaceContext resourceNamespaceContext = ResourceHelper.getNamespacesContext($receiver);
        if (resourceNamespaceContext == null) {
            return null;
        }
        ResourceNamespaceContext resourceNamespaceContext2 = resourceNamespaceContext;
        ResourceNamespace resourceNamespace = resourceNamespaceContext2.component1();
        ResourceNamespace.Resolver namespaceResolver2 = resourceNamespaceContext2.component2();
        return ResourceNamespace.fromNamespacePrefix((String)prefix, (ResourceNamespace)namespace, (ResourceNamespace.Resolver)namespaceResolver2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ResourceReference resolve(@NotNull ResourceUrl $receiver, @NotNull XmlElement element) {
        void namespace;
        ResourceNamespaceContext resourceNamespaceContext = ResourceHelper.getNamespacesContext(element);
        if (resourceNamespaceContext == null) {
            return null;
        }
        ResourceNamespaceContext resourceNamespaceContext2 = resourceNamespaceContext;
        ResourceNamespace resourceNamespace = resourceNamespaceContext2.component1();
        ResourceNamespace.Resolver namespaceResolver2 = resourceNamespaceContext2.component2();
        return $receiver.resolve((ResourceNamespace)namespace, namespaceResolver2);
    }

    @NotNull
    public static final Color makeColorWithAlpha(@NotNull RenderResources $receiver, @NotNull Color color, @Nullable String alphaValue) throws NumberFormatException {
        float f;
        if (alphaValue != null) {
            String string = ResourceHelper.resolveStringValue($receiver, alphaValue);
            f = Float.parseFloat(string);
        } else {
            f = 1.0f;
        }
        float alpha = f;
        int combinedAlpha = (int)((float)color.getAlpha() * alpha);
        return ColorUtil.toAlpha((Color)color, (int)ResourceHelper.clamp(combinedAlpha, 0, 255));
    }

    @Nullable
    public static final StateList resolveStateList(@NotNull RenderResources $receiver, @NotNull ResourceValue value2, @NotNull Project project) {
        return ResourceHelper.resolveStateList($receiver, value2, project, 0);
    }

    private static final StateList resolveStateList(@NotNull RenderResources $receiver, ResourceValue resourceValue2, Project project, int depth) {
        if (depth >= 50) {
            LOG.warn("too deep " + resourceValue2);
            return null;
        }
        String string = resourceValue2.getValue();
        if (string == null) {
            return null;
        }
        String value2 = string;
        if (StringsKt.startsWith$default((String)value2, (String)"@", (boolean)false, (int)2, null)) {
            ResourceValue resourceValue3 = $receiver.findResValue(value2, resourceValue2.isFramework());
            if (resourceValue3 == null) {
                return null;
            }
            ResourceValue resValue = resourceValue3;
            return ResourceHelper.resolveStateList($receiver, resValue, project, depth + 1);
        }
        PathString pathString = ResourceHelper.toFileResourcePathString(value2);
        if (pathString == null || (pathString = FileExtensions.toVirtualFile$default(pathString, false, 1, null)) == null) {
            return null;
        }
        PathString virtualFile = pathString;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, (VirtualFile)virtualFile);
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psiFile2 = xmlFile;
        boolean $i$f$runReadAction = false;
        return (StateList)ApplicationManager.getApplication().runReadAction(new Computable<T>(psiFile2, resourceValue2){
            final /* synthetic */ XmlFile $psiFile$inlined;
            final /* synthetic */ ResourceValue $resourceValue$inlined;
            {
                this.$psiFile$inlined = xmlFile;
                this.$resourceValue$inlined = resourceValue2;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                T t;
                XmlTag rootTag;
                boolean bl = false;
                XmlTag xmlTag = rootTag = this.$psiFile$inlined.getRootTag();
                if (Intrinsics.areEqual((Object)"selector", (Object)(xmlTag != null ? xmlTag.getName() : null))) {
                    void var3_3;
                    StateList stateList = new StateList(this.$psiFile$inlined.getName(), this.$psiFile$inlined.getContainingDirectory().getName());
                    for (XmlTag subTag : rootTag.findSubTags("item")) {
                        StateListState stateListState;
                        if (ResourceHelper.access$createStateListState(subTag, this.$resourceValue$inlined.isFramework()) == null) continue;
                        StateListState stateListState2 = stateListState;
                        boolean bl2 = false;
                        stateList.addState(stateListState2);
                    }
                    t = var3_3;
                } else {
                    t = null;
                }
                return t;
            }
        });
    }

    private static final StateListState createStateListState(XmlTag tag, boolean isFramework) {
        StateListState stateListState;
        XmlAttribute[] attributes;
        String stateValue = null;
        String alphaValue = null;
        HashMap stateAttributes = new HashMap();
        for (XmlAttribute attr : attributes = tag.getAttributes()) {
            ResourceUrl url;
            String value2;
            String name = attr.getLocalName();
            if (attr.getValue() == null) {
                continue;
            }
            if (Intrinsics.areEqual((Object)"color", (Object)name) || Intrinsics.areEqual((Object)"drawable", (Object)name)) {
                url = ResourceUrl.parse((String)value2, (boolean)isFramework);
                Object object = url;
                if (object == null || (object = object.toString()) == null) {
                    object = value2;
                }
                stateValue = object;
                continue;
            }
            if (Intrinsics.areEqual((Object)"alpha", (Object)name)) {
                url = ResourceUrl.parse((String)value2, (boolean)isFramework);
                Object object = url;
                if (object == null || (object = object.toString()) == null) {
                    object = value2;
                }
                alphaValue = object;
                continue;
            }
            if (!StringsKt.startsWith$default((String)name, (String)"state_", (boolean)false, (int)2, null)) continue;
            Map map2 = stateAttributes;
            Object object = value2;
            object = Boolean.parseBoolean((String)object);
            map2.put(name, object);
        }
        String string = stateValue;
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            stateListState = new StateListState(stateValue, stateAttributes, alphaValue);
        } else {
            stateListState = null;
        }
        return stateListState;
    }

    @Nullable
    public static final Color parseColor(@Nullable String s) {
        CharSequence charSequence;
        String string;
        block13: {
            block12: {
                string = s;
                if (string == null) break block12;
                charSequence = string;
                String string2 = charSequence;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (string != null) break block13;
            }
            return null;
        }
        String trimmed = string;
        charSequence = trimmed;
        if (charSequence.length() == 0) {
            return null;
        }
        if (trimmed.charAt(0) == '#') {
            String string3 = trimmed;
            int n = 1;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            Long l = StringsKt.toLongOrNull((String)string5, (int)16);
            if (l == null) {
                return null;
            }
            long longColor = l;
            if (trimmed.length() == 4 || trimmed.length() == 5) {
                long a = trimmed.length() == 4 ? 255L : ResourceHelper.extend((longColor & 0xF000L) >> 12);
                long r = ResourceHelper.extend((longColor & 0xF00L) >> 8);
                long g = ResourceHelper.extend((longColor & 0xF0L) >> 4);
                long b = ResourceHelper.extend(longColor & 0xFL);
                longColor = a << 24 | r << 16 | g << 8 | b;
                return new Color((int)longColor, true);
            }
            if (trimmed.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (trimmed.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    @NotNull
    public static final String colorToString(@NotNull Color color) {
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "#%08X";
            Object[] objectArray = new Object[]{longColor |= (long)color.getAlpha() << 24};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "#%06X";
        Object[] objectArray = new Object[]{longColor};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    private static final long extend(long nibble) {
        return nibble | nibble << 4;
    }

    @Nullable
    public static final VirtualFile resolveDrawable(@NotNull RenderResources $receiver, @Nullable ResourceValue drawable, @NotNull Project project) {
        List<StateListState> states;
        ResourceValue resourceValue2 = ResourceHelper.resolveNullableResValue($receiver, drawable);
        if (resourceValue2 == null) {
            return null;
        }
        ResourceValue resolvedDrawable = resourceValue2;
        String result2 = resolvedDrawable.getValue();
        StateList stateList = ResourceHelper.resolveStateList($receiver, resolvedDrawable, project);
        if (stateList != null && !(states = stateList.getStates()).isEmpty()) {
            StateListState state = states.get(states.size() - 1);
            result2 = state.getValue();
        }
        if (result2 == null) {
            return null;
        }
        PathString pathString = ResourceHelper.toFileResourcePathString(result2);
        return pathString != null ? FileExtensions.toVirtualFile$default(pathString, false, 1, null) : null;
    }

    @Nullable
    public static final VirtualFile resolveLayout(@NotNull RenderResources $receiver, @Nullable ResourceValue layout2) {
        ResourceValue resourceValue2 = ResourceHelper.resolveNullableResValue($receiver, layout2);
        if (resourceValue2 == null) {
            return null;
        }
        ResourceValue resolvedLayout = resourceValue2;
        String value2 = resolvedLayout.getValue();
        for (int depth = 0; value2 != null && depth < 50; ++depth) {
            if (DataBindingUtil.isBindingExpression(value2)) {
                String string = DataBindingUtil.getBindingExprDefault(value2);
                if (string == null) {
                    return null;
                }
                value2 = string;
            }
            if (StringsKt.startsWith$default((String)value2, (String)"@", (boolean)false, (int)2, null)) {
                if ($receiver.findResValue(value2, resolvedLayout.isFramework()) == null) break;
            } else {
                PathString pathString = ResourceHelper.toFileResourcePathString(value2);
                return pathString != null ? FileExtensions.toVirtualFile$default(pathString, false, 1, null) : null;
            }
            value2 = resolvedLayout.getValue();
        }
        return null;
    }

    @Nullable
    public static final PathString toFileResourcePathString(@NotNull String resourcePath) {
        for (String protocol : RESOURCE_PROTOCOLS) {
            String string;
            if (!StringsKt.startsWith$default((String)resourcePath, (String)protocol, (boolean)false, (int)2, null) || resourcePath.length() <= protocol.length() || resourcePath.charAt(protocol.length()) != ':') continue;
            int prefixLength = protocol.length() + 1;
            if (StringsKt.startsWith$default((String)resourcePath, (String)"//", (int)prefixLength, (boolean)false, (int)4, null)) {
                prefixLength += "//".length();
            }
            String string2 = resourcePath;
            String string3 = protocol;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(prefixLength);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string = string5;
            String string7 = string3;
            return new PathString(string7, string6);
        }
        File file = new File(resourcePath);
        return file.isFile() ? PathStringUtil.toPathString((File)file) : null;
    }

    public static final boolean isFileResource(@NotNull String candidatePath) {
        return StringsKt.startsWith$default((String)candidatePath, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)candidatePath, (String)"apk:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)candidatePath, (String)"jar:", (boolean)false, (int)2, null) || new File(candidatePath).isFile();
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public static final String prependResourcePrefix(@Nullable Module module, @Nullable String name, @Nullable ResourceFolderType folderType) {
        if (module == null) {
            return name;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet == null) {
            return name;
        }
        AndroidFacet facet = androidFacet;
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        if (androidModuleModel == null) {
            return name;
        }
        AndroidModuleModel androidModel = androidModuleModel;
        String string = Lint.computeResourcePrefix((AndroidProject)((AndroidProject)androidModel.getAndroidProject()));
        if (string == null) {
            return name;
        }
        String resourcePrefix = string;
        return name != null ? (StringsKt.startsWith$default((String)name, (String)resourcePrefix, (boolean)false, (int)2, null) ? name : Lint.computeResourceName((String)resourcePrefix, (String)name, (ResourceFolderType)folderType)) : resourcePrefix;
    }

    public static final int clamp(int i2, int min, int max) {
        return Math.max(min, Math.min(i2, max));
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getCompletionFromTypes(@NotNull AndroidFacet facet, @NotNull Set<? extends ResourceType> completionTypes, boolean sort) {
        EnumSet types = Sets.newEnumSet((Iterable)completionTypes, ResourceType.class);
        if (types.contains(ResourceType.MIPMAP)) {
            types.add(ResourceType.DRAWABLE);
        } else if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.MIPMAP);
        }
        boolean completionTypesContainsColor = types.contains(ResourceType.COLOR);
        if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.COLOR);
        }
        ResourceRepositoryManager repoManager = ResourceRepositoryManager.getInstance(facet);
        LocalResourceRepository appResources = repoManager.getAppResources();
        ResourceRepository frameworkResources = repoManager.getFrameworkResources(false);
        ArrayList resources = new ArrayList(500);
        for (ResourceType type : types) {
            boolean includeFileResources;
            boolean bl = includeFileResources = type != ResourceType.COLOR || completionTypesContainsColor;
            if (frameworkResources != null) {
                ResourceHelper.addFrameworkItems(resources, type, includeFileResources, frameworkResources);
            }
            ResourceHelper.addProjectItems(resources, type, includeFileResources, appResources, repoManager.getResourceVisibility());
        }
        if (sort) {
            List list = resources;
            Object object = getCompletionFromTypes.1.INSTANCE;
            if (object != null) {
                Function2 function2 = object;
                object = new ResourceHelper$sam$java_util_Comparator$0(function2);
            }
            CollectionsKt.sortWith((List)list, (Comparator)((Comparator)object));
        }
        return resources;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ List getCompletionFromTypes$default(AndroidFacet androidFacet, Set set, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ResourceHelper.getCompletionFromTypes(androidFacet, set, bl);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getCompletionFromTypes(@NotNull AndroidFacet facet, @NotNull Set<? extends ResourceType> completionTypes) {
        return ResourceHelper.getCompletionFromTypes$default(facet, completionTypes, false, 4, null);
    }

    @NotNull
    public static final Set<String> findIdsInFile(@NotNull PsiFile file) {
        HashSet ids = new HashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(ids){
            final /* synthetic */ HashSet $ids;

            public void visitElement(@NotNull PsiElement element) {
                String id;
                CharSequence charSequence;
                super.visitElement(element);
                if (element instanceof XmlTag && !((charSequence = (CharSequence)(id = Lint.stripIdPrefix((String)((XmlTag)element).getAttributeValue("id", "http://schemas.android.com/apk/res/android")))).length() == 0)) {
                    this.$ids.add(id);
                }
            }
            {
                this.$ids = $captured_local_variable$0;
            }
        });
        return ids;
    }

    public static final int compareResourceReferences(@NotNull String resource1, @NotNull String resource2) {
        int framework1 = StringsKt.startsWith$default((String)resource1, (String)"@android:", (boolean)false, (int)2, null) ? 1 : 0;
        int framework2 = StringsKt.startsWith$default((String)resource2, (String)"@android:", (boolean)false, (int)2, null) ? 1 : 0;
        int delta = framework1 - framework2;
        return delta != 0 ? delta : StringsKt.compareTo((String)resource1, (String)resource2, (boolean)true);
    }

    private static final void addFrameworkItems(List<String> destination, ResourceType type, boolean includeFileResources, ResourceRepository frameworkResources) {
        Collection items2 = frameworkResources.getPublicResources(ResourceNamespace.ANDROID, type);
        for (ResourceItem item : items2) {
            if (!includeFileResources) {
                String dirName;
                PathString pathString = item.getSource();
                String string = dirName = pathString != null ? pathString.getParentFileName() : null;
                if (dirName != null && !StringsKt.startsWith$default((String)dirName, (String)"values", (boolean)false, (int)2, null)) continue;
            }
            destination.add("@android:" + type.getName() + "/" + item.getName());
        }
    }

    private static final void addProjectItems(List<String> destination, ResourceType type, boolean includeFileResources, LocalResourceRepository repository, ResourceVisibilityLookup lookup) {
        ResourceNamespace namespace = ResourceNamespace.TODO();
        for (Map.Entry entry : repository.getResources(namespace, type).asMap().entrySet()) {
            String resourceName = (String)entry.getKey();
            if (lookup != null && lookup.isPrivate(type, resourceName)) continue;
            Collection items2 = (Collection)entry.getValue();
            if (!includeFileResources) {
                ResourceItem resourceItem = (ResourceItem)Iterables.getFirst((Iterable)items2, null);
                if (resourceItem != null) {
                    if (resourceItem.isFileBased()) {
                        continue;
                    }
                }
            }
            destination.add("@" + type.getName() + '/' + resourceName);
        }
    }

    @NotNull
    public static final ResourceNamespace.Resolver getNamespaceResolver(@NotNull XmlElement element) {
        Function1<Function1<? super XmlTag, ? extends String>, String> withTag$ = new Function1<Function1<? super XmlTag, ? extends String>, String>(element){
            final /* synthetic */ XmlElement $element;

            @Nullable
            public final String invoke(@NotNull Function1<? super XmlTag, String> compute) {
                return (String)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(this, compute){
                    final /* synthetic */ getNamespaceResolver.1 this$0;
                    final /* synthetic */ Function1 $compute;

                    public final String compute() {
                        String string;
                        if (!this.this$0.$element.isValid()) {
                            string = null;
                        } else {
                            String string2;
                            XmlTag xmlTag;
                            XmlTag tag;
                            XmlTag xmlTag2 = tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)this.this$0.$element), XmlTag.class, (boolean)false);
                            if (xmlTag2 != null) {
                                xmlTag = xmlTag2;
                                Function1 function1 = this.$compute;
                                string2 = (String)function1.invoke((Object)xmlTag);
                            } else {
                                string2 = null;
                            }
                            XmlTag p1 = xmlTag = string2;
                            boolean bl = false;
                            string = StringUtil.nullize((String)p1);
                        }
                        return string;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$compute = function1;
                    }
                }));
            }
            {
                this.$element = xmlElement;
                super(1);
            }
        };
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance((PsiElement)element);
        if (resourceRepositoryManager == null) {
            return ResourceNamespace.Resolver.EMPTY_RESOLVER;
        }
        ResourceRepositoryManager repositoryManager = resourceRepositoryManager;
        return repositoryManager.getNamespacing() == AaptOptions.Namespacing.DISABLED ? ResourceNamespace.Resolver.TOOLS_ONLY : (ResourceNamespace.Resolver)new ResourceNamespace.Resolver(withTag$){
            final /* synthetic */ getNamespaceResolver.1 $withTag$1;

            @Nullable
            public String uriToPrefix(@NotNull String namespaceUri) {
                return this.$withTag$1.invoke((Function1<? super XmlTag, String>)((Function1)new Function1<XmlTag, String>(namespaceUri){
                    final /* synthetic */ String $namespaceUri;

                    @Nullable
                    public final String invoke(@NotNull XmlTag tag) {
                        return tag.getPrefixByNamespace(this.$namespaceUri);
                    }
                    {
                        this.$namespaceUri = string;
                        super(1);
                    }
                }));
            }

            @Nullable
            public String prefixToUri(@NotNull String namespacePrefix) {
                return this.$withTag$1.invoke((Function1<? super XmlTag, String>)((Function1)new Function1<XmlTag, String>(namespacePrefix){
                    final /* synthetic */ String $namespacePrefix;

                    @Nullable
                    public final String invoke(@NotNull XmlTag tag) {
                        return StringKt.nullize$default((String)tag.getNamespaceByPrefix(this.$namespacePrefix), (boolean)false, (int)1, null);
                    }
                    {
                        this.$namespacePrefix = string;
                        super(1);
                    }
                }));
            }
            {
                this.$withTag$1 = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final String getTextContent(@NotNull XmlTag tag) {
        XmlTag[] subTags = tag.getSubTags();
        XmlText[] textElements = tag.getValue().getTextElements();
        XmlTag[] xmlTagArray = subTags;
        if (xmlTagArray.length == 0) {
            if (textElements.length == 1) {
                return ResourceHelper.getXmlTextValue(textElements[0]);
            }
            xmlTagArray = textElements;
            if (xmlTagArray.length == 0) {
                return "";
            }
        }
        StringBuilder sb = new StringBuilder(40);
        ResourceHelper.appendText(sb, tag);
        return sb.toString();
    }

    private static final String getXmlTextValue(XmlText element) {
        PsiElement[] children;
        PsiElement psiElement = element.getFirstChild();
        if (psiElement == null) {
            return element.getText();
        }
        PsiElement current = psiElement;
        if (current.getNextSibling() != null) {
            StringBuilder sb = new StringBuilder();
            while (true) {
                IElementType type;
                if ((type = current.getNode().getElementType()) == XmlElementType.XML_CDATA) {
                    PsiElement[] children2 = current.getChildren();
                    if (children2.length == 3) {
                        boolean bl;
                        boolean bl2 = bl = children2[1].getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        sb.append(children2[1].getText());
                    }
                    if (current.getNextSibling() != null) continue;
                    break;
                }
                sb.append(current.getText());
                if (current.getNextSibling() != null) continue;
                break;
            }
            return sb.toString();
        }
        if (current.getNode().getElementType() == XmlElementType.XML_CDATA && (children = current.getChildren()).length == 3) {
            boolean bl;
            boolean bl3 = bl = children[1].getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return children[1].getText();
        }
        return element.getText();
    }

    private static final void appendText(StringBuilder sb, XmlTag tag) {
        PsiElement[] children;
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof XmlText) {
                sb.append(ResourceHelper.getXmlTextValue((XmlText)child));
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            if (Intrinsics.areEqual((Object)"g", (Object)((XmlTag)child).getLocalName()) && StringsKt.startsWith$default((String)((XmlTag)child).getNamespace(), (String)"urn:oasis:names:tc:xliff:document:", (boolean)false, (int)2, null)) {
                String example = ((XmlTag)child).getAttributeValue("example");
                if (example != null) {
                    sb.append('(').append(example).append(')');
                    continue;
                }
                String id = ((XmlTag)child).getAttributeValue("id");
                if (id != null) {
                    sb.append('$').append('{').append(id).append('}');
                    continue;
                }
            }
            ResourceHelper.appendText(sb, (XmlTag)child);
        }
    }

    @Contract(value="null -> null")
    private static final ResourceValue resolveNullableResValue(@NotNull RenderResources $receiver, ResourceValue res) {
        if (res == null) {
            return null;
        }
        return $receiver.resolveResValue(res);
    }

    public static final int buildResourceId(byte packageId, byte typeId, short entryId) {
        return packageId << 24 | typeId << 16 | entryId & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<String> getResourceItems(@NotNull ResourceRepository $receiver, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull ResourceVisibilityLookup visibilityLookup, @NotNull ResourceVisibility minVisibility) {
        Collection collection;
        Preconditions.checkArgument((minVisibility != ResourceVisibility.UNDEFINED ? 1 : 0) != 0);
        if ($receiver instanceof AarResourceRepository) {
            void $receiver$iv;
            List items2 = $receiver.getResources(namespace, type, (Predicate)new Predicate<ResourceItem>(minVisibility){
                final /* synthetic */ ResourceVisibility $minVisibility;

                public final boolean test(ResourceItem item) {
                    ResourceItem resourceItem = item;
                    if (resourceItem == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.resources.ResourceItemWithVisibility");
                    }
                    return ((ResourceItemWithVisibility)resourceItem).getVisibility().compareTo((Enum)this.$minVisibility) >= 0;
                }
                {
                    this.$minVisibility = resourceVisibility;
                }
            });
            Iterable iterable = items2;
            Collection destination$iv = new HashSet(items2.size());
            for (Object item$iv : $receiver$iv) {
                void p1;
                ResourceItem resourceItem = (ResourceItem)item$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                String string = p1.getName();
                collection2.add(string);
            }
            collection = destination$iv;
        } else {
            List items3 = $receiver.getResources(namespace, type, (Predicate)new Predicate<ResourceItem>(minVisibility, visibilityLookup, type){
                final /* synthetic */ ResourceVisibility $minVisibility;
                final /* synthetic */ ResourceVisibilityLookup $visibilityLookup;
                final /* synthetic */ ResourceType $type;

                public final boolean test(ResourceItem item) {
                    return this.$minVisibility == ResourceVisibility.values()[0] ? true : (item instanceof ResourceItemWithVisibility ? ((ResourceItemWithVisibility)item).getVisibility().compareTo((Enum)this.$minVisibility) >= 0 : this.$minVisibility != ResourceVisibility.PUBLIC || !this.$visibilityLookup.isPrivate(this.$type, item.getName()));
                }
                {
                    this.$minVisibility = resourceVisibility;
                    this.$visibilityLookup = resourceVisibilityLookup;
                    this.$type = resourceType;
                }
            });
            Iterable $receiver$iv = items3;
            Collection destination$iv = new HashSet(items3.size());
            for (Object item$iv : $receiver$iv) {
                ResourceItem p1 = (ResourceItem)item$iv;
                Collection collection3 = destination$iv;
                boolean bl = false;
                String string = p1.getName();
                collection3.add(string);
            }
            collection = destination$iv;
        }
        return collection;
    }

    public static final boolean isAccessibleInXml(@NotNull ResourceItem $receiver, @NotNull AndroidFacet facet) {
        return ResourceHelper.isAccessible($receiver.getNamespace(), $receiver.getType(), $receiver.getName(), facet);
    }

    public static final boolean isAccessibleInXml(@NotNull ResourceValue $receiver, @NotNull AndroidFacet facet) {
        return ResourceHelper.isAccessible($receiver.getNamespace(), $receiver.getResourceType(), $receiver.getName(), facet);
    }

    public static final boolean isAccessibleInCode(@NotNull ResourceItem $receiver, @NotNull AndroidFacet facet) {
        return ResourceHelper.isAccessibleInXml($receiver, facet);
    }

    public static final boolean isAccessibleInCode(@NotNull ResourceValue $receiver, @NotNull AndroidFacet facet) {
        return ResourceHelper.isAccessibleInXml($receiver, facet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAccessible(ResourceNamespace namespace, ResourceType type, String name, AndroidFacet facet) {
        ResourceRepositoryManager repoManager = ResourceRepositoryManager.getInstance(facet);
        if (Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID)) {
            ResourceRepository resourceRepository = repoManager.getFrameworkResources(false);
            if (resourceRepository == null) return false;
            ResourceRepository repo = resourceRepository;
            List items2 = repo.getResources(ResourceNamespace.ANDROID, type, name);
            Collection collection = items2;
            if (collection.isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            Object e = items2.get(0);
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.resources.ResourceItemWithVisibility");
            }
            if (((ResourceItemWithVisibility)e).getVisibility() != ResourceVisibility.PUBLIC) return false;
            return true;
        }
        if (repoManager.getResourceVisibility().isPrivate(type, name)) return false;
        return true;
    }

    public static final /* synthetic */ StateListState access$createStateListState(XmlTag tag, boolean isFramework) {
        return ResourceHelper.createStateListState(tag, isFramework);
    }
}

