/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.projectmodel.ExternalLibrary;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.res.AarResourceRepositoryCache;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.TestAppResourceRepository;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceRepositoryManager
implements Disposable {
    private static final Key<ResourceRepositoryManager> KEY = Key.create((String)ResourceRepositoryManager.class.getName());
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static final Object TEST_APP_RESOURCES_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final AaptOptions.Namespacing myNamespacing;
    @Nullable
    private ResourceNamespace myCachedNamespace;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private LocalResourceRepository myModuleResources;
    private LocalResourceRepository myTestAppResources;
    private Map<ExternalLibrary, AarResourceRepository> myLibraryResourceMap;
    @Nullable
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private final Object myLibraryLock = new Object();

    @NotNull
    public static ResourceRepositoryManager getInstance(@NotNull AndroidFacet facet) {
        ResourceRepositoryManager manager;
        AaptOptions.Namespacing namespacing = AndroidProjectModelUtils.getNamespacing(facet);
        ResourceRepositoryManager instance = (ResourceRepositoryManager)facet.getUserData(KEY);
        if (instance != null && instance.myNamespacing != namespacing) {
            if (facet.replace(KEY, instance, null)) {
                Disposer.dispose((Disposable)instance);
            }
            instance = null;
        }
        if (instance == null && (instance = (ResourceRepositoryManager)facet.putUserDataIfAbsent(KEY, manager = new ResourceRepositoryManager(facet, namespacing))) == manager) {
            Disposer.register((Disposable)facet, (Disposable)instance);
            AndroidProjectRootListener.ensureSubscribed(facet.getModule().getProject());
        }
        return instance;
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet == null ? null : ResourceRepositoryManager.getInstance(facet);
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        return ResourceRepositoryManager.getInstance(facet);
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getAppResources(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? ResourceRepositoryManager.getAppResources(facet) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getAppResources(@NotNull AndroidFacet facet) {
        return ResourceRepositoryManager.getInstance(facet).getAppResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getProjectResources(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? ResourceRepositoryManager.getProjectResources(facet) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getProjectResources(@NotNull AndroidFacet facet) {
        return ResourceRepositoryManager.getInstance(facet).getProjectResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? ResourceRepositoryManager.getModuleResources(facet) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet) {
        return ResourceRepositoryManager.getInstance(facet).getModuleResources();
    }

    private ResourceRepositoryManager(@NotNull AndroidFacet facet, @NotNull AaptOptions.Namespacing namespacing) {
        this.myFacet = facet;
        this.myNamespacing = namespacing;
    }

    public static boolean testAndClearTempResourceCached(@NotNull Project project) {
        if (project.getUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE) != Boolean.TRUE) {
            return false;
        }
        project.putUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE, null);
        return true;
    }

    @NotNull
    public static Collection<Library> findAarLibraries(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel;
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (facet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            ResourceRepositoryManager.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                ResourceRepositoryManager.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        return libraries;
    }

    private static void addGradleLibraries(@NotNull List<Library> list, @NotNull AndroidModuleModel androidModuleModel) {
        list.addAll(androidModuleModel.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries());
    }

    @Slow
    @NotNull
    public LocalResourceRepository getAppResources() {
        LocalResourceRepository appResources = this.getExistingAppResources();
        if (appResources != null) {
            return appResources;
        }
        this.getLibraryResources();
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myAppResources = AppResourceRepository.create(this.myFacet, this.getLibraryResources());
                    Disposer.register((Disposable)this, (Disposable)this.myAppResources);
                }
                return this.myAppResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingAppResources() {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            return this.myAppResources;
        }
    }

    @Slow
    @NotNull
    public LocalResourceRepository getProjectResources() {
        LocalResourceRepository projectResources = this.getExistingProjectResources();
        if (projectResources != null) {
            return projectResources;
        }
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = PROJECT_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myProjectResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myProjectResources = ProjectResourceRepository.create(this.myFacet);
                    Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
                }
                return this.myProjectResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingProjectResources() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            return this.myProjectResources;
        }
    }

    @Slow
    @NotNull
    public LocalResourceRepository getModuleResources() {
        LocalResourceRepository moduleResources = this.getExistingModuleResources();
        if (moduleResources != null) {
            return moduleResources;
        }
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myModuleResources = ModuleResourceRepository.forMainResources(this.myFacet, this.getNamespace());
                    Disposer.register((Disposable)this, (Disposable)this.myModuleResources);
                }
                return this.myModuleResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getExistingModuleResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            return this.myModuleResources;
        }
    }

    @NotNull
    public LocalResourceRepository getTestAppResources() {
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestAppResources = this.computeTestAppResources();
                    Disposer.register((Disposable)this, (Disposable)this.myTestAppResources);
                }
                return this.myTestAppResources;
            }
        }));
    }

    @NotNull
    private LocalResourceRepository computeTestAppResources() {
        LocalResourceRepository moduleTestResources = ModuleResourceRepository.forTestResources(this.myFacet, this.getTestNamespace());
        if (this.myNamespacing == AaptOptions.Namespacing.REQUIRED) {
            return moduleTestResources;
        }
        AndroidModuleModel model2 = AndroidModuleModel.get(this.myFacet);
        if (model2 == null) {
            return moduleTestResources;
        }
        TestAppResourceRepository testAppRepo = TestAppResourceRepository.create(this.myFacet, moduleTestResources, model2);
        Disposer.register((Disposable)testAppRepo, (Disposable)moduleTestResources);
        return testAppRepo;
    }

    @Slow
    @Nullable
    public ResourceRepository getFrameworkResources(boolean needLocales) {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (androidPlatform == null) {
            return null;
        }
        return androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget()).getFrameworkResources(needLocales);
    }

    @Slow
    @NotNull
    public List<ResourceRepository> getAppResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        AppResourceRepository appRepository = (AppResourceRepository)this.getAppResources();
        if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
            return ImmutableList.of((Object)((Object)appRepository));
        }
        return appRepository.getRepositoriesForNamespace(namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResources() {
        this.resetVisibility();
        this.resetLibraries();
        SampleDataResourceRepository.SampleDataRepositoryManager.getInstance(this.myFacet).reset();
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                Disposer.dispose((Disposable)this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
        object = TEST_APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myTestAppResources != null) {
                Disposer.dispose((Disposable)this.myTestAppResources);
                this.myTestAppResources = null;
            }
        }
    }

    public void dispose() {
    }

    public void resetAllCaches() {
        this.resetResources();
        ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getResolverCache().reset();
        ResourceFolderRegistry.getInstance(this.myFacet.getModule().getProject()).reset();
        AarResourceRepositoryCache.getInstance().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetVisibility() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myResourceVisibilityProvider = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLibraries() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myLibraryResourceMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRootsAndLibraries() {
        Map<ExternalLibrary, AarResourceRepository> oldLibraryResourceMap;
        this.resetVisibility();
        ProjectResourceRepository projectResources = (ProjectResourceRepository)this.getExistingProjectResources();
        AppResourceRepository appResources = (AppResourceRepository)this.getExistingAppResources();
        if (projectResources != null) {
            projectResources.updateRoots();
            if (appResources != null) {
                appResources.invalidateCache(projectResources);
            }
        }
        Object object = this.myLibraryLock;
        synchronized (object) {
            oldLibraryResourceMap = this.myLibraryResourceMap;
            this.myLibraryResourceMap = null;
        }
        if (appResources != null) {
            appResources.updateRoots(this.getLibraryResources());
        }
        if (oldLibraryResourceMap != null) {
            oldLibraryResourceMap.size();
        }
    }

    @NotNull
    public AaptOptions.Namespacing getNamespacing() {
        return this.myNamespacing;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String packageName = AndroidManifestUtils.getPackageName(this.myFacet);
        if (packageName == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.myCachedNamespace == null || !packageName.equals(this.myCachedNamespace.getPackageName())) {
            this.myCachedNamespace = ResourceNamespace.fromPackageName((String)packageName);
        }
        return this.myCachedNamespace;
    }

    @NotNull
    public ResourceNamespace getTestNamespace() {
        return ResourceNamespace.TODO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myResourceVisibilityProvider == null) {
                if (!this.myFacet.requiresAndroidModel() || ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getModel() == null) {
                    return null;
                }
                this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
            }
            return this.myResourceVisibilityProvider;
        }
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup.Provider provider;
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel != null && (provider = this.getResourceVisibilityProvider()) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            IdeVariant variant = androidModel.getSelectedVariant();
            return provider.get((AndroidProject)androidProject, (Variant)variant);
        }
        return ResourceVisibilityLookup.NONE;
    }

    @Slow
    @NotNull
    public Collection<VirtualFile> getAllResourceDirs() {
        return ((AppResourceRepository)this.getAppResources()).getAllResourceDirs();
    }

    @Nullable
    public AarResourceRepository findLibraryResources(@NotNull ExternalLibrary library) {
        return this.getLibraryResourceMap().get(library);
    }

    @Slow
    @NotNull
    public Collection<AarResourceRepository> getLibraryResources() {
        return this.getLibraryResourceMap().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<ExternalLibrary, AarResourceRepository> getLibraryResourceMap() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myLibraryResourceMap == null) {
                this.myLibraryResourceMap = this.computeLibraryResourceMap();
            }
            return this.myLibraryResourceMap;
        }
    }

    @NotNull
    private Map<ExternalLibrary, AarResourceRepository> computeLibraryResourceMap() {
        Collection<ExternalLibrary> libraries = AndroidProjectModelUtils.findDependenciesWithResources(this.myFacet.getModule()).values();
        AarResourceRepositoryCache aarResourceRepositoryCache = AarResourceRepositoryCache.getInstance();
        Function<ExternalLibrary, AarResourceRepository> factory = this.myNamespacing == AaptOptions.Namespacing.DISABLED ? aarResourceRepositoryCache::getSourceRepository : aarResourceRepositoryCache::getProtoRepository;
        int maxThreads = ForkJoinPool.getCommonPoolParallelism();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)ResourceRepositoryManager.class.getName(), (int)maxThreads);
        HashMap futures = Maps.newHashMapWithExpectedSize((int)libraries.size());
        for (ExternalLibrary library : libraries) {
            futures.put(library, executorService.submit(() -> (AarResourceRepository)factory.apply(library)));
        }
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                map2.put(entry.getKey(), ((Future)entry.getValue()).get());
            }
            catch (ExecutionException e) {
                ResourceRepositoryManager.cancelPendingTasks(futures.values());
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new UncheckedExecutionException(e.getCause());
            }
            catch (InterruptedException e) {
                ResourceRepositoryManager.cancelPendingTasks(futures.values());
                throw new ProcessCanceledException((Throwable)e);
            }
        }
        return map2.build();
    }

    private static void cancelPendingTasks(Collection<Future<AarResourceRepository>> futures) {
        futures.forEach(f -> f.cancel(true));
    }
}

