/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.android.augment.ResourceRepositoryInnerRClass;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRepositoryRClass
extends AndroidRClassBase {
    private static final Logger LOG = Logger.getInstance(ResourceRepositoryRClass.class);
    @NotNull
    protected final Module myModule;
    @NotNull
    private final ResourcesSource mySource;

    public ResourceRepositoryRClass(@NotNull PsiManager psiManager, @NotNull Module module, @NotNull ResourcesSource source) {
        super(psiManager, source.getPackageName());
        this.mySource = source;
        this.myModule = module;
        this.setModuleInfo(module, this.mySource.isForTest());
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    protected PsiClass[] doGetInnerClasses() {
        if (DumbService.isDumb((Project)this.getProject())) {
            LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            return PsiClass.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet == null) {
            LOG.debug("R_CLASS_AUGMENT: empty because no facet");
            return PsiClass.EMPTY_ARRAY;
        }
        Set<ResourceType> types = this.mySource.getResourceRepository().getResourceTypes(this.mySource.getResourceNamespace());
        ArrayList<ResourceRepositoryInnerRClass> result2 = new ArrayList<ResourceRepositoryInnerRClass>();
        for (ResourceType type : types) {
            if (!type.getHasInnerClass()) continue;
            result2.add(new ResourceRepositoryInnerRClass(facet, type, this.mySource, this));
        }
        LOG.debug("R_CLASS_AUGMENT: " + result2.size() + " classes added");
        return result2.toArray(PsiClass.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    protected Object[] getInnerClassesDependencies() {
        return new Object[]{this.mySource.getResourceRepository()};
    }

    @Nullable
    public String getQualifiedName() {
        String packageName = this.mySource.getPackageName();
        return packageName == null ? "R" : packageName + "." + "R";
    }

    public static interface ResourcesSource {
        @Nullable
        public String getPackageName();

        @NotNull
        public LocalResourceRepository getResourceRepository();

        @NotNull
        public ResourceNamespace getResourceNamespace();

        default public boolean isForTest() {
            return false;
        }
    }
}

