/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataListener;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.sampledata.datasource.CombinerDataSource;
import com.android.tools.idea.sampledata.datasource.DateTimeGenerator;
import com.android.tools.idea.sampledata.datasource.LoremIpsumGenerator;
import com.android.tools.idea.sampledata.datasource.NumberGenerator;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleDataResourceRepository
extends MultiResourceRepository {
    public static final ResourceNamespace PREDEFINED_SAMPLES_NS = ResourceNamespace.TOOLS;
    private static final ImmutableList<SampleDataResourceItem> PREDEFINED_SOURCES = ImmutableList.of((Object)SampleDataResourceItem.getFromStaticDataSource("full_names", new CombinerDataSource(SampleDataResourceRepository.getResourceAsStream("sampleData/names.txt"), SampleDataResourceRepository.getResourceAsStream("sampleData/surnames.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("first_names", ResourceContent.fromInputStream(SampleDataResourceRepository.getResourceAsStream("sampleData/names.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("last_names", ResourceContent.fromInputStream(SampleDataResourceRepository.getResourceAsStream("sampleData/surnames.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("cities", ResourceContent.fromInputStream(SampleDataResourceRepository.getResourceAsStream("sampleData/cities.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("us_zipcodes", new NumberGenerator("%05d", 20000, 99999), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("us_phones", new NumberGenerator("(800) 555-%04d", 0, 9999), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("lorem", new LoremIpsumGenerator(false), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("lorem/random", new LoremIpsumGenerator(true), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("avatars", ResourceContent.fromDirectory("avatars"), SampleDataResourceItem.ContentType.IMAGE), (Object)SampleDataResourceItem.getFromStaticDataSource("backgrounds/scenic", ResourceContent.fromDirectory("backgrounds/scenic"), SampleDataResourceItem.ContentType.IMAGE), (Object)SampleDataResourceItem.getFromStaticDataSource("date/day_of_week", new DateTimeGenerator(DateTimeFormatter.ofPattern("E"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("date/ddmmyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("dd-MM-yy"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), (Object[])new SampleDataResourceItem[]{SampleDataResourceItem.getFromStaticDataSource("date/mmddyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("MM-dd-yy"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource("date/hhmm", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm"), ChronoUnit.MINUTES), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource("date/hhmmss", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm:ss"), ChronoUnit.SECONDS), SampleDataResourceItem.ContentType.TEXT)});
    private final LeafRepository myUserItemsRepository;

    private static InputStream getResourceAsStream(@NotNull String name) {
        return SampleDataResourceRepository.class.getClassLoader().getResourceAsStream(name);
    }

    @NotNull
    public static SampleDataResourceRepository getInstance(@NotNull AndroidFacet facet) {
        return SampleDataRepositoryManager.getInstance(facet).getRepository();
    }

    private SampleDataResourceRepository(@NotNull AndroidFacet androidFacet) {
        super("SampleData");
        LeafRepository predefinedItemsRepository = new LeafRepository("Predefined SampleData", androidFacet, ResourceNamespace.TOOLS);
        Disposer.register((Disposable)this, (Disposable)predefinedItemsRepository);
        predefinedItemsRepository.addPredefinedItems();
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        this.myUserItemsRepository = new LeafRepository("User-defined SampleData", androidFacet, repositoryManager.getNamespace());
        Disposer.register((Disposable)this, (Disposable)this.myUserItemsRepository);
        this.myUserItemsRepository.loadItems();
        this.setChildren((List<? extends LocalResourceRepository>)ImmutableList.of((Object)((Object)predefinedItemsRepository), (Object)((Object)this.myUserItemsRepository)), (Collection<? extends AarResourceRepository>)ImmutableList.of());
        SampleDataListener.ensureSubscribed(androidFacet.getModule().getProject());
    }

    @Override
    public void addParent(@NotNull MultiResourceRepository parent) {
        AndroidFacet facet = this.myUserItemsRepository.myAndroidFacet;
        if (facet == null || facet.isDisposed()) {
            return;
        }
        super.addParent(parent);
    }

    void reload() {
        this.myUserItemsRepository.loadItems();
    }

    static class SampleDataRepositoryManager
    extends AndroidFacetScopedService {
        private static final Key<SampleDataRepositoryManager> KEY = Key.create((String)SampleDataRepositoryManager.class.getName());
        private final Object repositoryLock = new Object();
        @GuardedBy(value="repositoryLock")
        private SampleDataResourceRepository repository;

        @NotNull
        public static SampleDataRepositoryManager getInstance(@NotNull AndroidFacet facet) {
            SampleDataRepositoryManager manager = (SampleDataRepositoryManager)facet.getUserData(KEY);
            if (manager == null) {
                manager = new SampleDataRepositoryManager(facet);
                facet.putUserData(KEY, manager);
            }
            return manager;
        }

        private SampleDataRepositoryManager(@NotNull AndroidFacet facet) {
            super(facet);
        }

        @Override
        protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public SampleDataResourceRepository getRepository() {
            if (this.isDisposed()) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " is disposed");
            }
            Object object = this.repositoryLock;
            synchronized (object) {
                if (this.repository == null) {
                    this.repository = new SampleDataResourceRepository(this.getFacet());
                    Disposer.register((Disposable)this, (Disposable)this.repository);
                }
                return this.repository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasRepository() {
            Object object = this.repositoryLock;
            synchronized (object) {
                return this.repository != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            SampleDataResourceRepository localRepository;
            Object object = this.repositoryLock;
            synchronized (object) {
                localRepository = this.repository;
                this.repository = null;
            }
            if (localRepository != null) {
                Disposer.dispose((Disposable)localRepository);
            }
        }
    }

    private static class LeafRepository
    extends LocalResourceRepository
    implements SingleNamespaceResourceRepository {
        private final ResourceTable myFullTable = new ResourceTable();
        private final AndroidFacet myAndroidFacet;
        private final ResourceNamespace myNamespace;

        LeafRepository(@NotNull String displayName, @NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace) {
            super(displayName);
            this.myAndroidFacet = facet;
            this.myNamespace = namespace;
        }

        @Override
        @NotNull
        protected ResourceTable getFullTable() {
            return this.myFullTable;
        }

        @Override
        @Nullable
        protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
            ListMultimap multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type);
            if (multimap == null && create2) {
                multimap = ArrayListMultimap.create();
                this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
            }
            return multimap;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public String getPackageName() {
            return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myAndroidFacet);
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            return ImmutableSet.of();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadItems() {
            AndroidFacet facet = this.myAndroidFacet;
            if (facet == null || facet.isDisposed()) {
                return;
            }
            VirtualFile sampleDataDir = FileExtensions.toVirtualFile(ProjectSystemUtil.getModuleSystem(facet.getModule()).getSampleDataDirectory());
            this.myFullTable.clear();
            if (sampleDataDir != null) {
                ArrayList items2 = new ArrayList();
                PsiManager psiManager = PsiManager.getInstance((Project)facet.getModule().getProject());
                Stream<VirtualFile> childrenStream = Arrays.stream(sampleDataDir.getChildren());
                ApplicationManager.getApplication().runReadAction(() -> childrenStream.map(vf -> vf.isDirectory() ? psiManager.findDirectory(vf) : psiManager.findFile(vf)).filter(Objects::nonNull).forEach(f -> items2.addAll(this.loadItemsFromFile((PsiFileSystemItem)f))));
                if (!items2.isEmpty()) {
                    Object object = ITEM_MAP_LOCK;
                    synchronized (object) {
                        ListMultimap map2 = this.myFullTable.getOrPutEmpty(this.myNamespace, ResourceType.SAMPLE_DATA);
                        for (ResourceItem item : items2) {
                            assert (item.getNamespace().equals((Object)this.myNamespace));
                            map2.put((Object)item.getName(), (Object)item);
                        }
                    }
                }
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(this.getNamespace(), ResourceType.SAMPLE_DATA);
        }

        private List<SampleDataResourceItem> loadItemsFromFile(@NotNull PsiFileSystemItem sampleDataFile) {
            try {
                return SampleDataResourceItem.getFromPsiFileSystemItem(sampleDataFile, this.myNamespace);
            }
            catch (IOException e) {
                LOG.warn("Error loading sample data file " + sampleDataFile.getName(), (Throwable)e);
                return Collections.emptyList();
            }
        }

        private void addPredefinedItems() {
            ListMultimap cell = this.myFullTable.getOrPutEmpty(PREDEFINED_SAMPLES_NS, ResourceType.SAMPLE_DATA);
            PREDEFINED_SOURCES.forEach(source -> cell.put((Object)source.getName(), source));
        }
    }
}

