/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.resources.ResourceVisitor;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceNavigationItem;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class GoToAndroidResourceContributor
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, @NotNull Set<String> result2) {
        LocalResourceRepository resources = ResourceRepositoryManager.getModuleResources(module);
        if (resources != null) {
            resources.accept(item -> {
                result2.add(item.getName());
                return ResourceVisitor.VisitResult.CONTINUE;
            });
        }
    }

    protected void addItems(@NotNull Module module, @NotNull String name, @NotNull List<NavigationItem> result2) {
        LocalResourceRepository resources = ResourceRepositoryManager.getModuleResources(module);
        if (resources != null) {
            resources.accept(item -> {
                VirtualFile file;
                if (item.getName().equals(name) && (file = ResourceHelper.getSourceAsVirtualFile(item)) != null) {
                    result2.add(new ResourceNavigationItem(item, file, module.getProject()));
                }
                return ResourceVisitor.VisitResult.CONTINUE;
            });
        }
    }

    protected boolean acceptModule(@NotNull Module module) {
        return AndroidFacet.getInstance(module) != null;
    }
}

