/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResolvableResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.resources.aar.AarResourceItem;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElementWithRequiredName;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceManagerToPsiResolver
implements AndroidResourceToPsiResolver {
    @NotNull
    public static final ResourceManagerToPsiResolver INSTANCE = new ResourceManagerToPsiResolver();

    private ResourceManagerToPsiResolver() {
    }

    @Override
    @NotNull
    public ResolveResult[] resolveToPsi(@NotNull ResourceValue resourceValue2, @NotNull XmlElement element, @NotNull AndroidFacet facet) {
        ResourceManager manager;
        ResourceNamespace resolvedNamespace = ResourceHelper.resolveResourceNamespace(element, resourceValue2.getPackage());
        if (resolvedNamespace == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean attrReference = resourceValue2.getPrefix() == '?';
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        if (resourceValue2.getType() != null && resourceValue2.getResourceName() != null && (manager = ModuleResourceManagers.getInstance(facet).getResourceManager(resolvedNamespace.getPackageName(), (PsiElement)element)) != null) {
            manager.collectLazyResourceElements(resolvedNamespace, resourceValue2.getType().getName(), resourceValue2.getResourceName(), attrReference, (PsiElement)element, elements);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (elements.isEmpty() && resourceValue2.getResourceName() != null && resolvedNamespace != ResourceNamespace.ANDROID) {
            LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(facet.getModule());
            ResourceType resourceType = resourceValue2.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                XmlAttribute attribute;
                assert (resources != null);
                String resourceName = resourceValue2.getResourceName();
                if (resourceType == ResourceType.SAMPLE_DATA) {
                    resourceName = SampleDataManager.getResourceNameFromSampleReference((String)resourceName);
                }
                List<ResourceItem> items2 = resources.getResources(resolvedNamespace, resourceType, resourceName);
                if (FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                    for (ResourceItem item : items2) {
                        if (item instanceof ResolvableResourceItem) {
                            result2.add(((ResolvableResourceItem)item).createResolveResult());
                            continue;
                        }
                        if (item instanceof AarResourceItem) {
                            result2.add(new AarResourceResolveResult((AarResourceItem)item));
                            continue;
                        }
                        XmlTag tag = LocalResourceRepository.getItemTag(facet.getModule().getProject(), item);
                        if (tag == null) continue;
                        elements.add((PsiElement)tag);
                    }
                } else if (resourceType == ResourceType.SAMPLE_DATA && element.getParent() instanceof XmlAttribute && "http://schemas.android.com/tools".equals((attribute = (XmlAttribute)element.getParent()).getNamespace())) {
                    items2.stream().filter(SampleDataResourceItem.class::isInstance).forEach(sampleDataItem -> result2.add(((SampleDataResourceItem)sampleDataItem).createResolveResult()));
                }
            }
        }
        if (elements.size() > 1) {
            elements.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result2.add(new PsiElementResolveResult(target));
        }
        return result2.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PsiElement[] getXmlAttributeNameGotoDeclarationTargets(@NotNull String attributeName, @NotNull ResourceNamespace namespace, @NotNull PsiElement context, @NotNull AndroidFacet facet) {
        LocalResourceRepository repository;
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet);
        LocalResourceRepository localResourceRepository = repository = namespace.equals((Object)ResourceNamespace.ANDROID) ? repositoryManager.getFrameworkResources(false) : repositoryManager.getAppResources();
        if (repository == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<LazyValueResourceElementWrapper> elementList = new ArrayList<LazyValueResourceElementWrapper>();
        for (ResourceItem resourceItem : repository.getResources(namespace, ResourceType.ATTR, attributeName)) {
            VirtualFile file = FileExtensions.toVirtualFile(resourceItem.getSource());
            if (file == null) continue;
            elementList.add(new LazyValueResourceElementWrapper(new ValueResourceInfoImpl(resourceItem, file, facet.getModule().getProject()), context));
        }
        return elementList.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PsiElement[] getGotoDeclarationTargets(@NotNull AndroidResourceUtil.MyReferredResourceFieldInfo info, @NotNull PsiReferenceExpression refExpr) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)refExpr);
        if (facet == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        String nestedClassName = info.getClassName();
        String fieldName = info.getFieldName();
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        if (info.isFromManifest()) {
            ResourceManagerToPsiResolver.collectManifestElements(nestedClassName, fieldName, facet, resourceList);
        } else {
            ResourceManager manager;
            ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
            ResourceManager resourceManager = manager = info.getNamespace() == ResourceNamespace.ANDROID ? resourceManagers.getFrameworkResourceManager(false) : resourceManagers.getLocalResourceManager();
            if (manager == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            manager.collectLazyResourceElements(info.getNamespace(), nestedClassName, fieldName, false, (PsiElement)refExpr, resourceList);
            if (manager instanceof LocalResourceManager) {
                LocalResourceManager localManager = (LocalResourceManager)manager;
                if (nestedClassName.equals(ResourceType.ATTR.getName())) {
                    for (Attr attr : localManager.findAttrs(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                } else if (nestedClassName.equals(ResourceType.STYLEABLE.getName())) {
                    for (DeclareStyleable declareStyleable : localManager.findStyleables(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)declareStyleable.getName().getXmlAttributeValue());
                    }
                    for (Attr attr : localManager.findStyleableAttributesByFieldName(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                }
            }
        }
        if (resourceList.size() > 1) {
            resourceList.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        return resourceList.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static void collectManifestElements(@NotNull String nestedClassName, @NotNull String fieldName, @NotNull AndroidFacet facet, @NotNull List<PsiElement> result2) {
        List<ManifestElementWithRequiredName> list;
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return;
        }
        if ("permission".equals(nestedClassName)) {
            list = manifest.getPermissions();
        } else if ("permission_group".equals(nestedClassName)) {
            list = manifest.getPermissionGroups();
        } else {
            return;
        }
        for (ManifestElementWithRequiredName manifestElementWithRequiredName : list) {
            XmlAttributeValue psiElement;
            AndroidAttributeValue<String> nameAttribute = manifestElementWithRequiredName.getName();
            String unqualifiedName = StringUtil.getShortName((String)StringUtil.notNullize((String)((String)nameAttribute.getValue())));
            if (!AndroidUtils.equal(unqualifiedName, fieldName, false) || (psiElement = nameAttribute.getXmlAttributeValue()) == null) continue;
            result2.add((PsiElement)psiElement);
        }
    }

    private static class AarResourceResolveResult
    implements ResolveResult {
        @Nullable
        private final PsiElement myElement = null;

        AarResourceResolveResult(@NotNull AarResourceItem resourceItem) {
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        public boolean isValidResult() {
            return false;
        }
    }
}

