/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.utils.HashCodes;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceNavigationItem
implements NavigationItem {
    @NotNull
    private final ResourceItem myResource;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;

    public ResourceNavigationItem(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file, @NotNull Project project) {
        this.myResource = resourceItem;
        this.myFile = file;
        this.myProject = project;
    }

    @NotNull
    public String getName() {
        return this.myResource.getName();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ResourceItemPresentation(this.myResource, this.myFile);
    }

    public void navigate(boolean requestFocus) {
        NavigationItem target = this.getNavigationTarget();
        if (target != null) {
            target.navigate(requestFocus);
        }
    }

    @Nullable
    private NavigationItem getNavigationTarget() {
        if (this.myResource.isFileBased()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        }
        if (this.myResource.getType() == ResourceType.ID) {
            XmlAttribute xmlAttribute = AndroidResourceUtil.getIdDeclarationAttribute(this.myProject, this.myResource);
            return xmlAttribute == null ? null : (NavigationItem)xmlAttribute.getValueElement();
        }
        return (NavigationItem)new ValueResourceInfoImpl(this.myResource, this.myFile, this.myProject).computeXmlElement();
    }

    public boolean canNavigate() {
        NavigationItem target = this.getNavigationTarget();
        return target != null && target.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem target = this.getNavigationTarget();
        return target != null && target.canNavigateToSource();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceNavigationItem item = (ResourceNavigationItem)o;
        return this.myResource.equals(item.myResource) && this.myFile.equals(item.myFile) && this.myProject.equals(item.myProject);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myResource.hashCode(), (int)this.myFile.hashCode(), (int)this.myProject.hashCode());
    }

    public static class ResourceItemPresentation
    implements ItemPresentation {
        @NotNull
        private final ResourceItem myResource;
        @NotNull
        private final VirtualFile myFile;

        public ResourceItemPresentation(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file) {
            this.myResource = resourceItem;
            this.myFile = file;
        }

        @NotNull
        public String getPresentableText() {
            VirtualFile parentDir = this.myFile.getParent();
            if (parentDir == null) {
                return this.myResource.getName();
            }
            if (this.myResource.isFileBased()) {
                return this.myResource.getName() + " (" + parentDir.getName() + ')';
            }
            return this.myResource.getName() + " (..." + File.separatorChar + parentDir.getName() + File.separatorChar + this.myFile.getName() + ')';
        }

        @Nullable
        public String getLocationString() {
            return null;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return null;
        }
    }
}

