/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AarArrayResourceItem
extends AbstractAarValueResourceItem
implements ArrayResourceValue {
    @NotNull
    private final List<String> myElements;

    public AarArrayResourceItem(@NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull List<String> elements) {
        super(ResourceType.ARRAY, name, sourceFile, visibility);
        this.myElements = elements;
    }

    public int getElementCount() {
        return this.myElements.size();
    }

    @NotNull
    public String getElement(int index) {
        return this.myElements.get(index);
    }

    public Iterator<String> iterator() {
        return this.myElements.iterator();
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myElements.isEmpty() ? null : this.myElements.get(0);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarArrayResourceItem other = (AarArrayResourceItem)obj;
        return this.myElements.equals(other.myElements);
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeInt(this.myElements.size());
        for (String element : this.myElements) {
            stream.writeString(element);
        }
    }

    @NotNull
    static AarArrayResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull AarSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        int n = stream.readInt();
        ArrayList<String> elements = n == 0 ? Collections.emptyList() : new ArrayList<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            elements.add(stream.readString());
        }
        AarArrayResourceItem item = new AarArrayResourceItem(name, sourceFile, visibility, elements);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

