/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarAttrReference;
import com.android.tools.idea.resources.aar.AarForeignAttrResourceItem;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AarAttrResourceItem
extends AbstractAarValueResourceItem
implements AttrResourceValue {
    @NotNull
    private final Set<AttributeFormat> myFormats;
    @NotNull
    private final Map<String, Integer> myValueMap;
    @NotNull
    private final Map<String, String> myValueDescriptionMap;
    @Nullable
    private final String myDescription;
    @Nullable
    private final String myGroupName;

    public AarAttrResourceItem(@NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String description, @Nullable String groupName, @NotNull Set<AttributeFormat> formats, @NotNull Map<String, Integer> valueMap, @NotNull Map<String, String> valueDescriptionMap) {
        super(ResourceType.ATTR, name, sourceFile, visibility);
        this.myDescription = description;
        this.myGroupName = groupName;
        this.myFormats = ImmutableSet.copyOf(formats);
        this.myValueMap = valueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(valueMap);
        this.myValueDescriptionMap = valueDescriptionMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(valueDescriptionMap);
    }

    @NotNull
    public final Set<AttributeFormat> getFormats() {
        return this.myFormats;
    }

    @NotNull
    public final Map<String, Integer> getAttributeValues() {
        return this.myValueMap;
    }

    @Nullable
    public final String getValueDescription(@NotNull String valueName) {
        return this.myValueDescriptionMap.get(valueName);
    }

    @Nullable
    public final String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public final String getGroupName() {
        return this.myGroupName;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarAttrResourceItem other = (AarAttrResourceItem)obj;
        return Objects.equals(this.myDescription, other.myDescription) && Objects.equals(this.myGroupName, other.myGroupName) && this.myFormats.equals(other.myFormats) && this.myValueMap.equals(other.myValueMap) && this.myValueDescriptionMap.equals(other.myValueDescriptionMap);
    }

    @NotNull
    AarAttrReference createReference() {
        return new AarAttrReference(this.getNamespace(), this.getName(), this.getSourceFile(), this.getVisibility(), this.myDescription, this.myGroupName);
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        AarAttrResourceItem.serializeAttrValue(this, this.getRepository().getNamespace(), stream);
    }

    static void serializeAttrValue(@NotNull AttrResourceValue attr2, @NotNull ResourceNamespace defaultNamespace2, @NotNull Base128OutputStream stream) throws IOException {
        ResourceNamespace namespace = attr2.getNamespace();
        String namespaceSuffix = namespace.equals((Object)defaultNamespace2) ? null : namespace.getXmlNamespaceUri().substring("http://schemas.android.com/".length());
        stream.writeString(namespaceSuffix);
        stream.writeString(attr2.getDescription());
        stream.writeString(attr2.getGroupName());
        int formatMask = 0;
        for (AttributeFormat format : attr2.getFormats()) {
            formatMask |= 1 << format.ordinal();
        }
        stream.writeInt(formatMask);
        Map attributeValues = attr2.getAttributeValues();
        stream.writeInt(attributeValues.size());
        for (Map.Entry entry : attributeValues.entrySet()) {
            String name = (String)entry.getKey();
            stream.writeString(name);
            Integer value2 = (Integer)entry.getValue();
            int v = value2 == null ? Integer.MIN_VALUE : value2 + 1;
            stream.writeInt(v);
            String description = attr2.getValueDescription(name);
            stream.writeString(description);
        }
    }

    @NotNull
    static AbstractAarValueResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull AarSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        AbstractAarValueResourceItem item;
        ResourceNamespace namespace;
        String namespaceSuffix = stream.readString();
        String description = stream.readString();
        String groupName = stream.readString();
        int formatMask = stream.readInt();
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        AttributeFormat[] attributeFormatValues = AttributeFormat.values();
        for (int ordinal = 0; ordinal < attributeFormatValues.length && formatMask != 0; ++ordinal, formatMask >>>= 1) {
            if ((formatMask & 1) == 0) continue;
            formats.add(attributeFormatValues[ordinal]);
        }
        int n = stream.readInt();
        HashMap valueMap = n == 0 ? Collections.emptyMap() : Maps.newHashMapWithExpectedSize((int)n);
        HashMap descriptionMap = n == 0 ? Collections.emptyMap() : Maps.newHashMapWithExpectedSize((int)n);
        for (int i2 = 0; i2 < n; ++i2) {
            String valueDescription;
            String valueName = stream.readString();
            int value2 = stream.readInt();
            if (value2 != Integer.MIN_VALUE) {
                valueMap.put(valueName, value2 - 1);
            }
            if ((valueDescription = stream.readString()) == null) continue;
            descriptionMap.put(valueName, valueDescription);
        }
        if (formats.isEmpty() && valueMap.isEmpty()) {
            ResourceNamespace resourceNamespace = namespace = namespaceSuffix == null ? sourceFile.getConfiguration().getRepository().getNamespace() : ResourceNamespace.fromNamespaceUri((String)("http://schemas.android.com/" + namespaceSuffix));
            if (namespace == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            item = new AarAttrReference(namespace, name, sourceFile, visibility, description, groupName);
        } else if (namespaceSuffix == null) {
            item = new AarAttrResourceItem(name, sourceFile, visibility, description, groupName, formats, valueMap, descriptionMap);
        } else {
            namespace = ResourceNamespace.fromNamespaceUri((String)("http://schemas.android.com/" + namespaceSuffix));
            if (namespace == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            item = new AarForeignAttrResourceItem(namespace, name, sourceFile, description, groupName, formats, (Map<String, Integer>)valueMap, (Map<String, String>)descriptionMap);
        }
        item.setNamespaceResolver(resolver);
        return item;
    }
}

