/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarConfiguration;
import com.android.tools.idea.resources.aar.AarDensityBasedFileResourceItem;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.utils.HashCodes;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AarFileResourceItem
extends AbstractAarResourceItem {
    @NotNull
    private final AarConfiguration myConfiguration;
    @NotNull
    private final String myRelativePath;

    public AarFileResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility, @NotNull String relativePath) {
        super(type, name, visibility);
        this.myConfiguration = configuration;
        this.myRelativePath = relativePath;
    }

    public final boolean isFileBased() {
        return true;
    }

    @Nullable
    public final ResourceReference getReference() {
        return null;
    }

    @Override
    @NotNull
    protected final AbstractAarResourceRepository getRepository() {
        return this.myConfiguration.getRepository();
    }

    @NotNull
    public final FolderConfiguration getConfiguration() {
        return this.myConfiguration.getFolderConfiguration();
    }

    @NotNull
    public final ResourceNamespace.Resolver getNamespaceResolver() {
        return ResourceNamespace.Resolver.EMPTY_RESOLVER;
    }

    @Nullable
    public String getValue() {
        return this.getRepository().getResourceUrl(this.myRelativePath);
    }

    @NotNull
    public final PathString getSource() {
        return this.getRepository().getSourceFile(this.myRelativePath, true);
    }

    @Nullable
    public final PathString getOriginalSource() {
        return this.getRepository().getOriginalSourceFile(this.myRelativePath, true);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarFileResourceItem other = (AarFileResourceItem)obj;
        return this.myConfiguration.equals(other.myConfiguration) && this.myRelativePath.equals(other.myRelativePath);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)this.myRelativePath.hashCode());
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myRelativePath);
        String qualifierString = this.getConfiguration().getQualifierString();
        int index = configIndexes.get((Object)qualifierString);
        assert (index >= 0);
        stream.writeInt(index);
        stream.writeInt(this.getEncodedDensityForSerialization());
    }

    @NotNull
    static AarFileResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull List<AarConfiguration> configurations) throws IOException {
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        AarConfiguration configuration = configurations.get(stream.readInt());
        int encodedDensity = stream.readInt();
        if (encodedDensity == 0) {
            return new AarFileResourceItem(resourceType, name, configuration, visibility, relativePath);
        }
        Density density = Density.values()[encodedDensity - 1];
        return new AarDensityBasedFileResourceItem(resourceType, name, configuration, visibility, relativePath, density);
    }

    protected int getEncodedDensityForSerialization() {
        return 0;
    }
}

