/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.Arity;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AarPluralsResourceItem
extends AbstractAarValueResourceItem
implements PluralsResourceValue {
    @NotNull
    private final Arity[] myArities;
    @NotNull
    private final String[] myValues;

    public AarPluralsResourceItem(@NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull Map<Arity, String> quantityValues) {
        this(name, sourceFile, visibility, quantityValues.keySet().toArray(Arity.EMPTY_ARRAY), quantityValues.values().toArray(ArrayUtil.EMPTY_STRING_ARRAY));
    }

    private AarPluralsResourceItem(@NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull Arity[] arities, @NotNull String[] values) {
        super(ResourceType.PLURALS, name, sourceFile, visibility);
        this.myArities = arities;
        this.myValues = values;
    }

    public int getPluralsCount() {
        return this.myArities.length;
    }

    @NotNull
    public String getQuantity(int index) {
        return this.myArities[index].getName();
    }

    @NotNull
    public String getValue(int index) {
        return this.myValues[index];
    }

    @Nullable
    public String getValue(@NotNull String quantity) {
        int n = this.myArities.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!quantity.equals(this.myArities[i2])) continue;
            return this.myValues[i2];
        }
        return null;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myValues.length == 0 ? null : this.myValues[0];
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarPluralsResourceItem other = (AarPluralsResourceItem)obj;
        return Arrays.equals(this.myArities, other.myArities) && Arrays.equals(this.myValues, other.myValues);
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int n = this.myArities.length;
        stream.writeInt(n);
        for (int i2 = 0; i2 < n; ++i2) {
            stream.writeInt(this.myArities[i2].ordinal());
            stream.writeString(this.myValues[i2]);
        }
    }

    @NotNull
    static AarPluralsResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull AarSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        int n = stream.readInt();
        Arity[] arities = n == 0 ? Arity.EMPTY_ARRAY : new Arity[n];
        String[] values = n == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            arities[i2] = Arity.values()[stream.readInt()];
            values[i2] = stream.readString();
        }
        AarPluralsResourceItem item = new AarPluralsResourceItem(name, sourceFile, visibility, arities, values);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

