/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.resources.PatternBasedFileFilter;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceNameKeyedMap;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.util.PathString;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.projectmodel.ResourceFolder;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarArrayResourceItem;
import com.android.tools.idea.resources.aar.AarAttrResourceItem;
import com.android.tools.idea.resources.aar.AarConfiguration;
import com.android.tools.idea.resources.aar.AarDensityBasedFileResourceItem;
import com.android.tools.idea.resources.aar.AarFileResourceItem;
import com.android.tools.idea.resources.aar.AarForeignAttrResourceItem;
import com.android.tools.idea.resources.aar.AarPluralsResourceItem;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AarStyleResourceItem;
import com.android.tools.idea.resources.aar.AarStyleableResourceItem;
import com.android.tools.idea.resources.aar.AarTextValueResourceItem;
import com.android.tools.idea.resources.aar.AarValueResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.tools.idea.resources.aar.NamespaceResolver;
import com.android.tools.idea.resources.aar.ValueResourceXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AarSourceResourceRepository
extends AbstractAarResourceRepository {
    private static final Logger LOG = Logger.getInstance(AarSourceResourceRepository.class);
    @NotNull
    protected final Path myResourceDirectoryOrFile;
    protected boolean myLoadedFromCache;
    @NotNull
    private final String mySourceFileProtocol;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final String myResourceUrlPrefix;
    @Nullable
    private Set<String> myRTxtIds;
    @NotNull
    private final NullableLazyValue<String> myManifestPackageName;

    protected AarSourceResourceRepository(@NotNull Loader loader) {
        super(loader.myNamespace, loader.myLibraryName);
        this.myResourceDirectoryOrFile = loader.myResourceDirectoryOrFile;
        this.mySourceFileProtocol = loader.getSourceFileProtocol();
        this.myResourcePathPrefix = loader.getResourcePathPrefix();
        this.myResourceUrlPrefix = loader.getResourceUrlPrefix();
        this.myManifestPackageName = NullableLazyValue.createValue(() -> {
            Path manifest = this.myResourceDirectoryOrFile.resolveSibling("AndroidManifest.xml");
            if (Files.notExists(manifest, new LinkOption[0])) {
                return null;
            }
            try {
                ManifestData manifestData = AndroidManifestParser.parse((Path)manifest);
                return manifestData.getPackage();
            }
            catch (IOException e) {
                LOG.error("Failed to read manifest " + manifest.toString() + " for " + this.getDisplayName(), (Throwable)e);
                return null;
            }
        });
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull File resourceDirectory, @NotNull String libraryName) {
        return AarSourceResourceRepository.create(resourceDirectory, null, ResourceNamespace.RES_AUTO, libraryName);
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull ResourceFolder resourceFolder, @NotNull String libraryName) {
        File resDir = resourceFolder.getRoot().toFile();
        Preconditions.checkArgument((resDir != null ? 1 : 0) != 0);
        return AarSourceResourceRepository.create(resDir, resourceFolder.getResources(), ResourceNamespace.RES_AUTO, libraryName);
    }

    @NotNull
    private static AarSourceResourceRepository create(@NotNull File resourceDirectory, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace, @NotNull String libraryName) {
        Loader loader = new Loader(resourceDirectory.toPath(), resourceFilesAndFolders, namespace, libraryName);
        AarSourceResourceRepository repository = new AarSourceResourceRepository(loader);
        loader.loadRepositoryContents(repository);
        return repository;
    }

    @Override
    @NotNull
    Path getOrigin() {
        return this.myResourceDirectoryOrFile;
    }

    @VisibleForTesting
    @NotNull
    public static AarSourceResourceRepository createForTest(@NotNull File resourceDirectory, @NotNull ResourceNamespace namespace, @NotNull String libraryName) {
        return AarSourceResourceRepository.create(resourceDirectory, null, namespace, libraryName);
    }

    @Nullable
    public String getPackageName() {
        String packageName = this.myNamespace.getPackageName();
        return packageName == null ? (String)this.myManifestPackageName.getValue() : packageName;
    }

    @Nullable
    public Set<String> getIdsFromRTxt() {
        return this.myRTxtIds;
    }

    @Override
    @NotNull
    final PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return new PathString(this.mySourceFileProtocol, this.myResourcePathPrefix + relativeResourcePath);
    }

    @Override
    @NotNull
    final String getResourceUrl(@NotNull String relativeResourcePath) {
        return this.myResourceUrlPrefix + relativeResourcePath;
    }

    protected void createPersistentCache(@NotNull Path cacheFile, @NotNull byte[] fileHeader) {
        Path tempFile;
        try {
            Files.deleteIfExists(cacheFile);
            tempFile = FileUtilRt.createTempFile((File)cacheFile.getParent().toFile(), (String)cacheFile.getFileName().toString(), (String)".tmp").toPath();
        }
        catch (IOException e) {
            LOG.error("Unable to create a temporary file in " + cacheFile.getParent().toString(), (Throwable)e);
            return;
        }
        try (Base128OutputStream stream = new Base128OutputStream(tempFile);){
            stream.write(fileHeader);
            this.writeToStream(stream);
        }
        catch (Throwable e) {
            LOG.error("Unable to create cache file " + tempFile.toString(), e);
            AarSourceResourceRepository.deleteIgnoringErrors(tempFile);
            return;
        }
        try {
            Files.move(tempFile, cacheFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            LOG.error("Unable to create cache file " + cacheFile.toString(), (Throwable)e);
            AarSourceResourceRepository.deleteIgnoringErrors(tempFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadFromPersistentCache(@NotNull Path cacheFile, @NotNull byte[] fileHeader) {
        try (Base128InputStream stream = new Base128InputStream(cacheFile);){
            for (byte expected2 : fileHeader) {
                byte b = stream.readByte();
                if (b == expected2) continue;
                boolean bl = false;
                return bl;
            }
            this.loadFromStream(stream);
            this.myLoadedFromCache = true;
            boolean bl = true;
            return bl;
        }
        catch (NoSuchFileException e) {
            return false;
        }
        catch (Throwable e) {
            this.cleanupAfterFailedLoadingFromCache();
            LOG.warn("Unable to load from cache file " + cacheFile.toString(), e);
            return false;
        }
    }

    protected void cleanupAfterFailedLoadingFromCache() {
        this.myResources.clear();
    }

    void writeToStream(@NotNull Base128OutputStream stream) throws IOException {
        ObjectIntHashMap qualifierStringIndexes = new ObjectIntHashMap();
        ObjectIntHashMap sourceFileIndexes = new ObjectIntHashMap();
        ObjectIntHashMap namespaceResolverIndexes = new ObjectIntHashMap();
        this.accept(item -> {
            ResourceNamespace.Resolver resolver;
            AarSourceFile sourceFile;
            String qualifier = item.getConfiguration().getQualifierString();
            if (!qualifierStringIndexes.containsKey((Object)qualifier)) {
                qualifierStringIndexes.put((Object)qualifier, qualifierStringIndexes.size());
            }
            if (item instanceof AbstractAarValueResourceItem && !sourceFileIndexes.containsKey((Object)(sourceFile = ((AbstractAarValueResourceItem)item).getSourceFile()))) {
                sourceFileIndexes.put((Object)sourceFile, sourceFileIndexes.size());
            }
            if (item instanceof ResourceValue && !namespaceResolverIndexes.containsKey((Object)(resolver = ((ResourceValue)item).getNamespaceResolver()))) {
                namespaceResolverIndexes.put((Object)resolver, namespaceResolverIndexes.size());
            }
            return ResourceVisitor.VisitResult.CONTINUE;
        });
        AarSourceResourceRepository.writeStrings((ObjectIntHashMap<String>)qualifierStringIndexes, stream);
        AarSourceResourceRepository.writeSourceFiles((ObjectIntHashMap<AarSourceFile>)sourceFileIndexes, stream, (ObjectIntHashMap<String>)qualifierStringIndexes);
        AarSourceResourceRepository.writeNamespaceResolvers((ObjectIntHashMap<ResourceNamespace.Resolver>)namespaceResolverIndexes, stream);
        Collection resourceMaps = this.myResources.values();
        int itemCount = 0;
        for (ListMultimap resourceMap : resourceMaps) {
            itemCount += resourceMap.size();
        }
        stream.writeInt(itemCount);
        for (ListMultimap resourceMap : resourceMaps) {
            for (ResourceItem item2 : resourceMap.values()) {
                ((AbstractAarResourceItem)item2).serialize(stream, (ObjectIntHashMap<String>)qualifierStringIndexes, (ObjectIntHashMap<AarSourceFile>)sourceFileIndexes, (ObjectIntHashMap<ResourceNamespace.Resolver>)namespaceResolverIndexes);
            }
        }
    }

    private static void writeStrings(@NotNull ObjectIntHashMap<String> qualifierStringIndexes, @NotNull Base128OutputStream stream) throws IOException {
        String[] strings = new String[qualifierStringIndexes.size()];
        qualifierStringIndexes.forEachEntry((str, index2) -> {
            strings[index2] = str;
            return true;
        });
        stream.writeInt(strings.length);
        for (String str2 : strings) {
            stream.writeString(str2);
        }
    }

    private static void writeSourceFiles(@NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> qualifierStringIndexes) throws IOException {
        AarSourceFile[] sourceFiles = new AarSourceFile[sourceFileIndexes.size()];
        sourceFileIndexes.forEachEntry((sourceFile, index1) -> {
            sourceFiles[index1] = sourceFile;
            return true;
        });
        stream.writeInt(sourceFiles.length);
        for (AarSourceFile sourceFile2 : sourceFiles) {
            sourceFile2.serialize(stream, qualifierStringIndexes);
        }
    }

    private static void writeNamespaceResolvers(@NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes, @NotNull Base128OutputStream stream) throws IOException {
        ResourceNamespace.Resolver[] resolvers = new ResourceNamespace.Resolver[namespaceResolverIndexes.size()];
        namespaceResolverIndexes.forEachEntry((resolver, index) -> {
            resolvers[index] = resolver;
            return true;
        });
        stream.writeInt(resolvers.length);
        for (ResourceNamespace.Resolver resolver2 : resolvers) {
            NamespaceResolver serializableResolver = resolver2 == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver2;
            serializableResolver.serialize(stream);
        }
    }

    protected void loadFromStream(@NotNull Base128InputStream stream) throws IOException {
        int i2;
        stream.setStringCache(Maps.newHashMapWithExpectedSize((int)10000));
        int n = stream.readInt();
        ArrayList<AarConfiguration> configurations = new ArrayList<AarConfiguration>(n);
        for (int i3 = 0; i3 < n; ++i3) {
            String configQualifier = stream.readString();
            if (configQualifier == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForQualifierString((String)configQualifier);
            if (folderConfig == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            configurations.add(new AarConfiguration(this, folderConfig));
        }
        n = stream.readInt();
        ArrayList<AarSourceFile> sourceFiles = new ArrayList<AarSourceFile>(n);
        for (int i4 = 0; i4 < n; ++i4) {
            AarSourceFile sourceFile = AarSourceFile.deserialize(stream, configurations);
            sourceFiles.add(sourceFile);
        }
        n = stream.readInt();
        ArrayList<ResourceNamespace.Resolver> namespaceResolvers = new ArrayList<ResourceNamespace.Resolver>(n);
        for (i2 = 0; i2 < n; ++i2) {
            NamespaceResolver resolver = NamespaceResolver.deserialize(stream);
            namespaceResolvers.add(resolver);
        }
        n = stream.readInt();
        for (i2 = 0; i2 < n; ++i2) {
            AbstractAarResourceItem item = AbstractAarResourceItem.deserialize(stream, configurations, sourceFiles, namespaceResolvers);
            this.addResourceItem((ResourceItem)item);
        }
        this.populatePublicResourcesMap();
        this.freezeResources();
    }

    private static void deleteIgnoringErrors(@NotNull Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    boolean isLoadedFromCache() {
        return this.myLoadedFromCache;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResourceDirectoryOrFile;
    }

    private static class XmlSyntaxException
    extends Exception {
        XmlSyntaxException(@NotNull String error, @NotNull XmlPullParser parser, @NotNull Path file) {
            super(error + " at " + file.toString() + " line " + parser.getLineNumber());
        }
    }

    private static class XmlTextExtractor {
        @NotNull
        private final StringBuilder text = new StringBuilder();
        @NotNull
        private final StringBuilder rawXml = new StringBuilder();
        @NotNull
        private final Deque<Boolean> textInclusionState = new ArrayDeque<Boolean>();
        private boolean nontrivialRawXml;

        private XmlTextExtractor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        String extractText(@NotNull XmlPullParser parser, boolean withRawXml) throws IOException, XmlPullParserException {
            int event;
            this.text.setLength(0);
            this.rawXml.setLength(0);
            this.textInclusionState.clear();
            this.nontrivialRawXml = false;
            int elementDepth = parser.getDepth();
            do {
                event = parser.nextToken();
                switch (event) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("g".equals(tagName) && XmlTextExtractor.isXliffNamespace(parser.getNamespace())) {
                            boolean includeNestedText = this.getTextInclusionState();
                            String example = parser.getAttributeValue(null, "example");
                            if (example != null) {
                                this.text.append('(').append(example).append(')');
                                includeNestedText = false;
                            } else {
                                String id = parser.getAttributeValue(null, "id");
                                if (id != null && !id.equals("id")) {
                                    this.text.append('$').append('{').append(id).append('}');
                                    includeNestedText = false;
                                }
                            }
                            this.textInclusionState.addLast(includeNestedText);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append('<');
                        String prefix = parser.getPrefix();
                        if (prefix != null) {
                            this.rawXml.append(prefix).append(':');
                        }
                        this.rawXml.append(tagName);
                        int numAttr = parser.getAttributeCount();
                        for (int i2 = 0; i2 < numAttr; ++i2) {
                            this.rawXml.append(' ');
                            String attributePrefix = parser.getAttributePrefix(i2);
                            if (attributePrefix != null) {
                                this.rawXml.append(attributePrefix).append(':');
                            }
                            this.rawXml.append(parser.getAttributeName(i2)).append('=').append('\"');
                            XmlUtils.appendXmlAttributeValue((StringBuilder)this.rawXml, (String)parser.getAttributeValue(i2));
                            this.rawXml.append('\"');
                        }
                        this.rawXml.append('>');
                        break;
                    }
                    case 3: {
                        if (parser.getDepth() <= elementDepth) {
                            return ValueXmlHelper.unescapeResourceString((String)this.text.toString(), (boolean)false, (boolean)true);
                        }
                        String tagName = parser.getName();
                        if (withRawXml) {
                            this.rawXml.append('<').append('/');
                            String prefix = parser.getPrefix();
                            if (prefix != null) {
                                this.rawXml.append(prefix).append(':');
                            }
                            this.rawXml.append(tagName).append('>');
                        }
                        if (!"g".equals(tagName) || !XmlTextExtractor.isXliffNamespace(parser.getNamespace())) break;
                        this.textInclusionState.removeLast();
                        break;
                    }
                    case 4: 
                    case 6: {
                        String textPiece = parser.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.rawXml.append(textPiece);
                        break;
                    }
                    case 5: {
                        String textPiece = parser.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append("<!CDATA[").append(textPiece).append("]]>");
                    }
                }
            } while (event != 1);
            return ValueXmlHelper.unescapeResourceString((String)this.text.toString(), (boolean)false, (boolean)true);
        }

        private boolean getTextInclusionState() {
            return this.textInclusionState.isEmpty() || this.textInclusionState.getLast() != false;
        }

        @Nullable
        String getRawXml() {
            return this.nontrivialRawXml ? this.rawXml.toString() : null;
        }

        private static boolean isXliffNamespace(@Nullable String namespaceUri) {
            return namespaceUri != null && namespaceUri.startsWith("urn:oasis:names:tc:xliff:document:");
        }
    }

    private static class FolderInfo {
        @NotNull
        final ResourceFolderType folderType;
        @NotNull
        final FolderConfiguration configuration;
        @Nullable
        final ResourceType resourceType;
        final boolean isIdGenerating;

        private FolderInfo(@NotNull ResourceFolderType folderType, @NotNull FolderConfiguration configuration, @Nullable ResourceType resourceType, boolean isIdGenerating) {
            this.configuration = configuration;
            this.resourceType = resourceType;
            this.folderType = folderType;
            this.isIdGenerating = isIdGenerating;
        }

        @Nullable
        static FolderInfo create(@NotNull String folderName) {
            boolean isIdGenerating;
            ResourceType resourceType;
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
            if (folderType == null) {
                return null;
            }
            FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)folderName);
            if (configuration == null) {
                return null;
            }
            if (!configuration.isDefault()) {
                configuration.normalize();
            }
            if (folderType == ResourceFolderType.VALUES) {
                resourceType = null;
                isIdGenerating = false;
            } else {
                resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                isIdGenerating = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
            }
            return new FolderInfo(folderType, configuration, resourceType, isIdGenerating);
        }
    }

    private static interface XmlTagVisitor {
        public void visitTag() throws IOException, XmlPullParserException;
    }

    private static class ResourceFileCollector
    implements FileVisitor<Path> {
        @NotNull
        final List<Path> resourceFiles = new ArrayList<Path>();
        @NotNull
        final List<IOException> ioErrors = new ArrayList<IOException>();
        @NotNull
        final ResourceFileFilter fileFilter;

        private ResourceFileCollector(@NotNull ResourceFileFilter filter2) {
            this.fileFilter = filter2;
        }

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
            if (this.fileFilter.isIgnored(dir, attrs)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
            if (this.fileFilter.isIgnored(file, attrs)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            this.resourceFiles.add(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult visitFileFailed(@NotNull Path file, @NotNull IOException exc) {
            this.ioErrors.add(exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }

    protected static interface ResourceFileFilter {
        public boolean isIgnored(@NotNull Path var1, @NotNull BasicFileAttributes var2);
    }

    protected static class Loader
    implements ResourceFileFilter {
        private final Set<AttributeFormat> DEFAULT_ATTR_FORMATS = Sets.immutableEnumSet((Enum)AttributeFormat.BOOLEAN, (Enum[])new AttributeFormat[]{AttributeFormat.COLOR, AttributeFormat.DIMENSION, AttributeFormat.FLOAT, AttributeFormat.FRACTION, AttributeFormat.INTEGER, AttributeFormat.REFERENCE, AttributeFormat.STRING});
        private final PatternBasedFileFilter myFileFilter = new PatternBasedFileFilter();
        @NotNull
        protected final Map<ResourceType, Set<String>> myPublicResources = new EnumMap<ResourceType, Set<String>>(ResourceType.class);
        @NotNull
        private final ListMultimap<String, AarAttrResourceItem> myAttrs = ArrayListMultimap.create();
        @NotNull
        private final ListMultimap<String, AarAttrResourceItem> myAttrCandidates = ArrayListMultimap.create();
        @NotNull
        private final ListMultimap<String, AarStyleableResourceItem> myStyleables = ArrayListMultimap.create();
        @NotNull
        private ResourceVisibility myDefaultVisibility = ResourceVisibility.PRIVATE;
        @NotNull
        private final Map<FolderConfiguration, AarConfiguration> myConfigCache = new HashMap<FolderConfiguration, AarConfiguration>();
        @NotNull
        private final ValueResourceXmlParser myParser = new ValueResourceXmlParser();
        @NotNull
        private final XmlTextExtractor myTextExtractor = new XmlTextExtractor();
        @NotNull
        private final AbstractAarResourceRepository.ResourceUrlParser myUrlParser = new AbstractAarResourceRepository.ResourceUrlParser();
        @NotNull
        private final Table<ResourceType, String, AbstractAarValueResourceItem> myValueFileResources = Tables.newCustomTable(new EnumMap(ResourceType.class), () -> new LinkedHashMap());
        @NotNull
        protected final Path myResourceDirectoryOrFile;
        @NotNull
        private final ResourceNamespace myNamespace;
        @Nullable
        private final Collection<PathString> myResourceFilesAndFolders;
        @Nullable
        private final String myLibraryName;

        Loader(@NotNull Path resourceDirectoryOrFile, @Nullable Collection<PathString> resourceFilesAndFolders, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
            this.myResourceDirectoryOrFile = resourceDirectoryOrFile;
            this.myNamespace = namespace;
            this.myResourceFilesAndFolders = resourceFilesAndFolders;
            this.myLibraryName = libraryName;
        }

        protected void loadRepositoryContents(@NotNull AarSourceResourceRepository repository) {
            try {
                if (Files.notExists(this.myResourceDirectoryOrFile, new LinkOption[0])) {
                    return;
                }
                this.loadPublicResourceNames();
                Set<String> ids = this.loadIdsFromRTxt();
                repository.myRTxtIds = ids;
                boolean shouldParseResourceIds = ids == null;
                ImmutableList sourceFilesAndFolders = this.myResourceFilesAndFolders == null ? ImmutableList.of((Object)this.myResourceDirectoryOrFile) : this.myResourceFilesAndFolders.stream().map(PathString::toPath).collect(Collectors.toList());
                List<Path> resourceFiles = this.findResourceFiles((List<Path>)sourceFilesAndFolders);
                for (Path file : resourceFiles) {
                    FolderInfo folderInfo = FolderInfo.create(file.getParent().getFileName().toString());
                    if (folderInfo == null) continue;
                    AarConfiguration configuration = this.getAarConfiguration(repository, folderInfo.configuration);
                    this.loadResourceFile(file, folderInfo, configuration, shouldParseResourceIds);
                }
                this.processAttrsAndStyleables();
                repository.populatePublicResourcesMap();
                repository.freezeResources();
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
        }

        @NotNull
        protected String getSourceFileProtocol() {
            return "file";
        }

        @NotNull
        protected String getResourcePathPrefix() {
            return this.myResourceDirectoryOrFile.toString() + File.separatorChar;
        }

        @NotNull
        protected String getResourceUrlPrefix() {
            return AbstractAarResourceRepository.portableFileName(this.myResourceDirectoryOrFile.toString()) + '/';
        }

        @Nullable
        protected Set<String> loadIdsFromRTxt() {
            Path rDotTxt = this.myResourceDirectoryOrFile.resolveSibling("R.txt");
            if (Files.exists(rDotTxt, new LinkOption[0])) {
                try {
                    SymbolTable symbolTable = SymbolIo.readFromAaptNoValues((File)rDotTxt.toFile(), null);
                    return symbolTable.getSymbols().row((Object)ResourceType.ID).values().stream().map(s -> s.getCanonicalName()).collect(Collectors.toSet());
                }
                catch (Exception e) {
                    LOG.warn("Failed to load id resources from " + rDotTxt.toString(), (Throwable)e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isIgnored(@NotNull Path fileOrDirectory, @NotNull BasicFileAttributes attrs) {
            return this.myFileFilter.isIgnored(fileOrDirectory.toString(), attrs.isDirectory());
        }

        protected void loadPublicResourceNames() {
            Path file = this.myResourceDirectoryOrFile.resolveSibling("public.txt");
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String line;
                while ((line = reader.readLine()) != null) {
                    ResourceType type;
                    int delimiterPos = (line = line.trim()).indexOf(32);
                    if (delimiterPos <= 0 || delimiterPos + 1 >= line.length() || (type = ResourceType.fromXmlTagName((String)line.substring(0, delimiterPos))) == null) continue;
                    String name = line.substring(delimiterPos + 1);
                    Set names = this.myPublicResources.computeIfAbsent(type, t -> new HashSet());
                    names.add(name);
                }
            }
            catch (NoSuchFileException e) {
                this.myDefaultVisibility = ResourceVisibility.PUBLIC;
            }
            catch (IOException e) {
                LOG.warn("Error reading " + file.toString(), (Throwable)e);
            }
        }

        @NotNull
        private List<Path> findResourceFiles(@NotNull List<Path> filesOrFolders) {
            ResourceFileCollector fileCollector = new ResourceFileCollector(this);
            for (Path file : filesOrFolders) {
                try {
                    Files.walkFileTree(file, fileCollector);
                }
                catch (IOException iOException) {}
            }
            for (IOException e : fileCollector.ioErrors) {
                LOG.error("Error loading resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
            Collections.sort(fileCollector.resourceFiles);
            return fileCollector.resourceFiles;
        }

        @NotNull
        private AarConfiguration getAarConfiguration(@NotNull AarSourceResourceRepository repository, @NotNull FolderConfiguration folderConfiguration) {
            AarConfiguration aarConfiguration = this.myConfigCache.get(folderConfiguration);
            if (aarConfiguration != null) {
                return aarConfiguration;
            }
            aarConfiguration = new AarConfiguration(repository, folderConfiguration);
            this.myConfigCache.put(folderConfiguration, aarConfiguration);
            return aarConfiguration;
        }

        private void loadResourceFile(@NotNull Path file, @NotNull FolderInfo folderInfo, @NotNull AarConfiguration configuration, boolean shouldParseResourceIds) {
            if (folderInfo.resourceType == null) {
                this.parseValueResourceFile(file, configuration);
            } else {
                String fileName = file.getFileName().toString();
                if (shouldParseResourceIds && folderInfo.isIdGenerating && SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) {
                    this.parseIdGeneratingResourceFile(file, configuration);
                }
                AarFileResourceItem item = this.createFileResourceItem(file, folderInfo.resourceType, configuration);
                Loader.addResourceItem(item);
            }
        }

        private static void addResourceItem(@NotNull AbstractAarResourceItem item) {
            item.getRepository().addResourceItem((ResourceItem)item);
        }

        private void parseValueResourceFile(@NotNull Path file, @NotNull AarConfiguration configuration) {
            AarSourceFile sourceFile = new AarSourceFile(this.getRelativePath(file), configuration);
            try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
                int event;
                this.myParser.setInput(stream, null);
                do {
                    String resourceName;
                    ResourceType resourceType;
                    event = this.myParser.nextToken();
                    int depth = this.myParser.getDepth();
                    if (event != 2 || this.myParser.getPrefix() != null) continue;
                    String tagName = this.myParser.getName();
                    assert (depth <= 2);
                    if (depth == 1) {
                        if (tagName.equals("resources")) continue;
                        break;
                    }
                    if (depth <= 1 || (resourceType = this.getResourceType(tagName, file)) == null || resourceType == ResourceType.PUBLIC || (resourceName = this.myParser.getAttributeValue(null, "name")) == null) continue;
                    this.validateResourceName(resourceName, resourceType, file);
                    AbstractAarValueResourceItem item = this.createResourceItem(resourceType, resourceName, sourceFile);
                    this.addValueResourceItem(item);
                } while (event != 1);
            }
            catch (XmlSyntaxException | IOException | XmlPullParserException e) {
                LOG.warn("Failed to parse " + file.toString(), e);
            }
            this.addValueFileResources();
        }

        private void addValueResourceItem(@NotNull AbstractAarValueResourceItem item) {
            ResourceType resourceType = item.getType();
            if (resourceType == ResourceType.ATTR) {
                Loader.addAttr((AarAttrResourceItem)item, this.myAttrs);
            } else if (resourceType == ResourceType.STYLEABLE) {
                this.myStyleables.put((Object)item.getName(), (Object)((AarStyleableResourceItem)item));
            } else {
                this.myValueFileResources.put((Object)resourceType, (Object)item.getName(), (Object)item);
            }
        }

        private void addValueFileResources() {
            for (AbstractAarValueResourceItem item : this.myValueFileResources.values()) {
                Loader.addResourceItem(item);
            }
            this.myValueFileResources.clear();
        }

        private void parseIdGeneratingResourceFile(@NotNull Path file, @NotNull AarConfiguration configuration) {
            AarSourceFile sourceFile = new AarSourceFile(this.getRelativePath(file), configuration);
            try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
                int event;
                KXmlParser parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((InputStream)stream, null);
                do {
                    if ((event = parser.nextToken()) != 2) continue;
                    int numAttributes = parser.getAttributeCount();
                    for (int i2 = 0; i2 < numAttributes; ++i2) {
                        ResourceVisibility visibility;
                        String resourceName;
                        AarValueResourceItem item;
                        String idValue = parser.getAttributeValue(i2);
                        if (!idValue.startsWith("@+id/") || idValue.length() <= "@+id/".length() || Loader.resourceAlreadyDefined(item = new AarValueResourceItem(ResourceType.ID, resourceName = idValue.substring("@+id/".length()), sourceFile, visibility = this.getVisibility(ResourceType.ID, resourceName), null))) continue;
                        this.addValueResourceItem(item);
                    }
                } while (event != 1);
            }
            catch (IOException | XmlPullParserException e) {
                LOG.warn("Failed to parse " + file.toString(), e);
            }
            this.addValueFileResources();
        }

        @NotNull
        private AarFileResourceItem createFileResourceItem(@NotNull Path file, @NotNull ResourceType resourceType, @NotNull AarConfiguration configuration) {
            Density densityValue;
            DensityQualifier densityQualifier;
            String resourceName = Loader.getResourceName(file);
            ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
            String relativePath = this.getRelativePath(file);
            if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null && (densityValue = densityQualifier.getValue()) != null) {
                return new AarDensityBasedFileResourceItem(resourceType, resourceName, configuration, visibility, relativePath, densityValue);
            }
            return new AarFileResourceItem(resourceType, resourceName, configuration, visibility, relativePath);
        }

        @NotNull
        private static String getResourceName(@NotNull Path file) {
            String filename = file.getFileName().toString();
            int dotPos = filename.indexOf(46);
            return dotPos < 0 ? filename : filename.substring(0, dotPos);
        }

        @NotNull
        private AbstractAarValueResourceItem createResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
            switch (type) {
                case ARRAY: {
                    return this.createArrayItem(name, sourceFile);
                }
                case ATTR: {
                    return this.createAttrItem(name, sourceFile);
                }
                case PLURALS: {
                    return this.createPluralsItem(name, sourceFile);
                }
                case STRING: {
                    return this.createStringItem(type, name, sourceFile, true);
                }
                case STYLE: {
                    return this.createStyleItem(name, sourceFile);
                }
                case STYLEABLE: {
                    return this.createStyleableItem(name, sourceFile);
                }
                case ANIMATOR: 
                case DRAWABLE: 
                case INTERPOLATOR: 
                case LAYOUT: 
                case MENU: 
                case MIPMAP: 
                case TRANSITION: {
                    return this.createFileReferenceItem(type, name, sourceFile);
                }
            }
            return this.createStringItem(type, name, sourceFile, false);
        }

        @NotNull
        private AarArrayResourceItem createArrayItem(@NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException {
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            ArrayList<String> values = new ArrayList<String>();
            this.forSubTags("item", () -> {
                String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                values.add(text);
            });
            ResourceVisibility visibility = this.getVisibility(ResourceType.ARRAY, name);
            AarArrayResourceItem item = new AarArrayResourceItem(name, sourceFile, visibility, values);
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        @NotNull
        private AarAttrResourceItem createAttrItem(@NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
            AarAttrResourceItem item;
            ResourceNamespace attrNamespace;
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            this.myUrlParser.parseResourceUrl(name);
            if (this.myUrlParser.hasNamespacePrefix("android")) {
                attrNamespace = ResourceNamespace.ANDROID;
            } else {
                String prefix = this.myUrlParser.getNamespacePrefix();
                attrNamespace = ResourceNamespace.fromNamespacePrefix((String)prefix, (ResourceNamespace)this.myNamespace, (ResourceNamespace.Resolver)this.myParser.getNamespaceResolver());
                if (attrNamespace == null) {
                    throw new XmlSyntaxException("Undefined prefix of attr resource name \"" + name + "\"", (XmlPullParser)this.myParser, this.getFile(sourceFile));
                }
            }
            name = this.myUrlParser.getName();
            String description = this.myParser.getLastComment();
            String groupName = this.myParser.getAttrGroupComment();
            String formatString = this.myParser.getAttributeValue(null, "format");
            Set<Object> formats = StringUtil.isEmpty((String)formatString) ? EnumSet.noneOf(AttributeFormat.class) : AttributeFormat.parse((String)formatString);
            HashMap valueMap = Maps.newHashMapWithExpectedSize((int)8);
            HashMap descriptionMap = Maps.newHashMapWithExpectedSize((int)8);
            this.forSubTags(null, () -> {
                if (this.myParser.getPrefix() == null) {
                    AttributeFormat format;
                    String tagName = this.myParser.getName();
                    Object object = tagName.equals("enum") ? AttributeFormat.ENUM : (format = tagName.equals("flag") ? AttributeFormat.FLAGS : null);
                    if (format != null) {
                        formats.add(format);
                        String valueName = this.myParser.getAttributeValue(null, "name");
                        if (valueName != null) {
                            String valueDescription = this.myParser.getLastComment();
                            if (valueDescription != null) {
                                descriptionMap.put(valueName, valueDescription);
                            }
                            String value2 = this.myParser.getAttributeValue(null, "value");
                            Integer numericValue = null;
                            if (value2 != null) {
                                try {
                                    numericValue = Long.decode(value2).intValue();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            valueMap.put(valueName, numericValue);
                        }
                    }
                }
            });
            if (attrNamespace.equals((Object)this.myNamespace)) {
                ResourceVisibility visibility = this.getVisibility(ResourceType.ATTR, name);
                item = new AarAttrResourceItem(name, sourceFile, visibility, description, groupName, formats, valueMap, descriptionMap);
            } else {
                item = new AarForeignAttrResourceItem(attrNamespace, name, sourceFile, description, groupName, formats, (Map<String, Integer>)valueMap, (Map<String, String>)descriptionMap);
            }
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        @NotNull
        private AarPluralsResourceItem createPluralsItem(@NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException {
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            EnumMap<Arity, String> values = new EnumMap<Arity, String>(Arity.class);
            this.forSubTags("item", () -> {
                Arity quantity;
                String quantityValue = this.myParser.getAttributeValue(null, "quantity");
                if (quantityValue != null && (quantity = Arity.getEnum((String)quantityValue)) != null) {
                    String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                    values.put(quantity, text);
                }
            });
            ResourceVisibility visibility = this.getVisibility(ResourceType.PLURALS, name);
            AarPluralsResourceItem item = new AarPluralsResourceItem(name, sourceFile, visibility, values);
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        @NotNull
        private AarValueResourceItem createStringItem(@NotNull ResourceType type, @NotNull String name, @NotNull AarSourceFile sourceFile, boolean withRowXml) throws IOException, XmlPullParserException {
            String rawXml;
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            String text = type == ResourceType.ID ? null : this.myTextExtractor.extractText((XmlPullParser)this.myParser, withRowXml);
            String string = rawXml = type == ResourceType.ID ? null : this.myTextExtractor.getRawXml();
            assert (withRowXml || rawXml == null);
            ResourceVisibility visibility = this.getVisibility(type, name);
            AarValueResourceItem item = rawXml == null ? new AarValueResourceItem(type, name, sourceFile, visibility, text) : new AarTextValueResourceItem(type, name, sourceFile, visibility, text, rawXml);
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        @NotNull
        private AarStyleResourceItem createStyleItem(@NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException {
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            String parentStyle = this.myParser.getAttributeValue(null, "parent");
            if (parentStyle != null && !parentStyle.isEmpty()) {
                this.myUrlParser.parseResourceUrl(parentStyle);
                this.myUrlParser.getQualifiedName();
            }
            ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>();
            this.forSubTags("item", () -> {
                ResourceNamespace.Resolver itemNamespaceResolver = this.myParser.getNamespaceResolver();
                String itemName = this.myParser.getAttributeValue(null, "name");
                if (itemName != null) {
                    String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                    StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(this.myNamespace, itemName, text, this.myLibraryName);
                    styleItem.setNamespaceResolver(itemNamespaceResolver);
                    styleItems.add((StyleItemResourceValue)styleItem);
                }
            });
            ResourceVisibility visibility = this.getVisibility(ResourceType.STYLE, name);
            AarStyleResourceItem item = new AarStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        @NotNull
        private AarStyleableResourceItem createStyleableItem(@NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException {
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>();
            this.forSubTags("attr", () -> {
                String attrName = this.myParser.getAttributeValue(null, "name");
                if (attrName != null) {
                    try {
                        AarAttrResourceItem attr2 = this.createAttrItem(attrName, sourceFile);
                        attrs.add((AttrResourceValue)(attr2.getFormats().isEmpty() ? attr2 : attr2.createReference()));
                        if (attr2.getNamespace().equals((Object)this.myNamespace) && (this.myNamespace != ResourceNamespace.RES_AUTO || !attr2.getFormats().isEmpty())) {
                            Loader.addAttr(attr2, this.myAttrCandidates);
                        }
                    }
                    catch (XmlSyntaxException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            AarStyleableResourceItem item = new AarStyleableResourceItem(name, sourceFile, ResourceVisibility.PUBLIC, attrs);
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        private static void addAttr(@NotNull AarAttrResourceItem attr2, @NotNull ListMultimap<String, AarAttrResourceItem> map2) {
            List attrs = map2.get((Object)attr2.getName());
            int i2 = Loader.findResourceWithSameNameAndConfiguration((ResourceItem)attr2, attrs);
            if (i2 >= 0) {
                AarAttrResourceItem existing2 = (AarAttrResourceItem)attrs.get(i2);
                if (existing2.getFormats().isEmpty() && !attr2.getFormats().isEmpty()) {
                    attrs.set(i2, attr2);
                }
            } else {
                attrs.add(attr2);
            }
        }

        private void processAttrsAndStyleables() {
            for (AarAttrResourceItem attr2 : this.myAttrs.values()) {
                this.addAttrWithAdjustedFormats(attr2);
            }
            for (AarAttrResourceItem attr2 : this.myAttrCandidates.values()) {
                List attrs;
                int i2 = Loader.findResourceWithSameNameAndConfiguration((ResourceItem)attr2, attrs = this.myAttrs.get((Object)attr2.getName()));
                if (i2 >= 0) continue;
                this.addAttrWithAdjustedFormats(attr2);
            }
            for (AarStyleableResourceItem styleable : this.myStyleables.values()) {
                Loader.addResourceItem(AbstractAarResourceRepository.resolveAttrReferences(styleable));
            }
        }

        private void addAttrWithAdjustedFormats(@NotNull AarAttrResourceItem attr2) {
            if (attr2.getFormats().isEmpty()) {
                attr2 = new AarAttrResourceItem(attr2.getName(), attr2.getSourceFile(), attr2.getVisibility(), attr2.getDescription(), attr2.getGroupName(), this.DEFAULT_ATTR_FORMATS, Collections.emptyMap(), Collections.emptyMap());
            }
            Loader.addResourceItem(attr2);
        }

        private static boolean resourceAlreadyDefined(@NotNull AbstractAarResourceItem resource) {
            AbstractAarResourceRepository repository = resource.getRepository();
            List<ResourceItem> items2 = repository.getResources(resource.getNamespace(), resource.getType(), resource.getName());
            return Loader.findResourceWithSameNameAndConfiguration((ResourceItem)resource, items2) >= 0;
        }

        private static int findResourceWithSameNameAndConfiguration(@NotNull ResourceItem resource, @NotNull List<? extends ResourceItem> items2) {
            for (int i2 = 0; i2 < items2.size(); ++i2) {
                ResourceItem item = items2.get(i2);
                if (!item.getConfiguration().equals((Object)resource.getConfiguration())) continue;
                return i2;
            }
            return -1;
        }

        @NotNull
        private AarValueResourceItem createFileReferenceItem(@NotNull ResourceType type, @NotNull String name, @NotNull AarSourceFile sourceFile) throws IOException, XmlPullParserException {
            ResourceNamespace.Resolver namespaceResolver2 = this.myParser.getNamespaceResolver();
            String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false).trim();
            if (!(text.isEmpty() || text.startsWith("@") || text.startsWith("?"))) {
                text = text.replace('/', File.separatorChar);
            }
            ResourceVisibility visibility = this.getVisibility(type, name);
            AarValueResourceItem item = new AarValueResourceItem(type, name, sourceFile, visibility, text);
            item.setNamespaceResolver(namespaceResolver2);
            return item;
        }

        @Nullable
        private ResourceType getResourceType(@NotNull String tagName, @NotNull Path file) throws XmlSyntaxException {
            ResourceType type = ResourceType.fromXmlTagName((String)tagName);
            if (type == null) {
                String typeAttr;
                if ("eat-comment".equals(tagName) || "skip".equals(tagName)) {
                    return null;
                }
                if (tagName.equals("item") && (typeAttr = this.myParser.getAttributeValue(null, "type")) != null) {
                    type = ResourceType.fromClassName((String)typeAttr);
                    if (type != null) {
                        return type;
                    }
                    throw new XmlSyntaxException("Invalid type attribute \"" + typeAttr + "\"", (XmlPullParser)this.myParser, file);
                }
                throw new XmlSyntaxException("Invalid tag name \"" + tagName + "\"", (XmlPullParser)this.myParser, file);
            }
            return type;
        }

        private void forSubTags(@Nullable String tagName, @NotNull XmlTagVisitor subtagVisitor) throws IOException, XmlPullParserException {
            int event;
            int elementDepth = this.myParser.getDepth();
            do {
                if ((event = this.myParser.nextToken()) != 2 || tagName != null && (!tagName.equals(this.myParser.getName()) || this.myParser.getPrefix() != null)) continue;
                subtagVisitor.visitTag();
            } while (event != 1 && (event != 3 || this.myParser.getDepth() > elementDepth));
        }

        private void validateResourceName(@NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull Path file) throws XmlSyntaxException {
            String error = ValueResourceNameValidator.getErrorText((String)resourceName, (ResourceType)resourceType);
            if (error != null) {
                throw new XmlSyntaxException(error, (XmlPullParser)this.myParser, file);
            }
        }

        @NotNull
        private ResourceVisibility getVisibility(@NotNull ResourceType resourceType, @NotNull String resourceName) {
            Set<String> names = this.myPublicResources.get(resourceType);
            return names != null && names.contains(this.getKeyForVisibilityLookup(resourceName)) ? ResourceVisibility.PUBLIC : this.myDefaultVisibility;
        }

        @NotNull
        protected String getKeyForVisibilityLookup(@NotNull String resourceName) {
            return ResourceNameKeyedMap.flattenResourceName((String)resourceName);
        }

        @NotNull
        private String getRelativePath(@NotNull Path file) {
            return AbstractAarResourceRepository.portableFileName(this.myResourceDirectoryOrFile.relativize(file).toString());
        }

        @NotNull
        private Path getFile(@NotNull AarSourceFile sourceFile) {
            String relativePath = sourceFile.getRelativePath();
            Preconditions.checkArgument((relativePath != null ? 1 : 0) != 0);
            return this.myResourceDirectoryOrFile.resolve(relativePath);
        }
    }
}

