/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AarStyleResourceItem
extends AbstractAarValueResourceItem
implements StyleResourceValue {
    private static final Logger LOG = Logger.getInstance(AarStyleResourceItem.class);
    @Nullable
    private final String myParentStyle;
    @NotNull
    private final Table<ResourceNamespace, String, StyleItemResourceValue> myStyleItemTable;

    public AarStyleResourceItem(@NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String parentStyle, @NotNull Collection<StyleItemResourceValue> styleItems) {
        super(ResourceType.STYLE, name, sourceFile, visibility);
        this.myParentStyle = parentStyle;
        ImmutableTable.Builder tableBuilder = ImmutableTable.builder();
        HashMap<ResourceReference, StyleItemResourceValue> duplicateCheckMap = new HashMap<ResourceReference, StyleItemResourceValue>();
        for (StyleItemResourceValue styleItem : styleItems) {
            ResourceReference attr2 = styleItem.getAttr();
            if (attr2 == null) continue;
            StyleItemResourceValue previouslyDefined = duplicateCheckMap.put(attr2, styleItem);
            if (previouslyDefined == null) {
                tableBuilder.put((Object)attr2.getNamespace(), (Object)attr2.getName(), (Object)styleItem);
                continue;
            }
            if (previouslyDefined.equals(styleItem)) continue;
            LOG.warn("Conflicting definitions of \"" + styleItem.getAttrName() + "\" in style \"" + name + "\"");
        }
        this.myStyleItemTable = tableBuilder.build();
    }

    @Nullable
    public String getParentStyleName() {
        return this.myParentStyle;
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceNamespace namespace, @NotNull String name) {
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)namespace, (Object)name);
    }

    @Nullable
    public StyleItemResourceValue getItem(@NotNull ResourceReference attr2) {
        assert (attr2.getResourceType() == ResourceType.ATTR);
        return (StyleItemResourceValue)this.myStyleItemTable.get((Object)attr2.getNamespace(), (Object)attr2.getName());
    }

    @NotNull
    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.myStyleItemTable.values();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarStyleResourceItem other = (AarStyleResourceItem)obj;
        return Objects.equals(this.myParentStyle, other.myParentStyle) && this.myStyleItemTable.equals(other.myStyleItemTable);
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myParentStyle);
        stream.writeInt(this.myStyleItemTable.size());
        for (StyleItemResourceValue styleItem : this.myStyleItemTable.values()) {
            stream.writeString(styleItem.getAttrName());
            stream.writeString(styleItem.getValue());
            int index = namespaceResolverIndexes.get((Object)styleItem.getNamespaceResolver());
            assert (index >= 0);
            stream.writeInt(index);
        }
    }

    @NotNull
    static AarStyleResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull AarSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        AbstractAarResourceRepository repository = sourceFile.getConfiguration().getRepository();
        ResourceNamespace namespace = repository.getNamespace();
        String libraryName = repository.getLibraryName();
        String parentStyle = stream.readString();
        int n = stream.readInt();
        ArrayList<StyleItemResourceValue> styleItems = n == 0 ? Collections.emptyList() : new ArrayList<StyleItemResourceValue>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            String attrName = stream.readString();
            if (attrName == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            String value2 = stream.readString();
            ResourceNamespace.Resolver itemResolver = namespaceResolvers.get(stream.readInt());
            StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(namespace, attrName, value2, libraryName);
            styleItem.setNamespaceResolver(itemResolver);
            styleItems.add((StyleItemResourceValue)styleItem);
        }
        AarStyleResourceItem item = new AarStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

