/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarAttrResourceItem;
import com.android.tools.idea.resources.aar.AarConfiguration;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.google.common.collect.ImmutableList;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AarStyleableResourceItem
extends AbstractAarValueResourceItem
implements StyleableResourceValue {
    @NotNull
    private final List<AttrResourceValue> myAttrs;

    public AarStyleableResourceItem(@NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull List<AttrResourceValue> attrs) {
        super(ResourceType.STYLEABLE, name, sourceFile, visibility);
        this.myAttrs = ImmutableList.copyOf(attrs);
    }

    @NotNull
    public List<AttrResourceValue> getAllAttributes() {
        return this.myAttrs;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarStyleableResourceItem other = (AarStyleableResourceItem)obj;
        return this.myAttrs.equals(other.myAttrs);
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeInt(this.myAttrs.size());
        for (AttrResourceValue attr2 : this.myAttrs) {
            if (attr2 instanceof AarAttrResourceItem && !attr2.getFormats().isEmpty()) {
                attr2 = ((AarAttrResourceItem)attr2).createReference();
            }
            ((AbstractAarValueResourceItem)attr2).serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        }
    }

    @NotNull
    static AarStyleableResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull AarSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver, @NotNull List<AarConfiguration> configurations, @NotNull List<AarSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        AbstractAarResourceRepository repository = sourceFile.getConfiguration().getRepository();
        int n = stream.readInt();
        ArrayList<AttrResourceValue> attrs = n == 0 ? Collections.emptyList() : new ArrayList<AttrResourceValue>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            AbstractAarResourceItem attrItem = AarStyleableResourceItem.deserialize(stream, configurations, sourceFiles, namespaceResolvers);
            if (!(attrItem instanceof AttrResourceValue)) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            AttrResourceValue attr2 = repository.getCanonicalAttr((AttrResourceValue)attrItem);
            attrs.add(attr2);
        }
        AarStyleableResourceItem item = new AarStyleableResourceItem(name, sourceFile, visibility, attrs);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

