/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AarTextValueResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.utils.HashCodes;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AarValueResourceItem
extends AbstractAarValueResourceItem {
    @Nullable
    private final String myValue;

    public AarValueResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String value2) {
        super(type, name, sourceFile, visibility);
        this.myValue = value2;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AarValueResourceItem other = (AarValueResourceItem)obj;
        return Objects.equals(this.myValue, other.myValue);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)Objects.hashCode(this.myValue));
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myValue);
        String rawXmlValue = this.getRawXmlValue();
        stream.writeString(Objects.equals(rawXmlValue, this.myValue) ? null : rawXmlValue);
    }

    @NotNull
    static AarValueResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull AarSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        String value2 = stream.readString();
        String rawXmlValue = stream.readString();
        AarValueResourceItem item = rawXmlValue == null ? new AarValueResourceItem(resourceType, name, sourceFile, visibility, value2) : new AarTextValueResourceItem(resourceType, name, sourceFile, visibility, value2, rawXmlValue);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

