/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarConfiguration;
import com.android.tools.idea.resources.aar.AarFileResourceItem;
import com.android.tools.idea.resources.aar.AarResourceItem;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.AbstractAarValueResourceItem;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractAarResourceItem
implements AarResourceItem,
ResourceValue {
    @NotNull
    private final String myName;
    private final byte myTypeOrdinal;
    private final byte myVisibilityOrdinal;

    AbstractAarResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceVisibility visibility) {
        this.myName = name;
        this.myTypeOrdinal = (byte)type.ordinal();
        this.myVisibilityOrdinal = (byte)visibility.ordinal();
    }

    @NotNull
    public final ResourceType getType() {
        return this.getResourceType();
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.getRepository().getNamespace();
    }

    @NotNull
    public final String getName() {
        return this.myName;
    }

    @Nullable
    public final String getLibraryName() {
        return this.getRepository().getLibraryName();
    }

    @NotNull
    public final ResourceType getResourceType() {
        return ResourceType.values()[this.myTypeOrdinal];
    }

    @NotNull
    public final ResourceVisibility getVisibility() {
        return ResourceVisibility.values()[this.myVisibilityOrdinal];
    }

    @NotNull
    public final ResourceReference getReferenceToSelf() {
        return this.asReference();
    }

    @NotNull
    public final ResourceValue getResourceValue() {
        return this;
    }

    public final boolean isUserDefined() {
        return false;
    }

    public final boolean isFramework() {
        return this.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    @NotNull
    public final ResourceReference asReference() {
        return new ResourceReference(this.getNamespace(), this.getResourceType(), this.myName);
    }

    @NotNull
    protected abstract AbstractAarResourceRepository getRepository();

    @NotNull
    public final String getKey() {
        String qualifiers = this.getConfiguration().getQualifierString();
        if (!qualifiers.isEmpty()) {
            return this.getType().getName() + '-' + qualifiers + '/' + this.getName();
        }
        return this.getType().getName() + '/' + this.getName();
    }

    public final void setValue(@Nullable String value2) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAarResourceItem other = (AbstractAarResourceItem)obj;
        return this.myTypeOrdinal == other.myTypeOrdinal && this.myName.equals(other.myName) && this.myVisibilityOrdinal == other.myVisibilityOrdinal;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myTypeOrdinal, (int)this.myName.hashCode());
    }

    @NotNull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).toString();
    }

    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        stream.writeInt((this.myTypeOrdinal << 1) + (this.isFileBased() ? 1 : 0));
        stream.writeString(this.myName);
        stream.writeInt(this.myVisibilityOrdinal);
    }

    @NotNull
    static AbstractAarResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull List<AarConfiguration> configurations, @NotNull List<AarSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        int encodedType = stream.readInt();
        boolean isFileBased = (encodedType & 1) != 0;
        ResourceType resourceType = ResourceType.values()[encodedType >>> 1];
        String name = stream.readString();
        if (name == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        ResourceVisibility visibility = ResourceVisibility.values()[stream.readInt()];
        if (isFileBased) {
            return AarFileResourceItem.deserialize(stream, resourceType, name, visibility, configurations);
        }
        return AbstractAarValueResourceItem.deserialize(stream, resourceType, name, visibility, configurations, sourceFiles, namespaceResolvers);
    }
}

