/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.resources.aar.AarStyleableResourceItem;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAarResourceRepository
extends AbstractResourceRepository
implements AarResourceRepository {
    @NotNull
    protected final ResourceNamespace myNamespace;
    @NotNull
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    @NotNull
    private final Map<ResourceType, Set<ResourceItem>> myPublicResources = new EnumMap<ResourceType, Set<ResourceItem>>(ResourceType.class);
    @Nullable
    protected final String myLibraryName;

    protected AbstractAarResourceRepository(@NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        this.myNamespace = namespace;
        this.myLibraryName = libraryName;
    }

    @NotNull
    protected final ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return ImmutableListMultimap.of();
        }
        return this.myResources.getOrDefault(resourceType, (ListMultimap<String, ResourceItem>)ImmutableListMultimap.of());
    }

    @NotNull
    protected final ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
        return this.myResources.computeIfAbsent(resourceType, type -> ArrayListMultimap.create());
    }

    protected final void addResourceItem(@NotNull ResourceItem item) {
        ListMultimap<String, ResourceItem> multimap = this.getOrCreateMap(item.getType());
        multimap.put((Object)item.getName(), (Object)item);
    }

    protected final void populatePublicResourcesMap() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            ResourceType resourceType = entry.getKey();
            ImmutableSet.Builder setBuilder = null;
            ListMultimap<String, ResourceItem> items2 = entry.getValue();
            for (ResourceItem item : items2.values()) {
                if (((ResourceItemWithVisibility)item).getVisibility() != ResourceVisibility.PUBLIC) continue;
                if (setBuilder == null) {
                    setBuilder = ImmutableSet.builder();
                }
                setBuilder.add((Object)item);
            }
            this.myPublicResources.put(resourceType, (Set<ResourceItem>)(setBuilder == null ? ImmutableSet.of() : setBuilder.build()));
        }
    }

    @NotNull
    static AarStyleableResourceItem resolveAttrReferences(@NotNull AarStyleableResourceItem styleable) {
        AbstractAarResourceRepository repository = styleable.getRepository();
        List<AttrResourceValue> attributes = styleable.getAllAttributes();
        ArrayList<AttrResourceValue> resolvedAttributes = null;
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            AttrResourceValue attr2 = attributes.get(i2);
            AttrResourceValue canonicalAttr = repository.getCanonicalAttr(attr2);
            if (canonicalAttr != attr2) {
                if (resolvedAttributes == null) {
                    resolvedAttributes = new ArrayList<AttrResourceValue>(attributes.size());
                    for (int j = 0; j < i2; ++j) {
                        resolvedAttributes.add(attributes.get(j));
                    }
                }
                resolvedAttributes.add(canonicalAttr);
                continue;
            }
            if (resolvedAttributes == null) continue;
            resolvedAttributes.add(attr2);
        }
        if (resolvedAttributes != null) {
            ResourceNamespace.Resolver namespaceResolver2 = styleable.getNamespaceResolver();
            styleable = new AarStyleableResourceItem(styleable.getName(), styleable.getSourceFile(), styleable.getVisibility(), resolvedAttributes);
            styleable.setNamespaceResolver(namespaceResolver2);
        }
        return styleable;
    }

    protected void freezeResources() {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : this.myResources.entrySet()) {
            this.myResources.put(entry.getKey(), (ListMultimap<String, ResourceItem>)ImmutableListMultimap.copyOf((Multimap)((Multimap)entry.getValue())));
        }
    }

    public void accept(@NotNull ResourceVisitor visitor) {
        if (visitor.shouldVisitNamespace(this.myNamespace)) {
            AbstractResourceRepository.acceptByResources(this.myResources, (ResourceVisitor)visitor);
        }
    }

    @NotNull
    public List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        ListMultimap<String, ResourceItem> map2 = this.getResourcesInternal(namespace, resourceType);
        List items2 = map2.get((Object)resourceName);
        return items2 == null ? ImmutableList.of() : items2;
    }

    @NotNull
    public ListMultimap<String, ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        return this.getResourcesInternal(namespace, resourceType);
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return Collections.emptySet();
        }
        Set<ResourceItem> resourceItems = this.myPublicResources.get(type);
        return resourceItems == null ? Collections.emptySet() : resourceItems;
    }

    @NotNull
    public final ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Override
    @Nullable
    public final String getLibraryName() {
        return this.myLibraryName;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myLibraryName == null ? "Android Framework" : this.myLibraryName;
    }

    @NotNull
    abstract String getResourceUrl(@NotNull String var1);

    @NotNull
    abstract PathString getSourceFile(@NotNull String var1, boolean var2);

    @Nullable
    PathString getOriginalSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return this.getSourceFile(relativeResourcePath, forFileResource);
    }

    @NotNull
    abstract Path getOrigin();

    @NotNull
    AttrResourceValue getCanonicalAttr(@NotNull AttrResourceValue attr2) {
        if (attr2.getFormats().isEmpty()) {
            List<ResourceItem> items2 = this.getResources(attr2.getNamespace(), ResourceType.ATTR, attr2.getName());
            for (ResourceItem item : items2) {
                if (!(item instanceof AttrResourceValue) || !Objects.equals(((AttrResourceValue)item).getDescription(), attr2.getDescription()) || !Objects.equals(((AttrResourceValue)item).getGroupName(), attr2.getGroupName())) continue;
                return (AttrResourceValue)item;
            }
        }
        return attr2;
    }

    @NotNull
    protected static String portableFileName(@NotNull String fileName) {
        return fileName.replace(File.separatorChar, '/');
    }

    protected static final class ResourceUrlParser {
        @NotNull
        private String resourceUrl = "";
        private int prefixEnd;
        private int colonPos;
        private int slashPos;
        private int typeStart;
        private int namespacePrefixStart;
        private int nameStart;

        protected ResourceUrlParser() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void parseResourceUrl(@NotNull String resourceUrl) {
            this.resourceUrl = resourceUrl;
            this.colonPos = -1;
            this.slashPos = -1;
            this.typeStart = -1;
            this.namespacePrefixStart = -1;
            this.prefixEnd = resourceUrl.startsWith("@") ? (resourceUrl.startsWith("@+") ? 2 : 1) : (resourceUrl.startsWith("?") ? 1 : 0);
            if (resourceUrl.startsWith("*", this.prefixEnd)) {
                ++this.prefixEnd;
            }
            int len = resourceUrl.length();
            int start = this.prefixEnd;
            block4: for (int i2 = this.prefixEnd; i2 < len; ++i2) {
                char c = resourceUrl.charAt(i2);
                switch (c) {
                    case '/': {
                        if (this.slashPos >= 0) break;
                        this.slashPos = i2;
                        this.typeStart = start;
                        start = i2 + 1;
                        if (this.colonPos < 0) break;
                        break block4;
                    }
                    case ':': {
                        if (this.colonPos >= 0) break;
                        this.colonPos = i2;
                        this.namespacePrefixStart = start;
                        start = i2 + 1;
                        if (this.slashPos >= 0) break block4;
                    }
                }
            }
            this.nameStart = start;
        }

        @Nullable
        public String getNamespacePrefix() {
            return this.colonPos >= 0 ? this.resourceUrl.substring(this.namespacePrefixStart, this.colonPos) : null;
        }

        @Nullable
        public String getType() {
            return this.slashPos >= 0 ? this.resourceUrl.substring(this.typeStart, this.slashPos) : null;
        }

        @NotNull
        public String getName() {
            return this.resourceUrl.substring(this.nameStart);
        }

        @NotNull
        public String getQualifiedName() {
            if (this.colonPos < 0) {
                return this.getName();
            }
            if (this.nameStart == this.colonPos + 1) {
                return this.resourceUrl.substring(this.namespacePrefixStart);
            }
            return this.resourceUrl.substring(this.namespacePrefixStart, this.colonPos + 1) + this.getName();
        }

        public boolean hasType(@NotNull String type) {
            if (this.slashPos < 0) {
                return false;
            }
            return this.slashPos == this.typeStart + type.length() && this.resourceUrl.startsWith(type, this.typeStart);
        }

        public boolean hasNamespacePrefix(@NotNull String namespacePrefix) {
            if (this.colonPos < 0) {
                return false;
            }
            return this.colonPos == this.namespacePrefixStart + namespacePrefix.length() && this.resourceUrl.startsWith(namespacePrefix, this.namespacePrefixStart);
        }
    }
}

