/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.aar.AarArrayResourceItem;
import com.android.tools.idea.resources.aar.AarAttrResourceItem;
import com.android.tools.idea.resources.aar.AarConfiguration;
import com.android.tools.idea.resources.aar.AarPluralsResourceItem;
import com.android.tools.idea.resources.aar.AarSourceFile;
import com.android.tools.idea.resources.aar.AarStyleResourceItem;
import com.android.tools.idea.resources.aar.AarStyleableResourceItem;
import com.android.tools.idea.resources.aar.AarValueResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarResourceItem;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.utils.HashCodes;
import com.intellij.util.containers.ObjectIntHashMap;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractAarValueResourceItem
extends AbstractAarResourceItem {
    @NotNull
    private final AarSourceFile mySourceFile;
    @NotNull
    private ResourceNamespace.Resolver myNamespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;

    public AbstractAarValueResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull AarSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
        super(type, name, visibility);
        this.mySourceFile = sourceFile;
    }

    @Nullable
    public String getValue() {
        return null;
    }

    public final boolean isFileBased() {
        return false;
    }

    @NotNull
    public final FolderConfiguration getConfiguration() {
        return this.mySourceFile.getConfiguration().getFolderConfiguration();
    }

    @Override
    @NotNull
    protected final AbstractAarResourceRepository getRepository() {
        return this.mySourceFile.getConfiguration().getRepository();
    }

    @NotNull
    public final ResourceNamespace.Resolver getNamespaceResolver() {
        return this.myNamespaceResolver;
    }

    public final void setNamespaceResolver(@NotNull ResourceNamespace.Resolver resolver) {
        this.myNamespaceResolver = resolver;
    }

    @Nullable
    public final PathString getSource() {
        return this.getOriginalSource();
    }

    @Nullable
    public final PathString getOriginalSource() {
        String sourcePath = this.mySourceFile.getRelativePath();
        return sourcePath == null ? null : this.getRepository().getOriginalSourceFile(sourcePath, false);
    }

    @NotNull
    final AarSourceFile getSourceFile() {
        return this.mySourceFile;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractAarValueResourceItem other = (AbstractAarValueResourceItem)obj;
        return Objects.equals(this.mySourceFile, other.mySourceFile);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)Objects.hashCode(this.mySourceFile));
    }

    @Override
    void serialize(@NotNull Base128OutputStream stream, @NotNull ObjectIntHashMap<String> configIndexes, @NotNull ObjectIntHashMap<AarSourceFile> sourceFileIndexes, @NotNull ObjectIntHashMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int index = sourceFileIndexes.get((Object)this.mySourceFile);
        assert (index >= 0);
        stream.writeInt(index);
        index = namespaceResolverIndexes.get((Object)this.myNamespaceResolver);
        assert (index >= 0);
        stream.writeInt(index);
    }

    @NotNull
    static AbstractAarValueResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull List<AarConfiguration> configurations, @NotNull List<AarSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        AarSourceFile sourceFile = sourceFiles.get(stream.readInt());
        ResourceNamespace.Resolver resolver = namespaceResolvers.get(stream.readInt());
        switch (resourceType) {
            case ARRAY: {
                return AarArrayResourceItem.deserialize(stream, name, visibility, sourceFile, resolver);
            }
            case ATTR: {
                return AarAttrResourceItem.deserialize(stream, name, visibility, sourceFile, resolver);
            }
            case PLURALS: {
                return AarPluralsResourceItem.deserialize(stream, name, visibility, sourceFile, resolver);
            }
            case STYLE: {
                return AarStyleResourceItem.deserialize(stream, name, visibility, sourceFile, resolver, namespaceResolvers);
            }
            case STYLEABLE: {
                return AarStyleableResourceItem.deserialize(stream, name, visibility, sourceFile, resolver, configurations, sourceFiles, namespaceResolvers);
            }
        }
        return AarValueResourceItem.deserialize(stream, resourceType, name, visibility, sourceFile, resolver);
    }
}

