/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.tools.idea.resources.aar.FrameworkResourceRepository;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class FrameworkResJarCreator {
    public static void main(@NotNull String[] args) {
        if (args.length != 2) {
            FrameworkResJarCreator.printUsage(FrameworkResJarCreator.class.getName());
            System.exit(1);
        }
        Path resDirectory = Paths.get(args[0], new String[0]).toAbsolutePath().normalize();
        Path jarFile = Paths.get(args[1], new String[0]).toAbsolutePath().normalize();
        try {
            FrameworkResJarCreator.createJar(resDirectory, jarFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createJar(@NotNull Path resDirectory, @NotNull Path jarFile) throws IOException {
        try (final ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            FrameworkResJarCreator.createZipEntry("resources.bin", FrameworkResJarCreator.getEncodedResources(resDirectory, true), zip);
            FrameworkResJarCreator.createZipEntry("resources_light.bin", FrameworkResJarCreator.getEncodedResources(resDirectory, false), zip);
            final Path parentDir = resDirectory.getParent();
            Files.walkFileTree(resDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    String relativePath = FileUtil.toSystemIndependentName((String)parentDir.relativize(file).toString());
                    if (!relativePath.equals("res/version")) {
                        FrameworkResJarCreator.createZipEntry(relativePath, Files.readAllBytes(file), zip);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void createZipEntry(@NotNull String name, @NotNull byte[] content, @NotNull ZipOutputStream zip) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        zip.putNextEntry(entry);
        zip.write(content);
        zip.closeEntry();
    }

    private static byte[] getEncodedResources(@NotNull Path resDirectory, boolean withLocaleResources) throws IOException {
        FrameworkResourceRepository repository = FrameworkResourceRepository.create(resDirectory, withLocaleResources, false, null);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(byteStream);){
            repository.writeToStream(stream);
        }
        return byteStream.toByteArray();
    }

    private static void printUsage(@NotNull String programName) {
        System.out.println(String.format("Usage: %s <res_directory> <jar_file>", programName));
    }
}

