/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.resources.aar.AarSourceResourceRepository;
import com.android.tools.idea.resources.aar.AbstractAarResourceRepository;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.android.tools.idea.resources.aar.CommentTrackingXmlPullParser;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrameworkResourceRepository
extends AarSourceResourceRepository {
    private static final ResourceNamespace ANDROID_NAMESPACE = ResourceNamespace.ANDROID;
    private static final String CACHE_DIRECTORY = "caches/framework_resources";
    private static final byte[] CACHE_FILE_HEADER = "Framework resource cache".getBytes(StandardCharsets.UTF_8);
    private static final String CACHE_FILE_FORMAT_VERSION = "6";
    static final String ENTRY_NAME_WITH_LOCALES = "resources.bin";
    static final String ENTRY_NAME_WITHOUT_LOCALES = "resources_light.bin";
    private static final Logger LOG = Logger.getInstance(FrameworkResourceRepository.class);
    private final boolean myWithLocaleResources;

    private FrameworkResourceRepository(@NotNull MyLoader loader) {
        super(loader);
        this.myWithLocaleResources = loader.myWithLocaleResources;
    }

    @NotNull
    public static FrameworkResourceRepository create(@NotNull Path resFolderOrJar, boolean withLocaleResources) {
        return FrameworkResourceRepository.create(resFolderOrJar, withLocaleResources, false, null);
    }

    @NotNull
    public static FrameworkResourceRepository create(@NotNull Path resFolderOrJar, boolean withLocaleResources, boolean usePersistentCache, @Nullable Executor cacheCreationExecutor) {
        MyLoader loader = new MyLoader(resFolderOrJar, withLocaleResources);
        FrameworkResourceRepository repository = new FrameworkResourceRepository(loader);
        if (!loader.myLoadFromJar && usePersistentCache && repository.loadFromPersistentCache()) {
            return repository;
        }
        loader.loadRepositoryContents(repository);
        if (!loader.myLoadFromJar && usePersistentCache && cacheCreationExecutor != null) {
            cacheCreationExecutor.execute(() -> repository.createPersistentCache());
        }
        return repository;
    }

    @Override
    @Nullable
    public String getPackageName() {
        return ANDROID_NAMESPACE.getPackageName();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Android framework";
    }

    @VisibleForTesting
    @NotNull
    static Path getCacheFile(@NotNull Path resourceDir, boolean withLocaleResources) {
        String dirHash = Hashing.md5().hashUnencodedChars((CharSequence)resourceDir.toString()).toString();
        String filename = String.format("%s%s.bin", dirHash, withLocaleResources ? "_L" : "");
        return Paths.get(PathManager.getSystemPath(), CACHE_DIRECTORY, filename);
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull ResourceNamespace namespace) {
        return namespace == ANDROID_NAMESPACE ? Sets.immutableEnumSet(this.myResources.keySet()) : ImmutableSet.of();
    }

    public boolean isWithLocaleResources() {
        return this.myWithLocaleResources;
    }

    private boolean loadFromPersistentCache() {
        byte[] header = this.getCacheFileHeader();
        return this.loadFromPersistentCache(this.getCacheFile(), header);
    }

    private void createPersistentCache() {
        byte[] header = this.getCacheFileHeader();
        this.createPersistentCache(this.getCacheFile(), header);
    }

    private byte[] getCacheFileHeader() {
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(header);){
            stream.write(CACHE_FILE_HEADER);
            stream.writeString(CACHE_FILE_FORMAT_VERSION);
            stream.writeString(this.myResourceDirectoryOrFile.toString());
            stream.writeString(this.getResourcesVersion());
            stream.writeBoolean(this.myWithLocaleResources);
        }
        catch (IOException e) {
            throw new Error("Internal error", e);
        }
        return header.toByteArray();
    }

    @NotNull
    private Path getCacheFile() {
        return FrameworkResourceRepository.getCacheFile(this.myResourceDirectoryOrFile, this.myWithLocaleResources);
    }

    @NotNull
    private String getResourcesVersion() {
        try {
            if (FrameworkResourceRepository.isJarFile(this.myResourceDirectoryOrFile)) {
                return Files.getLastModifiedTime(this.myResourceDirectoryOrFile, new LinkOption[0]).toString();
            }
            return new String(Files.readAllBytes(this.myResourceDirectoryOrFile.resolve("version")), StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static boolean isJarFile(@NotNull Path resourceDirectoryOrFile) {
        return SdkUtils.endsWithIgnoreCase((String)resourceDirectoryOrFile.getFileName().toString(), (String)".jar");
    }

    private static class MyLoader
    extends AarSourceResourceRepository.Loader {
        private final boolean myLoadFromJar;
        private final boolean myWithLocaleResources;

        MyLoader(@NotNull Path resourceDirectoryOrFile, boolean withLocaleResources) {
            super(resourceDirectoryOrFile, null, ANDROID_NAMESPACE, null);
            this.myLoadFromJar = FrameworkResourceRepository.isJarFile(resourceDirectoryOrFile);
            this.myWithLocaleResources = withLocaleResources;
        }

        @Override
        protected void loadRepositoryContents(@NotNull AarSourceResourceRepository repository) {
            if (this.myLoadFromJar) {
                this.loadFromJar(repository);
            } else {
                super.loadRepositoryContents(repository);
            }
        }

        private void loadFromJar(@NotNull AarSourceResourceRepository repository) {
            try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
                String entryName = this.myWithLocaleResources ? FrameworkResourceRepository.ENTRY_NAME_WITH_LOCALES : FrameworkResourceRepository.ENTRY_NAME_WITHOUT_LOCALES;
                ZipEntry zipEntry = zipFile.getEntry(entryName);
                if (zipEntry == null) {
                    throw new IOException("\"" + entryName + "\" not found in " + this.myResourceDirectoryOrFile.toString());
                }
                try (Base128InputStream stream = new Base128InputStream(zipFile.getInputStream(zipEntry));){
                    repository.loadFromStream(stream);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
        }

        @Override
        @NotNull
        protected String getSourceFileProtocol() {
            if (this.myLoadFromJar) {
                return "jar";
            }
            return "file";
        }

        @Override
        @NotNull
        protected String getResourcePathPrefix() {
            if (this.myLoadFromJar) {
                return this.myResourceDirectoryOrFile.toString() + "!/" + "res/";
            }
            return this.myResourceDirectoryOrFile.toString() + File.separatorChar;
        }

        @Override
        @NotNull
        protected String getResourceUrlPrefix() {
            if (this.myLoadFromJar) {
                return "jar://" + AbstractAarResourceRepository.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/" + "res/";
            }
            return AbstractAarResourceRepository.portableFileName(this.myResourceDirectoryOrFile.toString()) + '/';
        }

        @Override
        @Nullable
        protected Set<String> loadIdsFromRTxt() {
            return null;
        }

        @Override
        public boolean isIgnored(@NotNull Path fileOrDirectory, @NotNull BasicFileAttributes attrs) {
            if (super.isIgnored(fileOrDirectory, attrs)) {
                return true;
            }
            String fileName = fileOrDirectory.getFileName().toString();
            if (attrs.isDirectory()) {
                FolderConfiguration config;
                if (fileName.startsWith("values-mcc") || fileName.startsWith("raw") && (fileName.length() == "raw".length() || fileName.charAt("raw".length()) == '-')) {
                    return true;
                }
                if (!this.myWithLocaleResources && fileName.startsWith("values-") && ((config = FolderConfiguration.getConfigForFolder((String)fileName)) == null || config.getLocaleQualifier() != null)) {
                    return true;
                }
            } else if ((fileName.equals("public.xml") || fileName.equals("symbols.xml")) && "values".equals(new PathString(fileOrDirectory).getParentFileName())) {
                return true;
            }
            return false;
        }

        @Override
        protected void loadPublicResourceNames() {
            Path valuesFolder = this.myResourceDirectoryOrFile.resolve("values");
            Path publicXmlFile = valuesFolder.resolve("public.xml");
            try (BufferedInputStream stream2 = new BufferedInputStream(Files.newInputStream(publicXmlFile, new OpenOption[0]));){
                CommentTrackingXmlPullParser parser = new CommentTrackingXmlPullParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput(stream2, StandardCharsets.UTF_8.name());
                ResourceType groupType = null;
                ResourceType lastType = null;
                String lastTypeName = "";
                while (true) {
                    int event;
                    if ((event = parser.nextToken()) == 2) {
                        if (parser.getName().equals("public")) {
                            ResourceType type;
                            String name = null;
                            String typeName = groupType == null ? null : groupType.getName();
                            int n = parser.getAttributeCount();
                            for (int i2 = 0; i2 < n; ++i2) {
                                String attribute = parser.getAttributeName(i2);
                                if (attribute.equals("name")) {
                                    name = parser.getAttributeValue(i2);
                                    if (typeName == null) continue;
                                    break;
                                }
                                if (!attribute.equals("type")) continue;
                                typeName = parser.getAttributeValue(i2);
                            }
                            if (name == null || name.startsWith("__removed") || typeName == null && groupType == null || parser.getLastComment() != null && parser.getLastComment().startsWith("@hide ")) continue;
                            if (groupType != null) {
                                type = groupType;
                            } else if (typeName.equals(lastTypeName)) {
                                type = lastType;
                            } else {
                                lastType = type = ResourceType.fromXmlValue((String)typeName);
                                lastTypeName = typeName;
                            }
                            if (type != null) {
                                Set names = this.myPublicResources.computeIfAbsent(type, t -> new HashSet());
                                names.add(name);
                                continue;
                            }
                            LOG.error("Public resource declaration \"" + name + "\" of type " + typeName + " points to unknown resource type.");
                            continue;
                        }
                        if (!parser.getName().equals("public-group")) continue;
                        String typeName = parser.getAttributeValue(null, "type");
                        groupType = typeName == null ? null : ResourceType.fromXmlValue((String)typeName);
                        continue;
                    }
                    if (event == 3) {
                        if (!parser.getName().equals("public-group")) continue;
                        groupType = null;
                        continue;
                    }
                    if (event == 1) break;
                }
            }
            catch (NoSuchFileException stream2) {
            }
            catch (Exception e) {
                LOG.error("Can't read and parse " + publicXmlFile.toString(), (Throwable)e);
            }
        }

        @Override
        @NotNull
        protected String getKeyForVisibilityLookup(@NotNull String resourceName) {
            return resourceName;
        }
    }
}

