/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.resources.aar.Base128InputStream;
import com.android.tools.idea.resources.aar.Base128OutputStream;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

final class NamespaceResolver
implements ResourceNamespace.Resolver {
    static final NamespaceResolver EMPTY = new NamespaceResolver(ArrayUtil.EMPTY_STRING_ARRAY);
    @NotNull
    private final String[] prefixesAndUris;

    NamespaceResolver(@NotNull XmlPullParser parser) throws XmlPullParserException {
        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
        this.prefixesAndUris = new String[namespaceCount * 2];
        int j = this.prefixesAndUris.length;
        for (int i2 = 0; i2 < namespaceCount; ++i2) {
            this.prefixesAndUris[--j] = parser.getNamespaceUri(i2);
            this.prefixesAndUris[--j] = parser.getNamespacePrefix(i2);
        }
    }

    private NamespaceResolver(@NotNull String[] prefixesAndUris) {
        this.prefixesAndUris = prefixesAndUris;
    }

    int getNamespaceCount() {
        return this.prefixesAndUris.length / 2;
    }

    @Nullable
    public String prefixToUri(@NotNull String namespacePrefix) {
        for (int i2 = 0; i2 < this.prefixesAndUris.length; i2 += 2) {
            if (!namespacePrefix.equals(this.prefixesAndUris[i2])) continue;
            return this.prefixesAndUris[i2 + 1];
        }
        return null;
    }

    @Nullable
    public String uriToPrefix(@NotNull String namespaceUri) {
        for (int i2 = 0; i2 < this.prefixesAndUris.length; i2 += 2) {
            if (!namespaceUri.equals(this.prefixesAndUris[i2 + 1])) continue;
            return this.prefixesAndUris[i2];
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceResolver other = (NamespaceResolver)obj;
        return Arrays.equals(this.prefixesAndUris, other.prefixesAndUris);
    }

    public int hashCode() {
        return Arrays.hashCode(this.prefixesAndUris);
    }

    void serialize(@NotNull Base128OutputStream stream) throws IOException {
        stream.writeInt(this.getNamespaceCount());
        for (String str : this.prefixesAndUris) {
            stream.writeString(str);
        }
    }

    @NotNull
    static NamespaceResolver deserialize(@NotNull Base128InputStream stream) throws IOException {
        int n = stream.readInt() * 2;
        String[] prefixesAndUris = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            String s = stream.readString();
            if (s == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            prefixesAndUris[i2] = s;
        }
        return new NamespaceResolver(prefixesAndUris);
    }
}

