/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.ExecutorIconProvider;
import com.android.tools.idea.run.FileSystemApkProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.NonGradleApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.activity.DefaultStartActivityFlagsProvider;
import com.android.tools.idea.run.activity.InstantAppStartActivityFlagsProvider;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeepLinkLaunch;
import com.android.tools.idea.run.editor.DefaultActivityLaunch;
import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.NoLaunch;
import com.android.tools.idea.run.editor.SpecificActivityLaunch;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.RunStats;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidAppRunConfigurationBase
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider,
RunnerIconProvider {
    @NonNls
    private static final String FEATURE_LIST_SEPARATOR = ",";
    @NonNls
    public static final String LAUNCH_DEFAULT_ACTIVITY = "default_activity";
    @NonNls
    public static final String LAUNCH_SPECIFIC_ACTIVITY = "specific_activity";
    @NonNls
    public static final String DO_NOTHING = "do_nothing";
    @NonNls
    public static final String LAUNCH_DEEP_LINK = "launch_deep_link";
    public static final List<? extends LaunchOption> LAUNCH_OPTIONS = Arrays.asList(NoLaunch.INSTANCE, DefaultActivityLaunch.INSTANCE, SpecificActivityLaunch.INSTANCE, DeepLinkLaunch.INSTANCE);
    public boolean DEPLOY = true;
    public boolean DEPLOY_APK_FROM_BUNDLE = false;
    public boolean DEPLOY_AS_INSTANT = false;
    public String ARTIFACT_NAME = "";
    public String PM_INSTALL_OPTIONS = "";
    public String DYNAMIC_FEATURES_DISABLED_LIST = "";
    public String ACTIVITY_EXTRA_FLAGS = "";
    public String MODE = "default_activity";
    private final Map<String, LaunchOptionState> myLaunchOptionStates = Maps.newHashMap();

    public AndroidAppRunConfigurationBase(Project project, ConfigurationFactory factory) {
        super(project, factory, false);
        for (LaunchOption launchOption : LAUNCH_OPTIONS) {
            this.myLaunchOptionStates.put(launchOption.getId(), (LaunchOptionState)launchOption.createState());
        }
        this.putUserData(BaseAction.SHOW_APPLY_CHANGES_UI, true);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
    }

    @Override
    @NotNull
    protected List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        LaunchOptionState launchOptionState = this.getLaunchOptionState(this.MODE);
        if (launchOptionState != null) {
            errors.addAll(launchOptionState.checkConfiguration(facet));
        }
        errors.addAll(this.checkDeployConfiguration(facet));
        return errors;
    }

    @NotNull
    protected List<ValidationError> checkDeployConfiguration(@NotNull AndroidFacet facet) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.DEPLOY && this.DEPLOY_APK_FROM_BUNDLE && !DynamicAppUtils.supportsBundleTask(facet.getModule())) {
            ValidationError error = ValidationError.fatal("This option requires a newer version of the Android Gradle Plugin", () -> DynamicAppUtils.promptUserForGradleUpdate(this.getProject()));
            errors.add(error);
        }
        return errors;
    }

    @Override
    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        return super.getLaunchOptions().setDeploy(this.DEPLOY).setPmInstallOptions(this.PM_INSTALL_OPTIONS).setDisabledDynamicFeatures(this.getDisabledDynamicFeatures()).setOpenLogcatAutomatically(this.SHOW_LOGCAT_AUTOMATICALLY).setDeployAsInstant(this.DEPLOY_AS_INSTANT);
    }

    @NotNull
    public List<String> getDisabledDynamicFeatures() {
        if (StringUtil.isEmpty((String)this.DYNAMIC_FEATURES_DISABLED_LIST)) {
            return ImmutableList.of();
        }
        return StringUtil.split((String)this.DYNAMIC_FEATURES_DISABLED_LIST, (String)FEATURE_LIST_SEPARATOR);
    }

    public void setDisabledDynamicFeatures(@NotNull List<String> features) {
        List sortedFeatures = features.stream().distinct().sorted().collect(Collectors.toList());
        this.DYNAMIC_FEATURES_DISABLED_LIST = StringUtil.join(sortedFeatures, (String)FEATURE_LIST_SEPARATOR);
    }

    @Override
    @NotNull
    protected ApkProvider getApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull List<AndroidDevice> targetDevices) {
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() instanceof AndroidModuleModel) {
            return this.createGradleApkProvider(facet, applicationIdProvider, false, targetDevices);
        }
        ApkFacet apkFacet = ApkFacet.getInstance(facet.getModule());
        if (apkFacet != null) {
            return new FileSystemApkProvider(apkFacet.getModule(), new File(((ApkFacetConfiguration)apkFacet.getConfiguration()).APK_PATH));
        }
        return new NonGradleApkProvider(facet, applicationIdProvider, this.ARTIFACT_NAME);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor<AndroidAppRunConfigurationBase> editor2 = new AndroidRunConfigurationEditor<AndroidAppRunConfigurationBase>(project, (Predicate<AndroidFacet>)Predicates.alwaysFalse(), this);
        editor2.setConfigurationSpecificEditor(new ApplicationRunParameters(project, editor2.getModuleSelector()));
        return editor2;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        final SpecificActivityLaunch.State state = (SpecificActivityLaunch.State)this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state != null);
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                state.ACTIVITY_CLASS = qualifiedName;
            }

            @Nullable
            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)AndroidAppRunConfigurationBase.this.getConfigurationModule()).findClass(state.ACTIVITY_CLASS);
            }

            public void setPsiElement(PsiClass psiClass) {
                state.ACTIVITY_CLASS = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
            }
        });
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider() {
        return new ConsoleProvider(){

            @Override
            @NotNull
            public ConsoleView createAndAttach(@NotNull Disposable parent, @NotNull ProcessHandler handler, @NotNull Executor executor) throws ExecutionException {
                Project project = ((JavaRunConfigurationModule)AndroidAppRunConfigurationBase.this.getConfigurationModule()).getProject();
                TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
                ConsoleView console = builder.getConsole();
                console.attachToProcess(handler);
                return console;
            }
        };
    }

    @Override
    protected boolean supportMultipleDevices() {
        return true;
    }

    @Override
    @Nullable
    protected LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet, @NotNull String contributorsAmStartOptions, boolean waitForDebugger, @NotNull LaunchStatus launchStatus) {
        LaunchOptionState state = this.getLaunchOptionState(this.MODE);
        assert (state != null);
        String extraFlags = this.ACTIVITY_EXTRA_FLAGS;
        if (!contributorsAmStartOptions.isEmpty()) {
            extraFlags = extraFlags + (extraFlags.isEmpty() ? "" : " ") + contributorsAmStartOptions;
        }
        StartActivityFlagsProvider startActivityFlagsProvider = ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4 ? new InstantAppStartActivityFlagsProvider() : new DefaultStartActivityFlagsProvider(this.getAndroidDebuggerContext().getAndroidDebugger(), (AndroidDebuggerState)this.getAndroidDebuggerContext().getAndroidDebuggerState(), this.getProfilerState(), this.getProject(), waitForDebugger, extraFlags);
        try {
            return state.getLaunchTask(applicationIdProvider.getPackageName(), facet, startActivityFlagsProvider, this.getProfilerState());
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidAppRunConfigurationBase.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to identify application id", true);
            return null;
        }
    }

    public void setLaunchActivity(@NotNull String activityName) {
        this.MODE = LAUNCH_SPECIFIC_ACTIVITY;
        LaunchOptionState state = this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state instanceof SpecificActivityLaunch.State);
        ((SpecificActivityLaunch.State)state).ACTIVITY_CLASS = activityName;
    }

    public void setLaunchUrl(@NotNull String url) {
        this.MODE = LAUNCH_DEEP_LINK;
        LaunchOptionState state = this.getLaunchOptionState(LAUNCH_DEEP_LINK);
        assert (state instanceof DeepLinkLaunch.State);
        ((DeepLinkLaunch.State)state).DEEP_LINK = url;
    }

    public boolean isLaunchingActivity(@Nullable String activityName) {
        if (!StringUtil.equals((CharSequence)this.MODE, (CharSequence)LAUNCH_SPECIFIC_ACTIVITY)) {
            return false;
        }
        LaunchOptionState state = this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state instanceof SpecificActivityLaunch.State);
        return StringUtil.equals((CharSequence)((SpecificActivityLaunch.State)state).ACTIVITY_CLASS, (CharSequence)activityName);
    }

    @Nullable
    public LaunchOptionState getLaunchOptionState(@NotNull String launchOptionId) {
        return this.myLaunchOptionStates.get(launchOptionId);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        for (LaunchOptionState state : this.myLaunchOptionStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
        if (this.DEPLOY_APK_FROM_BUNDLE) {
            this.DEPLOY = true;
        }
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        super.writeExternal(element);
        for (LaunchOptionState state : this.myLaunchOptionStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }

    @Nullable
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor) {
        Icon executorIcon;
        boolean isRunning;
        if (!((Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get()).booleanValue()) {
            if (executor instanceof ExecutorIconProvider) {
                return ((ExecutorIconProvider)executor).getExecutorIcon(this.getProject(), executor);
            }
            return null;
        }
        Project project = configuration.getProject();
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance((Project)project);
        List runningDescriptors = executionManager.getRunningDescriptors(s -> s != null && s.getConfiguration() == configuration);
        runningDescriptors = runningDescriptors.stream().filter(descriptor2 -> {
            RunContentDescriptor contentDescriptor = executionManager.getContentManager().findContentDescriptor(executor, descriptor2.getProcessHandler());
            return contentDescriptor != null && executionManager.getExecutors(contentDescriptor).contains(executor);
        }).collect(Collectors.toList());
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider();
        String applicationId2 = null;
        try {
            applicationId2 = applicationIdProvider == null ? null : applicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException apkProvisionException) {
            // empty catch block
        }
        boolean bl = isRunning = executionTarget instanceof AndroidExecutionTarget && applicationId2 != null && ((AndroidExecutionTarget)executionTarget).isApplicationRunning(applicationId2);
        if (DefaultRunExecutor.EXECUTOR_ID.equals(executor.getId()) && !runningDescriptors.isEmpty() && isRunning) {
            return AllIcons.Actions.Restart;
        }
        Icon icon2 = executorIcon = executor instanceof ExecutorIconProvider ? ((ExecutorIconProvider)executor).getExecutorIcon(this.getProject(), executor) : executor.getIcon();
        if (runningDescriptors.isEmpty() || !isRunning) {
            return executorIcon;
        }
        return ExecutionUtil.getLiveIndicator((Icon)executorIcon);
    }

    @Override
    public void updateExtraRunStats(RunStats runStats) {
        runStats.setDeployedAsInstant(this.DEPLOY_AS_INSTANT);
        runStats.setDeployedFromBundle(this.DEPLOY_APK_FROM_BUNDLE);
    }
}

